/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import io.trino.server.PluginManager;
import io.trino.server.ServerPluginsProviderConfig;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;

public class ServerPluginsProvider
implements PluginManager.PluginsProvider {
    private final File installedPluginsDir;

    @Inject
    public ServerPluginsProvider(ServerPluginsProviderConfig config) {
        this.installedPluginsDir = config.getInstalledPluginsDir();
    }

    @Override
    public void loadPlugins(PluginManager.PluginsProvider.Loader loader, PluginManager.PluginsProvider.ClassLoaderFactory createClassLoader) {
        for (File file : ServerPluginsProvider.listFiles(this.installedPluginsDir)) {
            if (!file.isDirectory()) continue;
            loader.load(file.getAbsolutePath(), () -> createClassLoader.create(ServerPluginsProvider.buildClassPath(file)));
        }
    }

    private static List<URL> buildClassPath(File path) {
        return (List)ServerPluginsProvider.listFiles(path).stream().map(ServerPluginsProvider::fileToUrl).collect(ImmutableList.toImmutableList());
    }

    private static List<File> listFiles(File path) {
        try {
            return (List)Streams.stream(Files.newDirectoryStream(path.toPath())).map(Path::toFile).sorted().collect(ImmutableList.toImmutableList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static URL fileToUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }
}

