/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import io.trino.server.security.AbstractBearerAuthenticator;
import io.trino.server.security.AuthenticationException;
import io.trino.server.security.UserMapping;
import io.trino.server.security.jwt.JwtAuthenticatorConfig;
import io.trino.spi.security.BasicPrincipal;
import java.security.Principal;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;

public class JwtAuthenticator
extends AbstractBearerAuthenticator {
    private final JwtParser jwtParser;
    private final String principalField;

    @Inject
    public JwtAuthenticator(JwtAuthenticatorConfig config, SigningKeyResolver signingKeyResolver) {
        super(UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile()));
        this.principalField = config.getPrincipalField();
        JwtParser jwtParser = Jwts.parser().setSigningKeyResolver(signingKeyResolver);
        if (config.getRequiredIssuer() != null) {
            jwtParser.requireIssuer(config.getRequiredIssuer());
        }
        if (config.getRequiredAudience() != null) {
            jwtParser.requireAudience(config.getRequiredAudience());
        }
        this.jwtParser = jwtParser;
    }

    @Override
    protected Optional<Principal> extractPrincipalFromToken(String token) {
        return Optional.ofNullable((String)((Claims)this.jwtParser.parseClaimsJws(token).getBody()).get(this.principalField, String.class)).map(BasicPrincipal::new);
    }

    @Override
    protected AuthenticationException needAuthentication(ContainerRequestContext request, String message) {
        return new AuthenticationException(message, "Bearer realm=\"Trino\", token_type=\"JWT\"");
    }
}

