/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.LabelNode;
import io.trino.sql.gen.BytecodeGenerator;
import io.trino.sql.gen.BytecodeGeneratorContext;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import java.util.Objects;

public class OrCodeGenerator
implements BytecodeGenerator {
    private final RowExpression left;
    private final RowExpression right;

    public OrCodeGenerator(SpecialForm specialForm) {
        Objects.requireNonNull(specialForm, "specialForm is null");
        Preconditions.checkArgument((specialForm.getArguments().size() == 2 ? 1 : 0) != 0);
        this.left = specialForm.getArguments().get(0);
        this.right = specialForm.getArguments().get(1);
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generator) {
        Variable wasNull = generator.wasNull();
        BytecodeBlock block = new BytecodeBlock().comment("OR").setDescription("OR");
        block.append(generator.generate(this.left));
        IfStatement ifLeftIsNull = new IfStatement("if left wasNull...", new Object[0]).condition((BytecodeNode)wasNull);
        LabelNode end = new LabelNode("end");
        ifLeftIsNull.ifTrue((BytecodeNode)new BytecodeBlock().comment("clear the null flag, pop left value off stack, and push left null flag on the stack (true)").append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse())).pop(this.left.getType().getJavaType()).push(true));
        LabelNode leftIsFalse = new LabelNode("leftIsFalse");
        ifLeftIsNull.ifFalse((BytecodeNode)new BytecodeBlock().comment("if left is true, push true, and goto end").ifFalseGoto(leftIsFalse).push(true).gotoLabel(end).comment("left was false; push left null flag on the stack (false)").visitLabel(leftIsFalse).push(false));
        block.append((BytecodeNode)ifLeftIsNull);
        block.append(generator.generate(this.right));
        IfStatement ifRightIsNull = new IfStatement("if right wasNull...", new Object[0]).condition((BytecodeNode)wasNull);
        ifRightIsNull.ifTrue().comment("right was null, pop the right value off the stack; wasNull flag remains set to TRUE").pop(this.right.getType().getJavaType());
        LabelNode rightIsTrue = new LabelNode("rightIsTrue");
        ifRightIsNull.ifFalse().comment("if right is true, pop left null flag off stack, push true and goto end").ifFalseGoto(rightIsTrue).pop(Boolean.TYPE).push(true).gotoLabel(end).comment("right was false; store left null flag (on stack) in wasNull variable, and push false").visitLabel(rightIsTrue).putVariable(wasNull).push(false);
        block.append((BytecodeNode)ifRightIsNull).visitLabel(end);
        return block;
    }
}

