/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.SystemSessionProperties;
import io.trino.cost.CostCalculator;
import io.trino.cost.CostComparator;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.cost.StatsCalculator;
import io.trino.cost.TaskCountEstimator;
import io.trino.execution.TaskManagerConfig;
import io.trino.metadata.Metadata;
import io.trino.spi.type.TypeOperators;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.OptimizerStatsRecorder;
import io.trino.sql.planner.PlanOptimizersFactory;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.IterativeOptimizer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.RuleStats;
import io.trino.sql.planner.iterative.rule.AddExchangesBelowPartialAggregationOverGroupIdRuleSet;
import io.trino.sql.planner.iterative.rule.AddIntermediateAggregations;
import io.trino.sql.planner.iterative.rule.ApplyTableScanRedirection;
import io.trino.sql.planner.iterative.rule.CanonicalizeExpressions;
import io.trino.sql.planner.iterative.rule.CreatePartialTopN;
import io.trino.sql.planner.iterative.rule.DecorrelateInnerUnnestWithGlobalAggregation;
import io.trino.sql.planner.iterative.rule.DecorrelateLeftUnnestWithGlobalAggregation;
import io.trino.sql.planner.iterative.rule.DecorrelateUnnest;
import io.trino.sql.planner.iterative.rule.DesugarArrayConstructor;
import io.trino.sql.planner.iterative.rule.DesugarAtTimeZone;
import io.trino.sql.planner.iterative.rule.DesugarCurrentCatalog;
import io.trino.sql.planner.iterative.rule.DesugarCurrentPath;
import io.trino.sql.planner.iterative.rule.DesugarCurrentSchema;
import io.trino.sql.planner.iterative.rule.DesugarCurrentUser;
import io.trino.sql.planner.iterative.rule.DesugarLambdaExpression;
import io.trino.sql.planner.iterative.rule.DesugarLike;
import io.trino.sql.planner.iterative.rule.DesugarTryExpression;
import io.trino.sql.planner.iterative.rule.DetermineJoinDistributionType;
import io.trino.sql.planner.iterative.rule.DeterminePreferredWritePartitioning;
import io.trino.sql.planner.iterative.rule.DetermineSemiJoinDistributionType;
import io.trino.sql.planner.iterative.rule.DetermineTableScanNodePartitioning;
import io.trino.sql.planner.iterative.rule.EliminateCrossJoins;
import io.trino.sql.planner.iterative.rule.EvaluateEmptyIntersect;
import io.trino.sql.planner.iterative.rule.EvaluateZeroSample;
import io.trino.sql.planner.iterative.rule.ExtractDereferencesFromFilterAboveScan;
import io.trino.sql.planner.iterative.rule.ExtractSpatialJoins;
import io.trino.sql.planner.iterative.rule.GatherAndMergeWindows;
import io.trino.sql.planner.iterative.rule.ImplementBernoulliSampleAsFilter;
import io.trino.sql.planner.iterative.rule.ImplementExceptAll;
import io.trino.sql.planner.iterative.rule.ImplementExceptDistinctAsUnion;
import io.trino.sql.planner.iterative.rule.ImplementFilteredAggregations;
import io.trino.sql.planner.iterative.rule.ImplementIntersectAll;
import io.trino.sql.planner.iterative.rule.ImplementIntersectDistinctAsUnion;
import io.trino.sql.planner.iterative.rule.ImplementLimitWithTies;
import io.trino.sql.planner.iterative.rule.ImplementOffset;
import io.trino.sql.planner.iterative.rule.InlineProjectIntoFilter;
import io.trino.sql.planner.iterative.rule.InlineProjections;
import io.trino.sql.planner.iterative.rule.MergeExcept;
import io.trino.sql.planner.iterative.rule.MergeFilters;
import io.trino.sql.planner.iterative.rule.MergeIntersect;
import io.trino.sql.planner.iterative.rule.MergeLimitOverProjectWithSort;
import io.trino.sql.planner.iterative.rule.MergeLimitWithDistinct;
import io.trino.sql.planner.iterative.rule.MergeLimitWithSort;
import io.trino.sql.planner.iterative.rule.MergeLimitWithTopN;
import io.trino.sql.planner.iterative.rule.MergeLimits;
import io.trino.sql.planner.iterative.rule.MergePatternRecognitionNodes;
import io.trino.sql.planner.iterative.rule.MergeProjectWithValues;
import io.trino.sql.planner.iterative.rule.MergeUnion;
import io.trino.sql.planner.iterative.rule.MultipleDistinctAggregationToMarkDistinct;
import io.trino.sql.planner.iterative.rule.OptimizeDuplicateInsensitiveJoins;
import io.trino.sql.planner.iterative.rule.OptimizeRowPattern;
import io.trino.sql.planner.iterative.rule.PruneAggregationColumns;
import io.trino.sql.planner.iterative.rule.PruneAggregationSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneApplyColumns;
import io.trino.sql.planner.iterative.rule.PruneApplyCorrelation;
import io.trino.sql.planner.iterative.rule.PruneApplySourceColumns;
import io.trino.sql.planner.iterative.rule.PruneAssignUniqueIdColumns;
import io.trino.sql.planner.iterative.rule.PruneCorrelatedJoinColumns;
import io.trino.sql.planner.iterative.rule.PruneCorrelatedJoinCorrelation;
import io.trino.sql.planner.iterative.rule.PruneCountAggregationOverScalar;
import io.trino.sql.planner.iterative.rule.PruneDeleteSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneDistinctAggregation;
import io.trino.sql.planner.iterative.rule.PruneDistinctLimitSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneEnforceSingleRowColumns;
import io.trino.sql.planner.iterative.rule.PruneExceptSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneExchangeColumns;
import io.trino.sql.planner.iterative.rule.PruneExchangeSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneExplainAnalyzeSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneFilterColumns;
import io.trino.sql.planner.iterative.rule.PruneGroupIdColumns;
import io.trino.sql.planner.iterative.rule.PruneGroupIdSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneIndexJoinColumns;
import io.trino.sql.planner.iterative.rule.PruneIndexSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneIntersectSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneJoinChildrenColumns;
import io.trino.sql.planner.iterative.rule.PruneJoinColumns;
import io.trino.sql.planner.iterative.rule.PruneLimitColumns;
import io.trino.sql.planner.iterative.rule.PruneMarkDistinctColumns;
import io.trino.sql.planner.iterative.rule.PruneOffsetColumns;
import io.trino.sql.planner.iterative.rule.PruneOrderByInAggregation;
import io.trino.sql.planner.iterative.rule.PruneOutputSourceColumns;
import io.trino.sql.planner.iterative.rule.PrunePattenRecognitionColumns;
import io.trino.sql.planner.iterative.rule.PrunePatternRecognitionSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneProjectColumns;
import io.trino.sql.planner.iterative.rule.PruneRowNumberColumns;
import io.trino.sql.planner.iterative.rule.PruneSampleColumns;
import io.trino.sql.planner.iterative.rule.PruneSemiJoinColumns;
import io.trino.sql.planner.iterative.rule.PruneSemiJoinFilteringSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneSortColumns;
import io.trino.sql.planner.iterative.rule.PruneSpatialJoinChildrenColumns;
import io.trino.sql.planner.iterative.rule.PruneSpatialJoinColumns;
import io.trino.sql.planner.iterative.rule.PruneTableScanColumns;
import io.trino.sql.planner.iterative.rule.PruneTableWriterSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneTopNColumns;
import io.trino.sql.planner.iterative.rule.PruneTopNRankingColumns;
import io.trino.sql.planner.iterative.rule.PruneUnionColumns;
import io.trino.sql.planner.iterative.rule.PruneUnionSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneUnnestColumns;
import io.trino.sql.planner.iterative.rule.PruneUnnestSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneUpdateSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneValuesColumns;
import io.trino.sql.planner.iterative.rule.PruneWindowColumns;
import io.trino.sql.planner.iterative.rule.PushAggregationIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushAggregationThroughOuterJoin;
import io.trino.sql.planner.iterative.rule.PushCastIntoRow;
import io.trino.sql.planner.iterative.rule.PushDeleteIntoConnector;
import io.trino.sql.planner.iterative.rule.PushDistinctLimitIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushDownDereferenceThroughFilter;
import io.trino.sql.planner.iterative.rule.PushDownDereferenceThroughJoin;
import io.trino.sql.planner.iterative.rule.PushDownDereferenceThroughProject;
import io.trino.sql.planner.iterative.rule.PushDownDereferenceThroughSemiJoin;
import io.trino.sql.planner.iterative.rule.PushDownDereferenceThroughUnnest;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughAssignUniqueId;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughLimit;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughRowNumber;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughSort;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughTopN;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughTopNRanking;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughWindow;
import io.trino.sql.planner.iterative.rule.PushJoinIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushLimitIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushLimitThroughMarkDistinct;
import io.trino.sql.planner.iterative.rule.PushLimitThroughOffset;
import io.trino.sql.planner.iterative.rule.PushLimitThroughOuterJoin;
import io.trino.sql.planner.iterative.rule.PushLimitThroughProject;
import io.trino.sql.planner.iterative.rule.PushLimitThroughSemiJoin;
import io.trino.sql.planner.iterative.rule.PushLimitThroughUnion;
import io.trino.sql.planner.iterative.rule.PushOffsetThroughProject;
import io.trino.sql.planner.iterative.rule.PushPartialAggregationThroughExchange;
import io.trino.sql.planner.iterative.rule.PushPartialAggregationThroughJoin;
import io.trino.sql.planner.iterative.rule.PushPredicateIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushPredicateThroughProjectIntoRowNumber;
import io.trino.sql.planner.iterative.rule.PushPredicateThroughProjectIntoWindow;
import io.trino.sql.planner.iterative.rule.PushProjectionIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushProjectionThroughExchange;
import io.trino.sql.planner.iterative.rule.PushProjectionThroughUnion;
import io.trino.sql.planner.iterative.rule.PushRemoteExchangeThroughAssignUniqueId;
import io.trino.sql.planner.iterative.rule.PushSampleIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushTableWriteThroughUnion;
import io.trino.sql.planner.iterative.rule.PushTopNIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushTopNThroughOuterJoin;
import io.trino.sql.planner.iterative.rule.PushTopNThroughProject;
import io.trino.sql.planner.iterative.rule.PushTopNThroughUnion;
import io.trino.sql.planner.iterative.rule.PushdownFilterIntoRowNumber;
import io.trino.sql.planner.iterative.rule.PushdownFilterIntoWindow;
import io.trino.sql.planner.iterative.rule.PushdownLimitIntoRowNumber;
import io.trino.sql.planner.iterative.rule.PushdownLimitIntoWindow;
import io.trino.sql.planner.iterative.rule.RemoveAggregationInSemiJoin;
import io.trino.sql.planner.iterative.rule.RemoveDuplicateConditions;
import io.trino.sql.planner.iterative.rule.RemoveEmptyDelete;
import io.trino.sql.planner.iterative.rule.RemoveEmptyExceptBranches;
import io.trino.sql.planner.iterative.rule.RemoveEmptyUnionBranches;
import io.trino.sql.planner.iterative.rule.RemoveFullSample;
import io.trino.sql.planner.iterative.rule.RemoveRedundantDistinctLimit;
import io.trino.sql.planner.iterative.rule.RemoveRedundantEnforceSingleRowNode;
import io.trino.sql.planner.iterative.rule.RemoveRedundantExists;
import io.trino.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.trino.sql.planner.iterative.rule.RemoveRedundantJoin;
import io.trino.sql.planner.iterative.rule.RemoveRedundantLimit;
import io.trino.sql.planner.iterative.rule.RemoveRedundantOffset;
import io.trino.sql.planner.iterative.rule.RemoveRedundantSort;
import io.trino.sql.planner.iterative.rule.RemoveRedundantSortBelowLimitWithTies;
import io.trino.sql.planner.iterative.rule.RemoveRedundantTableScanPredicate;
import io.trino.sql.planner.iterative.rule.RemoveRedundantTopN;
import io.trino.sql.planner.iterative.rule.RemoveTrivialFilters;
import io.trino.sql.planner.iterative.rule.RemoveUnreferencedScalarApplyNodes;
import io.trino.sql.planner.iterative.rule.RemoveUnreferencedScalarSubqueries;
import io.trino.sql.planner.iterative.rule.RemoveUnsupportedDynamicFilters;
import io.trino.sql.planner.iterative.rule.ReorderJoins;
import io.trino.sql.planner.iterative.rule.ReplaceJoinOverConstantWithProject;
import io.trino.sql.planner.iterative.rule.ReplaceRedundantJoinWithProject;
import io.trino.sql.planner.iterative.rule.ReplaceRedundantJoinWithSource;
import io.trino.sql.planner.iterative.rule.ReplaceWindowWithRowNumber;
import io.trino.sql.planner.iterative.rule.RewriteSpatialPartitioningAggregation;
import io.trino.sql.planner.iterative.rule.SimplifyCountOverConstant;
import io.trino.sql.planner.iterative.rule.SimplifyExpressions;
import io.trino.sql.planner.iterative.rule.SimplifyFilterPredicate;
import io.trino.sql.planner.iterative.rule.SingleDistinctAggregationToGroupBy;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedDistinctAggregationWithProjection;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedDistinctAggregationWithoutProjection;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedGlobalAggregationWithProjection;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedGlobalAggregationWithoutProjection;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedGroupedAggregationWithProjection;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedGroupedAggregationWithoutProjection;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedInPredicateToJoin;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedJoinToJoin;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedScalarSubquery;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedSingleRowSubqueryToProject;
import io.trino.sql.planner.iterative.rule.TransformExistsApplyToCorrelatedJoin;
import io.trino.sql.planner.iterative.rule.TransformFilteringSemiJoinToInnerJoin;
import io.trino.sql.planner.iterative.rule.TransformUncorrelatedInPredicateSubqueryToSemiJoin;
import io.trino.sql.planner.iterative.rule.TransformUncorrelatedSubqueryToJoin;
import io.trino.sql.planner.iterative.rule.UnwrapCastInComparison;
import io.trino.sql.planner.iterative.rule.UnwrapRowSubscript;
import io.trino.sql.planner.iterative.rule.UnwrapSingleColumnRowInApply;
import io.trino.sql.planner.optimizations.AddExchanges;
import io.trino.sql.planner.optimizations.AddLocalExchanges;
import io.trino.sql.planner.optimizations.BeginTableWrite;
import io.trino.sql.planner.optimizations.CheckSubqueryNodesAreRewritten;
import io.trino.sql.planner.optimizations.HashGenerationOptimizer;
import io.trino.sql.planner.optimizations.IndexJoinOptimizer;
import io.trino.sql.planner.optimizations.LimitPushDown;
import io.trino.sql.planner.optimizations.MetadataQueryOptimizer;
import io.trino.sql.planner.optimizations.OptimizeMixedDistinctAggregations;
import io.trino.sql.planner.optimizations.OptimizerStats;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.optimizations.PredicatePushDown;
import io.trino.sql.planner.optimizations.PruneUnreferencedOutputs;
import io.trino.sql.planner.optimizations.ReplicateSemiJoinInDelete;
import io.trino.sql.planner.optimizations.StatsRecordingPlanOptimizer;
import io.trino.sql.planner.optimizations.TableDeleteOptimizer;
import io.trino.sql.planner.optimizations.TransformQuantifiedComparisonApplyToCorrelatedJoin;
import io.trino.sql.planner.optimizations.UnaliasSymbolReferences;
import io.trino.sql.planner.optimizations.WindowFilterPushDown;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class PlanOptimizers
implements PlanOptimizersFactory {
    private final List<PlanOptimizer> optimizers;
    private final RuleStatsRecorder ruleStats = new RuleStatsRecorder();
    private final OptimizerStatsRecorder optimizerStats = new OptimizerStatsRecorder();

    @Inject
    public PlanOptimizers(Metadata metadata, TypeOperators typeOperators, TypeAnalyzer typeAnalyzer, TaskManagerConfig taskManagerConfig, SplitManager splitManager, PageSourceManager pageSourceManager, StatsCalculator statsCalculator, ScalarStatsCalculator scalarStatsCalculator, CostCalculator costCalculator, @CostCalculator.EstimatedExchanges CostCalculator estimatedExchangesCostCalculator, CostComparator costComparator, TaskCountEstimator taskCountEstimator, NodePartitioningManager nodePartitioningManager) {
        this(metadata, typeOperators, typeAnalyzer, taskManagerConfig, false, splitManager, pageSourceManager, statsCalculator, scalarStatsCalculator, costCalculator, estimatedExchangesCostCalculator, costComparator, taskCountEstimator, nodePartitioningManager);
    }

    public PlanOptimizers(Metadata metadata, TypeOperators typeOperators, TypeAnalyzer typeAnalyzer, TaskManagerConfig taskManagerConfig, boolean forceSingleNode, SplitManager splitManager, PageSourceManager pageSourceManager, StatsCalculator statsCalculator, ScalarStatsCalculator scalarStatsCalculator, CostCalculator costCalculator, CostCalculator estimatedExchangesCostCalculator, CostComparator costComparator, TaskCountEstimator taskCountEstimator, NodePartitioningManager nodePartitioningManager) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSet columnPruningRules = ImmutableSet.of((Object)new PruneAggregationColumns(), (Object)new PruneAggregationSourceColumns(), (Object)new PruneApplyColumns(), (Object)new PruneApplyCorrelation(), (Object)new PruneApplySourceColumns(), (Object)new PruneAssignUniqueIdColumns(), (Object[])new Rule[]{new PruneCorrelatedJoinColumns(), new PruneCorrelatedJoinCorrelation(), new PruneDeleteSourceColumns(), new PruneUpdateSourceColumns(), new PruneDistinctLimitSourceColumns(), new PruneEnforceSingleRowColumns(), new PruneExceptSourceColumns(), new PruneExchangeColumns(), new PruneExchangeSourceColumns(), new PruneExplainAnalyzeSourceColumns(), new PruneFilterColumns(), new PruneGroupIdColumns(), new PruneGroupIdSourceColumns(), new PruneIndexJoinColumns(), new PruneIndexSourceColumns(), new PruneIntersectSourceColumns(), new PruneJoinChildrenColumns(), new PruneJoinColumns(), new PruneLimitColumns(), new PruneMarkDistinctColumns(), new PruneOffsetColumns(), new PruneOutputSourceColumns(), new PrunePattenRecognitionColumns(), new PrunePatternRecognitionSourceColumns(), new PruneProjectColumns(), new PruneRowNumberColumns(), new PruneSampleColumns(), new PruneSemiJoinColumns(), new PruneSemiJoinFilteringSourceColumns(), new PruneSortColumns(), new PruneSpatialJoinChildrenColumns(), new PruneSpatialJoinColumns(), new PruneTableScanColumns(metadata), new PruneTableWriterSourceColumns(), new PruneTopNColumns(), new PruneTopNRankingColumns(), new PruneUnionColumns(), new PruneUnionSourceColumns(), new PruneUnnestColumns(), new PruneUnnestSourceColumns(), new PruneValuesColumns(), new PruneWindowColumns()});
        ImmutableSet projectionPushdownRules = ImmutableSet.of((Object)new PushProjectionThroughUnion(), (Object)new PushProjectionThroughExchange(), (Object)new PushDownDereferenceThroughProject(typeAnalyzer), (Object)new PushDownDereferenceThroughUnnest(typeAnalyzer), (Object)new PushDownDereferenceThroughSemiJoin(typeAnalyzer), (Object)new PushDownDereferenceThroughJoin(typeAnalyzer), (Object[])new Rule[]{new PushDownDereferenceThroughFilter(typeAnalyzer), new ExtractDereferencesFromFilterAboveScan(typeAnalyzer), new PushDownDereferencesThroughLimit(typeAnalyzer), new PushDownDereferencesThroughSort(typeAnalyzer), new PushDownDereferencesThroughAssignUniqueId(typeAnalyzer), new PushDownDereferencesThroughWindow(typeAnalyzer), new PushDownDereferencesThroughTopN(typeAnalyzer), new PushDownDereferencesThroughRowNumber(typeAnalyzer), new PushDownDereferencesThroughTopNRanking(typeAnalyzer)});
        ImmutableSet limitPushdownRules = ImmutableSet.of((Object)new PushLimitThroughOffset(), (Object)new PushLimitThroughProject(typeAnalyzer), (Object)new PushLimitThroughMarkDistinct(), (Object)new PushLimitThroughOuterJoin(), (Object)new PushLimitThroughSemiJoin(), (Object)new PushLimitThroughUnion(), (Object[])new Rule[0]);
        IterativeOptimizer inlineProjections = new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new InlineProjections(typeAnalyzer), (Object)new RemoveRedundantIdentityProjections()));
        ImmutableSet simplifyOptimizerRules = ImmutableSet.builder().addAll(new SimplifyExpressions(metadata, typeAnalyzer).rules()).addAll(new UnwrapRowSubscript().rules()).addAll(new PushCastIntoRow().rules()).addAll(new UnwrapCastInComparison(metadata, typeOperators, typeAnalyzer).rules()).addAll(new RemoveDuplicateConditions(metadata).rules()).addAll(new CanonicalizeExpressions(metadata, typeAnalyzer).rules()).add((Object)new RemoveTrivialFilters()).build();
        IterativeOptimizer simplifyOptimizer = new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)simplifyOptimizerRules);
        IterativeOptimizer columnPruningOptimizer = new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, session -> !SystemSessionProperties.isIterativeRuleBasedColumnPruning(session), (List<PlanOptimizer>)ImmutableList.of((Object)new PruneUnreferencedOutputs(metadata)), (Set<Rule<?>>)columnPruningRules);
        builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(new DesugarLambdaExpression().rules()).addAll(new DesugarAtTimeZone(metadata, typeAnalyzer).rules()).addAll(new DesugarCurrentCatalog(metadata).rules()).addAll(new DesugarCurrentSchema(metadata).rules()).addAll(new DesugarCurrentUser(metadata).rules()).addAll(new DesugarCurrentPath(metadata).rules()).addAll(new DesugarTryExpression(metadata, typeAnalyzer).rules()).build()), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(new CanonicalizeExpressions(metadata, typeAnalyzer).rules()).add((Object)new OptimizeRowPattern()).build()), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)columnPruningRules).addAll((Iterable)projectionPushdownRules).addAll((Iterable)limitPushdownRules).addAll(new UnwrapRowSubscript().rules()).addAll(new PushCastIntoRow().rules()).addAll((Iterable)ImmutableSet.of((Object)new UnwrapSingleColumnRowInApply(typeAnalyzer), (Object)new RemoveEmptyUnionBranches(), (Object)new EvaluateEmptyIntersect(), (Object)new RemoveEmptyExceptBranches(), (Object)new MergeFilters(metadata), (Object)new InlineProjections(typeAnalyzer), (Object[])new Rule[]{new RemoveRedundantIdentityProjections(), new RemoveFullSample(), new EvaluateZeroSample(), new PushOffsetThroughProject(), new MergeLimits(), new MergeLimitWithSort(), new MergeLimitOverProjectWithSort(), new MergeLimitWithTopN(), new RemoveTrivialFilters(), new RemoveRedundantLimit(), new RemoveRedundantOffset(), new RemoveRedundantSort(), new RemoveRedundantSortBelowLimitWithTies(), new RemoveRedundantTopN(), new RemoveRedundantDistinctLimit(), new ReplaceRedundantJoinWithSource(), new RemoveRedundantJoin(), new ReplaceRedundantJoinWithProject(), new RemoveRedundantEnforceSingleRowNode(), new RemoveRedundantExists(), new ImplementFilteredAggregations(metadata), new SingleDistinctAggregationToGroupBy(), new MultipleDistinctAggregationToMarkDistinct(), new MergeLimitWithDistinct(), new PruneCountAggregationOverScalar(metadata), new PruneOrderByInAggregation(metadata), new RewriteSpatialPartitioningAggregation(metadata), new SimplifyCountOverConstant(metadata)})).build()), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ImplementOffset())), simplifyOptimizer, new UnaliasSymbolReferences(metadata), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new MergeUnion(), (Object)new MergeIntersect(), (Object)new MergeExcept(), (Object)new PruneDistinctAggregation())), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ImplementIntersectDistinctAsUnion(metadata), (Object)new ImplementExceptDistinctAsUnion(metadata), (Object)new ImplementIntersectAll(metadata), (Object)new ImplementExceptAll(metadata))), new LimitPushDown(), columnPruningOptimizer, inlineProjections, new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)columnPruningRules), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new TransformExistsApplyToCorrelatedJoin(metadata))), new TransformQuantifiedComparisonApplyToCorrelatedJoin(metadata), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantEnforceSingleRowNode(), (Object)new RemoveUnreferencedScalarSubqueries(), (Object)new TransformUncorrelatedSubqueryToJoin(), (Object)new TransformUncorrelatedInPredicateSubqueryToSemiJoin(), (Object)new TransformCorrelatedJoinToJoin(metadata), (Object)new DecorrelateInnerUnnestWithGlobalAggregation(), (Object[])new Rule[]{new DecorrelateLeftUnnestWithGlobalAggregation(), new DecorrelateUnnest(metadata), new TransformCorrelatedGlobalAggregationWithProjection(metadata), new TransformCorrelatedGlobalAggregationWithoutProjection(metadata), new TransformCorrelatedDistinctAggregationWithProjection(metadata), new TransformCorrelatedDistinctAggregationWithoutProjection(metadata), new TransformCorrelatedGroupedAggregationWithProjection(metadata), new TransformCorrelatedGroupedAggregationWithoutProjection(metadata)})), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ImplementLimitWithTies(metadata), (Object)new RemoveUnreferencedScalarApplyNodes(), (Object)new TransformCorrelatedInPredicateToJoin(metadata), (Object)new TransformCorrelatedScalarSubquery(metadata), (Object)new TransformCorrelatedJoinToJoin(metadata), (Object)new ImplementFilteredAggregations(metadata), (Object[])new Rule[0])), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new InlineProjections(typeAnalyzer), (Object)new RemoveRedundantIdentityProjections(), (Object)new TransformCorrelatedSingleRowSubqueryToProject(), (Object)new RemoveAggregationInSemiJoin(), (Object)new MergeProjectWithValues(metadata), (Object)new ReplaceJoinOverConstantWithProject(), (Object[])new Rule[0])), new CheckSubqueryNodesAreRewritten(), simplifyOptimizer, new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(metadata, typeOperators, typeAnalyzer, false, false)), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveEmptyUnionBranches(), (Object)new EvaluateEmptyIntersect(), (Object)new RemoveEmptyExceptBranches(), (Object)new TransformFilteringSemiJoinToInnerJoin(), (Object)new InlineProjectIntoFilter(metadata), (Object)new SimplifyFilterPredicate(metadata), (Object[])new Rule[0]))});
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ApplyTableScanRedirection(metadata), (Object)new PruneTableScanColumns(metadata), (Object)new PushPredicateIntoTableScan(metadata, typeOperators, typeAnalyzer))));
        ImmutableSet pushIntoTableScanRulesExceptJoins = ImmutableSet.builder().addAll((Iterable)columnPruningRules).addAll((Iterable)projectionPushdownRules).add((Object)new PushProjectionIntoTableScan(metadata, typeAnalyzer, scalarStatsCalculator)).add((Object)new RemoveRedundantIdentityProjections()).add((Object)new PushLimitIntoTableScan(metadata)).add((Object)new PushPredicateIntoTableScan(metadata, typeOperators, typeAnalyzer)).add((Object)new PushSampleIntoTableScan(metadata)).add((Object)new PushAggregationIntoTableScan(metadata)).add((Object)new PushDistinctLimitIntoTableScan(metadata)).add((Object)new PushTopNIntoTableScan(metadata)).build();
        IterativeOptimizer pushIntoTableScanOptimizer = new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)pushIntoTableScanRulesExceptJoins);
        builder.add((Object)pushIntoTableScanOptimizer);
        builder.add((Object)new UnaliasSymbolReferences(metadata));
        builder.add((Object)pushIntoTableScanOptimizer);
        IterativeOptimizer pushProjectionIntoTableScanOptimizer = new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)projectionPushdownRules).add((Object)new PushProjectionIntoTableScan(metadata, typeAnalyzer, scalarStatsCalculator)).build());
        builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ImplementBernoulliSampleAsFilter(metadata))), columnPruningOptimizer, new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveEmptyUnionBranches(), (Object)new EvaluateEmptyIntersect(), (Object)new RemoveEmptyExceptBranches(), (Object)new RemoveRedundantIdentityProjections(), (Object)new PushAggregationThroughOuterJoin(), (Object)new ReplaceRedundantJoinWithSource(), (Object[])new Rule[0])), inlineProjections, simplifyOptimizer, pushProjectionIntoTableScanOptimizer, new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(metadata, typeOperators, typeAnalyzer, true, false)), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)simplifyOptimizerRules).add((Object)new PushPredicateIntoTableScan(metadata, typeOperators, typeAnalyzer)).build()), new UnaliasSymbolReferences(metadata), columnPruningOptimizer, new IndexJoinOptimizer(metadata, typeOperators), new LimitPushDown(), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, SystemSessionProperties::useLegacyWindowFilterPushdown, (List<PlanOptimizer>)ImmutableList.of((Object)new WindowFilterPushDown(metadata, typeOperators)), (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveEmptyUnionBranches(), (Object)new EvaluateEmptyIntersect(), (Object)new RemoveEmptyExceptBranches(), (Object)new PushdownLimitIntoRowNumber(), (Object)new PushdownLimitIntoWindow(metadata), (Object)new PushdownFilterIntoRowNumber(metadata, typeOperators), (Object[])new Rule[]{new PushdownFilterIntoWindow(metadata, typeOperators), new ReplaceWindowWithRowNumber(metadata)})), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).addAll(GatherAndMergeWindows.rules()).addAll(MergePatternRecognitionNodes.rules()).add((Object)new PushPredicateThroughProjectIntoRowNumber(metadata, typeOperators)).add((Object)new PushPredicateThroughProjectIntoWindow(metadata, typeOperators)).build()), inlineProjections, columnPruningOptimizer, new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new MetadataQueryOptimizer(metadata), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new EliminateCrossJoins(metadata, typeAnalyzer))), new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(metadata, typeOperators, typeAnalyzer, true, false)), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)simplifyOptimizerRules).add((Object)new PushPredicateIntoTableScan(metadata, typeOperators, typeAnalyzer)).build()), pushProjectionIntoTableScanOptimizer, new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(metadata, typeOperators, typeAnalyzer, true, false)), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)simplifyOptimizerRules).add((Object)new PushPredicateIntoTableScan(metadata, typeOperators, typeAnalyzer)).build()), columnPruningOptimizer, new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new DeterminePreferredWritePartitioning())), new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ReorderJoins(metadata, costComparator, typeAnalyzer)))});
        builder.add((Object)new OptimizeMixedDistinctAggregations(metadata));
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new CreatePartialTopN(), (Object)new PushTopNThroughProject(typeAnalyzer), (Object)new PushTopNThroughOuterJoin(), (Object)new PushTopNThroughUnion(), (Object)new PushTopNIntoTableScan(metadata))));
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).addAll(new ExtractSpatialJoins(metadata, splitManager, pageSourceManager, typeAnalyzer).rules()).add((Object)new InlineProjections(typeAnalyzer)).build()));
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushDeleteIntoConnector(metadata), (Object)new DetermineTableScanNodePartitioning(metadata, nodePartitioningManager, taskCountEstimator), (Object)new OptimizeDuplicateInsensitiveJoins(metadata))));
        if (!forceSingleNode) {
            builder.add((Object)new ReplicateSemiJoinInDelete());
            builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new DetermineJoinDistributionType(costComparator, taskCountEstimator), (Object)new DetermineSemiJoinDistributionType(costComparator, taskCountEstimator))));
            builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)pushIntoTableScanRulesExceptJoins).add((Object)new PushJoinIntoTableScan(metadata)).add((Object)new DetermineTableScanNodePartitioning(metadata, nodePartitioningManager, taskCountEstimator)).build()));
            builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushTableWriteThroughUnion())));
            builder.add((Object)new UnaliasSymbolReferences(metadata));
            builder.add((Object)new StatsRecordingPlanOptimizer(this.optimizerStats, new AddExchanges(metadata, typeOperators, typeAnalyzer, statsCalculator)));
        }
        estimatedExchangesCostCalculator = null;
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveEmptyDelete())));
        builder.add((Object)new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(metadata, typeOperators, typeAnalyzer, true, false)));
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)simplifyOptimizerRules).add((Object)new RemoveRedundantTableScanPredicate(metadata, typeOperators)).build()));
        builder.add((Object)pushProjectionIntoTableScanOptimizer);
        builder.add((Object)new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(metadata, typeOperators, typeAnalyzer, true, true)));
        builder.add((Object)new RemoveUnsupportedDynamicFilters(metadata));
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)simplifyOptimizerRules).add((Object)new PushPredicateIntoTableScan(metadata, typeOperators, typeAnalyzer)).build()));
        builder.add((Object)inlineProjections);
        builder.add((Object)new UnaliasSymbolReferences(metadata));
        builder.add((Object)columnPruningOptimizer);
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).add((Object)new PushRemoteExchangeThroughAssignUniqueId()).add((Object)new InlineProjections(typeAnalyzer)).build()));
        builder.add((Object)new AddLocalExchanges(metadata, typeOperators, typeAnalyzer));
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushPartialAggregationThroughJoin(), (Object)new PushPartialAggregationThroughExchange(metadata), (Object)new PruneJoinColumns(), (Object)new PruneJoinChildrenColumns())));
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, new AddExchangesBelowPartialAggregationOverGroupIdRuleSet(metadata, typeOperators, typeAnalyzer, taskCountEstimator, taskManagerConfig).rules()));
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new AddIntermediateAggregations(), (Object)new RemoveRedundantIdentityProjections())));
        builder.add((Object)new IterativeOptimizer(metadata, this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(new DesugarLike(metadata, typeAnalyzer).rules()).addAll(new DesugarArrayConstructor(metadata, typeAnalyzer).rules()).build()));
        builder.add((Object)new HashGenerationOptimizer(metadata));
        builder.add((Object)new TableDeleteOptimizer(metadata));
        builder.add((Object)new BeginTableWrite(metadata));
        this.optimizers = builder.build();
    }

    @Override
    public List<PlanOptimizer> get() {
        return this.optimizers;
    }

    @Override
    public Map<Class<?>, OptimizerStats> getOptimizerStats() {
        return this.optimizerStats.getStats();
    }

    @Override
    public Map<Class<?>, RuleStats> getRuleStats() {
        return this.ruleStats.getStats();
    }
}

