/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableMetadata;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.Expression;
import io.trino.type.TypeCoercion;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ApplyTableScanRedirection
implements Rule<TableScanNode> {
    private static final Pattern<TableScanNode> PATTERN = Patterns.tableScan().matching(node -> !node.isUpdateTarget());
    private final Metadata metadata;
    private final DomainTranslator domainTranslator;
    private final TypeCoercion typeCoercion;

    public ApplyTableScanRedirection(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.domainTranslator = new DomainTranslator(metadata);
        this.typeCoercion = new TypeCoercion(metadata::getType);
    }

    @Override
    public Pattern<TableScanNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableScanNode scanNode, Captures captures, Rule.Context context) {
        Optional<TableScanRedirectApplicationResult> tableScanRedirectApplicationResult = this.metadata.applyTableScanRedirect(context.getSession(), scanNode.getTable());
        if (tableScanRedirectApplicationResult.isEmpty()) {
            return Rule.Result.empty();
        }
        CatalogSchemaTableName destinationTable = tableScanRedirectApplicationResult.get().getDestinationTable();
        QualifiedObjectName destinationObjectName = QualifiedObjectName.convertFromSchemaTableName(destinationTable.getCatalogName()).apply(destinationTable.getSchemaTableName());
        Optional<QualifiedObjectName> redirectedObjectName = this.metadata.getRedirectionAwareTableHandle(context.getSession(), destinationObjectName).getRedirectedTableName();
        redirectedObjectName.ifPresent(name -> {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Further redirection of destination table '%s' to '%s' is not supported", destinationObjectName, name));
        });
        TableMetadata tableMetadata = this.metadata.getTableMetadata(context.getSession(), scanNode.getTable());
        CatalogSchemaTableName sourceTable = new CatalogSchemaTableName(tableMetadata.getCatalogName().getCatalogName(), tableMetadata.getTable());
        if (destinationTable.equals((Object)sourceTable)) {
            return Rule.Result.empty();
        }
        Optional<TableHandle> destinationTableHandle = this.metadata.getTableHandle(context.getSession(), QualifiedObjectName.convertFromSchemaTableName(destinationTable.getCatalogName()).apply(destinationTable.getSchemaTableName()));
        if (destinationTableHandle.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, String.format("Destination table %s from table scan redirection not found", destinationTable));
        }
        Map columnMapping = tableScanRedirectApplicationResult.get().getDestinationColumns();
        Map<String, ColumnHandle> destinationColumnHandles = this.metadata.getColumnHandles(context.getSession(), destinationTableHandle.get());
        ImmutableMap.Builder casts = ImmutableMap.builder();
        ImmutableMap.Builder newAssignmentsBuilder = ImmutableMap.builder();
        for (Map.Entry<Symbol, ColumnHandle> assignment : scanNode.getAssignments().entrySet()) {
            Type redirectedType;
            String destinationColumn = (String)columnMapping.get(assignment.getValue());
            if (destinationColumn == null) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, String.format("Did not find mapping for source column %s in table scan redirection", assignment.getValue()));
            }
            ColumnHandle destinationColumnHandle = destinationColumnHandles.get(destinationColumn);
            if (destinationColumnHandle == null) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, String.format("Did not find handle for column %s in destination table %s", destinationColumn, destinationTable));
            }
            Type sourceType = context.getSymbolAllocator().getTypes().get(assignment.getKey());
            if (!sourceType.equals(redirectedType = this.metadata.getColumnMetadata(context.getSession(), destinationTableHandle.get(), destinationColumnHandle).getType())) {
                Symbol redirectedSymbol = context.getSymbolAllocator().newSymbol(destinationColumn, redirectedType);
                Cast cast = this.getCast(destinationTable, destinationColumn, redirectedType, redirectedSymbol, sourceTable, assignment.getValue(), sourceType);
                casts.put((Object)assignment.getKey(), (Object)cast);
                newAssignmentsBuilder.put((Object)redirectedSymbol, (Object)destinationColumnHandle);
                continue;
            }
            newAssignmentsBuilder.put((Object)assignment.getKey(), (Object)destinationColumnHandle);
        }
        TupleDomain requiredFilter = tableScanRedirectApplicationResult.get().getFilter();
        if (requiredFilter.isAll()) {
            ImmutableMap newAssignments = newAssignmentsBuilder.build();
            return Rule.Result.ofPlanNode(this.applyProjection(context.getIdAllocator(), (Set<Symbol>)ImmutableSet.copyOf(scanNode.getOutputSymbols()), (Map<Symbol, Cast>)casts.build(), new TableScanNode(scanNode.getId(), destinationTableHandle.get(), (List<Symbol>)ImmutableList.copyOf((Collection)newAssignments.keySet()), (Map<Symbol, ColumnHandle>)newAssignments, (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.empty(), scanNode.isUpdateTarget(), Optional.empty())));
        }
        ImmutableBiMap inverseAssignments = ImmutableBiMap.copyOf(scanNode.getAssignments()).inverse();
        ImmutableBiMap inverseColumnsMapping = ImmutableBiMap.copyOf((Map)columnMapping).inverse();
        TupleDomain transformedConstraint = requiredFilter.transformKeys(arg_0 -> this.lambda$apply$2((Map)inverseColumnsMapping, (Map)inverseAssignments, requiredFilter, context, destinationColumnHandles, destinationTable, destinationTableHandle, sourceTable, casts, newAssignmentsBuilder, arg_0));
        ImmutableMap newAssignments = newAssignmentsBuilder.build();
        TableScanNode newScanNode = new TableScanNode(scanNode.getId(), destinationTableHandle.get(), (List<Symbol>)ImmutableList.copyOf(newAssignments.keySet()), (Map<Symbol, ColumnHandle>)newAssignments, (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.empty(), scanNode.isUpdateTarget(), Optional.empty());
        FilterNode filterNode = new FilterNode(context.getIdAllocator().getNextId(), this.applyProjection(context.getIdAllocator(), newAssignments.keySet(), (Map<Symbol, Cast>)casts.build(), newScanNode), this.domainTranslator.toPredicate((TupleDomain<Symbol>)transformedConstraint));
        return Rule.Result.ofPlanNode(this.applyProjection(context.getIdAllocator(), (Set<Symbol>)ImmutableSet.copyOf(scanNode.getOutputSymbols()), (Map<Symbol, Cast>)ImmutableMap.of(), filterNode));
    }

    private PlanNode applyProjection(PlanNodeIdAllocator idAllocator, Set<Symbol> requiredSymbols, Map<Symbol, Cast> casts, PlanNode source) {
        if (casts.isEmpty() && requiredSymbols.equals(ImmutableSet.copyOf(source.getOutputSymbols()))) {
            return source;
        }
        return new ProjectNode(idAllocator.getNextId(), source, Assignments.builder().putIdentities((Iterable<Symbol>)Sets.difference(requiredSymbols, casts.keySet())).putAll(casts).build());
    }

    private Cast getCast(CatalogSchemaTableName destinationTable, String destinationColumn, Type destinationType, Symbol destinationSymbol, CatalogSchemaTableName sourceTable, ColumnHandle sourceColumnHandle, Type sourceType) {
        try {
            this.metadata.getCoercion(destinationType, sourceType);
        }
        catch (TrinoException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Cast not possible from redirected column %s.%s with type %s to source column %s.%s with type: %s", destinationTable, destinationColumn, destinationType, sourceTable, sourceColumnHandle, sourceType));
        }
        return new Cast((Expression)destinationSymbol.toSymbolReference(), TypeSignatureTranslator.toSqlType(sourceType), false, this.typeCoercion.isTypeOnlyCoercion(destinationType, sourceType));
    }

    private /* synthetic */ Symbol lambda$apply$2(Map inverseColumnsMapping, Map inverseAssignments, TupleDomain requiredFilter, Rule.Context context, Map destinationColumnHandles, CatalogSchemaTableName destinationTable, Optional destinationTableHandle, CatalogSchemaTableName sourceTable, ImmutableMap.Builder casts, ImmutableMap.Builder newAssignmentsBuilder, String destinationColumn) {
        ColumnHandle sourceColumnHandle = (ColumnHandle)inverseColumnsMapping.get(destinationColumn);
        if (sourceColumnHandle == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, String.format("Did not find mapping for destination column %s in table scan redirection", destinationColumn));
        }
        Symbol symbol = (Symbol)inverseAssignments.get(sourceColumnHandle);
        if (symbol != null) {
            return symbol;
        }
        Type domainType = ((Domain)((Map)requiredFilter.getDomains().get()).get(destinationColumn)).getType();
        symbol = context.getSymbolAllocator().newSymbol(destinationColumn, domainType);
        ColumnHandle destinationColumnHandle = (ColumnHandle)destinationColumnHandles.get(destinationColumn);
        if (destinationColumnHandle == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, String.format("Did not find handle for column %s in destination table %s", destinationColumn, destinationTable));
        }
        Type redirectedType = this.metadata.getColumnMetadata(context.getSession(), (TableHandle)destinationTableHandle.get(), destinationColumnHandle).getType();
        if (!domainType.equals(redirectedType)) {
            Symbol redirectedSymbol = context.getSymbolAllocator().newSymbol(destinationColumn, redirectedType);
            Cast cast = this.getCast(destinationTable, destinationColumn, redirectedType, redirectedSymbol, sourceTable, sourceColumnHandle, domainType);
            casts.put((Object)symbol, (Object)cast);
            newAssignmentsBuilder.put((Object)redirectedSymbol, (Object)destinationColumnHandle);
        } else {
            newAssignmentsBuilder.put((Object)symbol, (Object)destinationColumnHandle);
        }
        return symbol;
    }
}

