/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.metadata.Metadata;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.LogicalBinaryExpression;

public class RemoveDuplicateConditions
extends ExpressionRewriteRuleSet {
    public RemoveDuplicateConditions(Metadata metadata) {
        super(RemoveDuplicateConditions.createRewrite(metadata));
    }

    private static ExpressionRewriteRuleSet.ExpressionRewriter createRewrite(Metadata metadata) {
        return (expression, context) -> ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(metadata), (Expression)expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Metadata metadata;

        public Visitor(Metadata metadata) {
            this.metadata = metadata;
        }

        public Expression rewriteLogicalBinaryExpression(LogicalBinaryExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            return ExpressionUtils.combinePredicates(this.metadata, node.getOperator(), ExpressionUtils.extractPredicates(node));
        }
    }
}

