/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import io.trino.Session;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.spi.connector.ColumnHandle;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.NodeAndMappings;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.optimizations.SymbolMapper;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DeleteNode;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.ExplainAnalyzeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.IndexSourceNode;
import io.trino.sql.planner.plan.IntersectNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.OffsetNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RefreshMaterializedViewNode;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.SampleNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableDeleteNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.UpdateNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.SymbolReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class UnaliasSymbolReferences
implements PlanOptimizer {
    private final Metadata metadata;

    public UnaliasSymbolReferences(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return plan.accept(new Visitor(this.metadata, SymbolMapper::symbolMapper), UnaliasContext.empty()).getRoot();
    }

    public NodeAndMappings reallocateSymbols(PlanNode plan, List<Symbol> fields, SymbolAllocator symbolAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(fields, "fields is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        PlanAndMappings result = plan.accept(new Visitor(this.metadata, mapping -> SymbolMapper.symbolReallocator(mapping, symbolAllocator)), UnaliasContext.empty());
        return new NodeAndMappings(result.getRoot(), SymbolMapper.symbolMapper(result.getMappings()).map(fields));
    }

    private static class PlanAndMappings {
        private final PlanNode root;
        private final Map<Symbol, Symbol> mappings;

        public PlanAndMappings(PlanNode root, Map<Symbol, Symbol> mappings) {
            this.root = Objects.requireNonNull(root, "root is null");
            this.mappings = ImmutableMap.copyOf(Objects.requireNonNull(mappings, "mappings is null"));
        }

        public PlanNode getRoot() {
            return this.root;
        }

        public Map<Symbol, Symbol> getMappings() {
            return this.mappings;
        }
    }

    private static class UnaliasContext {
        private final Map<Symbol, Symbol> correlationMapping;

        public UnaliasContext(Map<Symbol, Symbol> correlationMapping) {
            this.correlationMapping = Objects.requireNonNull(correlationMapping, "correlationMapping is null");
        }

        public static UnaliasContext empty() {
            return new UnaliasContext((Map<Symbol, Symbol>)ImmutableMap.of());
        }

        public Map<Symbol, Symbol> getCorrelationMapping() {
            return this.correlationMapping;
        }
    }

    private static class Visitor
    extends PlanVisitor<PlanAndMappings, UnaliasContext> {
        private final Metadata metadata;
        private final Function<Map<Symbol, Symbol>, SymbolMapper> mapperProvider;

        public Visitor(Metadata metadata, Function<Map<Symbol, Symbol>, SymbolMapper> mapperProvider) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.mapperProvider = Objects.requireNonNull(mapperProvider, "mapperProvider is null");
        }

        private SymbolMapper symbolMapper(Map<Symbol, Symbol> mappings) {
            return this.mapperProvider.apply(mappings);
        }

        @Override
        protected PlanAndMappings visitPlan(PlanNode node, UnaliasContext context) {
            throw new UnsupportedOperationException("Unsupported plan node " + node.getClass().getSimpleName());
        }

        @Override
        public PlanAndMappings visitAggregation(AggregationNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            AggregationNode rewrittenAggregation = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenAggregation, mapping);
        }

        @Override
        public PlanAndMappings visitGroupId(GroupIdNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            GroupIdNode rewrittenGroupId = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenGroupId, mapping);
        }

        @Override
        public PlanAndMappings visitExplainAnalyze(ExplainAnalyzeNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            Symbol newOutputSymbol = mapper.map(node.getOutputSymbol());
            List<Symbol> actualOutputs = mapper.map(node.getActualOutputs());
            return new PlanAndMappings(new ExplainAnalyzeNode(node.getId(), rewrittenSource.getRoot(), newOutputSymbol, actualOutputs, node.isVerbose()), mapping);
        }

        @Override
        public PlanAndMappings visitMarkDistinct(MarkDistinctNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            Symbol newMarkerSymbol = mapper.map(node.getMarkerSymbol());
            List<Symbol> newDistinctSymbols = mapper.mapAndDistinct(node.getDistinctSymbols());
            Optional<Symbol> newHashSymbol = node.getHashSymbol().map(mapper::map);
            return new PlanAndMappings(new MarkDistinctNode(node.getId(), rewrittenSource.getRoot(), newMarkerSymbol, newDistinctSymbols, newHashSymbol), mapping);
        }

        @Override
        public PlanAndMappings visitUnnest(UnnestNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            List<Symbol> newReplicateSymbols = mapper.mapAndDistinct(node.getReplicateSymbols());
            ImmutableList.Builder newMappings = ImmutableList.builder();
            for (UnnestNode.Mapping unnestMapping : node.getMappings()) {
                newMappings.add((Object)new UnnestNode.Mapping(mapper.map(unnestMapping.getInput()), mapper.map(unnestMapping.getOutputs())));
            }
            Optional<Symbol> newOrdinalitySymbol = node.getOrdinalitySymbol().map(mapper::map);
            Optional<Expression> newFilter = node.getFilter().map(mapper::map);
            return new PlanAndMappings(new UnnestNode(node.getId(), rewrittenSource.getRoot(), newReplicateSymbols, (List<UnnestNode.Mapping>)newMappings.build(), newOrdinalitySymbol, node.getJoinType(), newFilter), mapping);
        }

        @Override
        public PlanAndMappings visitWindow(WindowNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            WindowNode rewrittenWindow = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenWindow, mapping);
        }

        @Override
        public PlanAndMappings visitPatternRecognition(PatternRecognitionNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            PatternRecognitionNode rewrittenPatternRecognition = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenPatternRecognition, mapping);
        }

        @Override
        public PlanAndMappings visitTableScan(TableScanNode node, UnaliasContext context) {
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(context.getCorrelationMapping());
            SymbolMapper mapper = this.symbolMapper(mapping);
            List<Symbol> newOutputs = mapper.map(node.getOutputSymbols());
            Optional<PlanNodeStatsEstimate> statistics = node.getStatistics();
            PlanNodeStatsEstimate.Builder newStatistics = PlanNodeStatsEstimate.builder();
            statistics.ifPresent(stats -> newStatistics.setOutputRowCount(stats.getOutputRowCount()));
            HashMap<Symbol, ColumnHandle> newAssignments = new HashMap<Symbol, ColumnHandle>();
            node.getAssignments().forEach((symbol, handle) -> {
                Symbol newSymbol = mapper.map((Symbol)symbol);
                newAssignments.put(newSymbol, (ColumnHandle)handle);
                statistics.ifPresent(stats -> newStatistics.addSymbolStatistics(newSymbol, stats.getSymbolStatistics((Symbol)symbol)));
            });
            return new PlanAndMappings(new TableScanNode(node.getId(), node.getTable(), newOutputs, newAssignments, node.getEnforcedConstraint(), statistics.isPresent() ? Optional.of(newStatistics.build()) : Optional.empty(), node.isUpdateTarget(), node.getUseConnectorNodePartitioning()), mapping);
        }

        @Override
        public PlanAndMappings visitExchange(ExchangeNode node, UnaliasContext context) {
            SymbolMapper mapper;
            ImmutableList.Builder rewrittenChildren = ImmutableList.builder();
            ImmutableList.Builder rewrittenInputsBuilder = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanAndMappings rewrittenChild = node.getSources().get(i).accept(this, context);
                rewrittenChildren.add((Object)rewrittenChild.getRoot());
                mapper = this.symbolMapper(new HashMap<Symbol, Symbol>(rewrittenChild.getMappings()));
                rewrittenInputsBuilder.add(mapper.map(node.getInputs().get(i)));
            }
            ImmutableList rewrittenInputs = rewrittenInputsBuilder.build();
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(context.getCorrelationMapping());
            mapper = this.symbolMapper(mapping);
            List<Symbol> rewrittenOutputs = mapper.map(node.getOutputSymbols());
            HashMap<Symbol, ImmutableList> outputsToInputs = new HashMap<Symbol, ImmutableList>();
            for (int i = 0; i < rewrittenOutputs.size(); ++i) {
                ImmutableList.Builder inputsBuilder = ImmutableList.builder();
                for (List inputs : rewrittenInputs) {
                    inputsBuilder.add((Object)((Symbol)inputs.get(i)));
                }
                ImmutableList inputs = inputsBuilder.build();
                List previous = (List)outputsToInputs.put(rewrittenOutputs.get(i), inputs);
                Preconditions.checkState((previous == null || inputs.equals(previous) ? 1 : 0) != 0, (Object)"different inputs mapped to the same output symbol");
            }
            HashMap<Symbol, Symbol> newMapping = new HashMap<Symbol, Symbol>();
            if (rewrittenInputs.size() == 1) {
                for (int i = 0; i < rewrittenOutputs.size(); ++i) {
                    Symbol input;
                    Symbol output = rewrittenOutputs.get(i);
                    if (output.equals(input = (Symbol)((List)rewrittenInputs.get(0)).get(i))) continue;
                    newMapping.put(output, input);
                }
            } else {
                HashMap<ImmutableList, Symbol> inputsToOutputs = new HashMap<ImmutableList, Symbol>();
                for (int i = 0; i < rewrittenOutputs.size(); ++i) {
                    ImmutableList.Builder inputsBuilder = ImmutableList.builder();
                    for (List inputs : rewrittenInputs) {
                        inputsBuilder.add((Object)((Symbol)inputs.get(i)));
                    }
                    ImmutableList inputs = inputsBuilder.build();
                    Symbol previous = (Symbol)inputsToOutputs.get(inputs);
                    if (previous == null || rewrittenOutputs.get(i).equals(previous)) {
                        inputsToOutputs.put(inputs, rewrittenOutputs.get(i));
                        continue;
                    }
                    newMapping.put(rewrittenOutputs.get(i), previous);
                }
            }
            HashMap<Symbol, Symbol> outputMapping = new HashMap<Symbol, Symbol>();
            outputMapping.putAll(mapping);
            outputMapping.putAll(newMapping);
            mapper = this.symbolMapper(outputMapping);
            ArrayList<List<Symbol>> newInputs = new ArrayList<List<Symbol>>();
            for (int i = 0; i < node.getInputs().size(); ++i) {
                newInputs.add(new ArrayList());
            }
            ImmutableList.Builder newOutputs = ImmutableList.builder();
            HashSet<Symbol> addedOutputs = new HashSet<Symbol>();
            for (int i = 0; i < rewrittenOutputs.size(); ++i) {
                Symbol output = mapper.map(rewrittenOutputs.get(i));
                if (!addedOutputs.add(output)) continue;
                newOutputs.add((Object)output);
                for (int j = 0; j < rewrittenInputs.size(); ++j) {
                    ((List)newInputs.get(j)).add((Symbol)((List)rewrittenInputs.get(j)).get(i));
                }
            }
            PartitioningScheme newPartitioningScheme = mapper.map(node.getPartitioningScheme(), (List<Symbol>)newOutputs.build());
            Optional<OrderingScheme> newOrderingScheme = node.getOrderingScheme().map(mapper::map);
            return new PlanAndMappings(new ExchangeNode(node.getId(), node.getType(), node.getScope(), newPartitioningScheme, (List<PlanNode>)rewrittenChildren.build(), newInputs, newOrderingScheme), outputMapping);
        }

        @Override
        public PlanAndMappings visitRemoteSource(RemoteSourceNode node, UnaliasContext context) {
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(context.getCorrelationMapping());
            SymbolMapper mapper = this.symbolMapper(mapping);
            List<Symbol> newOutputs = mapper.mapAndDistinct(node.getOutputSymbols());
            Optional<OrderingScheme> newOrderingScheme = node.getOrderingScheme().map(mapper::map);
            return new PlanAndMappings(new RemoteSourceNode(node.getId(), node.getSourceFragmentIds(), newOutputs, newOrderingScheme, node.getExchangeType()), mapping);
        }

        @Override
        public PlanAndMappings visitOffset(OffsetNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            return new PlanAndMappings(node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)rewrittenSource.getRoot())), rewrittenSource.getMappings());
        }

        @Override
        public PlanAndMappings visitLimit(LimitNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            LimitNode rewrittenLimit = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenLimit, mapping);
        }

        @Override
        public PlanAndMappings visitDistinctLimit(DistinctLimitNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            DistinctLimitNode rewrittenDistinctLimit = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenDistinctLimit, mapping);
        }

        @Override
        public PlanAndMappings visitSample(SampleNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            return new PlanAndMappings(node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)rewrittenSource.getRoot())), rewrittenSource.getMappings());
        }

        @Override
        public PlanAndMappings visitValues(ValuesNode node, UnaliasContext context) {
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(context.getCorrelationMapping());
            SymbolMapper mapper = this.symbolMapper(mapping);
            if (node.getRows().isEmpty()) {
                return new PlanAndMappings(node, mapping);
            }
            if (node.getRows().get().stream().anyMatch(row -> !(row instanceof Row))) {
                List newRows = (List)node.getRows().get().stream().map(mapper::map).collect(ImmutableList.toImmutableList());
                List newOutputs = (List)node.getOutputSymbols().stream().map(mapper::map).distinct().collect(ImmutableList.toImmutableList());
                Preconditions.checkState((newOutputs.size() == node.getOutputSymbols().size() ? 1 : 0) != 0, (Object)"duplicate output symbol in Values");
                return new PlanAndMappings(new ValuesNode(node.getId(), newOutputs, newRows), mapping);
            }
            ImmutableList.Builder rewrittenAssignmentsBuilder = ImmutableList.builder();
            for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                ImmutableList.Builder expressionsBuilder = ImmutableList.builder();
                for (Expression row2 : node.getRows().get()) {
                    expressionsBuilder.add((Object)mapper.map((Expression)((Row)row2).getItems().get(i)));
                }
                rewrittenAssignmentsBuilder.add(new AbstractMap.SimpleEntry<Symbol, ImmutableList>(mapper.map(node.getOutputSymbols().get(i)), expressionsBuilder.build()));
            }
            ImmutableList rewrittenAssignments = rewrittenAssignmentsBuilder.build();
            Map deduplicateAssignments = (Map)rewrittenAssignments.stream().collect(ImmutableMap.toImmutableMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, (previous, current) -> {
                Preconditions.checkState((boolean)previous.equals(current), (Object)"different expressions mapped to the same output symbol");
                return previous;
            }));
            List newOutputs = (List)deduplicateAssignments.keySet().stream().collect(ImmutableList.toImmutableList());
            ArrayList<ImmutableList.Builder> newRows = new ArrayList<ImmutableList.Builder>(node.getRowCount());
            for (int i = 0; i < node.getRowCount(); ++i) {
                newRows.add(ImmutableList.builder());
            }
            for (List expressions : deduplicateAssignments.values()) {
                for (int i = 0; i < expressions.size(); ++i) {
                    ((ImmutableList.Builder)newRows.get(i)).add((Object)((Expression)expressions.get(i)));
                }
            }
            return new PlanAndMappings(new ValuesNode(node.getId(), newOutputs, (List)newRows.stream().map(ImmutableList.Builder::build).map(Row::new).collect(ImmutableList.toImmutableList())), mapping);
        }

        @Override
        public PlanAndMappings visitTableDelete(TableDeleteNode node, UnaliasContext context) {
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(context.getCorrelationMapping());
            SymbolMapper mapper = this.symbolMapper(mapping);
            Symbol newOutput = mapper.map(node.getOutput());
            return new PlanAndMappings(new TableDeleteNode(node.getId(), node.getTarget(), newOutput), mapping);
        }

        @Override
        public PlanAndMappings visitDelete(DeleteNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            Symbol newRowId = mapper.map(node.getRowId());
            List<Symbol> newOutputs = mapper.map(node.getOutputSymbols());
            return new PlanAndMappings(new DeleteNode(node.getId(), rewrittenSource.getRoot(), node.getTarget(), newRowId, newOutputs), mapping);
        }

        @Override
        public PlanAndMappings visitUpdate(UpdateNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            Symbol newRowId = mapper.map(node.getRowId());
            List<Symbol> newColumnValueSymbols = mapper.map(node.getColumnValueAndRowIdSymbols());
            List<Symbol> newOutputs = mapper.map(node.getOutputSymbols());
            return new PlanAndMappings(new UpdateNode(node.getId(), rewrittenSource.getRoot(), node.getTarget(), newRowId, newColumnValueSymbols, newOutputs), mapping);
        }

        @Override
        public PlanAndMappings visitStatisticsWriterNode(StatisticsWriterNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            StatisticsWriterNode rewrittenStatisticsWriter = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenStatisticsWriter, mapping);
        }

        @Override
        public PlanAndMappings visitRefreshMaterializedView(RefreshMaterializedViewNode node, UnaliasContext context) {
            return new PlanAndMappings(node, (Map<Symbol, Symbol>)ImmutableMap.of());
        }

        @Override
        public PlanAndMappings visitTableWriter(TableWriterNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            TableWriterNode rewrittenTableWriter = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenTableWriter, mapping);
        }

        @Override
        public PlanAndMappings visitTableFinish(TableFinishNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            TableFinishNode rewrittenTableFinish = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenTableFinish, mapping);
        }

        @Override
        public PlanAndMappings visitRowNumber(RowNumberNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            RowNumberNode rewrittenRowNumber = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenRowNumber, mapping);
        }

        @Override
        public PlanAndMappings visitTopNRanking(TopNRankingNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            TopNRankingNode rewrittenTopNRanking = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenTopNRanking, mapping);
        }

        @Override
        public PlanAndMappings visitTopN(TopNNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            TopNNode rewrittenTopN = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenTopN, mapping);
        }

        @Override
        public PlanAndMappings visitSort(SortNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            OrderingScheme newOrderingScheme = mapper.map(node.getOrderingScheme());
            return new PlanAndMappings(new SortNode(node.getId(), rewrittenSource.getRoot(), newOrderingScheme, node.isPartial()), mapping);
        }

        @Override
        public PlanAndMappings visitFilter(FilterNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            Expression newPredicate = mapper.map(node.getPredicate());
            return new PlanAndMappings(new FilterNode(node.getId(), rewrittenSource.getRoot(), newPredicate), mapping);
        }

        @Override
        public PlanAndMappings visitProject(ProjectNode node, UnaliasContext context) {
            ImmutableSet symbolsInCorrelationMapping;
            ImmutableSet symbolsInSourceMapping;
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            Assignments assignments = node.getAssignments();
            Set<Symbol> newlyAssignedSymbols = assignments.filter(output -> !assignments.isIdentity((Symbol)output)).getSymbols();
            boolean ambiguousSymbolsPresent = !Sets.intersection(newlyAssignedSymbols, (Set)Sets.difference((Set)(symbolsInSourceMapping = ImmutableSet.builder().addAll(rewrittenSource.getMappings().keySet()).addAll(rewrittenSource.getMappings().values()).build()), (Set)(symbolsInCorrelationMapping = ImmutableSet.builder().addAll(context.getCorrelationMapping().keySet()).addAll(context.getCorrelationMapping().values()).build()))).isEmpty();
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            ImmutableList.Builder rewrittenAssignments = ImmutableList.builder();
            for (Map.Entry<Symbol, Expression> assignment : node.getAssignments().entrySet()) {
                rewrittenAssignments.add(new AbstractMap.SimpleEntry<Symbol, Expression>(ambiguousSymbolsPresent ? assignment.getKey() : mapper.map(assignment.getKey()), mapper.map(assignment.getValue())));
            }
            Map deduplicateAssignments = (Map)rewrittenAssignments.build().stream().distinct().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<Symbol, Symbol> newMapping = this.mappingFromAssignments(deduplicateAssignments, ambiguousSymbolsPresent);
            HashMap<Symbol, Symbol> outputMapping = new HashMap<Symbol, Symbol>();
            outputMapping.putAll(ambiguousSymbolsPresent ? context.getCorrelationMapping() : mapping);
            outputMapping.putAll(newMapping);
            mapper = this.symbolMapper(outputMapping);
            Assignments.Builder newAssignments = Assignments.builder();
            for (Map.Entry assignment : deduplicateAssignments.entrySet()) {
                newAssignments.put(mapper.map((Symbol)assignment.getKey()), (Expression)assignment.getValue());
            }
            return new PlanAndMappings(new ProjectNode(node.getId(), rewrittenSource.getRoot(), newAssignments.build()), outputMapping);
        }

        private Map<Symbol, Symbol> mappingFromAssignments(Map<Symbol, Expression> assignments, boolean ambiguousSymbolsPresent) {
            HashMap<Symbol, Symbol> newMapping = new HashMap<Symbol, Symbol>();
            HashMap<Expression, Symbol> inputsToOutputs = new HashMap<Expression, Symbol>();
            for (Map.Entry<Symbol, Expression> assignment : assignments.entrySet()) {
                Expression expression = assignment.getValue();
                if (expression instanceof SymbolReference && !ambiguousSymbolsPresent) {
                    Symbol value = Symbol.from(expression);
                    if (assignment.getKey().equals(value)) continue;
                    newMapping.put(assignment.getKey(), value);
                    continue;
                }
                if (!DeterminismEvaluator.isDeterministic(expression, this.metadata) || expression instanceof NullLiteral) continue;
                Symbol previous = (Symbol)inputsToOutputs.get(expression);
                if (previous == null) {
                    inputsToOutputs.put(expression, assignment.getKey());
                    continue;
                }
                newMapping.put(assignment.getKey(), previous);
            }
            return newMapping;
        }

        @Override
        public PlanAndMappings visitOutput(OutputNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            List<Symbol> newOutputs = mapper.map(node.getOutputSymbols());
            return new PlanAndMappings(new OutputNode(node.getId(), rewrittenSource.getRoot(), node.getColumnNames(), newOutputs), mapping);
        }

        @Override
        public PlanAndMappings visitEnforceSingleRow(EnforceSingleRowNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            return new PlanAndMappings(node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)rewrittenSource.getRoot())), rewrittenSource.getMappings());
        }

        @Override
        public PlanAndMappings visitAssignUniqueId(AssignUniqueId node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            Symbol newUnique = mapper.map(node.getIdColumn());
            return new PlanAndMappings(new AssignUniqueId(node.getId(), rewrittenSource.getRoot(), newUnique), mapping);
        }

        @Override
        public PlanAndMappings visitApply(ApplyNode node, UnaliasContext context) {
            PlanAndMappings rewrittenInput = node.getInput().accept(this, context);
            HashMap<Symbol, Symbol> inputMapping = new HashMap<Symbol, Symbol>(rewrittenInput.getMappings());
            SymbolMapper mapper = this.symbolMapper(inputMapping);
            List<Symbol> rewrittenCorrelation = mapper.mapAndDistinct(node.getCorrelation());
            ImmutableSet correlationSymbols = ImmutableSet.copyOf(node.getCorrelation());
            HashMap<Symbol, Symbol> correlationMapping = new HashMap<Symbol, Symbol>();
            for (Map.Entry entry : inputMapping.entrySet()) {
                if (!correlationSymbols.contains(entry.getKey())) continue;
                correlationMapping.put((Symbol)entry.getKey(), mapper.map((Symbol)entry.getKey()));
            }
            HashMap<Symbol, Symbol> mappingForSubquery = new HashMap<Symbol, Symbol>();
            mappingForSubquery.putAll(context.getCorrelationMapping());
            mappingForSubquery.putAll(correlationMapping);
            PlanAndMappings rewrittenSubquery = node.getSubquery().accept(this, new UnaliasContext(mappingForSubquery));
            HashMap<Symbol, Symbol> resultMapping = new HashMap<Symbol, Symbol>();
            resultMapping.putAll(rewrittenInput.getMappings());
            resultMapping.putAll(rewrittenSubquery.getMappings());
            mapper = this.symbolMapper(resultMapping);
            ImmutableList.Builder rewrittenAssignments = ImmutableList.builder();
            for (Map.Entry<Symbol, Expression> assignment : node.getSubqueryAssignments().entrySet()) {
                rewrittenAssignments.add(new AbstractMap.SimpleEntry<Symbol, Expression>(mapper.map(assignment.getKey()), mapper.map(assignment.getValue())));
            }
            Map deduplicateAssignments = (Map)rewrittenAssignments.build().stream().distinct().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<Symbol, Symbol> newMapping = this.mappingFromAssignments(deduplicateAssignments, false);
            HashMap<Symbol, Symbol> assignmentsOutputMapping = new HashMap<Symbol, Symbol>();
            assignmentsOutputMapping.putAll(resultMapping);
            assignmentsOutputMapping.putAll(newMapping);
            mapper = this.symbolMapper(assignmentsOutputMapping);
            Assignments.Builder newAssignments = Assignments.builder();
            for (Map.Entry assignment : deduplicateAssignments.entrySet()) {
                newAssignments.put(mapper.map((Symbol)assignment.getKey()), (Expression)assignment.getValue());
            }
            return new PlanAndMappings(new ApplyNode(node.getId(), rewrittenInput.getRoot(), rewrittenSubquery.getRoot(), newAssignments.build(), rewrittenCorrelation, node.getOriginSubquery()), assignmentsOutputMapping);
        }

        @Override
        public PlanAndMappings visitCorrelatedJoin(CorrelatedJoinNode node, UnaliasContext context) {
            PlanAndMappings rewrittenInput = node.getInput().accept(this, context);
            HashMap<Symbol, Symbol> inputMapping = new HashMap<Symbol, Symbol>(rewrittenInput.getMappings());
            SymbolMapper mapper = this.symbolMapper(inputMapping);
            List<Symbol> rewrittenCorrelation = mapper.mapAndDistinct(node.getCorrelation());
            ImmutableSet correlationSymbols = ImmutableSet.copyOf(node.getCorrelation());
            HashMap<Symbol, Symbol> correlationMapping = new HashMap<Symbol, Symbol>();
            for (Map.Entry entry : inputMapping.entrySet()) {
                if (!correlationSymbols.contains(entry.getKey())) continue;
                correlationMapping.put((Symbol)entry.getKey(), mapper.map((Symbol)entry.getKey()));
            }
            HashMap<Symbol, Symbol> mappingForSubquery = new HashMap<Symbol, Symbol>();
            mappingForSubquery.putAll(context.getCorrelationMapping());
            mappingForSubquery.putAll(correlationMapping);
            PlanAndMappings rewrittenSubquery = node.getSubquery().accept(this, new UnaliasContext(mappingForSubquery));
            HashMap<Symbol, Symbol> resultMapping = new HashMap<Symbol, Symbol>();
            resultMapping.putAll(rewrittenInput.getMappings());
            resultMapping.putAll(rewrittenSubquery.getMappings());
            mapper = this.symbolMapper(resultMapping);
            Expression newFilter = mapper.map(node.getFilter());
            return new PlanAndMappings(new CorrelatedJoinNode(node.getId(), rewrittenInput.getRoot(), rewrittenSubquery.getRoot(), rewrittenCorrelation, node.getType(), newFilter, node.getOriginSubquery()), resultMapping);
        }

        @Override
        public PlanAndMappings visitJoin(JoinNode node, UnaliasContext context) {
            PlanAndMappings rewrittenLeft = node.getLeft().accept(this, context);
            PlanAndMappings rewrittenRight = node.getRight().accept(this, context);
            HashMap<Symbol, Symbol> unifiedMapping = new HashMap<Symbol, Symbol>();
            unifiedMapping.putAll(rewrittenLeft.getMappings());
            unifiedMapping.putAll(rewrittenRight.getMappings());
            SymbolMapper mapper = this.symbolMapper(unifiedMapping);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JoinNode.EquiJoinClause clause2 : node.getCriteria()) {
                builder.add((Object)new JoinNode.EquiJoinClause(mapper.map(clause2.getLeft()), mapper.map(clause2.getRight())));
            }
            ImmutableList newCriteria = builder.build();
            Optional<Expression> newFilter = node.getFilter().map(mapper::map);
            Optional<Symbol> newLeftHashSymbol = node.getLeftHashSymbol().map(mapper::map);
            Optional<Symbol> newRightHashSymbol = node.getRightHashSymbol().map(mapper::map);
            HashSet<Symbol> added = new HashSet<Symbol>();
            ImmutableMap.Builder filtersBuilder = ImmutableMap.builder();
            for (Map.Entry<DynamicFilterId, Symbol> entry : node.getDynamicFilters().entrySet()) {
                Symbol canonical = mapper.map(entry.getValue());
                if (!added.add(canonical)) continue;
                filtersBuilder.put((Object)entry.getKey(), (Object)canonical);
            }
            ImmutableMap newDynamicFilters = filtersBuilder.build();
            HashMap newMapping = new HashMap();
            if (node.getType() == JoinNode.Type.INNER) {
                newCriteria.stream().forEach(clause -> newMapping.put(clause.getRight(), clause.getLeft()));
            }
            HashMap<Symbol, Symbol> outputMapping = new HashMap<Symbol, Symbol>();
            outputMapping.putAll(unifiedMapping);
            outputMapping.putAll(newMapping);
            mapper = this.symbolMapper(outputMapping);
            List<Symbol> canonicalOutputs = mapper.mapAndDistinct(node.getOutputSymbols());
            List newLeftOutputSymbols = (List)canonicalOutputs.stream().filter(rewrittenLeft.getRoot().getOutputSymbols()::contains).collect(ImmutableList.toImmutableList());
            List newRightOutputSymbols = (List)canonicalOutputs.stream().filter(rewrittenRight.getRoot().getOutputSymbols()::contains).collect(ImmutableList.toImmutableList());
            return new PlanAndMappings(new JoinNode(node.getId(), node.getType(), rewrittenLeft.getRoot(), rewrittenRight.getRoot(), (List<JoinNode.EquiJoinClause>)newCriteria, newLeftOutputSymbols, newRightOutputSymbols, node.isMaySkipOutputDuplicates(), newFilter, newLeftHashSymbol, newRightHashSymbol, node.getDistributionType(), node.isSpillable(), (Map<DynamicFilterId, Symbol>)newDynamicFilters, node.getReorderJoinStatsAndCost()), outputMapping);
        }

        @Override
        public PlanAndMappings visitSemiJoin(SemiJoinNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            PlanAndMappings rewrittenFilteringSource = node.getFilteringSource().accept(this, context);
            HashMap<Symbol, Symbol> outputMapping = new HashMap<Symbol, Symbol>();
            outputMapping.putAll(rewrittenSource.getMappings());
            outputMapping.putAll(rewrittenFilteringSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(outputMapping);
            Symbol newSourceJoinSymbol = mapper.map(node.getSourceJoinSymbol());
            Symbol newFilteringSourceJoinSymbol = mapper.map(node.getFilteringSourceJoinSymbol());
            Symbol newSemiJoinOutput = mapper.map(node.getSemiJoinOutput());
            Optional<Symbol> newSourceHashSymbol = node.getSourceHashSymbol().map(mapper::map);
            Optional<Symbol> newFilteringSourceHashSymbol = node.getFilteringSourceHashSymbol().map(mapper::map);
            return new PlanAndMappings(new SemiJoinNode(node.getId(), rewrittenSource.getRoot(), rewrittenFilteringSource.getRoot(), newSourceJoinSymbol, newFilteringSourceJoinSymbol, newSemiJoinOutput, newSourceHashSymbol, newFilteringSourceHashSymbol, node.getDistributionType(), node.getDynamicFilterId()), outputMapping);
        }

        @Override
        public PlanAndMappings visitSpatialJoin(SpatialJoinNode node, UnaliasContext context) {
            PlanAndMappings rewrittenLeft = node.getLeft().accept(this, context);
            PlanAndMappings rewrittenRight = node.getRight().accept(this, context);
            HashMap<Symbol, Symbol> outputMapping = new HashMap<Symbol, Symbol>();
            outputMapping.putAll(rewrittenLeft.getMappings());
            outputMapping.putAll(rewrittenRight.getMappings());
            SymbolMapper mapper = this.symbolMapper(outputMapping);
            List<Symbol> newOutputSymbols = mapper.mapAndDistinct(node.getOutputSymbols());
            Expression newFilter = mapper.map(node.getFilter());
            Optional<Symbol> newLeftPartitionSymbol = node.getLeftPartitionSymbol().map(mapper::map);
            Optional<Symbol> newRightPartitionSymbol = node.getRightPartitionSymbol().map(mapper::map);
            return new PlanAndMappings(new SpatialJoinNode(node.getId(), node.getType(), rewrittenLeft.getRoot(), rewrittenRight.getRoot(), newOutputSymbols, newFilter, newLeftPartitionSymbol, newRightPartitionSymbol, node.getKdbTree()), outputMapping);
        }

        @Override
        public PlanAndMappings visitIndexJoin(IndexJoinNode node, UnaliasContext context) {
            PlanAndMappings rewrittenProbe = node.getProbeSource().accept(this, context);
            PlanAndMappings rewrittenIndex = node.getIndexSource().accept(this, context);
            HashMap<Symbol, Symbol> outputMapping = new HashMap<Symbol, Symbol>();
            outputMapping.putAll(rewrittenProbe.getMappings());
            outputMapping.putAll(rewrittenIndex.getMappings());
            SymbolMapper mapper = this.symbolMapper(outputMapping);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                builder.add((Object)new IndexJoinNode.EquiJoinClause(mapper.map(clause.getProbe()), mapper.map(clause.getIndex())));
            }
            ImmutableList newEquiCriteria = builder.build();
            Optional<Symbol> newProbeHashSymbol = node.getProbeHashSymbol().map(mapper::map);
            Optional<Symbol> newIndexHashSymbol = node.getIndexHashSymbol().map(mapper::map);
            return new PlanAndMappings(new IndexJoinNode(node.getId(), node.getType(), rewrittenProbe.getRoot(), rewrittenIndex.getRoot(), (List<IndexJoinNode.EquiJoinClause>)newEquiCriteria, newProbeHashSymbol, newIndexHashSymbol), outputMapping);
        }

        @Override
        public PlanAndMappings visitIndexSource(IndexSourceNode node, UnaliasContext context) {
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(context.getCorrelationMapping());
            SymbolMapper mapper = this.symbolMapper(mapping);
            Set newLookupSymbols = (Set)node.getLookupSymbols().stream().map(mapper::map).collect(ImmutableSet.toImmutableSet());
            List<Symbol> newOutputSymbols = mapper.mapAndDistinct(node.getOutputSymbols());
            HashMap<Symbol, ColumnHandle> newAssignments = new HashMap<Symbol, ColumnHandle>();
            node.getAssignments().entrySet().stream().forEach(assignment -> newAssignments.put(mapper.map((Symbol)assignment.getKey()), (ColumnHandle)assignment.getValue()));
            return new PlanAndMappings(new IndexSourceNode(node.getId(), node.getIndexHandle(), node.getTableHandle(), newLookupSymbols, newOutputSymbols, newAssignments), mapping);
        }

        @Override
        public PlanAndMappings visitUnion(UnionNode node, UnaliasContext context) {
            List rewrittenSources = (List)node.getSources().stream().map(source -> source.accept(this, context)).collect(ImmutableList.toImmutableList());
            List inputMappers = (List)rewrittenSources.stream().map(source -> this.symbolMapper(new HashMap<Symbol, Symbol>(source.getMappings()))).collect(ImmutableList.toImmutableList());
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(context.getCorrelationMapping());
            SymbolMapper outputMapper = this.symbolMapper(mapping);
            ListMultimap<Symbol, Symbol> newOutputToInputs = this.rewriteOutputToInputsMap(node.getSymbolMapping(), outputMapper, inputMappers);
            List<Symbol> newOutputs = outputMapper.mapAndDistinct(node.getOutputSymbols());
            return new PlanAndMappings(new UnionNode(node.getId(), (List)rewrittenSources.stream().map(PlanAndMappings::getRoot).collect(ImmutableList.toImmutableList()), newOutputToInputs, newOutputs), mapping);
        }

        @Override
        public PlanAndMappings visitIntersect(IntersectNode node, UnaliasContext context) {
            List rewrittenSources = (List)node.getSources().stream().map(source -> source.accept(this, context)).collect(ImmutableList.toImmutableList());
            List inputMappers = (List)rewrittenSources.stream().map(source -> this.symbolMapper(new HashMap<Symbol, Symbol>(source.getMappings()))).collect(ImmutableList.toImmutableList());
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(context.getCorrelationMapping());
            SymbolMapper outputMapper = this.symbolMapper(mapping);
            ListMultimap<Symbol, Symbol> newOutputToInputs = this.rewriteOutputToInputsMap(node.getSymbolMapping(), outputMapper, inputMappers);
            List<Symbol> newOutputs = outputMapper.mapAndDistinct(node.getOutputSymbols());
            return new PlanAndMappings(new IntersectNode(node.getId(), (List)rewrittenSources.stream().map(PlanAndMappings::getRoot).collect(ImmutableList.toImmutableList()), newOutputToInputs, newOutputs, node.isDistinct()), mapping);
        }

        @Override
        public PlanAndMappings visitExcept(ExceptNode node, UnaliasContext context) {
            List rewrittenSources = (List)node.getSources().stream().map(source -> source.accept(this, context)).collect(ImmutableList.toImmutableList());
            List inputMappers = (List)rewrittenSources.stream().map(source -> this.symbolMapper(new HashMap<Symbol, Symbol>(source.getMappings()))).collect(ImmutableList.toImmutableList());
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(context.getCorrelationMapping());
            SymbolMapper outputMapper = this.symbolMapper(mapping);
            ListMultimap<Symbol, Symbol> newOutputToInputs = this.rewriteOutputToInputsMap(node.getSymbolMapping(), outputMapper, inputMappers);
            List<Symbol> newOutputs = outputMapper.mapAndDistinct(node.getOutputSymbols());
            return new PlanAndMappings(new ExceptNode(node.getId(), (List)rewrittenSources.stream().map(PlanAndMappings::getRoot).collect(ImmutableList.toImmutableList()), newOutputToInputs, newOutputs, node.isDistinct()), mapping);
        }

        private ListMultimap<Symbol, Symbol> rewriteOutputToInputsMap(ListMultimap<Symbol, Symbol> oldMapping, SymbolMapper outputMapper, List<SymbolMapper> inputMappers) {
            ImmutableListMultimap.Builder newMappingBuilder = ImmutableListMultimap.builder();
            HashSet<Symbol> addedSymbols = new HashSet<Symbol>();
            for (Map.Entry entry : oldMapping.asMap().entrySet()) {
                Symbol rewrittenOutput = outputMapper.map((Symbol)entry.getKey());
                if (!addedSymbols.add(rewrittenOutput)) continue;
                ImmutableList inputs = ImmutableList.copyOf((Collection)((Collection)entry.getValue()));
                ImmutableList.Builder rewrittenInputs = ImmutableList.builder();
                for (int i = 0; i < inputs.size(); ++i) {
                    rewrittenInputs.add((Object)inputMappers.get(i).map((Symbol)inputs.get(i)));
                }
                newMappingBuilder.putAll((Object)rewrittenOutput, (Iterable)rewrittenInputs.build());
            }
            return newMappingBuilder.build();
        }
    }
}

