/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.rowpattern;

import com.google.common.collect.ImmutableMap;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.rowpattern.LogicalIndexExtractor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.util.AstUtils;
import java.util.Map;
import java.util.function.BiFunction;

public class ExpressionAndValuePointersEquivalence {
    private ExpressionAndValuePointersEquivalence() {
    }

    public static boolean equivalent(LogicalIndexExtractor.ExpressionAndValuePointers left, LogicalIndexExtractor.ExpressionAndValuePointers right) {
        return ExpressionAndValuePointersEquivalence.equivalent(left, right, Symbol::equals);
    }

    public static boolean equivalent(LogicalIndexExtractor.ExpressionAndValuePointers left, LogicalIndexExtractor.ExpressionAndValuePointers right, BiFunction<Symbol, Symbol, Boolean> symbolEquivalence) {
        if (left.getLayout().size() != right.getLayout().size()) {
            return false;
        }
        for (int i = 0; i < left.getLayout().size(); ++i) {
            if (left.getValuePointers().get(i).getLogicalIndexPointer().equals(right.getValuePointers().get(i).getLogicalIndexPointer())) continue;
            return false;
        }
        ImmutableMap.Builder mapping = ImmutableMap.builder();
        for (int i = 0; i < left.getLayout().size(); ++i) {
            Symbol rightInputSymbol;
            Symbol leftInputSymbol;
            Symbol leftLayoutSymbol = left.getLayout().get(i);
            boolean leftIsClassifier = left.getClassifierSymbols().contains(leftLayoutSymbol);
            boolean leftIsMatchNumber = left.getMatchNumberSymbols().contains(leftLayoutSymbol);
            Symbol rightLayoutSymbol = right.getLayout().get(i);
            boolean rightIsClassifier = right.getClassifierSymbols().contains(rightLayoutSymbol);
            boolean rightIsMatchNumber = right.getMatchNumberSymbols().contains(rightLayoutSymbol);
            if (leftIsClassifier != rightIsClassifier || leftIsMatchNumber != rightIsMatchNumber) {
                return false;
            }
            if (!(leftIsClassifier || leftIsMatchNumber || symbolEquivalence.apply(leftInputSymbol = left.getValuePointers().get(i).getInputSymbol(), rightInputSymbol = right.getValuePointers().get(i).getInputSymbol()).booleanValue())) {
                return false;
            }
            mapping.put((Object)leftLayoutSymbol, (Object)rightLayoutSymbol);
        }
        return AstUtils.treeEqual((Node)left.getExpression(), (Node)right.getExpression(), ExpressionAndValuePointersEquivalence.mappingComparator((Map<Symbol, Symbol>)mapping.build()));
    }

    private static BiFunction<Node, Node, Boolean> mappingComparator(Map<Symbol, Symbol> mapping) {
        return (left, right) -> {
            if (left instanceof SymbolReference && right instanceof SymbolReference) {
                Symbol leftSymbol = Symbol.from((Expression)((SymbolReference)left));
                Symbol rightSymbol = Symbol.from((Expression)((SymbolReference)right));
                return rightSymbol.equals(mapping.get(leftSymbol));
            }
            if (!left.shallowEquals(right)) {
                return false;
            }
            return null;
        };
    }
}

