/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.rewrite;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.StatsCalculator;
import io.trino.execution.ParameterExtractor;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.spi.security.GroupProvider;
import io.trino.sql.ParsingUtil;
import io.trino.sql.QueryUtil;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.DescribeInput;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Limit;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.StringLiteral;
import io.trino.type.TypeUtils;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class DescribeInputRewrite
implements StatementRewrite.Rewrite {
    DescribeInputRewrite() {
    }

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, GroupProvider groupProvider, AccessControl accessControl, WarningCollector warningCollector, StatsCalculator statsCalculator) {
        return (Statement)new Visitor(session, parser, metadata, queryExplainer, parameters, parameterLookup, groupProvider, accessControl, warningCollector, statsCalculator).process((Node)node, null);
    }

    private static final class Visitor
    extends AstVisitor<Node, Void> {
        private final Session session;
        private final SqlParser parser;
        private final Metadata metadata;
        private final Optional<QueryExplainer> queryExplainer;
        private final List<Expression> parameters;
        private final Map<NodeRef<Parameter>, Expression> parameterLookup;
        private final GroupProvider groupProvider;
        private final AccessControl accessControl;
        private final WarningCollector warningCollector;
        private final StatsCalculator statsCalculator;

        public Visitor(Session session, SqlParser parser, Metadata metadata, Optional<QueryExplainer> queryExplainer, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, GroupProvider groupProvider, AccessControl accessControl, WarningCollector warningCollector, StatsCalculator statsCalculator) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.parser = parser;
            this.metadata = metadata;
            this.queryExplainer = queryExplainer;
            this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
            this.accessControl = accessControl;
            this.parameters = parameters;
            this.parameterLookup = parameterLookup;
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
            this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        }

        protected Node visitDescribeInput(DescribeInput node, Void context) {
            String sqlString = this.session.getPreparedStatement(node.getName().getValue());
            Statement statement = this.parser.createStatement(sqlString, ParsingUtil.createParsingOptions(this.session));
            Analyzer analyzer = new Analyzer(this.session, this.metadata, this.parser, this.groupProvider, this.accessControl, this.queryExplainer, this.parameters, this.parameterLookup, this.warningCollector, this.statsCalculator);
            Analysis analysis = analyzer.analyze(statement, true);
            List<Parameter> parameters = ParameterExtractor.getParameters(statement);
            Row[] rows = (Row[])parameters.stream().map(parameter -> Visitor.createDescribeInputRow(this.session, parameter, analysis)).toArray(Row[]::new);
            Optional<Object> limit = Optional.empty();
            if (rows.length == 0) {
                rows = new Row[]{QueryUtil.row((Expression[])new Expression[]{new NullLiteral(), new NullLiteral()})};
                limit = Optional.of(new Limit((Expression)new LongLiteral("0")));
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{QueryUtil.identifier((String)"Position"), QueryUtil.identifier((String)"Type")}), (Relation)QueryUtil.aliased((Relation)QueryUtil.values((Row[])rows), (String)"Parameter Input", (List)ImmutableList.of((Object)"Position", (Object)"Type")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"Position")})), Optional.empty(), limit);
        }

        private static Row createDescribeInputRow(Session session, Parameter parameter, Analysis queryAnalysis) {
            Object type = queryAnalysis.getCoercion((Expression)parameter);
            if (type == null) {
                type = UnknownType.UNKNOWN;
            }
            return QueryUtil.row((Expression[])new Expression[]{new LongLiteral(Integer.toString(parameter.getPosition())), new StringLiteral(TypeUtils.getDisplayLabel(type, SystemSessionProperties.isOmitDateTimeTypePrecision(session)))});
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

