/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import io.trino.GroupByHashPageIndexerFactory;
import io.trino.PagesIndexPageSorter;
import io.trino.connector.CatalogName;
import io.trino.connector.ConnectorAwareNodeManager;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.MetadataManager;
import io.trino.operator.PagesIndex;
import io.trino.spi.NodeManager;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.PageSorter;
import io.trino.spi.VersionEmbedder;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.JoinCompiler;
import io.trino.type.BlockTypeOperators;
import io.trino.type.InternalTypeManager;
import io.trino.version.EmbedVersion;

public final class TestingConnectorContext
implements ConnectorContext {
    private final NodeManager nodeManager;
    private final VersionEmbedder versionEmbedder = new EmbedVersion("testversion");
    private final TypeManager typeManager;
    private final PageSorter pageSorter = new PagesIndexPageSorter(new PagesIndex.TestingFactory(false));
    private final PageIndexerFactory pageIndexerFactory;

    public TestingConnectorContext() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        TypeOperators typeOperators = new TypeOperators();
        this.pageIndexerFactory = new GroupByHashPageIndexerFactory(new JoinCompiler(typeOperators), new BlockTypeOperators(typeOperators));
        this.typeManager = new InternalTypeManager(metadata, typeOperators);
        CatalogName catalogName = new CatalogName("test");
        InMemoryNodeManager inMemoryNodeManager = new InMemoryNodeManager();
        inMemoryNodeManager.addCurrentNodeConnector(catalogName);
        this.nodeManager = new ConnectorAwareNodeManager(inMemoryNodeManager, "testenv", catalogName, true);
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public VersionEmbedder getVersionEmbedder() {
        return this.versionEmbedder;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public PageSorter getPageSorter() {
        return this.pageSorter;
    }

    public PageIndexerFactory getPageIndexerFactory() {
        return this.pageIndexerFactory;
    }

    public ClassLoader duplicatePluginClassLoader() {
        return this.getClass().getClassLoader();
    }
}

