/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.util.SingleAccessMethodCompiler;
import java.lang.invoke.MethodHandle;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

public final class BlockTypeOperators {
    private static final InvocationConvention BLOCK_EQUAL_CONVENTION = InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION});
    private static final InvocationConvention HASH_CODE_CONVENTION = InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION});
    private static final InvocationConvention XX_HASH_64_CONVENTION = InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION});
    private static final InvocationConvention IS_DISTINCT_FROM_CONVENTION = InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION});
    private static final InvocationConvention COMPARISON_CONVENTION = InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION});
    private static final InvocationConvention ORDERING_CONVENTION = InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION});
    private static final InvocationConvention LESS_THAN_CONVENTION = InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION});
    private final Cache<GeneratedBlockOperatorKey<?>, GeneratedBlockOperator<?>> generatedBlockOperatorCache;
    private final TypeOperators typeOperators;

    public BlockTypeOperators() {
        this(new TypeOperators());
    }

    @Inject
    public BlockTypeOperators(TypeOperators typeOperators) {
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.generatedBlockOperatorCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(2L, TimeUnit.HOURS).build();
    }

    public BlockPositionEqual getEqualOperator(Type type) {
        return this.getBlockOperator(type, BlockPositionEqual.class, () -> this.typeOperators.getEqualOperator(type, BLOCK_EQUAL_CONVENTION));
    }

    public BlockPositionHashCode getHashCodeOperator(Type type) {
        return this.getBlockOperator(type, BlockPositionHashCode.class, () -> this.typeOperators.getHashCodeOperator(type, HASH_CODE_CONVENTION));
    }

    public BlockPositionXxHash64 getXxHash64Operator(Type type) {
        return this.getBlockOperator(type, BlockPositionXxHash64.class, () -> this.typeOperators.getXxHash64Operator(type, XX_HASH_64_CONVENTION));
    }

    public BlockPositionIsDistinctFrom getDistinctFromOperator(Type type) {
        return this.getBlockOperator(type, BlockPositionIsDistinctFrom.class, () -> this.typeOperators.getDistinctFromOperator(type, IS_DISTINCT_FROM_CONVENTION));
    }

    public BlockPositionComparison getComparisonOperator(Type type) {
        return this.getBlockOperator(type, BlockPositionComparison.class, () -> this.typeOperators.getComparisonOperator(type, COMPARISON_CONVENTION));
    }

    public BlockPositionOrdering generateBlockPositionOrdering(Type type, SortOrder sortOrder) {
        return this.getBlockOperator(type, BlockPositionOrdering.class, () -> this.typeOperators.getOrderingOperator(type, sortOrder, ORDERING_CONVENTION), Optional.of(sortOrder));
    }

    public BlockPositionLessThan generateBlockPositionLessThan(Type type) {
        return this.getBlockOperator(type, BlockPositionLessThan.class, () -> this.typeOperators.getLessThanOperator(type, LESS_THAN_CONVENTION));
    }

    private <T> T getBlockOperator(Type type, Class<T> operatorInterface, Supplier<MethodHandle> methodHandleSupplier) {
        return this.getBlockOperator(type, operatorInterface, methodHandleSupplier, Optional.empty());
    }

    private <T> T getBlockOperator(Type type, Class<T> operatorInterface, Supplier<MethodHandle> methodHandleSupplier, Optional<Object> additionalKey) {
        try {
            GeneratedBlockOperator generatedBlockOperator = (GeneratedBlockOperator)this.generatedBlockOperatorCache.get(new GeneratedBlockOperatorKey<T>(type, operatorInterface, additionalKey), () -> new GeneratedBlockOperator(type, operatorInterface, (MethodHandle)methodHandleSupplier.get()));
            return generatedBlockOperator.get();
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }

    @Managed
    public long cacheSize() {
        return this.generatedBlockOperatorCache.size();
    }

    @Managed
    public Double getCacheHitRate() {
        return this.generatedBlockOperatorCache.stats().hitRate();
    }

    @Managed
    public Double getCacheMissRate() {
        return this.generatedBlockOperatorCache.stats().missRate();
    }

    @Managed
    public long getCacheRequestCount() {
        return this.generatedBlockOperatorCache.stats().requestCount();
    }

    @Managed
    public void cacheReset() {
        this.generatedBlockOperatorCache.invalidateAll();
    }

    private static class GeneratedBlockOperator<T> {
        private final Type type;
        private final Class<T> operatorInterface;
        private final MethodHandle methodHandle;
        @GuardedBy(value="this")
        private T operator;

        public GeneratedBlockOperator(Type type, Class<T> operatorInterface, MethodHandle methodHandle) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.operatorInterface = Objects.requireNonNull(operatorInterface, "operatorInterface is null");
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
        }

        public synchronized T get() {
            if (this.operator != null) {
                return this.operator;
            }
            String suggestedClassName = this.operatorInterface.getSimpleName() + "_" + this.type.getDisplayName();
            this.operator = SingleAccessMethodCompiler.compileSingleAccessMethod(suggestedClassName, this.operatorInterface, this.methodHandle);
            return this.operator;
        }
    }

    private static class GeneratedBlockOperatorKey<T> {
        private final Type type;
        private final Class<T> operatorInterface;
        private final Optional<Object> additionalKey;

        public GeneratedBlockOperatorKey(Type type, Class<T> operatorInterface, Optional<Object> additionalKey) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.operatorInterface = Objects.requireNonNull(operatorInterface, "operatorInterface is null");
            this.additionalKey = Objects.requireNonNull(additionalKey, "additionalKey is null");
        }

        public Type getType() {
            return this.type;
        }

        public Class<T> getOperatorInterface() {
            return this.operatorInterface;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GeneratedBlockOperatorKey that = (GeneratedBlockOperatorKey)o;
            return this.type.equals(that.type) && this.operatorInterface.equals(that.operatorInterface) && this.additionalKey.equals(that.additionalKey);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.operatorInterface, this.additionalKey);
        }
    }

    public static interface BlockPositionLessThan {
        public boolean lessThan(Block var1, int var2, Block var3, int var4);
    }

    public static interface BlockPositionOrdering {
        public int order(Block var1, int var2, Block var3, int var4);
    }

    private static class ReversedBlockPositionComparison
    implements BlockPositionComparison {
        private final BlockPositionComparison comparison;

        static BlockPositionComparison createReversedBlockPositionComparison(BlockPositionComparison comparison) {
            if (comparison instanceof ReversedBlockPositionComparison) {
                return ((ReversedBlockPositionComparison)comparison).comparison;
            }
            return new ReversedBlockPositionComparison(comparison);
        }

        private ReversedBlockPositionComparison(BlockPositionComparison comparison) {
            this.comparison = comparison;
        }

        @Override
        public long compare(Block leftBlock, int leftIndex, Block rightBlock, int rightIndex) {
            return this.comparison.compare(rightBlock, rightIndex, leftBlock, leftIndex);
        }
    }

    public static interface BlockPositionComparison {
        public long compare(Block var1, int var2, Block var3, int var4);

        default public BlockPositionComparison reversed() {
            return ReversedBlockPositionComparison.createReversedBlockPositionComparison(this);
        }
    }

    public static interface BlockPositionIsDistinctFrom {
        public boolean isDistinctFrom(Block var1, int var2, Block var3, int var4);
    }

    public static interface BlockPositionXxHash64 {
        public long xxHash64(Block var1, int var2);
    }

    public static interface BlockPositionHashCode {
        public long hashCode(Block var1, int var2);

        default public long hashCodeNullSafe(Block block, int position) {
            if (block.isNull(position)) {
                return 0L;
            }
            return this.hashCode(block, position);
        }
    }

    public static interface BlockPositionEqual {
        public Boolean equal(Block var1, int var2, Block var3, int var4);

        default public boolean equalNullSafe(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
            boolean leftIsNull = leftBlock.isNull(leftPosition);
            boolean rightIsNull = rightBlock.isNull(rightPosition);
            if (leftIsNull || rightIsNull) {
                return leftIsNull && rightIsNull;
            }
            return this.equal(leftBlock, leftPosition, rightBlock, rightPosition);
        }
    }
}

