/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.metadata.Metadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import java.util.Objects;
import javax.inject.Inject;

public final class InternalTypeManager
implements TypeManager {
    private final Metadata metadata;
    private final TypeOperators typeOperators;

    @Inject
    public InternalTypeManager(Metadata metadata, TypeOperators typeOperators) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
    }

    public Type getType(TypeSignature signature) {
        return this.metadata.getType(signature);
    }

    public Type fromSqlType(String type) {
        return this.metadata.fromSqlType(type);
    }

    public Type getType(TypeId id) {
        return this.metadata.getType(id);
    }

    public TypeOperators getTypeOperators() {
        return this.typeOperators;
    }
}

