/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;

public final class TinyintOperators {
    private TinyintOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="tinyint")
    public static long add(@SqlType(value="tinyint") long left, @SqlType(value="tinyint") long right) {
        try {
            return SignedBytes.checkedCast((long)(left + right));
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("tinyint addition overflow: %s + %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="tinyint")
    public static long subtract(@SqlType(value="tinyint") long left, @SqlType(value="tinyint") long right) {
        try {
            return SignedBytes.checkedCast((long)(left - right));
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("tinyint subtraction overflow: %s - %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="tinyint")
    public static long multiply(@SqlType(value="tinyint") long left, @SqlType(value="tinyint") long right) {
        try {
            return SignedBytes.checkedCast((long)(left * right));
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("tinyint multiplication overflow: %s * %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="tinyint")
    public static long divide(@SqlType(value="tinyint") long left, @SqlType(value="tinyint") long right) {
        try {
            return left / right;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero", (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MODULUS)
    @SqlType(value="tinyint")
    public static long modulus(@SqlType(value="tinyint") long left, @SqlType(value="tinyint") long right) {
        try {
            return left % right;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero", (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="tinyint")
    public static long negate(@SqlType(value="tinyint") long value) {
        try {
            return SignedBytes.checkedCast((long)(-value));
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "tinyint negation overflow: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToBigint(@SqlType(value="tinyint") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="integer")
    public static long castToInteger(@SqlType(value="tinyint") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="smallint")
    public static long castToSmallint(@SqlType(value="tinyint") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="boolean")
    public static boolean castToBoolean(@SqlType(value="tinyint") long value) {
        return value != 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="double")
    public static double castToDouble(@SqlType(value="tinyint") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="real")
    public static long castToReal(@SqlType(value="tinyint") long value) {
        return Float.floatToRawIntBits(value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@SqlType(value="tinyint") long value) {
        return Slices.utf8Slice((String)String.valueOf(value));
    }
}

