/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.Analyze;
import io.trino.sql.tree.Call;
import io.trino.sql.tree.Comment;
import io.trino.sql.tree.Commit;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.CreateRole;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.CreateTableAsSelect;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.Deallocate;
import io.trino.sql.tree.Delete;
import io.trino.sql.tree.DescribeInput;
import io.trino.sql.tree.DescribeOutput;
import io.trino.sql.tree.DropColumn;
import io.trino.sql.tree.DropMaterializedView;
import io.trino.sql.tree.DropRole;
import io.trino.sql.tree.DropSchema;
import io.trino.sql.tree.DropTable;
import io.trino.sql.tree.DropView;
import io.trino.sql.tree.Explain;
import io.trino.sql.tree.ExplainAnalyze;
import io.trino.sql.tree.Grant;
import io.trino.sql.tree.GrantRoles;
import io.trino.sql.tree.Insert;
import io.trino.sql.tree.Prepare;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.RefreshMaterializedView;
import io.trino.sql.tree.RenameColumn;
import io.trino.sql.tree.RenameSchema;
import io.trino.sql.tree.RenameTable;
import io.trino.sql.tree.RenameView;
import io.trino.sql.tree.ResetSession;
import io.trino.sql.tree.Revoke;
import io.trino.sql.tree.RevokeRoles;
import io.trino.sql.tree.Rollback;
import io.trino.sql.tree.SetPath;
import io.trino.sql.tree.SetRole;
import io.trino.sql.tree.SetSchemaAuthorization;
import io.trino.sql.tree.SetSession;
import io.trino.sql.tree.SetTableAuthorization;
import io.trino.sql.tree.SetTimeZone;
import io.trino.sql.tree.SetViewAuthorization;
import io.trino.sql.tree.ShowCatalogs;
import io.trino.sql.tree.ShowColumns;
import io.trino.sql.tree.ShowCreate;
import io.trino.sql.tree.ShowFunctions;
import io.trino.sql.tree.ShowGrants;
import io.trino.sql.tree.ShowRoleGrants;
import io.trino.sql.tree.ShowRoles;
import io.trino.sql.tree.ShowSchemas;
import io.trino.sql.tree.ShowSession;
import io.trino.sql.tree.ShowStats;
import io.trino.sql.tree.ShowTables;
import io.trino.sql.tree.StartTransaction;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.Update;
import io.trino.sql.tree.Use;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public final class StatementUtils {
    private static final Map<Class<? extends Statement>, QueryType> STATEMENT_QUERY_TYPES = ImmutableMap.builder().put(Query.class, (Object)QueryType.SELECT).put(Explain.class, (Object)QueryType.EXPLAIN).put(DescribeInput.class, (Object)QueryType.DESCRIBE).put(DescribeOutput.class, (Object)QueryType.DESCRIBE).put(ShowCatalogs.class, (Object)QueryType.DESCRIBE).put(ShowColumns.class, (Object)QueryType.DESCRIBE).put(ShowCreate.class, (Object)QueryType.DESCRIBE).put(ShowFunctions.class, (Object)QueryType.DESCRIBE).put(ShowGrants.class, (Object)QueryType.DESCRIBE).put(ShowRoleGrants.class, (Object)QueryType.DESCRIBE).put(ShowRoles.class, (Object)QueryType.DESCRIBE).put(ShowSchemas.class, (Object)QueryType.DESCRIBE).put(ShowSession.class, (Object)QueryType.DESCRIBE).put(ShowStats.class, (Object)QueryType.DESCRIBE).put(ShowTables.class, (Object)QueryType.DESCRIBE).put(CreateTableAsSelect.class, (Object)QueryType.INSERT).put(RefreshMaterializedView.class, (Object)QueryType.INSERT).put(Insert.class, (Object)QueryType.INSERT).put(Update.class, (Object)QueryType.UPDATE).put(Delete.class, (Object)QueryType.DELETE).put(Analyze.class, (Object)QueryType.ANALYZE).put(AddColumn.class, (Object)QueryType.DATA_DEFINITION).put(Call.class, (Object)QueryType.DATA_DEFINITION).put(Comment.class, (Object)QueryType.DATA_DEFINITION).put(Commit.class, (Object)QueryType.DATA_DEFINITION).put(CreateMaterializedView.class, (Object)QueryType.DATA_DEFINITION).put(CreateRole.class, (Object)QueryType.DATA_DEFINITION).put(CreateSchema.class, (Object)QueryType.DATA_DEFINITION).put(CreateTable.class, (Object)QueryType.DATA_DEFINITION).put(CreateView.class, (Object)QueryType.DATA_DEFINITION).put(Deallocate.class, (Object)QueryType.DATA_DEFINITION).put(DropColumn.class, (Object)QueryType.DATA_DEFINITION).put(DropMaterializedView.class, (Object)QueryType.DATA_DEFINITION).put(DropRole.class, (Object)QueryType.DATA_DEFINITION).put(DropSchema.class, (Object)QueryType.DATA_DEFINITION).put(DropTable.class, (Object)QueryType.DATA_DEFINITION).put(DropView.class, (Object)QueryType.DATA_DEFINITION).put(Grant.class, (Object)QueryType.DATA_DEFINITION).put(GrantRoles.class, (Object)QueryType.DATA_DEFINITION).put(Prepare.class, (Object)QueryType.DATA_DEFINITION).put(RenameColumn.class, (Object)QueryType.DATA_DEFINITION).put(RenameSchema.class, (Object)QueryType.DATA_DEFINITION).put(RenameTable.class, (Object)QueryType.DATA_DEFINITION).put(RenameView.class, (Object)QueryType.DATA_DEFINITION).put(ResetSession.class, (Object)QueryType.DATA_DEFINITION).put(Revoke.class, (Object)QueryType.DATA_DEFINITION).put(RevokeRoles.class, (Object)QueryType.DATA_DEFINITION).put(Rollback.class, (Object)QueryType.DATA_DEFINITION).put(SetPath.class, (Object)QueryType.DATA_DEFINITION).put(SetRole.class, (Object)QueryType.DATA_DEFINITION).put(SetSchemaAuthorization.class, (Object)QueryType.DATA_DEFINITION).put(SetSession.class, (Object)QueryType.DATA_DEFINITION).put(SetTableAuthorization.class, (Object)QueryType.DATA_DEFINITION).put(SetTimeZone.class, (Object)QueryType.DATA_DEFINITION).put(SetViewAuthorization.class, (Object)QueryType.DATA_DEFINITION).put(StartTransaction.class, (Object)QueryType.DATA_DEFINITION).put(Use.class, (Object)QueryType.DATA_DEFINITION).build();

    private StatementUtils() {
    }

    public static Optional<QueryType> getQueryType(Statement statement) {
        if (statement instanceof ExplainAnalyze) {
            return StatementUtils.getQueryType(((ExplainAnalyze)statement).getStatement());
        }
        return Optional.ofNullable(STATEMENT_QUERY_TYPES.get(statement.getClass()));
    }

    public static Set<Class<? extends Statement>> getNonDataDefinitionStatements() {
        return (Set)Stream.concat(Stream.of(ExplainAnalyze.class), STATEMENT_QUERY_TYPES.entrySet().stream().filter(entry -> entry.getValue() != QueryType.DATA_DEFINITION).map(Map.Entry::getKey)).collect(ImmutableSet.toImmutableSet());
    }

    public static boolean isDataDefinitionStatement(Class<? extends Statement> statement) {
        return STATEMENT_QUERY_TYPES.get(statement) == QueryType.DATA_DEFINITION;
    }

    public static boolean isTransactionControlStatement(Statement statement) {
        return statement instanceof StartTransaction || statement instanceof Commit || statement instanceof Rollback;
    }
}

