/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.trino.connector.CatalogName;
import io.trino.connector.system.GlobalSystemTransactionHandle;
import io.trino.metadata.Catalog;
import io.trino.metadata.MetadataUtil;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;

abstract class AbstractPropertiesSystemTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final TransactionManager transactionManager;
    private final Supplier<Map<CatalogName, Map<String, PropertyMetadata<?>>>> propertySupplier;

    protected AbstractPropertiesSystemTable(String tableName, TransactionManager transactionManager, Supplier<Map<CatalogName, Map<String, PropertyMetadata<?>>>> propertySupplier) {
        this.tableMetadata = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(new SchemaTableName("metadata", tableName)).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("property_name", (Type)VarcharType.createUnboundedVarcharType()).column("default_value", (Type)VarcharType.createUnboundedVarcharType()).column("type", (Type)VarcharType.createUnboundedVarcharType()).column("description", (Type)VarcharType.createUnboundedVarcharType()).build();
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.propertySupplier = Objects.requireNonNull(propertySupplier, "propertySupplier is null");
    }

    public final SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public final ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public final RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        TransactionId transactionId = ((GlobalSystemTransactionHandle)transactionHandle).getTransactionId();
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)this.tableMetadata);
        Map<CatalogName, Map<String, PropertyMetadata<?>>> connectorProperties = this.propertySupplier.get();
        Map<String, CatalogName> catalogNames = this.transactionManager.getCatalogs(transactionId).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Catalog)entry.getValue()).getConnectorCatalogName()));
        for (Map.Entry<String, CatalogName> entry2 : new TreeMap<String, CatalogName>(catalogNames).entrySet()) {
            String catalog = entry2.getKey();
            TreeMap properties = new TreeMap((Map)connectorProperties.getOrDefault(entry2.getValue(), (Map<String, PropertyMetadata<?>>)ImmutableMap.of()));
            for (PropertyMetadata propertyMetadata : properties.values()) {
                table.addRow(new Object[]{catalog, propertyMetadata.getName(), MoreObjects.firstNonNull((Object)propertyMetadata.getDefaultValue(), (Object)"").toString(), propertyMetadata.getSqlType().toString(), propertyMetadata.getDescription()});
            }
        }
        return table.build().cursor();
    }
}

