/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.sql.NodeUtils;
import io.trino.sql.ParameterUtils;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.Statement;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class AddColumnTask
implements DataDefinitionTask<AddColumn> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public AddColumnTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "ADD COLUMN";
    }

    @Override
    public ListenableFuture<Void> execute(AddColumn statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Type type;
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        Optional<TableHandle> tableHandle = this.metadata.getTableHandle(session, tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName()));
        if (tableHandle.isEmpty()) {
            if (!statement.isTableExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName);
            }
            return Futures.immediateVoidFuture();
        }
        CatalogName catalogName = MetadataUtil.getRequiredCatalogHandle(this.metadata, session, (Node)statement, tableName.getCatalogName());
        this.accessControl.checkCanAddColumns(session.toSecurityContext(), tableName);
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(session, tableHandle.get());
        ColumnDefinition element = statement.getColumn();
        try {
            type = this.metadata.getType(TypeSignatureTranslator.toTypeSignature(element.getType()));
        }
        catch (TypeNotFoundException e) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_NOT_FOUND, (Node)element, "Unknown type '%s' for column '%s'", element.getType(), element.getName());
        }
        if (type.equals((Object)UnknownType.UNKNOWN)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_TYPE_UNKNOWN, (Node)element, "Unknown type '%s' for column '%s'", element.getType(), element.getName());
        }
        if (columnHandles.containsKey(element.getName().getValue().toLowerCase(Locale.ENGLISH))) {
            if (!statement.isColumnNotExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_ALREADY_EXISTS, (Node)statement, "Column '%s' already exists", element.getName());
            }
            return Futures.immediateVoidFuture();
        }
        if (!element.isNullable() && !this.metadata.getConnectorCapabilities(session, catalogName).contains(ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)element, "Catalog '%s' does not support NOT NULL for column '%s'", catalogName.getCatalogName(), element.getName());
        }
        Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(element.getProperties());
        Map columnProperties = this.metadata.getColumnPropertyManager().getProperties(catalogName, tableName.getCatalogName(), (Map)sqlProperties, session, this.metadata, this.accessControl, (Map)ParameterUtils.parameterExtractor((Statement)statement, parameters), true);
        ColumnMetadata column = ColumnMetadata.builder().setName(element.getName().getValue()).setType(type).setNullable(element.isNullable()).setComment(element.getComment()).setProperties(columnProperties).build();
        this.metadata.addColumn(session, tableHandle.get(), column);
        return Futures.immediateVoidFuture();
    }
}

