/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.NodeUtils;
import io.trino.sql.ParameterUtils;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.PrincipalSpecification;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class CreateSchemaTask
implements DataDefinitionTask<CreateSchema> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public CreateSchemaTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "CREATE SCHEMA";
    }

    @Override
    public ListenableFuture<Void> execute(CreateSchema statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        return CreateSchemaTask.internalExecute(statement, this.metadata, this.accessControl, stateMachine.getSession(), parameters);
    }

    @VisibleForTesting
    static ListenableFuture<Void> internalExecute(CreateSchema statement, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters) {
        block4: {
            CatalogSchemaName schema = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getSchemaName()));
            accessControl.checkCanCreateSchema(session.toSecurityContext(), schema);
            if (metadata.schemaExists(session, schema)) {
                if (!statement.isNotExists()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_ALREADY_EXISTS, (Node)statement, "Schema '%s' already exists", schema);
                }
                return Futures.immediateVoidFuture();
            }
            CatalogName catalogName = MetadataUtil.getRequiredCatalogHandle(metadata, session, (Node)statement, schema.getCatalogName());
            Map properties = metadata.getSchemaPropertyManager().getProperties(catalogName, schema.getCatalogName(), (Map)NodeUtils.mapFromProperties(statement.getProperties()), session, metadata, accessControl, (Map)ParameterUtils.parameterExtractor((Statement)statement, parameters), true);
            TrinoPrincipal principal = CreateSchemaTask.getCreatePrincipal(statement, session, metadata, catalogName.getCatalogName());
            try {
                metadata.createSchema(session, schema, properties, principal);
            }
            catch (TrinoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.ALREADY_EXISTS.toErrorCode()) && statement.isNotExists()) break block4;
                throw e;
            }
        }
        return Futures.immediateVoidFuture();
    }

    private static TrinoPrincipal getCreatePrincipal(CreateSchema statement, Session session, Metadata metadata, String catalog) {
        if (statement.getPrincipal().isEmpty()) {
            return new TrinoPrincipal(PrincipalType.USER, session.getUser());
        }
        TrinoPrincipal principal = MetadataUtil.createPrincipal((PrincipalSpecification)statement.getPrincipal().get());
        MetadataUtil.checkRoleExists(session, (Node)statement, metadata, principal, Optional.of(catalog));
        return principal;
    }
}

