/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.Column;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableMetadata;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.sql.NodeUtils;
import io.trino.sql.ParameterUtils;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Output;
import io.trino.sql.analyzer.OutputColumn;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LikeClause;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.TableElement;
import io.trino.type.UnknownType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;

public class CreateTableTask
implements DataDefinitionTask<CreateTable> {
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final boolean disableSetPropertiesSecurityCheckForCreateDdl;

    @Inject
    public CreateTableTask(Metadata metadata, AccessControl accessControl, FeaturesConfig featuresConfig) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.disableSetPropertiesSecurityCheckForCreateDdl = featuresConfig.isDisableSetPropertiesSecurityCheckForCreateDdl();
    }

    @Override
    public String getName() {
        return "CREATE TABLE";
    }

    @Override
    public ListenableFuture<Void> execute(CreateTable statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        return this.internalExecute(statement, stateMachine.getSession(), parameters, output -> stateMachine.setOutput(Optional.of(output)));
    }

    @VisibleForTesting
    ListenableFuture<Void> internalExecute(CreateTable statement, Session session, List<Expression> parameters, Consumer<Output> outputConsumer) {
        ConnectorTableMetadata tableMetadata;
        QualifiedObjectName tableName;
        block24: {
            Preconditions.checkArgument((!statement.getElements().isEmpty() ? 1 : 0) != 0, (Object)"no columns for table");
            Map<NodeRef<Parameter>, Expression> parameterLookup = ParameterUtils.parameterExtractor((Statement)statement, parameters);
            tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
            Optional<TableHandle> tableHandle = this.metadata.getTableHandle(session, tableName);
            if (tableHandle.isPresent()) {
                if (!statement.isNotExists()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Table '%s' already exists", tableName);
                }
                return Futures.immediateVoidFuture();
            }
            CatalogName catalogName = MetadataUtil.getRequiredCatalogHandle(this.metadata, session, (Node)statement, tableName.getCatalogName());
            LinkedHashMap<String, ColumnMetadata> columns = new LinkedHashMap<String, ColumnMetadata>();
            Object inheritedProperties = ImmutableMap.of();
            boolean includingProperties = false;
            for (TableElement element : statement.getElements()) {
                if (element instanceof ColumnDefinition) {
                    Type type;
                    ColumnDefinition column2 = (ColumnDefinition)element;
                    String name = column2.getName().getValue().toLowerCase(Locale.ENGLISH);
                    try {
                        type = this.metadata.getType(TypeSignatureTranslator.toTypeSignature(column2.getType()));
                    }
                    catch (TypeNotFoundException e) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_NOT_FOUND, (Node)element, "Unknown type '%s' for column '%s'", column2.getType(), column2.getName());
                    }
                    if (type.equals((Object)UnknownType.UNKNOWN)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_TYPE_UNKNOWN, (Node)element, "Unknown type '%s' for column '%s'", column2.getType(), column2.getName());
                    }
                    if (columns.containsKey(name)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, (Node)column2, "Column name '%s' specified more than once", column2.getName());
                    }
                    if (!column2.isNullable() && !this.metadata.getConnectorCapabilities(session, catalogName).contains(ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)column2, "Catalog '%s' does not support non-null column for column name '%s'", catalogName.getCatalogName(), column2.getName());
                    }
                    Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(column2.getProperties());
                    Map columnProperties = this.metadata.getColumnPropertyManager().getProperties(catalogName, tableName.getCatalogName(), (Map)sqlProperties, session, this.metadata, this.accessControl, (Map)parameterLookup, true);
                    columns.put(name, ColumnMetadata.builder().setName(name).setType(type).setNullable(column2.isNullable()).setComment(column2.getComment()).setProperties(columnProperties).build());
                    continue;
                }
                if (element instanceof LikeClause) {
                    LikeClause likeClause = (LikeClause)element;
                    QualifiedObjectName originalLikeTableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, likeClause.getTableName());
                    if (this.metadata.getCatalogHandle(session, originalLikeTableName.getCatalogName()).isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_FOUND, (Node)statement, "LIKE table catalog '%s' does not exist", originalLikeTableName.getCatalogName());
                    }
                    RedirectionAwareTableHandle redirection = this.metadata.getRedirectionAwareTableHandle(session, originalLikeTableName);
                    TableHandle likeTable = redirection.getTableHandle().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "LIKE table '%s' does not exist", originalLikeTableName));
                    QualifiedObjectName likeTableName = redirection.getRedirectedTableName().orElse(originalLikeTableName);
                    if (!tableName.getCatalogName().equals(likeTableName.getCatalogName())) {
                        Object message = "CREATE TABLE LIKE across catalogs is not supported";
                        if (!originalLikeTableName.equals(likeTableName)) {
                            message = (String)message + String.format(". LIKE table '%s' redirected to '%s'.", originalLikeTableName, likeTableName);
                        }
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, (String)message, new Object[0]);
                    }
                    TableMetadata likeTableMetadata = this.metadata.getTableMetadata(session, likeTable);
                    Optional propertiesOption = likeClause.getPropertiesOption();
                    if (propertiesOption.isPresent() && propertiesOption.get() == LikeClause.PropertiesOption.INCLUDING) {
                        if (includingProperties) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Only one LIKE clause can specify INCLUDING PROPERTIES", new Object[0]);
                        }
                        includingProperties = true;
                        inheritedProperties = likeTableMetadata.getMetadata().getProperties();
                    }
                    try {
                        this.accessControl.checkCanSelectFromColumns(session.toSecurityContext(), likeTableName, (Set)likeTableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet()));
                    }
                    catch (AccessDeniedException e) {
                        throw new AccessDeniedException("Cannot reference columns of table " + likeTableName);
                    }
                    if (propertiesOption.orElse(LikeClause.PropertiesOption.EXCLUDING) == LikeClause.PropertiesOption.INCLUDING) {
                        try {
                            this.accessControl.checkCanShowCreateTable(session.toSecurityContext(), likeTableName);
                        }
                        catch (AccessDeniedException e) {
                            throw new AccessDeniedException("Cannot reference properties of table " + likeTableName);
                        }
                    }
                    likeTableMetadata.getColumns().stream().filter(column -> !column.isHidden()).forEach(column -> {
                        if (columns.containsKey(column.getName().toLowerCase(Locale.ENGLISH))) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, (Node)element, "Column name '%s' specified more than once", column.getName());
                        }
                        columns.put(column.getName().toLowerCase(Locale.ENGLISH), (ColumnMetadata)column);
                    });
                    continue;
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid TableElement: " + element.getClass().getName());
            }
            Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(statement.getProperties());
            Map properties = this.metadata.getTablePropertyManager().getProperties(catalogName, tableName.getCatalogName(), (Map)sqlProperties, session, this.metadata, this.accessControl, (Map)parameterLookup, true);
            if (!this.disableSetPropertiesSecurityCheckForCreateDdl && !properties.isEmpty()) {
                this.accessControl.checkCanCreateTable(session.toSecurityContext(), tableName, properties);
            } else {
                this.accessControl.checkCanCreateTable(session.toSecurityContext(), tableName);
            }
            Map<String, Object> finalProperties = CreateTableTask.combineProperties(sqlProperties.keySet(), properties, (Map<String, Object>)inheritedProperties);
            tableMetadata = new ConnectorTableMetadata(tableName.asSchemaTableName(), (List)ImmutableList.copyOf(columns.values()), finalProperties, statement.getComment());
            try {
                this.metadata.createTable(session, tableName.getCatalogName(), tableMetadata, statement.isNotExists());
            }
            catch (TrinoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.ALREADY_EXISTS.toErrorCode()) && statement.isNotExists()) break block24;
                throw e;
            }
        }
        outputConsumer.accept(new Output(tableName.getCatalogName(), tableName.getSchemaName(), tableName.getObjectName(), Optional.of((List)tableMetadata.getColumns().stream().map(column -> new OutputColumn(new Column(column.getName(), column.getType().toString()), (Set<Analysis.SourceColumn>)ImmutableSet.of())).collect(ImmutableList.toImmutableList()))));
        return Futures.immediateVoidFuture();
    }

    private static Map<String, Object> combineProperties(Set<String> specifiedPropertyKeys, Map<String, Object> defaultProperties, Map<String, Object> inheritedProperties) {
        HashMap<String, Object> finalProperties = new HashMap<String, Object>(inheritedProperties);
        for (Map.Entry<String, Object> entry : defaultProperties.entrySet()) {
            if (!specifiedPropertyKeys.contains(entry.getKey()) && finalProperties.containsKey(entry.getKey())) continue;
            finalProperties.put(entry.getKey(), entry.getValue());
        }
        return finalProperties;
    }
}

