/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.airlift.units.Duration;
import io.trino.execution.FailureInjectionConfig;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.ErrorType;
import io.trino.spi.TrinoException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class FailureInjector {
    public static final String FAILURE_INJECTION_MESSAGE = "This error is injected by the failure injection service";
    private final Cache<Key, InjectedFailure> failures;
    private final Duration requestTimeout;

    @Inject
    public FailureInjector(FailureInjectionConfig config) {
        this(Objects.requireNonNull(config, "config is null").getExpirationPeriod(), config.getRequestTimeout());
    }

    public FailureInjector(Duration expirationPeriod, Duration requestTimeout) {
        this.failures = CacheBuilder.newBuilder().expireAfterWrite(expirationPeriod.toMillis(), TimeUnit.MILLISECONDS).build();
        this.requestTimeout = Objects.requireNonNull(requestTimeout, "requestTimeout is null");
    }

    public void injectTaskFailure(String traceToken, int stageId, int partitionId, int attemptId, InjectedFailureType injectionType, Optional<ErrorType> errorType) {
        this.failures.put((Object)new Key(traceToken, stageId, partitionId, attemptId), (Object)new InjectedFailure(injectionType, errorType));
    }

    public Optional<InjectedFailure> getInjectedFailure(String traceToken, int stageId, int partitionId, int attemptId) {
        if (this.failures.size() == 0L) {
            return Optional.empty();
        }
        return Optional.ofNullable((InjectedFailure)this.failures.getIfPresent((Object)new Key(traceToken, stageId, partitionId, attemptId)));
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public static enum InjectedErrorCode implements ErrorCodeSupplier
    {
        INJECTED_USER_ERROR(1, ErrorType.USER_ERROR),
        INJECTED_INTERNAL_ERROR(2, ErrorType.INTERNAL_ERROR),
        INJECTED_INSUFFICIENT_RESOURCES_ERROR(3, ErrorType.INSUFFICIENT_RESOURCES),
        INJECTED_EXTERNAL_ERROR(4, ErrorType.EXTERNAL);

        private final ErrorCode errorCode;

        private InjectedErrorCode(int code, ErrorType type) {
            this.errorCode = new ErrorCode(code + 196608, this.name(), type);
        }

        public ErrorCode toErrorCode() {
            return this.errorCode;
        }

        public static InjectedErrorCode getErrorCode(ErrorType errorType) {
            for (InjectedErrorCode code : InjectedErrorCode.values()) {
                if (code.toErrorCode().getType() != errorType) continue;
                return code;
            }
            throw new IllegalArgumentException("unexpected error type: " + errorType);
        }
    }

    public static class InjectedFailure {
        private final InjectedFailureType injectedFailureType;
        private final Optional<ErrorType> taskFailureErrorType;

        public InjectedFailure(InjectedFailureType injectedFailureType, Optional<ErrorType> taskFailureErrorType) {
            this.injectedFailureType = Objects.requireNonNull(injectedFailureType, "injectedFailureType is null");
            this.taskFailureErrorType = Objects.requireNonNull(taskFailureErrorType, "taskFailureErrorType is null");
            if (injectedFailureType == InjectedFailureType.TASK_FAILURE) {
                Preconditions.checkArgument((boolean)taskFailureErrorType.isPresent(), (Object)"error type must be present when injection type is task failure");
            } else {
                Preconditions.checkArgument((boolean)taskFailureErrorType.isEmpty(), (Object)"error type must not be present when injection type is not task failure");
            }
        }

        public InjectedFailureType getInjectedFailureType() {
            return this.injectedFailureType;
        }

        public ErrorType getTaskFailureErrorType() {
            return this.taskFailureErrorType.orElseThrow(() -> new IllegalStateException("this method must only be called for failure type of TASK_FAILURE"));
        }

        public Throwable getTaskFailureException() {
            ErrorType errorType = this.getTaskFailureErrorType();
            return new TrinoException((ErrorCodeSupplier)InjectedErrorCode.getErrorCode(errorType), FailureInjector.FAILURE_INJECTION_MESSAGE);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("injectedFailureType", (Object)this.injectedFailureType).add("taskFailureErrorType", this.taskFailureErrorType).toString();
        }
    }

    public static enum InjectedFailureType {
        TASK_MANAGEMENT_REQUEST_FAILURE,
        TASK_MANAGEMENT_REQUEST_TIMEOUT,
        TASK_GET_RESULTS_REQUEST_FAILURE,
        TASK_GET_RESULTS_REQUEST_TIMEOUT,
        TASK_FAILURE;

    }

    private static class Key {
        private final String traceToken;
        private final int stageId;
        private final int partitionId;
        private final int attemptId;

        private Key(String traceToken, int stageId, int partitionId, int attemptId) {
            this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
            this.stageId = stageId;
            this.partitionId = partitionId;
            this.attemptId = attemptId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.stageId == key.stageId && this.partitionId == key.partitionId && this.attemptId == key.attemptId && Objects.equals(this.traceToken, key.traceToken);
        }

        public int hashCode() {
            return Objects.hash(this.traceToken, this.stageId, this.partitionId, this.attemptId);
        }
    }
}

