/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.connector.CatalogName;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.ResetSession;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ResetSessionTask
implements DataDefinitionTask<ResetSession> {
    private final Metadata metadata;

    @Inject
    public ResetSessionTask(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public String getName() {
        return "RESET SESSION";
    }

    @Override
    public ListenableFuture<Void> execute(ResetSession statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        List parts = statement.getName().getParts();
        if (parts.size() > 2) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Invalid session property '%s'", statement.getName());
        }
        if (parts.size() == 1) {
            if (this.metadata.getSessionPropertyManager().getSystemSessionPropertyMetadata((String)parts.get(0)).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property '%s' does not exist", statement.getName());
            }
        } else {
            CatalogName catalogName = this.metadata.getCatalogHandle(stateMachine.getSession(), (String)parts.get(0)).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_FOUND, (Node)statement, "Catalog '%s' does not exist", parts.get(0)));
            if (this.metadata.getSessionPropertyManager().getConnectorSessionPropertyMetadata(catalogName, (String)parts.get(1)).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property '%s' does not exist", statement.getName());
            }
        }
        stateMachine.addResetSessionProperties(statement.getName().toString());
        return Futures.immediateVoidFuture();
    }
}

