/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.security.GroupProvider;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ParameterUtils;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.CorrelationSupport;
import io.trino.sql.analyzer.ExpressionAnalysis;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.Field;
import io.trino.sql.analyzer.RelationId;
import io.trino.sql.analyzer.RelationType;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.SetTimeZone;
import io.trino.sql.tree.Statement;
import io.trino.type.IntervalDayTimeType;
import io.trino.util.Failures;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.inject.Inject;

public class SetTimeZoneTask
implements DataDefinitionTask<SetTimeZone> {
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final SqlParser sqlParser;
    private final AnalyzerFactory analyzerFactory;
    private final GroupProvider groupProvider;

    @Inject
    public SetTimeZoneTask(Metadata metadata, AccessControl accessControl, SqlParser sqlParser, AnalyzerFactory analyzerFactory, GroupProvider groupProvider) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.analyzerFactory = Objects.requireNonNull(analyzerFactory, "analyzerFactory is null");
        this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
    }

    @Override
    public String getName() {
        return "SET TIME ZONE";
    }

    @Override
    public ListenableFuture<Void> execute(SetTimeZone statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        String timeZoneId = statement.getTimeZone().map(timeZone -> this.getTimeZoneId((Expression)timeZone, statement, stateMachine, parameters, warningCollector)).orElse(TimeZone.getDefault().getID());
        stateMachine.addSetSessionProperties("time_zone_id", timeZoneId);
        return Futures.immediateVoidFuture();
    }

    private String getTimeZoneId(Expression expression, SetTimeZone statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        TimeZoneKey timeZoneKey;
        Session session = stateMachine.getSession();
        Analysis analysis = this.analyzeStatement(statement, stateMachine, parameters, session);
        Scope scope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(new Field[0])).build();
        ExpressionAnalysis expressionAnalysis = ExpressionAnalyzer.analyzeExpression(session, this.metadata, this.groupProvider, this.accessControl, this.sqlParser, scope, analysis, expression, warningCollector, CorrelationSupport.ALLOWED);
        Expression rewrittenExpression = SetTimeZoneTask.rewriteExpression(expression, analysis);
        Type type = expressionAnalysis.getType(expression);
        if (!(type instanceof VarcharType) && !(type instanceof IntervalDayTimeType)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Expected expression of varchar or interval day-time type, but '%s' has %s type", expression, type.getDisplayName()));
        }
        ImmutableMap expressionTypes = ImmutableMap.builder().put((Object)NodeRef.of((Node)rewrittenExpression), (Object)type).build();
        ExpressionInterpreter interpreter = new ExpressionInterpreter(rewrittenExpression, this.metadata, session, (Map<NodeRef<Expression>, Type>)expressionTypes);
        Object timeZoneValue = interpreter.evaluate();
        if (timeZoneValue instanceof Slice) {
            timeZoneKey = TimeZoneKey.getTimeZoneKey((String)((Slice)timeZoneValue).toStringUtf8());
        } else if (timeZoneValue instanceof Long) {
            timeZoneKey = TimeZoneKey.getTimeZoneKeyForOffset((long)SetTimeZoneTask.getZoneOffsetMinutes((Long)timeZoneValue));
        } else {
            throw new IllegalStateException(String.format("Time Zone expression '%s' not supported", expression));
        }
        return timeZoneKey.getId();
    }

    private Analysis analyzeStatement(SetTimeZone statement, QueryStateMachine stateMachine, List<Expression> parameters, Session session) {
        return this.analyzerFactory.createAnalyzer(session, parameters, ParameterUtils.parameterExtractor((Statement)statement, parameters), stateMachine.getWarningCollector()).analyze((Statement)statement);
    }

    private static Expression rewriteExpression(Expression expression, final Analysis analysis) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                ResolvedFunction resolvedFunction = analysis.getResolvedFunction(node);
                Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
                FunctionCall rewritten = (FunctionCall)treeRewriter.defaultRewrite((Expression)node, (Object)context);
                rewritten = new FunctionCall(rewritten.getLocation(), resolvedFunction.toQualifiedName(), rewritten.getWindow(), rewritten.getFilter(), rewritten.getOrderBy(), rewritten.isDistinct(), rewritten.getNullTreatment(), rewritten.getProcessingMode(), rewritten.getArguments());
                return rewritten;
            }
        }, (Expression)expression, null);
    }

    private static long getZoneOffsetMinutes(long interval) {
        Failures.checkCondition(interval % 60000L == 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, "Invalid time zone offset interval: interval contains seconds", new Object[0]);
        return interval / 60000L;
    }
}

