/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.trino.execution.Lifespan;
import io.trino.execution.RemoteTask;
import io.trino.execution.scheduler.PipelinedStageExecution;
import io.trino.execution.scheduler.ScheduleResult;
import io.trino.execution.scheduler.StageScheduler;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;

public class FixedCountScheduler
implements StageScheduler {
    private final TaskScheduler taskScheduler;
    private final List<InternalNode> partitionToNode;

    public FixedCountScheduler(PipelinedStageExecution stageExecution, List<InternalNode> partitionToNode) {
        Objects.requireNonNull(stageExecution, "stage is null");
        this.taskScheduler = (node, partition) -> stageExecution.scheduleTask(node, partition, (Multimap<PlanNodeId, Split>)ImmutableMultimap.of(), (Multimap<PlanNodeId, Lifespan>)ImmutableMultimap.of());
        this.partitionToNode = Objects.requireNonNull(partitionToNode, "partitionToNode is null");
    }

    @VisibleForTesting
    public FixedCountScheduler(TaskScheduler taskScheduler, List<InternalNode> partitionToNode) {
        this.taskScheduler = Objects.requireNonNull(taskScheduler, "taskScheduler is null");
        this.partitionToNode = Objects.requireNonNull(partitionToNode, "partitionToNode is null");
    }

    @Override
    public ScheduleResult schedule() {
        List newTasks = (List)IntStream.range(0, this.partitionToNode.size()).mapToObj(partition -> this.taskScheduler.scheduleTask(this.partitionToNode.get(partition), partition)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
        return new ScheduleResult(true, newTasks, 0);
    }

    public static interface TaskScheduler {
        public Optional<RemoteTask> scheduleTask(InternalNode var1, int var2);
    }
}

