/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.http.client.HttpClient;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.FeaturesConfig;
import io.trino.execution.TaskFailureListener;
import io.trino.execution.TaskId;
import io.trino.execution.buffer.SerializedPage;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.ExchangeClientBuffer;
import io.trino.operator.ExchangeClientStatus;
import io.trino.operator.HttpPageBufferClient;
import io.trino.operator.PageBufferClientStatus;
import io.trino.operator.WorkProcessor;
import java.io.Closeable;
import java.net.URI;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ExchangeClient
implements Closeable {
    private final String selfAddress;
    private final FeaturesConfig.DataIntegrityVerification dataIntegrityVerification;
    private final DataSize maxResponseSize;
    private final int concurrentRequestMultiplier;
    private final Duration maxErrorDuration;
    private final boolean acknowledgePages;
    private final HttpClient httpClient;
    private final ScheduledExecutorService scheduledExecutor;
    @GuardedBy(value="this")
    private boolean noMoreLocations;
    private final ConcurrentMap<URI, HttpPageBufferClient> allClients = new ConcurrentHashMap<URI, HttpPageBufferClient>();
    @GuardedBy(value="this")
    private final Deque<HttpPageBufferClient> queuedClients = new LinkedList<HttpPageBufferClient>();
    private final Set<HttpPageBufferClient> completedClients = Sets.newConcurrentHashSet();
    private final ExchangeClientBuffer buffer;
    @GuardedBy(value="this")
    private long successfulRequests;
    @GuardedBy(value="this")
    private long averageBytesPerRequest;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final LocalMemoryContext systemMemoryContext;
    private final Executor pageBufferClientCallbackExecutor;
    private final TaskFailureListener taskFailureListener;

    public ExchangeClient(String selfAddress, FeaturesConfig.DataIntegrityVerification dataIntegrityVerification, ExchangeClientBuffer buffer, DataSize maxResponseSize, int concurrentRequestMultiplier, Duration maxErrorDuration, boolean acknowledgePages, HttpClient httpClient, ScheduledExecutorService scheduledExecutor, LocalMemoryContext systemMemoryContext, Executor pageBufferClientCallbackExecutor, TaskFailureListener taskFailureListener) {
        this.selfAddress = Objects.requireNonNull(selfAddress, "selfAddress is null");
        this.dataIntegrityVerification = Objects.requireNonNull(dataIntegrityVerification, "dataIntegrityVerification is null");
        this.buffer = Objects.requireNonNull(buffer, "buffer is null");
        this.maxResponseSize = maxResponseSize;
        this.concurrentRequestMultiplier = concurrentRequestMultiplier;
        this.maxErrorDuration = maxErrorDuration;
        this.acknowledgePages = acknowledgePages;
        this.httpClient = httpClient;
        this.scheduledExecutor = scheduledExecutor;
        this.systemMemoryContext = systemMemoryContext;
        this.pageBufferClientCallbackExecutor = Objects.requireNonNull(pageBufferClientCallbackExecutor, "pageBufferClientCallbackExecutor is null");
        this.taskFailureListener = Objects.requireNonNull(taskFailureListener, "taskFailureListener is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExchangeClientStatus getStatus() {
        ImmutableList.Builder pageBufferClientStatusBuilder = ImmutableList.builder();
        for (HttpPageBufferClient client : this.allClients.values()) {
            pageBufferClientStatusBuilder.add((Object)client.getStatus());
        }
        ImmutableList pageBufferClientStatus = pageBufferClientStatusBuilder.build();
        ExchangeClient exchangeClient = this;
        synchronized (exchangeClient) {
            return new ExchangeClientStatus(this.buffer.getRetainedSizeInBytes(), this.buffer.getMaxRetainedSizeInBytes(), this.averageBytesPerRequest, this.successfulRequests, this.buffer.getBufferedPageCount(), this.noMoreLocations, (List<PageBufferClientStatus>)pageBufferClientStatus);
        }
    }

    public synchronized void addLocation(TaskId taskId, URI location) {
        Objects.requireNonNull(location, "location is null");
        if (this.closed.get()) {
            return;
        }
        if (this.allClients.containsKey(location)) {
            return;
        }
        Preconditions.checkState((!this.noMoreLocations ? 1 : 0) != 0, (Object)"No more locations already set");
        this.buffer.addTask(taskId);
        HttpPageBufferClient client = new HttpPageBufferClient(this.selfAddress, this.httpClient, this.dataIntegrityVerification, this.maxResponseSize, this.maxErrorDuration, this.acknowledgePages, taskId, location, new ExchangeClientCallback(), this.scheduledExecutor, this.pageBufferClientCallbackExecutor);
        this.allClients.put(location, client);
        this.queuedClients.add(client);
        this.scheduleRequestIfNecessary();
    }

    public synchronized void noMoreLocations() {
        this.noMoreLocations = true;
        this.buffer.noMoreTasks();
        this.scheduleRequestIfNecessary();
    }

    public WorkProcessor<SerializedPage> pages() {
        return WorkProcessor.create(() -> {
            SerializedPage page = this.pollPage();
            if (page == null) {
                if (this.isFinished()) {
                    return WorkProcessor.ProcessState.finished();
                }
                ListenableFuture<Void> blocked = this.isBlocked();
                if (!blocked.isDone()) {
                    return WorkProcessor.ProcessState.blocked(blocked);
                }
                return WorkProcessor.ProcessState.yielded();
            }
            return WorkProcessor.ProcessState.ofResult(page);
        });
    }

    private void assertNotHoldsLock() {
        assert (!Thread.holdsLock(this)) : "Cannot get next page while holding a lock on this";
    }

    @Nullable
    public SerializedPage pollPage() {
        this.assertNotHoldsLock();
        if (this.closed.get()) {
            return null;
        }
        SerializedPage page = this.buffer.pollPage();
        if (page == null) {
            return null;
        }
        this.systemMemoryContext.setBytes(this.buffer.getRetainedSizeInBytes());
        this.scheduleRequestIfNecessary();
        return page;
    }

    public boolean isFinished() {
        return this.buffer.isFinished() && this.completedClients.size() == this.allClients.size();
    }

    @Override
    public synchronized void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        for (HttpPageBufferClient client : this.allClients.values()) {
            ExchangeClient.closeQuietly(client);
        }
        this.buffer.close();
        this.systemMemoryContext.setBytes(0L);
    }

    private synchronized void scheduleRequestIfNecessary() {
        if (this.isFinished()) {
            return;
        }
        long neededBytes = this.buffer.getRemainingCapacityInBytes();
        if (neededBytes <= 0L) {
            return;
        }
        int clientCount = (int)(1.0 * (double)neededBytes / (double)this.averageBytesPerRequest * (double)this.concurrentRequestMultiplier);
        clientCount = Math.max(clientCount, 1);
        int pendingClients = this.allClients.size() - this.queuedClients.size() - this.completedClients.size();
        clientCount -= pendingClients;
        for (int i = 0; i < clientCount; ++i) {
            HttpPageBufferClient client = this.queuedClients.poll();
            if (client == null) {
                return;
            }
            client.scheduleRequest();
        }
    }

    public ListenableFuture<Void> isBlocked() {
        return this.buffer.isBlocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addPages(HttpPageBufferClient client, List<SerializedPage> pages) {
        Preconditions.checkState((!this.completedClients.contains(client) ? 1 : 0) != 0, (Object)"client is already marked as completed");
        long responseSize = 0L;
        for (SerializedPage page : pages) {
            responseSize += (long)page.getSizeInBytes();
        }
        ExchangeClient exchangeClient = this;
        synchronized (exchangeClient) {
            if (this.closed.get() || this.buffer.isFinished()) {
                return false;
            }
            ++this.successfulRequests;
            this.averageBytesPerRequest = (long)(1.0 * (double)this.averageBytesPerRequest * (double)(this.successfulRequests - 1L) / (double)this.successfulRequests + (double)(responseSize / this.successfulRequests));
        }
        if (!pages.isEmpty()) {
            this.buffer.addPages(client.getRemoteTaskId(), pages);
            this.systemMemoryContext.setBytes(this.buffer.getRetainedSizeInBytes());
        }
        return true;
    }

    private synchronized void requestComplete(HttpPageBufferClient client) {
        if (!this.completedClients.contains(client) && !this.queuedClients.contains(client)) {
            this.queuedClients.add(client);
        }
        this.scheduleRequestIfNecessary();
    }

    private synchronized void clientFinished(HttpPageBufferClient client) {
        Objects.requireNonNull(client, "client is null");
        if (this.completedClients.add(client)) {
            this.buffer.taskFinished(client.getRemoteTaskId());
        }
        this.scheduleRequestIfNecessary();
    }

    private synchronized void clientFailed(HttpPageBufferClient client, Throwable cause) {
        Objects.requireNonNull(client, "client is null");
        if (this.completedClients.add(client)) {
            this.buffer.taskFailed(client.getRemoteTaskId(), cause);
            this.scheduledExecutor.execute(() -> this.taskFailureListener.onTaskFailed(client.getRemoteTaskId(), cause));
            ExchangeClient.closeQuietly(client);
        }
        this.scheduleRequestIfNecessary();
    }

    private static void closeQuietly(HttpPageBufferClient client) {
        try {
            client.close();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private class ExchangeClientCallback
    implements HttpPageBufferClient.ClientCallback {
        private ExchangeClientCallback() {
        }

        @Override
        public boolean addPages(HttpPageBufferClient client, List<SerializedPage> pages) {
            Objects.requireNonNull(client, "client is null");
            Objects.requireNonNull(pages, "pages is null");
            return ExchangeClient.this.addPages(client, pages);
        }

        @Override
        public void requestComplete(HttpPageBufferClient client) {
            Objects.requireNonNull(client, "client is null");
            ExchangeClient.this.requestComplete(client);
        }

        @Override
        public void clientFinished(HttpPageBufferClient client) {
            ExchangeClient.this.clientFinished(client);
        }

        @Override
        public void clientFailed(HttpPageBufferClient client, Throwable cause) {
            Objects.requireNonNull(client, "client is null");
            Objects.requireNonNull(cause, "cause is null");
            ExchangeClient.this.clientFailed(client, cause);
        }
    }
}

