/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.ForLoop;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.slice.Slice;
import io.trino.metadata.BoundSignature;
import io.trino.operator.GroupByIdBlock;
import io.trino.operator.aggregation.Accumulator;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.AggregationUtils;
import io.trino.operator.aggregation.GenericAccumulatorFactoryBinder;
import io.trino.operator.aggregation.GroupedAccumulator;
import io.trino.operator.aggregation.LambdaProvider;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.function.GroupedAccumulatorState;
import io.trino.spi.function.WindowIndex;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.Binding;
import io.trino.sql.gen.Bootstrap;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.CompilerOperations;
import io.trino.sql.gen.SqlTypeBytecodeExpression;
import io.trino.util.CompilerUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class AccumulatorCompiler {
    private AccumulatorCompiler() {
    }

    public static GenericAccumulatorFactoryBinder generateAccumulatorFactoryBinder(BoundSignature boundSignature, AggregationMetadata metadata) {
        metadata = AccumulatorCompiler.normalizeAggregationMethods(metadata);
        DynamicClassLoader classLoader = new DynamicClassLoader(AccumulatorCompiler.class.getClassLoader());
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(boundSignature, Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(boundSignature, GroupedAccumulator.class, metadata, classLoader);
        return new GenericAccumulatorFactoryBinder(accumulatorClass, metadata.getRemoveInputFunction().isPresent(), groupedAccumulatorClass);
    }

    private static <T> Class<? extends T> generateAccumulatorClass(BoundSignature boundSignature, Class<T> accumulatorInterface, AggregationMetadata metadata, DynamicClassLoader classLoader) {
        boolean grouped = accumulatorInterface == GroupedAccumulator.class;
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(boundSignature.getName() + accumulatorInterface.getSimpleName()), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(accumulatorInterface)});
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        List<AggregationMetadata.AccumulatorStateDescriptor<?>> stateDescriptors = metadata.getAccumulatorStateDescriptors();
        ArrayList<StateFieldAndDescriptor> stateFieldAndDescriptors = new ArrayList<StateFieldAndDescriptor>();
        for (int i = 0; i < stateDescriptors.size(); ++i) {
            stateFieldAndDescriptors.add(new StateFieldAndDescriptor(stateDescriptors.get(i), definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "stateSerializer_" + i, AccumulatorStateSerializer.class), definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "stateFactory_" + i, AccumulatorStateFactory.class), definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "state_" + i, grouped ? GroupedAccumulatorState.class : AccumulatorState.class)));
        }
        List stateFields = (List)stateFieldAndDescriptors.stream().map(rec$ -> ((StateFieldAndDescriptor)rec$).getStateField()).collect(ImmutableList.toImmutableList());
        int lambdaCount = metadata.getLambdaInterfaces().size();
        ArrayList<FieldDefinition> lambdaProviderFields = new ArrayList<FieldDefinition>(lambdaCount);
        for (int i = 0; i < lambdaCount; ++i) {
            lambdaProviderFields.add(definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "lambdaProvider_" + i, LambdaProvider.class));
        }
        FieldDefinition maskChannelField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "maskChannel", Integer.TYPE);
        int inputChannelCount = AccumulatorCompiler.countInputChannels(metadata.getInputParameterKinds());
        ImmutableList.Builder inputFieldsBuilder = ImmutableList.builderWithExpectedSize((int)inputChannelCount);
        for (int i = 0; i < inputChannelCount; ++i) {
            inputFieldsBuilder.add((Object)definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "inputChannel" + i, Integer.TYPE));
        }
        ImmutableList inputChannelFields = inputFieldsBuilder.build();
        AccumulatorCompiler.generateConstructor(definition, stateFieldAndDescriptors, (List<FieldDefinition>)inputChannelFields, maskChannelField, lambdaProviderFields, callSiteBinder, grouped);
        AccumulatorCompiler.generatePrivateConstructor(definition);
        AccumulatorCompiler.generateCopy(definition, stateFieldAndDescriptors, lambdaProviderFields, maskChannelField, (List<FieldDefinition>)inputChannelFields);
        AccumulatorCompiler.generateAddInput(definition, stateFields, (List<FieldDefinition>)inputChannelFields, maskChannelField, boundSignature.getArgumentTypes(), metadata.getInputParameterKinds(), lambdaProviderFields, metadata.getInputFunction(), callSiteBinder, grouped);
        AccumulatorCompiler.generateAddOrRemoveInputWindowIndex(definition, stateFields, metadata.getInputParameterKinds(), lambdaProviderFields, metadata.getInputFunction(), "addInput", callSiteBinder);
        metadata.getRemoveInputFunction().ifPresent(removeInputFunction -> AccumulatorCompiler.generateAddOrRemoveInputWindowIndex(definition, stateFields, metadata.getInputParameterKinds(), lambdaProviderFields, removeInputFunction, "removeInput", callSiteBinder));
        AccumulatorCompiler.generateGetEstimatedSize(definition, stateFields);
        AccumulatorCompiler.generateGetIntermediateType(definition, callSiteBinder, (List)stateDescriptors.stream().map(stateDescriptor -> stateDescriptor.getSerializer().getSerializedType()).collect(ImmutableList.toImmutableList()));
        AccumulatorCompiler.generateGetFinalType(definition, callSiteBinder, boundSignature.getReturnType());
        AccumulatorCompiler.generateAddIntermediateAsCombine(definition, stateFieldAndDescriptors, lambdaProviderFields, metadata.getCombineFunction(), callSiteBinder, grouped);
        if (grouped) {
            AccumulatorCompiler.generateGroupedEvaluateIntermediate(definition, stateFieldAndDescriptors);
        } else {
            AccumulatorCompiler.generateEvaluateIntermediate(definition, stateFieldAndDescriptors);
        }
        if (grouped) {
            AccumulatorCompiler.generateGroupedEvaluateFinal(definition, stateFields, metadata.getOutputFunction(), callSiteBinder);
        } else {
            AccumulatorCompiler.generateEvaluateFinal(definition, stateFields, metadata.getOutputFunction(), callSiteBinder);
        }
        if (grouped) {
            AccumulatorCompiler.generatePrepareFinal(definition);
        }
        return CompilerUtils.defineClass(definition, accumulatorInterface, callSiteBinder.getBindings(), (ClassLoader)classLoader);
    }

    private static void generateGetIntermediateType(ClassDefinition definition, CallSiteBinder callSiteBinder, List<Type> type) {
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getIntermediateType", ParameterizedType.type(Type.class), new Parameter[0]);
        if (type.size() == 1) {
            methodDefinition.getBody().append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, (Type)Iterables.getOnlyElement(type))).retObject();
        } else {
            methodDefinition.getBody().append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, (Type)RowType.anonymous(type))).retObject();
        }
    }

    private static void generateGetFinalType(ClassDefinition definition, CallSiteBinder callSiteBinder, Type type) {
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getFinalType", ParameterizedType.type(Type.class), new Parameter[0]);
        methodDefinition.getBody().append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, type)).retObject();
    }

    private static void generateGetEstimatedSize(ClassDefinition definition, List<FieldDefinition> stateFields) {
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getEstimatedSize", ParameterizedType.type(Long.TYPE), new Parameter[0]);
        Variable estimatedSize = method.getScope().declareVariable(Long.TYPE, "estimatedSize");
        method.getBody().append((BytecodeNode)estimatedSize.set(BytecodeExpressions.constantLong((long)0L)));
        for (FieldDefinition stateField : stateFields) {
            method.getBody().append((BytecodeNode)estimatedSize.set(BytecodeExpressions.add((BytecodeExpression)estimatedSize, (BytecodeExpression)method.getThis().getField(stateField).invoke("getEstimatedSize", Long.TYPE, new BytecodeExpression[0]))));
        }
        method.getBody().append((BytecodeNode)estimatedSize.ret());
    }

    private static void generateAddInput(ClassDefinition definition, List<FieldDefinition> stateField, List<FieldDefinition> inputChannelFields, FieldDefinition maskChannelField, List<Type> inputTypes, List<AggregationMetadata.AggregationParameterKind> parameterKinds, List<FieldDefinition> lambdaProviderFields, MethodHandle inputFunction, CallSiteBinder callSiteBinder, boolean grouped) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        if (grouped) {
            parameters.add((Object)Parameter.arg((String)"groupIdsBlock", GroupByIdBlock.class));
        }
        Parameter page = Parameter.arg((String)"page", Page.class);
        parameters.add((Object)page);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "addInput", ParameterizedType.type(Void.TYPE), (Iterable)parameters.build());
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        if (grouped) {
            AccumulatorCompiler.generateEnsureCapacity(scope, stateField, body);
        }
        Variable masksBlock = scope.declareVariable(Block.class, "masksBlock");
        body.comment("masksBlock = extractMaskBlock(%s, page);", new Object[]{maskChannelField.getName()}).append((BytecodeNode)thisVariable.getField(maskChannelField)).append((BytecodeNode)page).invokeStatic(AggregationUtils.class, "extractMaskBlock", Block.class, new Class[]{Integer.TYPE, Page.class}).putVariable(masksBlock);
        ImmutableList.Builder variablesBuilder = ImmutableList.builderWithExpectedSize((int)inputChannelFields.size());
        for (int i = 0; i < inputChannelFields.size(); ++i) {
            FieldDefinition inputChannelField = inputChannelFields.get(i);
            Variable blockVariable = scope.declareVariable(Block.class, "block" + i);
            variablesBuilder.add((Object)blockVariable);
            body.comment("%s = page.getBlock(%s);", new Object[]{blockVariable.getName(), inputChannelField.getName()}).append((BytecodeNode)page).append((BytecodeNode)thisVariable.getField(inputChannelField)).invokeVirtual(Page.class, "getBlock", Block.class, new Class[]{Integer.TYPE}).putVariable(blockVariable);
        }
        ImmutableList parameterVariables = variablesBuilder.build();
        BytecodeBlock block = AccumulatorCompiler.generateInputForLoop(stateField, inputTypes, parameterKinds, inputFunction, scope, (List<Variable>)parameterVariables, lambdaProviderFields, masksBlock, callSiteBinder, grouped);
        body.append((BytecodeNode)block);
        body.ret();
    }

    private static void generateAddOrRemoveInputWindowIndex(ClassDefinition definition, List<FieldDefinition> stateField, List<AggregationMetadata.AggregationParameterKind> parameterKinds, List<FieldDefinition> lambdaProviderFields, MethodHandle inputFunction, String generatedFunctionName, CallSiteBinder callSiteBinder) {
        Parameter index = Parameter.arg((String)"index", WindowIndex.class);
        Parameter channels = Parameter.arg((String)"channels", (ParameterizedType)ParameterizedType.type(List.class, (Class[])new Class[]{Integer.class}));
        Parameter startPosition = Parameter.arg((String)"startPosition", Integer.TYPE);
        Parameter endPosition = Parameter.arg((String)"endPosition", Integer.TYPE);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), generatedFunctionName, ParameterizedType.type(Void.TYPE), (Iterable)ImmutableList.of((Object)index, (Object)channels, (Object)startPosition, (Object)endPosition));
        Scope scope = method.getScope();
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        Binding binding = callSiteBinder.bind(inputFunction);
        BytecodeExpression invokeInputFunction = BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)binding.getBindingId()), (String)generatedFunctionName, (MethodType)binding.getType(), AccumulatorCompiler.getInvokeFunctionOnWindowIndexParameters(scope, inputFunction.type().parameterArray(), parameterKinds, lambdaProviderFields, stateField, (Variable)index, (Variable)channels, position));
        method.getBody().append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set((BytecodeExpression)startPosition)).condition((BytecodeNode)BytecodeExpressions.lessThanOrEqual((BytecodeExpression)position, (BytecodeExpression)endPosition)).update((BytecodeNode)position.increment()).body((BytecodeNode)new IfStatement().condition((BytecodeNode)AccumulatorCompiler.anyParametersAreNull(parameterKinds, (Variable)index, (Variable)channels, position)).ifFalse((BytecodeNode)invokeInputFunction))).ret();
    }

    private static BytecodeExpression anyParametersAreNull(List<AggregationMetadata.AggregationParameterKind> parameterKinds, Variable index, Variable channels, Variable position) {
        int inputChannel = 0;
        BytecodeExpression isNull = BytecodeExpressions.constantFalse();
        for (AggregationMetadata.AggregationParameterKind parameterKind : parameterKinds) {
            switch (parameterKind) {
                case BLOCK_INPUT_CHANNEL: 
                case INPUT_CHANNEL: {
                    BytecodeExpression getChannel = channels.invoke("get", Object.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)inputChannel)}).cast(Integer.TYPE);
                    isNull = BytecodeExpressions.or((BytecodeExpression)isNull, (BytecodeExpression)index.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{getChannel, position}));
                    ++inputChannel;
                    break;
                }
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    ++inputChannel;
                    break;
                }
            }
        }
        return isNull;
    }

    private static List<BytecodeExpression> getInvokeFunctionOnWindowIndexParameters(Scope scope, Class<?>[] parameterTypes, List<AggregationMetadata.AggregationParameterKind> parameterKinds, List<FieldDefinition> lambdaProviderFields, List<FieldDefinition> stateField, Variable index, Variable channels, Variable position) {
        int inputChannel = 0;
        int stateIndex = 0;
        Verify.verify((parameterTypes.length == parameterKinds.size() + lambdaProviderFields.size() ? 1 : 0) != 0);
        ArrayList<BytecodeExpression> expressions = new ArrayList<BytecodeExpression>();
        block6: for (int i = 0; i < parameterKinds.size(); ++i) {
            AggregationMetadata.AggregationParameterKind parameterKind = parameterKinds.get(i);
            Class<?> parameterType = parameterTypes[i];
            BytecodeExpression getChannel = channels.invoke("get", Object.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)inputChannel)}).cast(Integer.TYPE);
            switch (parameterKind) {
                case STATE: {
                    expressions.add(scope.getThis().getField(stateField.get(stateIndex)));
                    ++stateIndex;
                    continue block6;
                }
                case BLOCK_INDEX: {
                    expressions.add(BytecodeExpressions.constantInt((int)0));
                    continue block6;
                }
                case BLOCK_INPUT_CHANNEL: 
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    expressions.add(index.invoke("getSingleValueBlock", Block.class, new BytecodeExpression[]{getChannel, position}));
                    ++inputChannel;
                    continue block6;
                }
                case INPUT_CHANNEL: {
                    if (parameterType == Long.TYPE) {
                        expressions.add(index.invoke("getLong", Long.TYPE, new BytecodeExpression[]{getChannel, position}));
                    } else if (parameterType == Double.TYPE) {
                        expressions.add(index.invoke("getDouble", Double.TYPE, new BytecodeExpression[]{getChannel, position}));
                    } else if (parameterType == Boolean.TYPE) {
                        expressions.add(index.invoke("getBoolean", Boolean.TYPE, new BytecodeExpression[]{getChannel, position}));
                    } else if (parameterType == Slice.class) {
                        expressions.add(index.invoke("getSlice", Slice.class, new BytecodeExpression[]{getChannel, position}));
                    } else {
                        BytecodeExpression expression = index.invoke("getObject", Object.class, new BytecodeExpression[]{getChannel, position});
                        if (parameterType != Object.class) {
                            expression = expression.cast(parameterType);
                        }
                        expressions.add(expression);
                    }
                    ++inputChannel;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter type: " + parameterKind);
                }
            }
        }
        for (FieldDefinition lambdaProviderField : lambdaProviderFields) {
            expressions.add(scope.getThis().getField(lambdaProviderField).invoke("getLambda", Object.class, new BytecodeExpression[0]));
        }
        return expressions;
    }

    private static BytecodeBlock generateInputForLoop(List<FieldDefinition> stateField, List<Type> inputTypes, List<AggregationMetadata.AggregationParameterKind> parameterKinds, MethodHandle inputFunction, Scope scope, List<Variable> parameterVariables, List<FieldDefinition> lambdaProviderFields, Variable masksBlock, CallSiteBinder callSiteBinder, boolean grouped) {
        Variable page = scope.getVariable("page");
        Variable positionVariable = scope.declareVariable(Integer.TYPE, "position");
        Variable rowsVariable = scope.declareVariable(Integer.TYPE, "rows");
        BytecodeBlock block = new BytecodeBlock().append((BytecodeNode)page).invokeVirtual(Page.class, "getPositionCount", Integer.TYPE, new Class[0]).putVariable(rowsVariable).initializeVariable(positionVariable);
        BytecodeBlock loopBody = AccumulatorCompiler.generateInvokeInputFunction(scope, stateField, positionVariable, inputTypes, parameterVariables, parameterKinds, lambdaProviderFields, inputFunction, callSiteBinder, grouped);
        ArrayList<Boolean> nullable = new ArrayList<Boolean>();
        for (AggregationMetadata.AggregationParameterKind parameterKind : parameterKinds) {
            switch (parameterKind) {
                case BLOCK_INPUT_CHANNEL: 
                case INPUT_CHANNEL: {
                    nullable.add(false);
                    break;
                }
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    nullable.add(true);
                    break;
                }
            }
        }
        Preconditions.checkState((nullable.size() == parameterVariables.size() ? 1 : 0) != 0, (Object)"Number of parameters does not match");
        for (int i = 0; i < parameterVariables.size(); ++i) {
            if (((Boolean)nullable.get(i)).booleanValue()) continue;
            Variable variableDefinition = parameterVariables.get(i);
            loopBody = new IfStatement("if(!%s.isNull(position))", new Object[]{variableDefinition.getName()}).condition((BytecodeNode)new BytecodeBlock().getVariable(variableDefinition).getVariable(positionVariable).invokeInterface(Block.class, "isNull", Boolean.TYPE, new Class[]{Integer.TYPE})).ifFalse((BytecodeNode)loopBody);
        }
        loopBody = new IfStatement("if(testMask(%s, position))", new Object[]{masksBlock.getName()}).condition((BytecodeNode)new BytecodeBlock().getVariable(masksBlock).getVariable(positionVariable).invokeStatic(CompilerOperations.class, "testMask", Boolean.TYPE, new Class[]{Block.class, Integer.TYPE})).ifTrue((BytecodeNode)loopBody);
        ForLoop forLoop = new ForLoop().initialize((BytecodeNode)new BytecodeBlock().putVariable(positionVariable, 0)).condition((BytecodeNode)new BytecodeBlock().getVariable(positionVariable).getVariable(rowsVariable).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, new Class[]{Integer.TYPE, Integer.TYPE})).update((BytecodeNode)new BytecodeBlock().incrementVariable(positionVariable, (byte)1)).body((BytecodeNode)loopBody);
        block.append((BytecodeNode)new IfStatement("if(!maskGuaranteedToFilterAllRows(%s, %s))", new Object[]{rowsVariable.getName(), masksBlock.getName()}).condition((BytecodeNode)new BytecodeBlock().getVariable(rowsVariable).getVariable(masksBlock).invokeStatic(AggregationUtils.class, "maskGuaranteedToFilterAllRows", Boolean.TYPE, new Class[]{Integer.TYPE, Block.class})).ifFalse((BytecodeNode)forLoop));
        return block;
    }

    private static BytecodeBlock generateInvokeInputFunction(Scope scope, List<FieldDefinition> stateField, Variable position, List<Type> inputTypes, List<Variable> parameterVariables, List<AggregationMetadata.AggregationParameterKind> parameterKinds, List<FieldDefinition> lambdaProviderFields, MethodHandle inputFunction, CallSiteBinder callSiteBinder, boolean grouped) {
        BytecodeBlock block = new BytecodeBlock();
        if (grouped) {
            AccumulatorCompiler.generateSetGroupIdFromGroupIdsBlock(scope, stateField, block);
        }
        block.comment("Call input function with unpacked Block arguments");
        Class<?>[] parameters = inputFunction.type().parameterArray();
        int inputChannel = 0;
        int stateIndex = 0;
        Verify.verify((parameters.length == parameterKinds.size() + lambdaProviderFields.size() ? 1 : 0) != 0);
        block6: for (int i = 0; i < parameterKinds.size(); ++i) {
            AggregationMetadata.AggregationParameterKind parameterKind = parameterKinds.get(i);
            switch (parameterKind) {
                case STATE: {
                    block.append((BytecodeNode)scope.getThis().getField(stateField.get(stateIndex)));
                    ++stateIndex;
                    continue block6;
                }
                case BLOCK_INDEX: {
                    block.getVariable(position);
                    continue block6;
                }
                case BLOCK_INPUT_CHANNEL: 
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    block.getVariable(parameterVariables.get(inputChannel));
                    ++inputChannel;
                    continue block6;
                }
                case INPUT_CHANNEL: {
                    BytecodeBlock getBlockBytecode = new BytecodeBlock().getVariable(parameterVariables.get(inputChannel));
                    AccumulatorCompiler.pushStackType(scope, block, inputTypes.get(inputChannel), getBlockBytecode, parameters[i], callSiteBinder);
                    ++inputChannel;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter type: " + parameterKind);
                }
            }
        }
        for (FieldDefinition lambdaProviderField : lambdaProviderFields) {
            block.append((BytecodeNode)scope.getThis().getField(lambdaProviderField).invoke("getLambda", Object.class, new BytecodeExpression[0]));
        }
        block.append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(inputFunction), "input"));
        return block;
    }

    private static void pushStackType(Scope scope, BytecodeBlock block, Type sqlType, BytecodeBlock getBlockBytecode, Class<?> parameter, CallSiteBinder callSiteBinder) {
        Variable position = scope.getVariable("position");
        if (parameter == Long.TYPE) {
            block.comment("%s.getLong(block, position)", new Object[]{sqlType.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, sqlType)).append((BytecodeNode)getBlockBytecode).append((BytecodeNode)position).invokeInterface(Type.class, "getLong", Long.TYPE, new Class[]{Block.class, Integer.TYPE});
        } else if (parameter == Double.TYPE) {
            block.comment("%s.getDouble(block, position)", new Object[]{sqlType.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, sqlType)).append((BytecodeNode)getBlockBytecode).append((BytecodeNode)position).invokeInterface(Type.class, "getDouble", Double.TYPE, new Class[]{Block.class, Integer.TYPE});
        } else if (parameter == Boolean.TYPE) {
            block.comment("%s.getBoolean(block, position)", new Object[]{sqlType.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, sqlType)).append((BytecodeNode)getBlockBytecode).append((BytecodeNode)position).invokeInterface(Type.class, "getBoolean", Boolean.TYPE, new Class[]{Block.class, Integer.TYPE});
        } else if (parameter == Slice.class) {
            block.comment("%s.getSlice(block, position)", new Object[]{sqlType.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, sqlType)).append((BytecodeNode)getBlockBytecode).append((BytecodeNode)position).invokeInterface(Type.class, "getSlice", Slice.class, new Class[]{Block.class, Integer.TYPE});
        } else {
            block.comment("%s.getObject(block, position)", new Object[]{sqlType.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, sqlType)).append((BytecodeNode)getBlockBytecode).append((BytecodeNode)position).invokeInterface(Type.class, "getObject", Object.class, new Class[]{Block.class, Integer.TYPE});
            if (sqlType.getJavaType() != Object.class) {
                block.checkCast(sqlType.getJavaType());
            }
        }
    }

    private static void generateAddIntermediateAsCombine(ClassDefinition definition, List<StateFieldAndDescriptor> stateFieldAndDescriptors, List<FieldDefinition> lambdaProviderFields, MethodHandle combineFunction, CallSiteBinder callSiteBinder, boolean grouped) {
        int i;
        Object block;
        MethodDefinition method = AccumulatorCompiler.declareAddIntermediate(definition, grouped);
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        int stateCount = stateFieldAndDescriptors.size();
        ArrayList<Variable> scratchStates = new ArrayList<Variable>();
        for (int i2 = 0; i2 < stateCount; ++i2) {
            Class<AccumulatorState> scratchStateClass = AccumulatorState.class;
            scratchStates.add(scope.declareVariable(scratchStateClass, "scratchState_" + i2));
        }
        if (stateCount == 1) {
            block = ImmutableList.of((Object)scope.getVariable("block"));
        } else {
            Variable columnarRow = scope.declareVariable(ColumnarRow.class, "columnarRow");
            body.append((BytecodeNode)columnarRow.set(BytecodeExpressions.invokeStatic(ColumnarRow.class, (String)"toColumnarRow", ColumnarRow.class, (BytecodeExpression[])new BytecodeExpression[]{scope.getVariable("block")})));
            block = new ArrayList();
            for (i = 0; i < stateCount; ++i) {
                Variable columnBlock = scope.declareVariable(Block.class, "columnBlock_" + i);
                body.append((BytecodeNode)columnBlock.set(columnarRow.invoke("getField", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)i)})));
                block.add(columnBlock);
            }
        }
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        for (i = 0; i < stateCount; ++i) {
            FieldDefinition stateFactoryField = stateFieldAndDescriptors.get(i).getStateFactoryField();
            body.comment(String.format("scratchState_%s = stateFactory[%s].createSingleState();", i, i)).append((BytecodeNode)thisVariable.getField(stateFactoryField)).invokeInterface(AccumulatorStateFactory.class, "createSingleState", AccumulatorState.class, new Class[0]).checkCast(((Variable)scratchStates.get(i)).getType()).putVariable((Variable)scratchStates.get(i));
        }
        List stateFields = (List)stateFieldAndDescriptors.stream().map(rec$ -> ((StateFieldAndDescriptor)rec$).getStateField()).collect(ImmutableList.toImmutableList());
        if (grouped) {
            AccumulatorCompiler.generateEnsureCapacity(scope, stateFields, body);
        }
        BytecodeBlock loopBody = new BytecodeBlock();
        loopBody.comment("combine(state_0, state_1, ... scratchState_0, scratchState_1, ... lambda_0, lambda_1, ...)");
        for (FieldDefinition stateField : stateFields) {
            if (grouped) {
                Variable groupIdsBlock = scope.getVariable("groupIdsBlock");
                loopBody.append((BytecodeNode)thisVariable.getField(stateField).invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupIdsBlock.invoke("getGroupId", Long.TYPE, new BytecodeExpression[]{position})}));
            }
            loopBody.append((BytecodeNode)thisVariable.getField(stateField));
        }
        for (int i3 = 0; i3 < stateCount; ++i3) {
            FieldDefinition stateSerializerField = stateFieldAndDescriptors.get(i3).getStateSerializerField();
            loopBody.append((BytecodeNode)thisVariable.getField(stateSerializerField).invoke("deserialize", Void.TYPE, new BytecodeExpression[]{(BytecodeExpression)block.get(i3), position, ((Variable)scratchStates.get(i3)).cast(AccumulatorState.class)}));
            loopBody.append((BytecodeNode)scratchStates.get(i3));
        }
        for (FieldDefinition lambdaProviderField : lambdaProviderFields) {
            loopBody.append((BytecodeNode)scope.getThis().getField(lambdaProviderField).invoke("getLambda", Object.class, new BytecodeExpression[0]));
        }
        loopBody.append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(combineFunction), "combine"));
        if (grouped) {
            IfStatement ifStatement = new IfStatement("if (!groupIdsBlock.isNull(position))", new Object[0]).condition((BytecodeNode)BytecodeExpressions.not((BytecodeExpression)scope.getVariable("groupIdsBlock").invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position}))).ifTrue((BytecodeNode)loopBody);
            loopBody = new BytecodeBlock().append((BytecodeNode)ifStatement);
        }
        body.append((BytecodeNode)AccumulatorCompiler.generateBlockNonNullPositionForLoop(scope, position, loopBody)).ret();
    }

    private static void generateSetGroupIdFromGroupIdsBlock(Scope scope, List<FieldDefinition> stateFields, BytecodeBlock block) {
        Variable groupIdsBlock = scope.getVariable("groupIdsBlock");
        Variable position = scope.getVariable("position");
        for (FieldDefinition stateField : stateFields) {
            BytecodeExpression state = scope.getThis().getField(stateField);
            block.append((BytecodeNode)state.invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupIdsBlock.invoke("getGroupId", Long.TYPE, new BytecodeExpression[]{position})}));
        }
    }

    private static void generateEnsureCapacity(Scope scope, List<FieldDefinition> stateFields, BytecodeBlock block) {
        Variable groupIdsBlock = scope.getVariable("groupIdsBlock");
        for (FieldDefinition stateField : stateFields) {
            BytecodeExpression state = scope.getThis().getField(stateField);
            block.append((BytecodeNode)state.invoke("ensureCapacity", Void.TYPE, new BytecodeExpression[]{groupIdsBlock.invoke("getGroupCount", Long.TYPE, new BytecodeExpression[0])}));
        }
    }

    private static MethodDefinition declareAddIntermediate(ClassDefinition definition, boolean grouped) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        if (grouped) {
            parameters.add((Object)Parameter.arg((String)"groupIdsBlock", GroupByIdBlock.class));
        }
        parameters.add((Object)Parameter.arg((String)"block", Block.class));
        return definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "addIntermediate", ParameterizedType.type(Void.TYPE), (Iterable)parameters.build());
    }

    private static BytecodeBlock generateBlockNonNullPositionForLoop(Scope scope, Variable positionVariable, BytecodeBlock loopBody) {
        Variable rowsVariable = scope.declareVariable(Integer.TYPE, "rows");
        Variable blockVariable = scope.getVariable("block");
        BytecodeBlock block = new BytecodeBlock().append((BytecodeNode)blockVariable).invokeInterface(Block.class, "getPositionCount", Integer.TYPE, new Class[0]).putVariable(rowsVariable);
        IfStatement ifStatement = new IfStatement("if(!block.isNull(position))", new Object[0]).condition((BytecodeNode)new BytecodeBlock().append((BytecodeNode)blockVariable).append((BytecodeNode)positionVariable).invokeInterface(Block.class, "isNull", Boolean.TYPE, new Class[]{Integer.TYPE})).ifFalse((BytecodeNode)loopBody);
        block.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)positionVariable.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)new BytecodeBlock().append((BytecodeNode)positionVariable).append((BytecodeNode)rowsVariable).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, new Class[]{Integer.TYPE, Integer.TYPE})).update((BytecodeNode)new BytecodeBlock().incrementVariable(positionVariable, (byte)1)).body((BytecodeNode)ifStatement));
        return block;
    }

    private static void generateGroupedEvaluateIntermediate(ClassDefinition definition, List<StateFieldAndDescriptor> stateFieldAndDescriptors) {
        Parameter groupId = Parameter.arg((String)"groupId", Integer.TYPE);
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluateIntermediate", ParameterizedType.type(Void.TYPE), new Parameter[]{groupId, out});
        Variable thisVariable = method.getThis();
        BytecodeBlock body = method.getBody();
        if (stateFieldAndDescriptors.size() == 1) {
            BytecodeExpression stateSerializer = thisVariable.getField(((StateFieldAndDescriptor)Iterables.getOnlyElement(stateFieldAndDescriptors)).getStateSerializerField());
            BytecodeExpression state = thisVariable.getField(((StateFieldAndDescriptor)Iterables.getOnlyElement(stateFieldAndDescriptors)).getStateField());
            body.append((BytecodeNode)state.invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupId.cast(Long.TYPE)})).append((BytecodeNode)stateSerializer.invoke("serialize", Void.TYPE, new BytecodeExpression[]{state.cast(AccumulatorState.class), out})).ret();
        } else {
            Variable rowBuilder = method.getScope().declareVariable(BlockBuilder.class, "rowBuilder");
            body.append((BytecodeNode)rowBuilder.set(out.invoke("beginBlockEntry", BlockBuilder.class, new BytecodeExpression[0])));
            for (StateFieldAndDescriptor stateFieldAndDescriptor : stateFieldAndDescriptors) {
                BytecodeExpression stateSerializer = thisVariable.getField(stateFieldAndDescriptor.getStateSerializerField());
                BytecodeExpression state = thisVariable.getField(stateFieldAndDescriptor.getStateField());
                body.append((BytecodeNode)state.invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupId.cast(Long.TYPE)})).append((BytecodeNode)stateSerializer.invoke("serialize", Void.TYPE, new BytecodeExpression[]{state.cast(AccumulatorState.class), rowBuilder}));
            }
            body.append((BytecodeNode)out.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop()).ret();
        }
    }

    private static void generateEvaluateIntermediate(ClassDefinition definition, List<StateFieldAndDescriptor> stateFieldAndDescriptors) {
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluateIntermediate", ParameterizedType.type(Void.TYPE), new Parameter[]{out});
        Variable thisVariable = method.getThis();
        BytecodeBlock body = method.getBody();
        if (stateFieldAndDescriptors.size() == 1) {
            BytecodeExpression stateSerializer = thisVariable.getField(((StateFieldAndDescriptor)Iterables.getOnlyElement(stateFieldAndDescriptors)).getStateSerializerField());
            BytecodeExpression state = thisVariable.getField(((StateFieldAndDescriptor)Iterables.getOnlyElement(stateFieldAndDescriptors)).getStateField());
            body.append((BytecodeNode)stateSerializer.invoke("serialize", Void.TYPE, new BytecodeExpression[]{state.cast(AccumulatorState.class), out})).ret();
        } else {
            Variable rowBuilder = method.getScope().declareVariable(BlockBuilder.class, "rowBuilder");
            body.append((BytecodeNode)rowBuilder.set(out.invoke("beginBlockEntry", BlockBuilder.class, new BytecodeExpression[0])));
            for (StateFieldAndDescriptor stateFieldAndDescriptor : stateFieldAndDescriptors) {
                BytecodeExpression stateSerializer = thisVariable.getField(stateFieldAndDescriptor.getStateSerializerField());
                BytecodeExpression state = thisVariable.getField(stateFieldAndDescriptor.getStateField());
                body.append((BytecodeNode)stateSerializer.invoke("serialize", Void.TYPE, new BytecodeExpression[]{state.cast(AccumulatorState.class), rowBuilder}));
            }
            body.append((BytecodeNode)out.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop()).ret();
        }
    }

    private static void generateGroupedEvaluateFinal(ClassDefinition definition, List<FieldDefinition> stateFields, MethodHandle outputFunction, CallSiteBinder callSiteBinder) {
        Parameter groupId = Parameter.arg((String)"groupId", Integer.TYPE);
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluateFinal", ParameterizedType.type(Void.TYPE), new Parameter[]{groupId, out});
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        ArrayList<BytecodeExpression> states = new ArrayList<BytecodeExpression>();
        for (FieldDefinition stateField : stateFields) {
            BytecodeExpression state = thisVariable.getField(stateField);
            body.append((BytecodeNode)state.invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupId.cast(Long.TYPE)}));
            states.add(state);
        }
        body.comment("output(state_0, state_1, ..., out)");
        states.forEach(arg_0 -> ((BytecodeBlock)body).append(arg_0));
        body.append((BytecodeNode)out);
        body.append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(outputFunction), "output"));
        body.ret();
    }

    private static void generateEvaluateFinal(ClassDefinition definition, List<FieldDefinition> stateFields, MethodHandle outputFunction, CallSiteBinder callSiteBinder) {
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluateFinal", ParameterizedType.type(Void.TYPE), new Parameter[]{out});
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        ArrayList<BytecodeExpression> states = new ArrayList<BytecodeExpression>();
        for (FieldDefinition stateField : stateFields) {
            BytecodeExpression state = thisVariable.getField(stateField);
            states.add(state);
        }
        body.comment("output(state_0, state_1, ..., out)");
        states.forEach(arg_0 -> ((BytecodeBlock)body).append(arg_0));
        body.append((BytecodeNode)out);
        body.append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(outputFunction), "output"));
        body.ret();
    }

    private static void generatePrepareFinal(ClassDefinition definition) {
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "prepareFinal", ParameterizedType.type(Void.TYPE), new Parameter[0]);
        method.getBody().ret();
    }

    private static void generateConstructor(ClassDefinition definition, List<StateFieldAndDescriptor> stateFieldAndDescriptors, List<FieldDefinition> inputChannelFields, FieldDefinition maskChannelField, List<FieldDefinition> lambdaProviderFields, CallSiteBinder callSiteBinder, boolean grouped) {
        Parameter inputChannels = Parameter.arg((String)"inputChannels", (ParameterizedType)ParameterizedType.type(List.class, (Class[])new Class[]{Integer.class}));
        Parameter maskChannel = Parameter.arg((String)"maskChannel", (ParameterizedType)ParameterizedType.type(Optional.class, (Class[])new Class[]{Integer.class}));
        Parameter lambdaProviders = Parameter.arg((String)"lambdaProviders", (ParameterizedType)ParameterizedType.type(List.class, (Class[])new Class[]{LambdaProvider.class}));
        MethodDefinition method = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{inputChannels, maskChannel, lambdaProviders});
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        for (StateFieldAndDescriptor fieldAndDescriptor : stateFieldAndDescriptors) {
            AggregationMetadata.AccumulatorStateDescriptor<?> accumulatorStateDescriptor = fieldAndDescriptor.getAccumulatorStateDescriptor();
            body.append((BytecodeNode)thisVariable.setField(fieldAndDescriptor.getStateSerializerField(), BytecodeUtils.loadConstant(callSiteBinder, accumulatorStateDescriptor.getSerializer(), AccumulatorStateSerializer.class)));
            body.append((BytecodeNode)thisVariable.setField(fieldAndDescriptor.getStateFactoryField(), BytecodeUtils.loadConstant(callSiteBinder, accumulatorStateDescriptor.getFactory(), AccumulatorStateFactory.class)));
        }
        for (int i = 0; i < lambdaProviderFields.size(); ++i) {
            body.append((BytecodeNode)thisVariable.setField(lambdaProviderFields.get(i), lambdaProviders.invoke("get", Object.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)i)}).cast(LambdaProvider.class)));
        }
        body.append((BytecodeNode)thisVariable.setField(maskChannelField, BytecodeExpressions.invokeStatic((ParameterizedType)ParameterizedType.type(CompilerOperations.class), (String)"optionalChannelToIntOrNegative", (ParameterizedType)ParameterizedType.type(Integer.TYPE), (Iterable)ImmutableList.of((Object)ParameterizedType.type(Optional.class, (Class[])new Class[]{Integer.class})), (BytecodeExpression[])new BytecodeExpression[]{AccumulatorCompiler.generateRequireNotNull((Variable)maskChannel)})));
        body.append((BytecodeNode)AccumulatorCompiler.generateRequireNotNull((Variable)inputChannels)).push(inputChannelFields.size()).invokeStatic(ParameterizedType.type(CompilerOperations.class), "validateChannelsListLength", ParameterizedType.type(Void.TYPE), (Iterable)ImmutableList.of((Object)ParameterizedType.type(List.class, (Class[])new Class[]{Integer.class}), (Object)ParameterizedType.type(Integer.TYPE)));
        if (!inputChannelFields.isEmpty()) {
            BytecodeBlock assignFromList = new BytecodeBlock().comment("(this.inputChannel = %s.get(i), ...)", new Object[]{inputChannels.getName()});
            BytecodeBlock assignNegative = new BytecodeBlock().comment("(this.inputChannel = -1, ...)");
            for (int i = 0; i < inputChannelFields.size(); ++i) {
                FieldDefinition inputChannelField = inputChannelFields.get(i);
                assignFromList.append((BytecodeNode)thisVariable.setField(inputChannelField, inputChannels.invoke("get", Object.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)i)}).cast(Integer.TYPE)));
                assignNegative.append((BytecodeNode)thisVariable.setField(inputChannelField, BytecodeExpressions.constantInt((int)-1)));
            }
            body.append((BytecodeNode)new IfStatement("if(%s.isEmpty())", new Object[]{inputChannels.getName()}).condition((BytecodeNode)new BytecodeBlock().append((BytecodeNode)inputChannels).invokeInterface(List.class, "isEmpty", Boolean.TYPE, new Class[0])).ifTrue((BytecodeNode)assignNegative).ifFalse((BytecodeNode)assignFromList));
        }
        String createState = grouped ? "createGroupedState" : "createSingleState";
        for (StateFieldAndDescriptor stateFieldAndDescriptor : stateFieldAndDescriptors) {
            FieldDefinition stateField = stateFieldAndDescriptor.getStateField();
            BytecodeExpression stateFactory = thisVariable.getField(stateFieldAndDescriptor.getStateFactoryField());
            body.append((BytecodeNode)thisVariable.setField(stateField, stateFactory.invoke(createState, AccumulatorState.class, new BytecodeExpression[0]).cast(stateField.getType())));
        }
        body.ret();
    }

    private static void generatePrivateConstructor(ClassDefinition definition) {
        MethodDefinition method = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}), new Parameter[0]);
        BytecodeBlock body = method.getBody();
        body.comment("super();").append((BytecodeNode)method.getThis()).invokeConstructor(Object.class, new Class[0]).ret();
    }

    private static void generateCopy(ClassDefinition definition, List<StateFieldAndDescriptor> stateFieldsAndDescriptors, List<FieldDefinition> lambdaProviderFields, FieldDefinition maskChannelField, List<FieldDefinition> inputChannelFields) {
        MethodDefinition copy = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "copy", ParameterizedType.type(Accumulator.class), new Parameter[0]);
        Variable thisVariable = copy.getThis();
        Variable instanceCopy = copy.getScope().declareVariable(definition.getType(), "instanceCopy");
        copy.getBody().append((BytecodeNode)instanceCopy.set(BytecodeExpressions.newInstance((ParameterizedType)definition.getType(), (BytecodeExpression[])new BytecodeExpression[0])));
        for (StateFieldAndDescriptor descriptor : stateFieldsAndDescriptors) {
            FieldDefinition stateSerializerField = descriptor.getStateSerializerField();
            FieldDefinition stateFactoryField = descriptor.getStateFactoryField();
            FieldDefinition stateField = descriptor.getStateField();
            copy.getBody().append((BytecodeNode)instanceCopy.setField(stateSerializerField, thisVariable.getField(stateSerializerField))).append((BytecodeNode)instanceCopy.setField(stateFactoryField, thisVariable.getField(stateFactoryField))).append((BytecodeNode)instanceCopy.setField(stateField, thisVariable.getField(stateField).invoke("copy", AccumulatorState.class, (Iterable)ImmutableList.of()).cast(stateField.getType())));
        }
        for (FieldDefinition lambdaProviderField : lambdaProviderFields) {
            copy.getBody().append((BytecodeNode)instanceCopy.setField(lambdaProviderField, thisVariable.getField(lambdaProviderField)));
        }
        copy.getBody().append((BytecodeNode)instanceCopy.setField(maskChannelField, thisVariable.getField(maskChannelField)));
        for (FieldDefinition inputChannelField : inputChannelFields) {
            copy.getBody().append((BytecodeNode)instanceCopy.setField(inputChannelField, thisVariable.getField(inputChannelField)));
        }
        copy.getBody().append((BytecodeNode)instanceCopy.ret());
    }

    private static BytecodeExpression generateRequireNotNull(Variable variable) {
        return BytecodeExpressions.invokeStatic(Objects.class, (String)"requireNonNull", Object.class, (BytecodeExpression[])new BytecodeExpression[]{variable.cast(Object.class), BytecodeExpressions.constantString((String)(variable.getName() + " is null"))}).cast(variable.getType());
    }

    private static int countInputChannels(List<AggregationMetadata.AggregationParameterKind> parameterKinds) {
        int parameters = 0;
        for (AggregationMetadata.AggregationParameterKind parameterKind : parameterKinds) {
            if (parameterKind != AggregationMetadata.AggregationParameterKind.INPUT_CHANNEL && parameterKind != AggregationMetadata.AggregationParameterKind.BLOCK_INPUT_CHANNEL && parameterKind != AggregationMetadata.AggregationParameterKind.NULLABLE_BLOCK_INPUT_CHANNEL) continue;
            ++parameters;
        }
        return parameters;
    }

    private static AggregationMetadata normalizeAggregationMethods(AggregationMetadata metadata) {
        int stateParameterCount = metadata.getAccumulatorStateDescriptors().size();
        int lambdaParameterCount = metadata.getLambdaInterfaces().size();
        return new AggregationMetadata(metadata.getInputParameterKinds(), AccumulatorCompiler.castStateParameters(metadata.getInputFunction(), stateParameterCount, lambdaParameterCount), metadata.getRemoveInputFunction().map(removeFunction -> AccumulatorCompiler.castStateParameters(removeFunction, stateParameterCount, lambdaParameterCount)), AccumulatorCompiler.castStateParameters(metadata.getCombineFunction(), stateParameterCount * 2, lambdaParameterCount), AccumulatorCompiler.castStateParameters(metadata.getOutputFunction(), stateParameterCount, 0), metadata.getAccumulatorStateDescriptors(), metadata.getLambdaInterfaces());
    }

    private static MethodHandle castStateParameters(MethodHandle inputFunction, int stateParameterCount, int lambdaParameterCount) {
        int i;
        Class<?>[] parameterTypes = inputFunction.type().parameterArray();
        for (i = 0; i < stateParameterCount; ++i) {
            parameterTypes[i] = AccumulatorState.class;
        }
        for (i = parameterTypes.length - lambdaParameterCount; i < parameterTypes.length; ++i) {
            parameterTypes[i] = Object.class;
        }
        return MethodHandles.explicitCastArguments(inputFunction, MethodType.methodType(inputFunction.type().returnType(), parameterTypes));
    }

    private static class StateFieldAndDescriptor {
        private final AggregationMetadata.AccumulatorStateDescriptor<?> accumulatorStateDescriptor;
        private final FieldDefinition stateSerializerField;
        private final FieldDefinition stateFactoryField;
        private final FieldDefinition stateField;

        private StateFieldAndDescriptor(AggregationMetadata.AccumulatorStateDescriptor<?> accumulatorStateDescriptor, FieldDefinition stateSerializerField, FieldDefinition stateFactoryField, FieldDefinition stateField) {
            this.accumulatorStateDescriptor = accumulatorStateDescriptor;
            this.stateSerializerField = Objects.requireNonNull(stateSerializerField, "stateSerializerField is null");
            this.stateFactoryField = Objects.requireNonNull(stateFactoryField, "stateFactoryField is null");
            this.stateField = Objects.requireNonNull(stateField, "stateField is null");
        }

        public AggregationMetadata.AccumulatorStateDescriptor<?> getAccumulatorStateDescriptor() {
            return this.accumulatorStateDescriptor;
        }

        private FieldDefinition getStateSerializerField() {
            return this.stateSerializerField;
        }

        private FieldDefinition getStateFactoryField() {
            return this.stateFactoryField;
        }

        private FieldDefinition getStateField() {
            return this.stateField;
        }
    }
}

