/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import io.trino.metadata.Signature;
import io.trino.operator.ParametricFunctionHelpers;
import io.trino.operator.ParametricImplementation;
import io.trino.operator.ParametricImplementationsGroup;
import io.trino.operator.aggregation.AggregationHeader;
import io.trino.operator.aggregation.AggregationImplementation;
import io.trino.operator.aggregation.ParametricAggregation;
import io.trino.operator.annotations.FunctionsParserHelper;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.RemoveInputFunction;
import io.trino.spi.type.TypeSignature;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class AggregationFromAnnotationsParser {
    private AggregationFromAnnotationsParser() {
    }

    public static List<ParametricAggregation> parseFunctionDefinitions(Class<?> aggregationDefinition) {
        AggregationFunction aggregationAnnotation = aggregationDefinition.getAnnotation(AggregationFunction.class);
        Objects.requireNonNull(aggregationAnnotation, "aggregationAnnotation is null");
        ImmutableList.Builder functions = ImmutableList.builder();
        Class<? extends AccumulatorState> stateClass = AggregationFromAnnotationsParser.getStateClass(aggregationDefinition);
        Method combineFunction = AggregationFromAnnotationsParser.getCombineFunction(aggregationDefinition, stateClass);
        for (Method outputFunction : AggregationFromAnnotationsParser.getOutputFunctions(aggregationDefinition, stateClass)) {
            AggregationHeader header = AggregationFromAnnotationsParser.parseHeader(aggregationDefinition, outputFunction);
            ArrayList<AggregationImplementation> exactImplementations = new ArrayList<AggregationImplementation>();
            ArrayList<AggregationImplementation> nonExactImplementations = new ArrayList<AggregationImplementation>();
            for (Method inputFunction : AggregationFromAnnotationsParser.getInputFunctions(aggregationDefinition, stateClass)) {
                Optional<Method> removeInputFunction = AggregationFromAnnotationsParser.getRemoveInputFunction(aggregationDefinition, inputFunction);
                AggregationImplementation implementation = AggregationImplementation.Parser.parseImplementation(aggregationDefinition, header.getName(), inputFunction, removeInputFunction, outputFunction, combineFunction);
                if (AggregationFromAnnotationsParser.isGenericOrCalculated(implementation.getSignature())) {
                    exactImplementations.add(implementation);
                    continue;
                }
                nonExactImplementations.add(implementation);
            }
            functions.addAll(AggregationFromAnnotationsParser.buildFunctions(header.getName(), header, stateClass, exactImplementations, nonExactImplementations));
            for (String alias : AggregationFromAnnotationsParser.getAliases(aggregationDefinition.getAnnotation(AggregationFunction.class), outputFunction)) {
                functions.addAll(AggregationFromAnnotationsParser.buildFunctions(alias, header, stateClass, exactImplementations, nonExactImplementations));
            }
        }
        return functions.build();
    }

    private static List<ParametricAggregation> buildFunctions(String name, AggregationHeader header, Class<? extends AccumulatorState> stateClass, List<AggregationImplementation> exactImplementations, List<AggregationImplementation> nonExactImplementations) {
        ImmutableList.Builder functions = ImmutableList.builder();
        for (AggregationImplementation exactImplementation : exactImplementations) {
            functions.add((Object)new ParametricAggregation(ParametricFunctionHelpers.signatureWithName(name, exactImplementation.getSignature()), header, stateClass, ParametricImplementationsGroup.of((ParametricImplementation[])new AggregationImplementation[]{exactImplementation}).withAlias(name)));
        }
        if (!nonExactImplementations.isEmpty()) {
            ParametricImplementationsGroup.Builder implementationsBuilder = ParametricImplementationsGroup.builder();
            nonExactImplementations.forEach(implementationsBuilder::addImplementation);
            ParametricImplementationsGroup implementations = implementationsBuilder.build();
            functions.add((Object)new ParametricAggregation(ParametricFunctionHelpers.signatureWithName(name, implementations.getSignature()), header, stateClass, implementations.withAlias(name)));
        }
        return functions.build();
    }

    private static boolean isGenericOrCalculated(Signature signature) {
        return signature.getTypeVariableConstraints().isEmpty() && signature.getArgumentTypes().stream().noneMatch(TypeSignature::isCalculated) && !signature.getReturnType().isCalculated();
    }

    private static AggregationHeader parseHeader(AnnotatedElement aggregationDefinition, AnnotatedElement outputFunction) {
        AggregationFunction aggregationAnnotation = aggregationDefinition.getAnnotation(AggregationFunction.class);
        Objects.requireNonNull(aggregationAnnotation, "aggregationAnnotation is null");
        String name = AggregationFromAnnotationsParser.getName(aggregationAnnotation, outputFunction);
        return new AggregationHeader(name, FunctionsParserHelper.parseDescription(aggregationDefinition, outputFunction), aggregationAnnotation.decomposable(), aggregationAnnotation.isOrderSensitive(), aggregationAnnotation.hidden(), ((Deprecated[])aggregationDefinition.getAnnotationsByType(Deprecated.class)).length > 0);
    }

    private static String getName(AggregationFunction aggregationAnnotation, AnnotatedElement outputFunction) {
        AggregationFunction annotation = outputFunction.getAnnotation(AggregationFunction.class);
        if (annotation != null && !annotation.value().isEmpty()) {
            return Strings.emptyToNull((String)annotation.value());
        }
        return Strings.emptyToNull((String)aggregationAnnotation.value());
    }

    private static List<String> getAliases(AggregationFunction aggregationAnnotation, AnnotatedElement outputFunction) {
        AggregationFunction annotation = outputFunction.getAnnotation(AggregationFunction.class);
        if (annotation != null && annotation.alias().length > 0) {
            return ImmutableList.copyOf((Object[])annotation.alias());
        }
        return ImmutableList.copyOf((Object[])aggregationAnnotation.alias());
    }

    private static Method getCombineFunction(Class<?> clazz, Class<?> stateClass) {
        List combineFunctions = (List)FunctionsParserHelper.findPublicStaticMethodsWithAnnotation(clazz, CombineFunction.class).stream().filter(method -> method.getParameterTypes()[AggregationImplementation.Parser.findAggregationStateParamId(method, 0)] == stateClass).filter(method -> method.getParameterTypes()[AggregationImplementation.Parser.findAggregationStateParamId(method, 1)] == stateClass).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((combineFunctions.size() == 1 ? 1 : 0) != 0, (String)"There must be exactly one @CombineFunction in class %s for the @AggregationState %s", (Object)clazz.toGenericString(), (Object)stateClass.toGenericString());
        return (Method)Iterables.getOnlyElement((Iterable)combineFunctions);
    }

    private static List<Method> getOutputFunctions(Class<?> clazz, Class<?> stateClass) {
        List outputFunctions = (List)FunctionsParserHelper.findPublicStaticMethodsWithAnnotation(clazz, OutputFunction.class).stream().filter(method -> method.getParameterTypes()[AggregationImplementation.Parser.findAggregationStateParamId(method)] == stateClass).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((!outputFunctions.isEmpty() ? 1 : 0) != 0, (Object)"Aggregation has no output functions");
        return outputFunctions;
    }

    private static List<Method> getInputFunctions(Class<?> clazz, Class<?> stateClass) {
        List inputFunctions = (List)FunctionsParserHelper.findPublicStaticMethodsWithAnnotation(clazz, InputFunction.class).stream().filter(method -> method.getParameterTypes()[AggregationImplementation.Parser.findAggregationStateParamId(method)] == stateClass).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((!inputFunctions.isEmpty() ? 1 : 0) != 0, (Object)"Aggregation has no input functions");
        return inputFunctions;
    }

    private static Optional<Method> getRemoveInputFunction(Class<?> clazz, Method inputFunction) {
        return (Optional)FunctionsParserHelper.findPublicStaticMethodsWithAnnotation(clazz, RemoveInputFunction.class).stream().filter(method -> Arrays.equals(method.getParameterTypes(), inputFunction.getParameterTypes())).filter(method -> Arrays.deepEquals((Object[])method.getParameterAnnotations(), (Object[])inputFunction.getParameterAnnotations())).collect(MoreCollectors.toOptional());
    }

    private static Class<? extends AccumulatorState> getStateClass(Class<?> clazz) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Method inputFunction : FunctionsParserHelper.findPublicStaticMethodsWithAnnotation(clazz, InputFunction.class)) {
            Preconditions.checkArgument((inputFunction.getParameterTypes().length > 0 ? 1 : 0) != 0, (Object)"Input function has no parameters");
            Class<?> stateClass = AggregationImplementation.Parser.findAggregationStateParamType(inputFunction);
            Preconditions.checkArgument((boolean)AccumulatorState.class.isAssignableFrom(stateClass), (Object)"stateClass is not a subclass of AccumulatorState");
            builder.add(stateClass.asSubclass(AccumulatorState.class));
        }
        ImmutableSet stateClasses = builder.build();
        Preconditions.checkArgument((!stateClasses.isEmpty() ? 1 : 0) != 0, (Object)"No input functions found");
        Preconditions.checkArgument((stateClasses.size() == 1 ? 1 : 0) != 0, (String)"There must be exactly one @AccumulatorState in class %s", (Object)clazz.toGenericString());
        return (Class)Iterables.getOnlyElement((Iterable)stateClasses);
    }
}

