/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.ParametricFunctionHelpers;
import io.trino.operator.ParametricImplementation;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.NullablePosition;
import io.trino.operator.annotations.FunctionsParserHelper;
import io.trino.operator.annotations.ImplementationDependency;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.util.Reflection;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class AggregationImplementation
implements ParametricImplementation {
    private final Signature signature;
    private final Class<?> definitionClass;
    private final MethodHandle inputFunction;
    private final Optional<MethodHandle> removeInputFunction;
    private final MethodHandle outputFunction;
    private final MethodHandle combineFunction;
    private final List<AggregateNativeContainerType> argumentNativeContainerTypes;
    private final List<ImplementationDependency> inputDependencies;
    private final List<ImplementationDependency> removeInputDependencies;
    private final List<ImplementationDependency> combineDependencies;
    private final List<ImplementationDependency> outputDependencies;
    private final List<AggregationMetadata.AggregationParameterKind> inputParameterKinds;
    private final FunctionNullability functionNullability;

    public AggregationImplementation(Signature signature, Class<?> definitionClass, MethodHandle inputFunction, Optional<MethodHandle> removeInputFunction, MethodHandle outputFunction, MethodHandle combineFunction, List<AggregateNativeContainerType> argumentNativeContainerTypes, List<ImplementationDependency> inputDependencies, List<ImplementationDependency> removeInputDependencies, List<ImplementationDependency> combineDependencies, List<ImplementationDependency> outputDependencies, List<AggregationMetadata.AggregationParameterKind> inputParameterKinds) {
        this.signature = Objects.requireNonNull(signature, "signature cannot be null");
        this.definitionClass = Objects.requireNonNull(definitionClass, "definition class cannot be null");
        this.inputFunction = Objects.requireNonNull(inputFunction, "inputFunction cannot be null");
        this.removeInputFunction = Objects.requireNonNull(removeInputFunction, "removeInputFunction cannot be null");
        this.outputFunction = Objects.requireNonNull(outputFunction, "outputFunction cannot be null");
        this.combineFunction = Objects.requireNonNull(combineFunction, "combineFunction cannot be null");
        this.argumentNativeContainerTypes = Objects.requireNonNull(argumentNativeContainerTypes, "argumentNativeContainerTypes cannot be null");
        this.inputDependencies = Objects.requireNonNull(inputDependencies, "inputDependencies cannot be null");
        this.removeInputDependencies = Objects.requireNonNull(removeInputDependencies, "removeInputDependencies cannot be null");
        this.outputDependencies = Objects.requireNonNull(outputDependencies, "outputDependencies cannot be null");
        this.combineDependencies = Objects.requireNonNull(combineDependencies, "combineDependencies cannot be null");
        this.inputParameterKinds = Objects.requireNonNull(inputParameterKinds, "inputParameterKinds cannot be null");
        this.functionNullability = new FunctionNullability(true, (List)inputParameterKinds.stream().filter(parameterType -> parameterType != AggregationMetadata.AggregationParameterKind.BLOCK_INDEX && parameterType != AggregationMetadata.AggregationParameterKind.STATE).map(AggregationMetadata.AggregationParameterKind.NULLABLE_BLOCK_INPUT_CHANNEL::equals).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean hasSpecializedTypeParameters() {
        return false;
    }

    @Override
    public FunctionNullability getFunctionNullability() {
        return this.functionNullability;
    }

    public Class<?> getDefinitionClass() {
        return this.definitionClass;
    }

    public MethodHandle getInputFunction() {
        return this.inputFunction;
    }

    public Optional<MethodHandle> getRemoveInputFunction() {
        return this.removeInputFunction;
    }

    public MethodHandle getOutputFunction() {
        return this.outputFunction;
    }

    public MethodHandle getCombineFunction() {
        return this.combineFunction;
    }

    public List<ImplementationDependency> getInputDependencies() {
        return this.inputDependencies;
    }

    public List<ImplementationDependency> getRemoveInputDependencies() {
        return this.removeInputDependencies;
    }

    public List<ImplementationDependency> getOutputDependencies() {
        return this.outputDependencies;
    }

    public List<ImplementationDependency> getCombineDependencies() {
        return this.combineDependencies;
    }

    public List<AggregationMetadata.AggregationParameterKind> getInputParameterKinds() {
        return this.inputParameterKinds;
    }

    public boolean areTypesAssignable(BoundSignature boundSignature) {
        Preconditions.checkState((this.argumentNativeContainerTypes.size() == boundSignature.getArgumentTypes().size() ? 1 : 0) != 0, (Object)"Number of argument assigned to AggregationImplementation is different than number parsed from annotations.");
        for (int i = 0; i < boundSignature.getArgumentTypes().size(); ++i) {
            Class argumentType = boundSignature.getArgumentTypes().get(i).getJavaType();
            Class<Block> methodDeclaredType = this.argumentNativeContainerTypes.get(i).getJavaType();
            boolean isCurrentBlockPosition = this.argumentNativeContainerTypes.get(i).isBlockPosition();
            if (isCurrentBlockPosition && methodDeclaredType.isAssignableFrom(Block.class) || !isCurrentBlockPosition && methodDeclaredType.isAssignableFrom(argumentType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public AggregationImplementation withAlias(String alias) {
        return new AggregationImplementation(ParametricFunctionHelpers.signatureWithName(alias, this.signature), this.definitionClass, this.inputFunction, this.removeInputFunction, this.outputFunction, this.combineFunction, this.argumentNativeContainerTypes, this.inputDependencies, this.removeInputDependencies, this.combineDependencies, this.outputDependencies, this.inputParameterKinds);
    }

    public static final class Parser {
        private final Class<?> aggregationDefinition;
        private final MethodHandle inputHandle;
        private final Optional<MethodHandle> removeInputHandle;
        private final MethodHandle outputHandle;
        private final MethodHandle combineHandle;
        private final List<AggregateNativeContainerType> argumentNativeContainerTypes;
        private final List<ImplementationDependency> inputDependencies;
        private final List<ImplementationDependency> removeInputDependencies;
        private final List<ImplementationDependency> combineDependencies;
        private final List<ImplementationDependency> outputDependencies;
        private final List<AggregationMetadata.AggregationParameterKind> inputParameterKinds;
        private final List<LongVariableConstraint> longVariableConstraints;
        private final List<TypeVariableConstraint> typeVariableConstraints;
        private final List<TypeSignature> inputTypes;
        private final TypeSignature returnType;
        private final String name;
        private final Set<String> literalParameters;
        private final List<TypeParameter> typeParameters;

        private Parser(Class<?> aggregationDefinition, String name, Method inputFunction, Optional<Method> removeInputFunction, Method outputFunction, Method combineFunction) {
            this.aggregationDefinition = aggregationDefinition;
            this.name = name;
            this.literalParameters = FunctionsParserHelper.parseLiteralParameters(inputFunction);
            this.typeParameters = Arrays.asList((TypeParameter[])inputFunction.getAnnotationsByType(TypeParameter.class));
            this.inputDependencies = this.parseImplementationDependencies(inputFunction);
            this.removeInputDependencies = removeInputFunction.map(this::parseImplementationDependencies).orElse((List)ImmutableList.of());
            this.outputDependencies = this.parseImplementationDependencies(outputFunction);
            this.combineDependencies = this.parseImplementationDependencies(combineFunction);
            this.inputParameterKinds = Parser.parseInputParameterKinds(inputFunction);
            this.longVariableConstraints = FunctionsParserHelper.parseLongVariableConstraints(inputFunction);
            List allDependencies = (List)Stream.of(this.inputDependencies.stream(), this.removeInputDependencies.stream(), this.outputDependencies.stream(), this.combineDependencies.stream()).reduce(Stream::concat).orElseGet(Stream::empty).collect(ImmutableList.toImmutableList());
            this.typeVariableConstraints = FunctionsParserHelper.createTypeVariableConstraints(this.typeParameters, allDependencies);
            this.argumentNativeContainerTypes = Parser.parseSignatureArgumentsTypes(inputFunction);
            this.inputTypes = this.getInputTypesSignatures(inputFunction);
            this.returnType = TypeSignatureTranslator.parseTypeSignature(outputFunction.getAnnotation(OutputFunction.class).value(), this.literalParameters);
            this.inputHandle = Reflection.methodHandle(inputFunction);
            this.removeInputHandle = removeInputFunction.map(Reflection::methodHandle);
            this.combineHandle = Reflection.methodHandle(combineFunction);
            this.outputHandle = Reflection.methodHandle(outputFunction);
        }

        private AggregationImplementation get() {
            Signature signature = new Signature(this.name, this.typeVariableConstraints, this.longVariableConstraints, this.returnType, this.inputTypes, false);
            return new AggregationImplementation(signature, this.aggregationDefinition, this.inputHandle, this.removeInputHandle, this.outputHandle, this.combineHandle, this.argumentNativeContainerTypes, this.inputDependencies, this.removeInputDependencies, this.combineDependencies, this.outputDependencies, this.inputParameterKinds);
        }

        public static AggregationImplementation parseImplementation(Class<?> aggregationDefinition, String name, Method inputFunction, Optional<Method> removeInputFunction, Method outputFunction, Method combineFunction) {
            return new Parser(aggregationDefinition, name, inputFunction, removeInputFunction, outputFunction, combineFunction).get();
        }

        private static List<AggregationMetadata.AggregationParameterKind> parseInputParameterKinds(Method method) {
            ImmutableList.Builder builder = ImmutableList.builder();
            Annotation[][] annotations = method.getParameterAnnotations();
            String methodName = method.getDeclaringClass() + "." + method.getName();
            Preconditions.checkArgument((method.getParameterCount() > 0 ? 1 : 0) != 0, (Object)"At least @AggregationState argument is required for each of aggregation functions.");
            int i = 0;
            if (annotations[0].length == 0) {
                builder.add((Object)AggregationMetadata.AggregationParameterKind.STATE);
                ++i;
            }
            while (i < annotations.length) {
                Annotation baseTypeAnnotation = Parser.baseTypeAnnotation(annotations[i], methodName);
                if (!ImplementationDependency.isImplementationDependencyAnnotation(baseTypeAnnotation)) {
                    if (baseTypeAnnotation instanceof AggregationState) {
                        builder.add((Object)AggregationMetadata.AggregationParameterKind.STATE);
                    } else if (baseTypeAnnotation instanceof SqlType) {
                        boolean isParameterBlock = Parser.isParameterBlock(annotations[i]);
                        boolean isParameterNullable = Parser.isParameterNullable(annotations[i]);
                        builder.add((Object)Parser.getInputParameterKind(isParameterNullable, isParameterBlock, methodName));
                    } else if (baseTypeAnnotation instanceof BlockIndex) {
                        builder.add((Object)AggregationMetadata.AggregationParameterKind.BLOCK_INDEX);
                    } else {
                        throw new VerifyException("Unhandled annotation: " + baseTypeAnnotation);
                    }
                }
                ++i;
            }
            return builder.build();
        }

        static AggregationMetadata.AggregationParameterKind getInputParameterKind(boolean isNullable, boolean isBlock, String methodName) {
            if (isBlock) {
                if (isNullable) {
                    return AggregationMetadata.AggregationParameterKind.NULLABLE_BLOCK_INPUT_CHANNEL;
                }
                return AggregationMetadata.AggregationParameterKind.BLOCK_INPUT_CHANNEL;
            }
            if (isNullable) {
                throw new IllegalArgumentException(methodName + " contains a parameter with @NullablePosition that is not @BlockPosition");
            }
            return AggregationMetadata.AggregationParameterKind.INPUT_CHANNEL;
        }

        private static Annotation baseTypeAnnotation(Annotation[] annotations, String methodName) {
            List baseTypes = (List)Arrays.asList(annotations).stream().filter(annotation -> Parser.isAggregationMetaAnnotation(annotation) || annotation instanceof SqlType).collect(ImmutableList.toImmutableList());
            Preconditions.checkArgument((baseTypes.size() == 1 ? 1 : 0) != 0, (String)"Parameter of %s must have exactly one of @SqlType, @BlockIndex", (Object)methodName);
            boolean nullable = Parser.isParameterNullable(annotations);
            boolean isBlock = Parser.isParameterBlock(annotations);
            Annotation annotation2 = (Annotation)baseTypes.get(0);
            Preconditions.checkArgument((!isBlock && !nullable || annotation2 instanceof SqlType ? 1 : 0) != 0, (String)"%s contains a parameter with @BlockPosition and/or @NullablePosition that is not @SqlType", (Object)methodName);
            return annotation2;
        }

        public static List<AggregateNativeContainerType> parseSignatureArgumentsTypes(Method inputFunction) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < inputFunction.getParameterCount(); ++i) {
                Class<?> parameterType = inputFunction.getParameterTypes()[i];
                Annotation[] annotations = inputFunction.getParameterAnnotations()[i];
                if (parameterType == ConnectorSession.class || FunctionsParserHelper.containsAnnotation(annotations, Parser::isAggregationMetaAnnotation)) continue;
                builder.add((Object)new AggregateNativeContainerType(inputFunction.getParameterTypes()[i], Parser.isParameterBlock(annotations)));
            }
            return builder.build();
        }

        public List<ImplementationDependency> parseImplementationDependencies(Method inputFunction) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Parameter parameter : inputFunction.getParameters()) {
                Class<?> parameterType = parameter.getType();
                if (parameterType == ConnectorSession.class) continue;
                ImplementationDependency.getImplementationDependencyAnnotation(parameter).ifPresent(annotation -> {
                    ImplementationDependency.validateImplementationDependencyAnnotation(inputFunction, annotation, (Set)this.typeParameters.stream().map(TypeParameter::value).collect(ImmutableSet.toImmutableSet()), this.literalParameters);
                    builder.add((Object)ImplementationDependency.Factory.createDependency(annotation, this.literalParameters, parameter.getType()));
                });
            }
            return builder.build();
        }

        public static boolean isParameterNullable(Annotation[] annotations) {
            return FunctionsParserHelper.containsAnnotation(annotations, annotation -> annotation instanceof NullablePosition);
        }

        public static boolean isParameterBlock(Annotation[] annotations) {
            return FunctionsParserHelper.containsAnnotation(annotations, annotation -> annotation instanceof BlockPosition);
        }

        public List<TypeSignature> getInputTypesSignatures(Method inputFunction) {
            Annotation[][] parameterAnnotations;
            ImmutableList.Builder builder = ImmutableList.builder();
            Annotation[][] annotationArray = parameterAnnotations = inputFunction.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = annotationArray[i]) {
                    if (!(annotation instanceof SqlType)) continue;
                    String typeName = ((SqlType)annotation).value();
                    builder.add((Object)TypeSignatureTranslator.parseTypeSignature(typeName, this.literalParameters));
                }
            }
            return builder.build();
        }

        public static Class<?> findAggregationStateParamType(Method inputFunction) {
            return inputFunction.getParameterTypes()[Parser.findAggregationStateParamId(inputFunction)];
        }

        public static int findAggregationStateParamId(Method method) {
            return Parser.findAggregationStateParamId(method, 0);
        }

        public static int findAggregationStateParamId(Method method, int id) {
            int currentParamId = 0;
            int found = 0;
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = annotationArray[i]) {
                    if (!(annotation instanceof AggregationState) || found++ != id) continue;
                    return currentParamId;
                }
                ++currentParamId;
            }
            return id;
        }

        private static boolean isAggregationMetaAnnotation(Annotation annotation) {
            return annotation instanceof BlockIndex || annotation instanceof AggregationState || ImplementationDependency.isImplementationDependencyAnnotation(annotation);
        }
    }

    public static class AggregateNativeContainerType {
        private final Class<?> javaType;
        private final boolean isBlockPosition;

        public AggregateNativeContainerType(Class<?> javaType, boolean isBlockPosition) {
            this.javaType = javaType;
            this.isBlockPosition = isBlockPosition;
        }

        public Class<?> getJavaType() {
            return this.javaType;
        }

        public boolean isBlockPosition() {
            return this.isBlockPosition;
        }
    }
}

