/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.type.BlockTypeOperators;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ChecksumAggregationFunction
extends SqlAggregationFunction {
    @VisibleForTesting
    public static final long PRIME64 = -7046029288634856825L;
    private static final String NAME = "checksum";
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(ChecksumAggregationFunction.class, "output", NullableLongState.class, BlockBuilder.class);
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(ChecksumAggregationFunction.class, "input", BlockTypeOperators.BlockPositionXxHash64.class, NullableLongState.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(ChecksumAggregationFunction.class, "combine", NullableLongState.class, NullableLongState.class);
    private final BlockTypeOperators blockTypeOperators;

    public ChecksumAggregationFunction(BlockTypeOperators blockTypeOperators) {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter("T")), (List<LongVariableConstraint>)ImmutableList.of(), VarbinaryType.VARBINARY.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0])), false), new FunctionNullability(true, (List<Boolean>)ImmutableList.of((Object)true)), false, true, "Checksum of the given values", FunctionKind.AGGREGATE), new AggregationFunctionMetadata(false, BigintType.BIGINT.getTypeSignature()));
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature) {
        Type valueType = boundSignature.getArgumentTypes().get(0);
        BlockTypeOperators.BlockPositionXxHash64 xxHash64Operator = this.blockTypeOperators.getXxHash64Operator(valueType);
        AccumulatorStateSerializer<NullableLongState> stateSerializer = StateCompiler.generateStateSerializer(NullableLongState.class);
        return new AggregationMetadata((List<AggregationMetadata.AggregationParameterKind>)ImmutableList.of((Object)((Object)AggregationMetadata.AggregationParameterKind.STATE), (Object)((Object)AggregationMetadata.AggregationParameterKind.NULLABLE_BLOCK_INPUT_CHANNEL), (Object)((Object)AggregationMetadata.AggregationParameterKind.BLOCK_INDEX)), INPUT_FUNCTION.bindTo(xxHash64Operator), Optional.empty(), COMBINE_FUNCTION, OUTPUT_FUNCTION, (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(new AggregationMetadata.AccumulatorStateDescriptor<NullableLongState>(NullableLongState.class, stateSerializer, StateCompiler.generateStateFactory(NullableLongState.class))));
    }

    public static void input(BlockTypeOperators.BlockPositionXxHash64 xxHash64Operator, NullableLongState state, Block block, int position) {
        state.setNull(false);
        if (block.isNull(position)) {
            state.setValue(state.getValue() + -7046029288634856825L);
        } else {
            state.setValue(state.getValue() + xxHash64Operator.xxHash64(block, position) * -7046029288634856825L);
        }
    }

    public static void combine(NullableLongState state, NullableLongState otherState) {
        state.setNull(state.isNull() && otherState.isNull());
        state.setValue(state.getValue() + otherState.getValue());
    }

    public static void output(NullableLongState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            VarbinaryType.VARBINARY.writeSlice(out, Slices.wrappedLongArray((long[])new long[]{state.getValue()}));
        }
    }
}

