/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.state.LongState;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class CountColumn
extends SqlAggregationFunction {
    public static final CountColumn COUNT_COLUMN = new CountColumn();
    private static final String NAME = "count";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(CountColumn.class, "input", LongState.class, Block.class, Integer.TYPE);
    private static final MethodHandle REMOVE_INPUT_FUNCTION = Reflection.methodHandle(CountColumn.class, "removeInput", LongState.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(CountColumn.class, "combine", LongState.class, LongState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(CountColumn.class, "output", LongState.class, BlockBuilder.class);

    public CountColumn() {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("T")), (List<LongVariableConstraint>)ImmutableList.of(), BigintType.BIGINT.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0])), false), new FunctionNullability(true, (List<Boolean>)ImmutableList.of((Object)false)), false, true, "Counts the non-null values", FunctionKind.AGGREGATE), new AggregationFunctionMetadata(false, BigintType.BIGINT.getTypeSignature()));
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature) {
        AccumulatorStateSerializer<LongState> stateSerializer = StateCompiler.generateStateSerializer(LongState.class);
        AccumulatorStateFactory<LongState> stateFactory = StateCompiler.generateStateFactory(LongState.class);
        return new AggregationMetadata((List<AggregationMetadata.AggregationParameterKind>)ImmutableList.of((Object)((Object)AggregationMetadata.AggregationParameterKind.STATE), (Object)((Object)AggregationMetadata.AggregationParameterKind.BLOCK_INPUT_CHANNEL), (Object)((Object)AggregationMetadata.AggregationParameterKind.BLOCK_INDEX)), INPUT_FUNCTION, Optional.of(REMOVE_INPUT_FUNCTION), COMBINE_FUNCTION, OUTPUT_FUNCTION, (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(new AggregationMetadata.AccumulatorStateDescriptor<LongState>(LongState.class, stateSerializer, stateFactory)));
    }

    public static void input(LongState state, Block block, int index) {
        state.setValue(state.getValue() + 1L);
    }

    public static void removeInput(LongState state, Block block, int index) {
        state.setValue(state.getValue() - 1L);
    }

    public static void combine(LongState state, LongState otherState) {
        state.setValue(state.getValue() + otherState.getValue());
    }

    public static void output(LongState state, BlockBuilder out) {
        BigintType.BIGINT.writeLong(out, state.getValue());
    }
}

