/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongState;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongStateFactory;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongStateSerializer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.UnscaledDecimal128Arithmetic;
import io.trino.spi.type.VarbinaryType;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;

public class DecimalAverageAggregation
extends SqlAggregationFunction {
    public static final DecimalAverageAggregation DECIMAL_AVERAGE_AGGREGATION = new DecimalAverageAggregation();
    private static final String NAME = "avg";
    private static final MethodHandle SHORT_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "inputShortDecimal", LongDecimalWithOverflowAndLongState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "inputLongDecimal", LongDecimalWithOverflowAndLongState.class, Block.class, Integer.TYPE);
    private static final MethodHandle SHORT_DECIMAL_OUTPUT_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "outputShortDecimal", DecimalType.class, LongDecimalWithOverflowAndLongState.class, BlockBuilder.class);
    private static final MethodHandle LONG_DECIMAL_OUTPUT_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "outputLongDecimal", DecimalType.class, LongDecimalWithOverflowAndLongState.class, BlockBuilder.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "combine", LongDecimalWithOverflowAndLongState.class, LongDecimalWithOverflowAndLongState.class);
    private static final BigInteger TWO = new BigInteger("2");
    private static final BigInteger OVERFLOW_MULTIPLIER = TWO.shiftLeft(126);

    public DecimalAverageAggregation() {
        super(new FunctionMetadata(new Signature(NAME, new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")}), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")}))), new FunctionNullability(true, (List<Boolean>)ImmutableList.of((Object)false)), false, true, "Calculates the average value", FunctionKind.AGGREGATE), new AggregationFunctionMetadata(false, VarbinaryType.VARBINARY.getTypeSignature()));
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature) {
        Type type = (Type)Iterables.getOnlyElement(boundSignature.getArgumentTypes());
        return DecimalAverageAggregation.generateAggregation(type);
    }

    private static AggregationMetadata generateAggregation(Type type) {
        MethodHandle outputFunction;
        MethodHandle inputFunction;
        Preconditions.checkArgument((boolean)(type instanceof DecimalType), (Object)"type must be Decimal");
        Class<LongDecimalWithOverflowAndLongState> stateInterface = LongDecimalWithOverflowAndLongState.class;
        LongDecimalWithOverflowAndLongStateSerializer stateSerializer = new LongDecimalWithOverflowAndLongStateSerializer();
        if (((DecimalType)type).isShort()) {
            inputFunction = SHORT_DECIMAL_INPUT_FUNCTION;
            outputFunction = SHORT_DECIMAL_OUTPUT_FUNCTION;
        } else {
            inputFunction = LONG_DECIMAL_INPUT_FUNCTION;
            outputFunction = LONG_DECIMAL_OUTPUT_FUNCTION;
        }
        outputFunction = outputFunction.bindTo(type);
        return new AggregationMetadata((List<AggregationMetadata.AggregationParameterKind>)ImmutableList.of((Object)((Object)AggregationMetadata.AggregationParameterKind.STATE), (Object)((Object)AggregationMetadata.AggregationParameterKind.BLOCK_INPUT_CHANNEL), (Object)((Object)AggregationMetadata.AggregationParameterKind.BLOCK_INDEX)), inputFunction, Optional.empty(), COMBINE_FUNCTION, outputFunction, (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(new AggregationMetadata.AccumulatorStateDescriptor<LongDecimalWithOverflowAndLongState>(stateInterface, stateSerializer, new LongDecimalWithOverflowAndLongStateFactory())));
    }

    public static void inputShortDecimal(LongDecimalWithOverflowAndLongState state, Block block, int position) {
        state.addLong(1L);
        state.setNotNull();
        long[] decimal = state.getDecimalArray();
        int offset = state.getDecimalArrayOffset();
        long rightLow = block.getLong(position, 0);
        long rightHigh = 0L;
        if (rightLow < 0L) {
            rightLow = -rightLow;
            rightHigh = Long.MIN_VALUE;
        }
        long overflow = UnscaledDecimal128Arithmetic.addWithOverflow((long)decimal[offset], (long)decimal[offset + 1], (long)rightLow, (long)rightHigh, (long[])decimal, (int)offset);
        state.addOverflow(overflow);
    }

    public static void inputLongDecimal(LongDecimalWithOverflowAndLongState state, Block block, int position) {
        state.addLong(1L);
        state.setNotNull();
        long[] decimal = state.getDecimalArray();
        int offset = state.getDecimalArrayOffset();
        long overflow = UnscaledDecimal128Arithmetic.addWithOverflow((long)decimal[offset], (long)decimal[offset + 1], (long)block.getLong(position, 0), (long)block.getLong(position, 8), (long[])decimal, (int)offset);
        state.addOverflow(overflow);
    }

    public static void combine(LongDecimalWithOverflowAndLongState state, LongDecimalWithOverflowAndLongState otherState) {
        state.addLong(otherState.getLong());
        long overflow = otherState.getOverflow();
        long[] decimal = state.getDecimalArray();
        int offset = state.getDecimalArrayOffset();
        long[] otherDecimal = otherState.getDecimalArray();
        int otherOffset = otherState.getDecimalArrayOffset();
        if (state.isNotNull()) {
            overflow += UnscaledDecimal128Arithmetic.addWithOverflow((long)decimal[offset], (long)decimal[offset + 1], (long)otherDecimal[otherOffset], (long)otherDecimal[otherOffset + 1], (long[])decimal, (int)offset);
        } else {
            state.setNotNull();
            decimal[offset] = otherDecimal[otherOffset];
            decimal[offset + 1] = otherDecimal[otherOffset + 1];
        }
        state.addOverflow(overflow);
    }

    public static void outputShortDecimal(DecimalType type, LongDecimalWithOverflowAndLongState state, BlockBuilder out) {
        if (state.getLong() == 0L) {
            out.appendNull();
        } else {
            Decimals.writeShortDecimal((BlockBuilder)out, (long)UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLong((Slice)DecimalAverageAggregation.average(state, type)));
        }
    }

    public static void outputLongDecimal(DecimalType type, LongDecimalWithOverflowAndLongState state, BlockBuilder out) {
        if (state.getLong() == 0L) {
            out.appendNull();
        } else {
            type.writeSlice(out, DecimalAverageAggregation.average(state, type));
        }
    }

    @VisibleForTesting
    public static Slice average(LongDecimalWithOverflowAndLongState state, DecimalType type) {
        long[] decimal = state.getDecimalArray();
        int offset = state.getDecimalArrayOffset();
        long overflow = state.getOverflow();
        if (overflow != 0L) {
            BigDecimal sum = new BigDecimal(UnscaledDecimal128Arithmetic.unscaledDecimalToBigInteger((long)decimal[offset], (long)decimal[offset + 1]), type.getScale());
            BigDecimal count = BigDecimal.valueOf(state.getLong());
            sum = sum.add(new BigDecimal(OVERFLOW_MULTIPLIER.multiply(BigInteger.valueOf(overflow))));
            return Decimals.encodeScaledValue((BigDecimal)sum.divide(count, type.getScale(), 4), (int)type.getScale());
        }
        return UnscaledDecimal128Arithmetic.divideRoundUp((long)decimal[offset], (long)decimal[offset + 1], (int)0, (long)state.getLong(), (long)0L);
    }
}

