/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowState;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowStateFactory;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowStateSerializer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.UnscaledDecimal128Arithmetic;
import io.trino.spi.type.VarbinaryType;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class DecimalSumAggregation
extends SqlAggregationFunction {
    public static final DecimalSumAggregation DECIMAL_SUM_AGGREGATION = new DecimalSumAggregation();
    private static final String NAME = "sum";
    private static final MethodHandle SHORT_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "inputShortDecimal", LongDecimalWithOverflowState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "inputLongDecimal", LongDecimalWithOverflowState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_OUTPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "outputLongDecimal", LongDecimalWithOverflowState.class, BlockBuilder.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "combine", LongDecimalWithOverflowState.class, LongDecimalWithOverflowState.class);

    public DecimalSumAggregation() {
        super(new FunctionMetadata(new Signature(NAME, new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.numericParameter((long)38L), TypeSignatureParameter.typeVariable((String)"s")}), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")}))), new FunctionNullability(true, (List<Boolean>)ImmutableList.of((Object)false)), false, true, "Calculates the sum over the input values", FunctionKind.AGGREGATE), new AggregationFunctionMetadata(false, VarbinaryType.VARBINARY.getTypeSignature()));
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature) {
        Type inputType = (Type)Iterables.getOnlyElement(boundSignature.getArgumentTypes());
        return DecimalSumAggregation.generateAggregation(inputType);
    }

    private static AggregationMetadata generateAggregation(Type inputType) {
        Preconditions.checkArgument((boolean)(inputType instanceof DecimalType), (Object)"type must be Decimal");
        Class<LongDecimalWithOverflowState> stateInterface = LongDecimalWithOverflowState.class;
        LongDecimalWithOverflowStateSerializer stateSerializer = new LongDecimalWithOverflowStateSerializer();
        MethodHandle inputFunction = ((DecimalType)inputType).isShort() ? SHORT_DECIMAL_INPUT_FUNCTION : LONG_DECIMAL_INPUT_FUNCTION;
        return new AggregationMetadata((List<AggregationMetadata.AggregationParameterKind>)ImmutableList.of((Object)((Object)AggregationMetadata.AggregationParameterKind.STATE), (Object)((Object)AggregationMetadata.AggregationParameterKind.BLOCK_INPUT_CHANNEL), (Object)((Object)AggregationMetadata.AggregationParameterKind.BLOCK_INDEX)), inputFunction, Optional.empty(), COMBINE_FUNCTION, LONG_DECIMAL_OUTPUT_FUNCTION, (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(new AggregationMetadata.AccumulatorStateDescriptor<LongDecimalWithOverflowState>(stateInterface, stateSerializer, new LongDecimalWithOverflowStateFactory())));
    }

    public static void inputShortDecimal(LongDecimalWithOverflowState state, Block block, int position) {
        state.setNotNull();
        long[] decimal = state.getDecimalArray();
        int offset = state.getDecimalArrayOffset();
        long rightLow = block.getLong(position, 0);
        long rightHigh = 0L;
        if (rightLow < 0L) {
            rightLow = -rightLow;
            rightHigh = Long.MIN_VALUE;
        }
        long overflow = UnscaledDecimal128Arithmetic.addWithOverflow((long)decimal[offset], (long)decimal[offset + 1], (long)rightLow, (long)rightHigh, (long[])decimal, (int)offset);
        state.addOverflow(overflow);
    }

    public static void inputLongDecimal(LongDecimalWithOverflowState state, Block block, int position) {
        state.setNotNull();
        long[] decimal = state.getDecimalArray();
        int offset = state.getDecimalArrayOffset();
        long overflow = UnscaledDecimal128Arithmetic.addWithOverflow((long)decimal[offset], (long)decimal[offset + 1], (long)block.getLong(position, 0), (long)block.getLong(position, 8), (long[])decimal, (int)offset);
        state.addOverflow(overflow);
    }

    public static void combine(LongDecimalWithOverflowState state, LongDecimalWithOverflowState otherState) {
        long overflow = otherState.getOverflow();
        long[] decimal = state.getDecimalArray();
        int offset = state.getDecimalArrayOffset();
        long[] otherDecimal = otherState.getDecimalArray();
        int otherOffset = otherState.getDecimalArrayOffset();
        if (state.isNotNull()) {
            overflow += UnscaledDecimal128Arithmetic.addWithOverflow((long)decimal[offset], (long)decimal[offset + 1], (long)otherDecimal[otherOffset], (long)otherDecimal[otherOffset + 1], (long[])decimal, (int)offset);
        } else {
            state.setNotNull();
            decimal[offset] = otherDecimal[otherOffset];
            decimal[offset + 1] = otherDecimal[otherOffset + 1];
        }
        state.addOverflow(overflow);
    }

    public static void outputLongDecimal(LongDecimalWithOverflowState state, BlockBuilder out) {
        if (state.isNotNull()) {
            if (state.getOverflow() != 0L) {
                UnscaledDecimal128Arithmetic.throwOverflowException();
            }
            long[] decimal = state.getDecimalArray();
            int offset = state.getDecimalArrayOffset();
            long rawLow = decimal[offset];
            long rawHigh = decimal[offset + 1];
            UnscaledDecimal128Arithmetic.throwIfOverflows((long)rawLow, (long)rawHigh);
            out.writeLong(rawLow);
            out.writeLong(rawHigh);
            out.closeEntry();
        } else {
            out.appendNull();
        }
    }
}

