/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.AggregationUtils;
import io.trino.operator.aggregation.DoubleCovarianceAggregation;
import io.trino.operator.aggregation.state.CovarianceState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.RealType;

@AggregationFunction
public final class RealCovarianceAggregation {
    private RealCovarianceAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState CovarianceState state, @SqlType(value="real") long dependentValue, @SqlType(value="real") long independentValue) {
        DoubleCovarianceAggregation.input(state, Float.intBitsToFloat((int)dependentValue), Float.intBitsToFloat((int)independentValue));
    }

    @CombineFunction
    public static void combine(@AggregationState CovarianceState state, @AggregationState CovarianceState otherState) {
        DoubleCovarianceAggregation.combine(state, otherState);
    }

    @AggregationFunction(value="covar_samp")
    @OutputFunction(value="real")
    public static void covarSamp(@AggregationState CovarianceState state, BlockBuilder out) {
        if (state.getCount() <= 1L) {
            out.appendNull();
        } else {
            double result = AggregationUtils.getCovarianceSample(state);
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        }
    }

    @AggregationFunction(value="covar_pop")
    @OutputFunction(value="real")
    public static void covarPop(@AggregationState CovarianceState state, BlockBuilder out) {
        if (state.getCount() == 0L) {
            out.appendNull();
        } else {
            double result = AggregationUtils.getCovariancePopulation(state);
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        }
    }
}

