/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.histogram;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.histogram.HistogramState;
import io.trino.operator.aggregation.histogram.HistogramStateFactory;
import io.trino.operator.aggregation.histogram.HistogramStateSerializer;
import io.trino.operator.aggregation.histogram.TypedHistogram;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.BlockTypeOperators;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Histogram
extends SqlAggregationFunction {
    public static final String NAME = "histogram";
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(Histogram.class, "output", Type.class, HistogramState.class, BlockBuilder.class);
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(Histogram.class, "input", Type.class, HistogramState.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(Histogram.class, "combine", HistogramState.class, HistogramState.class);
    public static final int EXPECTED_SIZE_FOR_HASHING = 10;
    private final BlockTypeOperators blockTypeOperators;

    public Histogram(BlockTypeOperators blockTypeOperators) {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter("K")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)BigintType.BIGINT.getTypeSignature()), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("K", new TypeSignatureParameter[0])), false), new FunctionNullability(true, (List<Boolean>)ImmutableList.of((Object)false)), false, true, "Count the number of times each value occurs", FunctionKind.AGGREGATE), new AggregationFunctionMetadata(false, TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)BigintType.BIGINT.getTypeSignature())));
        this.blockTypeOperators = blockTypeOperators;
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature) {
        Type keyType = boundSignature.getArgumentTypes().get(0);
        BlockTypeOperators.BlockPositionEqual keyEqual = this.blockTypeOperators.getEqualOperator(keyType);
        BlockTypeOperators.BlockPositionHashCode keyHashCode = this.blockTypeOperators.getHashCodeOperator(keyType);
        Type outputType = boundSignature.getReturnType();
        return Histogram.generateAggregation(keyType, keyEqual, keyHashCode, outputType);
    }

    private static AggregationMetadata generateAggregation(Type keyType, BlockTypeOperators.BlockPositionEqual keyEqual, BlockTypeOperators.BlockPositionHashCode keyHashCode, Type outputType) {
        HistogramStateSerializer stateSerializer = new HistogramStateSerializer(outputType);
        MethodHandle inputFunction = INPUT_FUNCTION.bindTo(keyType);
        MethodHandle outputFunction = OUTPUT_FUNCTION.bindTo(outputType);
        return new AggregationMetadata((List<AggregationMetadata.AggregationParameterKind>)ImmutableList.of((Object)((Object)AggregationMetadata.AggregationParameterKind.STATE), (Object)((Object)AggregationMetadata.AggregationParameterKind.BLOCK_INPUT_CHANNEL), (Object)((Object)AggregationMetadata.AggregationParameterKind.BLOCK_INDEX)), inputFunction, Optional.empty(), COMBINE_FUNCTION, outputFunction, (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(new AggregationMetadata.AccumulatorStateDescriptor<HistogramState>(HistogramState.class, stateSerializer, new HistogramStateFactory(keyType, keyEqual, keyHashCode, 10))));
    }

    public static void input(Type type, HistogramState state, Block key, int position) {
        TypedHistogram typedHistogram = state.get();
        long startSize = typedHistogram.getEstimatedSize();
        typedHistogram.add(position, key, 1L);
        state.addMemoryUsage(typedHistogram.getEstimatedSize() - startSize);
    }

    public static void combine(HistogramState state, HistogramState otherState) {
        Objects.requireNonNull(otherState.get(), "scratch state should always be non-null");
        TypedHistogram typedHistogram = state.get();
        long startSize = typedHistogram.getEstimatedSize();
        typedHistogram.addAll(otherState.get());
        state.addMemoryUsage(typedHistogram.getEstimatedSize() - startSize);
    }

    public static void output(Type type, HistogramState state, BlockBuilder out) {
        TypedHistogram typedHistogram = state.get();
        typedHistogram.serialize(out);
    }
}

