/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxby;

import com.google.common.collect.ImmutableList;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.state.BlockPositionState;
import io.trino.operator.aggregation.state.BlockPositionStateSerializer;
import io.trino.operator.aggregation.state.NullableBooleanState;
import io.trino.operator.aggregation.state.NullableDoubleState;
import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.operator.aggregation.state.NullableState;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.util.MinMaxCompare;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Optional;

public abstract class AbstractMinMaxBy
extends SqlAggregationFunction {
    private final boolean min;

    protected AbstractMinMaxBy(boolean min, String description) {
        super(new FunctionMetadata(new Signature((min ? "min" : "max") + "_by", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.orderableTypeParameter("K"), (Object)Signature.typeVariable("V")), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("V", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("V", new TypeSignatureParameter[0]), (Object)new TypeSignature("K", new TypeSignatureParameter[0])), false), new FunctionNullability(true, (List<Boolean>)ImmutableList.of((Object)true, (Object)false)), false, true, description, FunctionKind.AGGREGATE), new AggregationFunctionMetadata(false, new TypeSignature("K", new TypeSignatureParameter[0]), BooleanType.BOOLEAN.getTypeSignature(), new TypeSignature("V", new TypeSignatureParameter[0]), BooleanType.BOOLEAN.getTypeSignature()));
        this.min = min;
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        return MinMaxCompare.getMinMaxCompareFunctionDependencies(new TypeSignature("K", new TypeSignatureParameter[0]), this.min);
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        try {
            Type keyType = boundSignature.getArgumentType(1);
            Type valueType = boundSignature.getArgumentType(0);
            MethodHandle inputMethod = this.generateInput(keyType, valueType, functionDependencies);
            MethodHandle combineMethod = this.generateCombine(keyType, valueType, functionDependencies);
            MethodHandle outputMethod = AbstractMinMaxBy.generateOutput(keyType, valueType);
            return new AggregationMetadata((List<AggregationMetadata.AggregationParameterKind>)ImmutableList.of((Object)((Object)AggregationMetadata.AggregationParameterKind.STATE), (Object)((Object)AggregationMetadata.AggregationParameterKind.STATE), (Object)((Object)AggregationMetadata.AggregationParameterKind.NULLABLE_BLOCK_INPUT_CHANNEL), (Object)((Object)AggregationMetadata.AggregationParameterKind.BLOCK_INPUT_CHANNEL), (Object)((Object)AggregationMetadata.AggregationParameterKind.BLOCK_INDEX)), inputMethod, Optional.empty(), combineMethod, outputMethod, (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(AbstractMinMaxBy.getAccumulatorStateDescriptor(keyType), AbstractMinMaxBy.getAccumulatorStateDescriptor(valueType)));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static AggregationMetadata.AccumulatorStateDescriptor<? extends AccumulatorState> getAccumulatorStateDescriptor(Type type) {
        Class<? extends AccumulatorState> stateClass = AbstractMinMaxBy.getStateClass(type);
        if (stateClass.equals(BlockPositionState.class)) {
            return new AggregationMetadata.AccumulatorStateDescriptor<BlockPositionState>(BlockPositionState.class, new BlockPositionStateSerializer(type), StateCompiler.generateStateFactory(BlockPositionState.class));
        }
        return AbstractMinMaxBy.getAccumulatorStateDescriptor(stateClass);
    }

    private static <T extends AccumulatorState> AggregationMetadata.AccumulatorStateDescriptor<T> getAccumulatorStateDescriptor(Class<T> stateClass) {
        return new AggregationMetadata.AccumulatorStateDescriptor<T>(stateClass, StateCompiler.generateStateSerializer(stateClass), StateCompiler.generateStateFactory(stateClass));
    }

    private MethodHandle generateInput(Type keyType, Type valueType, FunctionDependencies functionDependencies) throws ReflectiveOperationException {
        MethodHandle input = MethodHandles.lookup().findStatic(AbstractMinMaxBy.class, "input", MethodType.methodType(Void.TYPE, MethodHandle.class, MethodHandle.class, MethodHandle.class, NullableState.class, NullableState.class, Block.class, Block.class, Integer.TYPE));
        Class<? extends AccumulatorState> keyState = AbstractMinMaxBy.getStateClass(keyType);
        Class<? extends AccumulatorState> valueState = AbstractMinMaxBy.getStateClass(valueType);
        MethodHandle compareStateBlockPosition = this.generateCompareStateBlockPosition(keyType, functionDependencies, keyState);
        MethodHandle setKeyState = AbstractMinMaxBy.getSetStateValue(keyType, keyState);
        MethodHandle setValueState = AbstractMinMaxBy.getSetStateValue(valueType, valueState);
        input = MethodHandles.insertArguments(input, 0, compareStateBlockPosition, setKeyState, setValueState);
        return MethodHandles.explicitCastArguments(input, MethodType.methodType(Void.TYPE, keyState, valueState, Block.class, Block.class, Integer.TYPE));
    }

    private static void input(MethodHandle compareStateBlockPosition, MethodHandle setKeyState, MethodHandle setValueState, NullableState keyState, NullableState valueState, Block value, Block key, int position) throws Throwable {
        if (keyState.isNull() || compareStateBlockPosition.invoke(key, position, keyState)) {
            setKeyState.invoke(keyState, key, position);
            setValueState.invoke(valueState, value, position);
        }
    }

    private MethodHandle generateCombine(Type keyType, Type valueType, FunctionDependencies functionDependencies) throws ReflectiveOperationException {
        MethodHandle combine = MethodHandles.lookup().findStatic(AbstractMinMaxBy.class, "combine", MethodType.methodType(Void.TYPE, MethodHandle.class, MethodHandle.class, MethodHandle.class, NullableState.class, NullableState.class, NullableState.class, NullableState.class));
        Class<? extends AccumulatorState> keyState = AbstractMinMaxBy.getStateClass(keyType);
        Class<? extends AccumulatorState> valueState = AbstractMinMaxBy.getStateClass(valueType);
        MethodHandle compareStateBlockPosition = this.generateCompareStateState(keyType, functionDependencies, keyState);
        MethodHandle setKeyState = MethodHandles.lookup().findVirtual(keyState, "set", MethodType.methodType(Void.TYPE, keyState));
        MethodHandle setValueState = MethodHandles.lookup().findVirtual(valueState, "set", MethodType.methodType(Void.TYPE, valueState));
        combine = MethodHandles.insertArguments(combine, 0, compareStateBlockPosition, setKeyState, setValueState);
        return MethodHandles.explicitCastArguments(combine, MethodType.methodType(Void.TYPE, keyState, valueState, keyState, valueState));
    }

    private static void combine(MethodHandle compareStateState, MethodHandle setKeyState, MethodHandle setValueState, NullableState keyState, NullableState valueState, NullableState otherKeyState, NullableState otherValueState) throws Throwable {
        if (otherKeyState.isNull()) {
            return;
        }
        if (keyState.isNull() || compareStateState.invoke(otherKeyState, keyState)) {
            setKeyState.invoke(keyState, otherKeyState);
            setValueState.invoke(valueState, otherValueState);
        }
    }

    private static MethodHandle generateOutput(Type keyType, Type valueType) throws ReflectiveOperationException {
        Class<? extends AccumulatorState> keyState = AbstractMinMaxBy.getStateClass(keyType);
        Class<? extends AccumulatorState> valueState = AbstractMinMaxBy.getStateClass(valueType);
        MethodHandle writeState = MethodHandles.lookup().findStatic(AbstractMinMaxBy.class, "writeState", MethodType.methodType(Void.TYPE, Type.class, valueState, BlockBuilder.class)).bindTo(valueType);
        MethodHandle output = MethodHandles.lookup().findStatic(AbstractMinMaxBy.class, "output", MethodType.methodType(Void.TYPE, MethodHandle.class, NullableState.class, NullableState.class, BlockBuilder.class));
        output = output.bindTo(writeState);
        return MethodHandles.explicitCastArguments(output, MethodType.methodType(Void.TYPE, keyState, valueState, BlockBuilder.class));
    }

    private static void output(MethodHandle valueWriter, NullableState keyState, NullableState valueState, BlockBuilder blockBuilder) throws Throwable {
        if (keyState.isNull() || valueState.isNull()) {
            blockBuilder.appendNull();
            return;
        }
        valueWriter.invoke(valueState, blockBuilder);
    }

    @UsedByGeneratedCode
    private static void writeState(Type type, NullableLongState state, BlockBuilder output) {
        type.writeLong(output, state.getValue());
    }

    @UsedByGeneratedCode
    private static void writeState(Type type, NullableDoubleState state, BlockBuilder output) {
        type.writeDouble(output, state.getValue());
    }

    @UsedByGeneratedCode
    private static void writeState(Type type, NullableBooleanState state, BlockBuilder output) {
        type.writeBoolean(output, state.getValue());
    }

    @UsedByGeneratedCode
    private static void writeState(Type type, BlockPositionState state, BlockBuilder output) {
        type.appendTo(state.getBlock(), state.getPosition(), output);
    }

    private static Class<? extends AccumulatorState> getStateClass(Type type) {
        if (type.getJavaType().equals(Long.TYPE)) {
            return NullableLongState.class;
        }
        if (type.getJavaType().equals(Double.TYPE)) {
            return NullableDoubleState.class;
        }
        if (type.getJavaType().equals(Boolean.TYPE)) {
            return NullableBooleanState.class;
        }
        return BlockPositionState.class;
    }

    private static MethodHandle getSetStateValue(Type type, Class<?> stateClass) throws ReflectiveOperationException {
        if (stateClass.equals(BlockPositionState.class)) {
            return MethodHandles.lookup().findStatic(AbstractMinMaxBy.class, "setStateValue", MethodType.methodType(Void.TYPE, BlockPositionState.class, Block.class, Integer.TYPE));
        }
        return MethodHandles.lookup().findStatic(AbstractMinMaxBy.class, "setStateValue", MethodType.methodType(Void.TYPE, Type.class, stateClass, Block.class, Integer.TYPE)).bindTo(type);
    }

    @UsedByGeneratedCode
    private static void setStateValue(BlockPositionState state, Block block, int position) {
        state.setBlock(block);
        state.setPosition(position);
    }

    @UsedByGeneratedCode
    private static void setStateValue(Type valueType, NullableLongState state, Block block, int position) {
        if (block.isNull(position)) {
            state.setNull(true);
        } else {
            state.setNull(false);
            state.setValue(valueType.getLong(block, position));
        }
    }

    @UsedByGeneratedCode
    private static void setStateValue(Type valueType, NullableDoubleState state, Block block, int position) {
        if (block.isNull(position)) {
            state.setNull(true);
        } else {
            state.setNull(false);
            state.setValue(valueType.getDouble(block, position));
        }
    }

    @UsedByGeneratedCode
    private static void setStateValue(Type valueType, NullableBooleanState state, Block block, int position) {
        if (block.isNull(position)) {
            state.setNull(true);
        } else {
            state.setNull(false);
            state.setValue(valueType.getBoolean(block, position));
        }
    }

    private MethodHandle generateCompareStateBlockPosition(Type type, FunctionDependencies functionDependencies, Class<?> state) throws ReflectiveOperationException {
        if (state.equals(BlockPositionState.class)) {
            MethodHandle comparisonMethod = MethodHandles.lookup().findStatic(AbstractMinMaxBy.class, "compareStateBlockPosition", MethodType.methodType(Long.TYPE, MethodHandle.class, Block.class, Integer.TYPE, BlockPositionState.class)).bindTo(functionDependencies.getOperatorInvoker(MinMaxCompare.getMinMaxCompareOperatorType(this.min), (List<Type>)ImmutableList.of((Object)type, (Object)type), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION})).getMethodHandle());
            return MinMaxCompare.comparisonToMinMaxResult(this.min, comparisonMethod);
        }
        MethodHandle minMaxMethod = MinMaxCompare.getMinMaxCompare(functionDependencies, type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}), this.min);
        MethodHandle stateGetValue = MethodHandles.lookup().findVirtual(state, "getValue", MethodType.methodType(type.getJavaType()));
        return MethodHandles.filterArguments(minMaxMethod, 2, stateGetValue);
    }

    private static long compareStateBlockPosition(MethodHandle blockPositionBlockPositionOperator, Block left, int leftPosition, BlockPositionState state) throws Throwable {
        return blockPositionBlockPositionOperator.invokeExact(left, leftPosition, state.getBlock(), state.getPosition());
    }

    private MethodHandle generateCompareStateState(Type type, FunctionDependencies functionDependencies, Class<?> state) throws ReflectiveOperationException {
        if (state.equals(BlockPositionState.class)) {
            MethodHandle comparisonMethod = MethodHandles.lookup().findStatic(AbstractMinMaxBy.class, "compareStateState", MethodType.methodType(Long.TYPE, MethodHandle.class, BlockPositionState.class, BlockPositionState.class)).bindTo(functionDependencies.getOperatorInvoker(MinMaxCompare.getMinMaxCompareOperatorType(this.min), (List<Type>)ImmutableList.of((Object)type, (Object)type), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION})).getMethodHandle());
            return MinMaxCompare.comparisonToMinMaxResult(this.min, comparisonMethod);
        }
        MethodHandle maxMaxMethod = MinMaxCompare.getMinMaxCompare(functionDependencies, type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}), this.min);
        MethodHandle stateGetValue = MethodHandles.lookup().findVirtual(state, "getValue", MethodType.methodType(type.getJavaType()));
        return MethodHandles.filterArguments(maxMaxMethod, 0, stateGetValue, stateGetValue);
    }

    private static long compareStateState(MethodHandle blockPositionBlockPositionOperator, BlockPositionState state, BlockPositionState otherState) throws Throwable {
        return blockPositionBlockPositionOperator.invokeExact(state.getBlock(), state.getPosition(), otherState.getBlock(), otherState.getPosition());
    }
}

