/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxby;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.TypedKeyValueHeap;
import io.trino.operator.aggregation.minmaxby.MinMaxByNState;
import io.trino.operator.aggregation.minmaxby.MinMaxByNStateFactory;
import io.trino.operator.aggregation.minmaxby.MinMaxByNStateSerializer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.util.Failures;
import io.trino.util.MinMaxCompare;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public abstract class AbstractMinMaxByNAggregationFunction
extends SqlAggregationFunction {
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxByNAggregationFunction.class, "input", MethodHandle.class, Type.class, Type.class, MinMaxByNState.class, Block.class, Block.class, Integer.TYPE, Long.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxByNAggregationFunction.class, "combine", MinMaxByNState.class, MinMaxByNState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxByNAggregationFunction.class, "output", ArrayType.class, MinMaxByNState.class, BlockBuilder.class);
    private static final long MAX_NUMBER_OF_VALUES = 10000L;
    private final boolean min;

    protected AbstractMinMaxByNAggregationFunction(String name, boolean min, String description) {
        super(new FunctionMetadata(new Signature(name, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("V"), (Object)Signature.orderableTypeParameter("K")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.arrayType((TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0])), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("V", new TypeSignatureParameter[0]), (Object)new TypeSignature("K", new TypeSignatureParameter[0]), (Object)BigintType.BIGINT.getTypeSignature()), false), new FunctionNullability(true, (List<Boolean>)ImmutableList.of((Object)true, (Object)false, (Object)false)), false, true, description, FunctionKind.AGGREGATE), new AggregationFunctionMetadata(false, BigintType.BIGINT.getTypeSignature(), TypeSignature.arrayType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0])), TypeSignature.arrayType((TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0]))));
        this.min = min;
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies(BoundSignature boundSignature) {
        return MinMaxCompare.getMinMaxCompareFunctionDependencies(boundSignature.getArgumentTypes().get(1).getTypeSignature(), this.min);
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        Type keyType = boundSignature.getArgumentTypes().get(1);
        Type valueType = boundSignature.getArgumentTypes().get(0);
        MethodHandle keyComparisonMethod = MinMaxCompare.getMinMaxCompare(functionDependencies, keyType, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}), this.min);
        return this.generateAggregation(keyComparisonMethod, valueType, keyType);
    }

    public static void input(MethodHandle keyComparisonMethod, Type valueType, Type keyType, MinMaxByNState state, Block value, Block key, int blockIndex, long n) {
        TypedKeyValueHeap heap = state.getTypedKeyValueHeap();
        if (heap == null) {
            if (n <= 0L) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "third argument of max_by/min_by must be a positive integer");
            }
            Failures.checkCondition(n <= 10000L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "third argument of max_by/min_by must be less than or equal to %s; found %s", 10000L, n);
            heap = new TypedKeyValueHeap(keyComparisonMethod, keyType, valueType, Math.toIntExact(n));
            state.setTypedKeyValueHeap(heap);
        }
        long startSize = heap.getEstimatedSize();
        if (!key.isNull(blockIndex)) {
            heap.add(key, value, blockIndex);
        }
        state.addMemoryUsage(heap.getEstimatedSize() - startSize);
    }

    public static void combine(MinMaxByNState state, MinMaxByNState otherState) {
        TypedKeyValueHeap otherHeap = otherState.getTypedKeyValueHeap();
        if (otherHeap == null) {
            return;
        }
        TypedKeyValueHeap heap = state.getTypedKeyValueHeap();
        if (heap == null) {
            state.setTypedKeyValueHeap(otherHeap);
            return;
        }
        long startSize = heap.getEstimatedSize();
        heap.addAll(otherHeap);
        state.addMemoryUsage(heap.getEstimatedSize() - startSize);
    }

    public static void output(ArrayType outputType, MinMaxByNState state, BlockBuilder out) {
        TypedKeyValueHeap heap = state.getTypedKeyValueHeap();
        if (heap == null || heap.isEmpty()) {
            out.appendNull();
            return;
        }
        Type elementType = outputType.getElementType();
        BlockBuilder arrayBlockBuilder = out.beginBlockEntry();
        BlockBuilder reversedBlockBuilder = elementType.createBlockBuilder(null, heap.getCapacity());
        long startSize = heap.getEstimatedSize();
        heap.popAll(reversedBlockBuilder);
        state.addMemoryUsage(heap.getEstimatedSize() - startSize);
        for (int i = reversedBlockBuilder.getPositionCount() - 1; i >= 0; --i) {
            elementType.appendTo((Block)reversedBlockBuilder, i, arrayBlockBuilder);
        }
        out.closeEntry();
    }

    protected AggregationMetadata generateAggregation(MethodHandle keyComparisonMethod, Type valueType, Type keyType) {
        MinMaxByNStateSerializer stateSerializer = new MinMaxByNStateSerializer(keyComparisonMethod, keyType, valueType);
        ArrayType outputType = new ArrayType(valueType);
        return new AggregationMetadata((List<AggregationMetadata.AggregationParameterKind>)ImmutableList.of((Object)((Object)AggregationMetadata.AggregationParameterKind.STATE), (Object)((Object)AggregationMetadata.AggregationParameterKind.NULLABLE_BLOCK_INPUT_CHANNEL), (Object)((Object)AggregationMetadata.AggregationParameterKind.BLOCK_INPUT_CHANNEL), (Object)((Object)AggregationMetadata.AggregationParameterKind.BLOCK_INDEX), (Object)((Object)AggregationMetadata.AggregationParameterKind.INPUT_CHANNEL)), INPUT_FUNCTION.bindTo(keyComparisonMethod).bindTo(valueType).bindTo(keyType), Optional.empty(), COMBINE_FUNCTION, OUTPUT_FUNCTION.bindTo(outputType), (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(new AggregationMetadata.AccumulatorStateDescriptor<MinMaxByNState>(MinMaxByNState.class, stateSerializer, new MinMaxByNStateFactory())));
    }
}

