/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.block.Block;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameterSpecialization;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.longs.LongArrays;

@ScalarFunction(value="arrays_overlap")
@Description(value="Returns true if arrays have common elements")
public final class ArraysOverlapFunction {
    private int[] leftPositions = new int[0];
    private int[] rightPositions = new int[0];
    private long[] leftLongArray = new long[0];
    private long[] rightLongArray = new long[0];

    @TypeParameter(value="E")
    public ArraysOverlapFunction(@TypeParameter(value="E") Type elementType) {
    }

    @SqlNullable
    @TypeParameter(value="E")
    @TypeParameterSpecialization(name="E", nativeContainerType=long.class)
    @SqlType(value="boolean")
    public Boolean arraysOverlapInt(@OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_LAST, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) LongComparison comparisonOperator, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int leftSize = leftArray.getPositionCount();
        int rightSize = rightArray.getPositionCount();
        if (leftSize == 0 || rightSize == 0) {
            return false;
        }
        if (this.leftLongArray.length < leftSize) {
            this.leftLongArray = new long[leftSize * 2];
        }
        if (this.rightLongArray.length < rightSize) {
            this.rightLongArray = new long[rightSize * 2];
        }
        int leftNonNullSize = ArraysOverlapFunction.sortLongArray(leftArray, this.leftLongArray, type, comparisonOperator);
        int rightNonNullSize = ArraysOverlapFunction.sortLongArray(rightArray, this.rightLongArray, type, comparisonOperator);
        int leftPosition = 0;
        int rightPosition = 0;
        while (leftPosition < leftNonNullSize && rightPosition < rightNonNullSize) {
            long compareValue = comparisonOperator.compare(this.leftLongArray[leftPosition], this.rightLongArray[rightPosition]);
            if (compareValue > 0L) {
                ++rightPosition;
                continue;
            }
            if (compareValue < 0L) {
                ++leftPosition;
                continue;
            }
            return true;
        }
        return leftNonNullSize < leftSize || rightNonNullSize < rightSize ? null : Boolean.valueOf(false);
    }

    private static int sortLongArray(Block array, long[] buffer, Type type, LongComparison comparisonOperator) {
        int arraySize = array.getPositionCount();
        int nonNullSize = 0;
        for (int i = 0; i < arraySize; ++i) {
            if (array.isNull(i)) continue;
            buffer[nonNullSize++] = type.getLong(array, i);
        }
        LongArrays.unstableSort((long[])buffer, (int)0, (int)nonNullSize, (left, right) -> (int)comparisonOperator.compare(left, right));
        return nonNullSize;
    }

    @SqlNullable
    @TypeParameter(value="E")
    @SqlType(value="boolean")
    public Boolean arraysOverlap(@OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_LAST, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionComparison comparisonOperator, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int i;
        int leftPositionCount = leftArray.getPositionCount();
        int rightPositionCount = rightArray.getPositionCount();
        if (leftPositionCount == 0 || rightPositionCount == 0) {
            return false;
        }
        if (this.leftPositions.length < leftPositionCount) {
            this.leftPositions = new int[leftPositionCount * 2];
        }
        if (this.rightPositions.length < rightPositionCount) {
            this.rightPositions = new int[rightPositionCount * 2];
        }
        for (i = 0; i < leftPositionCount; ++i) {
            this.leftPositions[i] = i;
        }
        for (i = 0; i < rightPositionCount; ++i) {
            this.rightPositions[i] = i;
        }
        IntArrays.quickSort((int[])this.leftPositions, (int)0, (int)leftPositionCount, (IntComparator)ArraysOverlapFunction.intBlockCompare(comparisonOperator, leftArray));
        IntArrays.quickSort((int[])this.rightPositions, (int)0, (int)rightPositionCount, (IntComparator)ArraysOverlapFunction.intBlockCompare(comparisonOperator, rightArray));
        int leftPosition = 0;
        int rightPosition = 0;
        while (leftPosition < leftPositionCount && rightPosition < rightPositionCount) {
            if (leftArray.isNull(this.leftPositions[leftPosition]) || rightArray.isNull(this.rightPositions[rightPosition])) {
                return null;
            }
            long compareValue = comparisonOperator.compare(leftArray, this.leftPositions[leftPosition], rightArray, this.rightPositions[rightPosition]);
            if (compareValue > 0L) {
                ++rightPosition;
                continue;
            }
            if (compareValue < 0L) {
                ++leftPosition;
                continue;
            }
            return true;
        }
        return leftArray.isNull(this.leftPositions[leftPositionCount - 1]) || rightArray.isNull(this.rightPositions[rightPositionCount - 1]) ? null : Boolean.valueOf(false);
    }

    private static IntComparator intBlockCompare(BlockTypeOperators.BlockPositionComparison comparisonOperator, Block block) {
        return (left, right) -> {
            if (block.isNull(left) && block.isNull(right)) {
                return 0;
            }
            if (block.isNull(left)) {
                return 1;
            }
            if (block.isNull(right)) {
                return -1;
            }
            return (int)comparisonOperator.compare(block, left, block, right);
        };
    }

    public static interface LongComparison {
        public long compare(long var1, long var3);
    }
}

