/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.annotations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.primitives.Primitives;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.operator.ParametricFunctionHelpers;
import io.trino.operator.ParametricImplementation;
import io.trino.operator.annotations.FunctionsParserHelper;
import io.trino.operator.annotations.ImplementationDependency;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.IsNull;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.type.FunctionType;
import io.trino.util.Failures;
import io.trino.util.Reflection;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class ParametricScalarImplementation
implements ParametricImplementation {
    private final Signature signature;
    private final List<Optional<Class<?>>> argumentNativeContainerTypes;
    private final Map<String, Class<?>> specializedTypeParameters;
    private final Class<?> returnNativeContainerType;
    private final List<ParametricScalarImplementationChoice> choices;
    private final FunctionNullability functionNullability;

    private ParametricScalarImplementation(Signature signature, List<Optional<Class<?>>> argumentNativeContainerTypes, Map<String, Class<?>> specializedTypeParameters, List<ParametricScalarImplementationChoice> choices, Class<?> returnContainerType) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.argumentNativeContainerTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentNativeContainerTypes, "argumentNativeContainerTypes is null"));
        this.specializedTypeParameters = ImmutableMap.copyOf(Objects.requireNonNull(specializedTypeParameters, "specializedTypeParameters is null"));
        this.choices = Objects.requireNonNull(choices, "choices is null");
        Preconditions.checkArgument((!choices.isEmpty() ? 1 : 0) != 0, (Object)"choices is empty");
        this.returnNativeContainerType = Objects.requireNonNull(returnContainerType, "returnContainerType is null");
        for (Class<?> specializedJavaType : specializedTypeParameters.values()) {
            Preconditions.checkArgument((!Primitives.isWrapperType(specializedJavaType) ? 1 : 0) != 0, (Object)"specializedTypeParameter must not contain boxed primitive types");
        }
        ParametricScalarImplementationChoice defaultChoice = choices.get(0);
        boolean expression = defaultChoice.getArgumentConventions().stream().noneMatch(arg_0 -> InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION.equals(arg_0));
        Preconditions.checkArgument((boolean)expression, (String)"default choice can not use the BLOCK_AND_POSITION calling convention: %s", (Object)signature);
        boolean returnNullability = defaultChoice.getReturnConvention().isNullable();
        Preconditions.checkArgument((boolean)choices.stream().allMatch(choice -> choice.getReturnConvention().isNullable() == returnNullability), (String)"all choices must have the same nullable flag: %s", (Object)signature);
        List argumentNullability = (List)defaultChoice.getArgumentConventions().stream().map(InvocationConvention.InvocationArgumentConvention::isNullable).collect(ImmutableList.toImmutableList());
        this.functionNullability = new FunctionNullability(returnNullability, argumentNullability);
        Preconditions.checkArgument((boolean)choices.stream().allMatch(choice -> ParametricScalarImplementation.matches(argumentNullability, choice.getArgumentConventions())), (String)"all choices must have the same nullable parameter flags: %s", (Object)signature);
    }

    @Override
    public FunctionNullability getFunctionNullability() {
        return this.functionNullability;
    }

    public Optional<ScalarFunctionImplementation> specialize(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        ArrayList<ChoicesScalarFunctionImplementation.ScalarImplementationChoice> implementationChoices = new ArrayList<ChoicesScalarFunctionImplementation.ScalarImplementationChoice>();
        for (Map.Entry<String, Class<?>> entry : this.specializedTypeParameters.entrySet()) {
            if (entry.getValue().isAssignableFrom(functionBinding.getTypeVariable(entry.getKey()).getJavaType())) continue;
            return Optional.empty();
        }
        BoundSignature boundSignature = functionBinding.getBoundSignature();
        if (this.returnNativeContainerType != Object.class && this.returnNativeContainerType != boundSignature.getReturnType().getJavaType()) {
            return Optional.empty();
        }
        for (int i = 0; i < boundSignature.getArgumentTypes().size(); ++i) {
            if (boundSignature.getArgumentTypes().get(i) instanceof FunctionType) {
                if (!this.argumentNativeContainerTypes.get(i).isPresent()) continue;
                return Optional.empty();
            }
            if (this.argumentNativeContainerTypes.get(i).isEmpty()) {
                return Optional.empty();
            }
            Class argumentType = boundSignature.getArgumentTypes().get(i).getJavaType();
            Class<?> argumentNativeContainerType = this.argumentNativeContainerTypes.get(i).get();
            if (argumentNativeContainerType == Object.class || argumentNativeContainerType == argumentType) continue;
            return Optional.empty();
        }
        for (ParametricScalarImplementationChoice choice : this.choices) {
            MethodHandle boundMethodHandle = ParametricFunctionHelpers.bindDependencies(choice.getMethodHandle(), choice.getDependencies(), functionBinding, functionDependencies);
            Optional<MethodHandle> boundConstructor = choice.getConstructor().map(constructor -> {
                MethodHandle result = ParametricFunctionHelpers.bindDependencies(constructor, choice.getConstructorDependencies(), functionBinding, functionDependencies);
                Failures.checkCondition(result.type().parameterList().isEmpty(), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "All parameters of a constructor in a function definition class must be Dependencies. Signature: %s", boundSignature);
                return result;
            });
            implementationChoices.add(new ChoicesScalarFunctionImplementation.ScalarImplementationChoice(choice.getReturnConvention(), choice.getArgumentConventions(), choice.getLambdaInterfaces(), boundMethodHandle.asType(ParametricScalarImplementation.javaMethodType(choice, boundSignature)), boundConstructor));
        }
        return Optional.of(new ChoicesScalarFunctionImplementation(boundSignature, implementationChoices));
    }

    @Override
    public boolean hasSpecializedTypeParameters() {
        return !this.specializedTypeParameters.isEmpty();
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @VisibleForTesting
    public List<ParametricScalarImplementationChoice> getChoices() {
        return this.choices;
    }

    @Override
    public ParametricScalarImplementation withAlias(String alias) {
        return new ParametricScalarImplementation(ParametricFunctionHelpers.signatureWithName(alias, this.signature), this.argumentNativeContainerTypes, this.specializedTypeParameters, this.choices, this.returnNativeContainerType);
    }

    private static MethodType javaMethodType(ParametricScalarImplementationChoice choice, BoundSignature signature) {
        ImmutableList.Builder methodHandleParameterTypes = ImmutableList.builder();
        if (choice.getConstructor().isPresent()) {
            methodHandleParameterTypes.add(Object.class);
        }
        if (choice.hasConnectorSession()) {
            methodHandleParameterTypes.add(ConnectorSession.class);
        }
        List<InvocationConvention.InvocationArgumentConvention> argumentConventions = choice.getArgumentConventions();
        int lambdaArgumentIndex = 0;
        block7: for (int i = 0; i < argumentConventions.size(); ++i) {
            InvocationConvention.InvocationArgumentConvention argumentConvention = argumentConventions.get(i);
            Type signatureType = signature.getArgumentTypes().get(i);
            switch (argumentConvention) {
                case NEVER_NULL: {
                    methodHandleParameterTypes.add((Object)signatureType.getJavaType());
                    continue block7;
                }
                case NULL_FLAG: {
                    methodHandleParameterTypes.add((Object)signatureType.getJavaType());
                    methodHandleParameterTypes.add(Boolean.TYPE);
                    continue block7;
                }
                case BOXED_NULLABLE: {
                    methodHandleParameterTypes.add((Object)Primitives.wrap((Class)signatureType.getJavaType()));
                    continue block7;
                }
                case BLOCK_POSITION: {
                    methodHandleParameterTypes.add(Block.class);
                    methodHandleParameterTypes.add(Integer.TYPE);
                    continue block7;
                }
                case FUNCTION: {
                    methodHandleParameterTypes.add(choice.getLambdaInterfaces().get(lambdaArgumentIndex));
                    ++lambdaArgumentIndex;
                    continue block7;
                }
                default: {
                    throw new UnsupportedOperationException("unknown argument convention: " + argumentConvention);
                }
            }
        }
        Class methodHandleReturnType = signature.getReturnType().getJavaType();
        if (choice.getReturnConvention().isNullable()) {
            methodHandleReturnType = Primitives.wrap((Class)methodHandleReturnType);
        }
        return MethodType.methodType(methodHandleReturnType, methodHandleParameterTypes.build());
    }

    private static boolean matches(List<Boolean> argumentNullability, List<InvocationConvention.InvocationArgumentConvention> argumentConventions) {
        if (argumentNullability.size() != argumentConventions.size()) {
            return false;
        }
        for (int i = 0; i < argumentNullability.size(); ++i) {
            boolean expectedNullable = argumentNullability.get(i);
            InvocationConvention.InvocationArgumentConvention argumentConvention = argumentConventions.get(i);
            if (!(argumentConvention == InvocationConvention.InvocationArgumentConvention.FUNCTION ? expectedNullable : argumentConvention != InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION && expectedNullable != argumentConvention.isNullable())) continue;
            return false;
        }
        return true;
    }

    public static final class Parser {
        private final String functionName;
        private final List<InvocationConvention.InvocationArgumentConvention> argumentConventions = new ArrayList<InvocationConvention.InvocationArgumentConvention>();
        private final List<Class<?>> lambdaInterfaces = new ArrayList();
        private final TypeSignature returnType;
        private final List<TypeSignature> argumentTypes = new ArrayList<TypeSignature>();
        private final List<Optional<Class<?>>> argumentNativeContainerTypes = new ArrayList();
        private final MethodHandle methodHandle;
        private final List<ImplementationDependency> dependencies = new ArrayList<ImplementationDependency>();
        private final Set<TypeParameter> typeParameters = new LinkedHashSet<TypeParameter>();
        private final Set<String> literalParameters;
        private final Set<String> typeParameterNames;
        private final Map<String, Class<?>> specializedTypeParameters;
        private final List<ImplementationDependency> constructorDependencies = new ArrayList<ImplementationDependency>();
        private final List<LongVariableConstraint> longVariableConstraints;
        private final Class<?> returnNativeContainerType;
        private boolean hasConnectorSession;
        private final ParametricScalarImplementationChoice choice;

        Parser(String functionName, Method method, Optional<Constructor<?>> constructor) {
            this.functionName = Objects.requireNonNull(functionName, "functionName is null");
            boolean nullable = method.getAnnotation(SqlNullable.class) != null;
            Preconditions.checkArgument((nullable || !FunctionsParserHelper.containsLegacyNullable(method.getAnnotations()) ? 1 : 0) != 0, (String)"Method [%s] is annotated with @Nullable but not @SqlNullable", (Object)method);
            this.typeParameters.addAll(Arrays.asList((TypeParameter[])method.getAnnotationsByType(TypeParameter.class)));
            this.literalParameters = FunctionsParserHelper.parseLiteralParameters(method);
            this.typeParameterNames = (Set)this.typeParameters.stream().map(TypeParameter::value).collect(ImmutableSortedSet.toImmutableSortedSet((Comparator)String.CASE_INSENSITIVE_ORDER));
            SqlType returnType = method.getAnnotation(SqlType.class);
            Preconditions.checkArgument((returnType != null ? 1 : 0) != 0, (String)"Method [%s] is missing @SqlType annotation", (Object)method);
            this.returnType = TypeSignatureTranslator.parseTypeSignature(returnType.value(), this.literalParameters);
            Class<?> actualReturnType = method.getReturnType();
            this.returnNativeContainerType = Primitives.unwrap(actualReturnType);
            if (Primitives.isWrapperType(actualReturnType)) {
                Preconditions.checkArgument((boolean)nullable, (String)"Method [%s] has wrapper return type %s but is missing @SqlNullable", (Object)method, (Object)actualReturnType.getSimpleName());
            } else if (actualReturnType.isPrimitive()) {
                Preconditions.checkArgument((!nullable ? 1 : 0) != 0, (String)"Method [%s] annotated with @SqlNullable has primitive return type %s", (Object)method, (Object)actualReturnType.getSimpleName());
            }
            this.longVariableConstraints = FunctionsParserHelper.parseLongVariableConstraints(method);
            this.specializedTypeParameters = FunctionsParserHelper.getDeclaredSpecializedTypeParameters(method, this.typeParameters);
            for (TypeParameter typeParameter : this.typeParameters) {
                Preconditions.checkArgument((boolean)typeParameter.value().matches("[A-Z][A-Z0-9]*"), (String)"Expected type parameter to only contain A-Z and 0-9 (starting with A-Z), but got %s on method [%s]", (Object)typeParameter.value(), (Object)method);
            }
            this.inferSpecialization(method, actualReturnType, returnType.value());
            this.parseArguments(method);
            Optional<MethodHandle> constructorMethodHandle = this.getConstructor(method, constructor);
            this.methodHandle = this.getMethodHandle(method);
            this.choice = new ParametricScalarImplementationChoice(nullable ? InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN : InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, this.hasConnectorSession, this.argumentConventions, this.lambdaInterfaces, this.methodHandle, constructorMethodHandle, this.dependencies, this.constructorDependencies);
        }

        private void parseArguments(Method method) {
            boolean encounteredNonDependencyAnnotation = false;
            int parameterIndex = 0;
            while (parameterIndex < method.getParameterCount()) {
                InvocationConvention.InvocationArgumentConvention argumentConvention;
                Parameter parameter = method.getParameters()[parameterIndex];
                Class<?> parameterType = parameter.getType();
                if (parameterType == ConnectorSession.class) {
                    Failures.checkCondition(!this.hasConnectorSession, (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Method [%s] has more than 1 ConnectorSession in the parameter list", method);
                    this.hasConnectorSession = true;
                    ++parameterIndex;
                    continue;
                }
                Optional<Annotation> implementationDependency = ImplementationDependency.getImplementationDependencyAnnotation(parameter);
                if (implementationDependency.isPresent()) {
                    Failures.checkCondition(!encounteredNonDependencyAnnotation, (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Method [%s] has parameters annotated with Dependency annotations that appears after other parameters", method);
                    ImplementationDependency.validateImplementationDependencyAnnotation(method, implementationDependency.get(), this.typeParameterNames, this.literalParameters);
                    this.dependencies.add(ImplementationDependency.Factory.createDependency(implementationDependency.get(), this.literalParameters, parameterType));
                    ++parameterIndex;
                    continue;
                }
                encounteredNonDependencyAnnotation = true;
                Annotation[] annotations = parameter.getAnnotations();
                Preconditions.checkArgument((boolean)Stream.of(annotations).noneMatch(IsNull.class::isInstance), (String)"Method [%s] has @IsNull parameter that does not follow a @SqlType parameter", (Object)method);
                SqlType type = Stream.of(annotations).filter(SqlType.class::isInstance).map(SqlType.class::cast).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Method [%s] is missing @SqlType annotation for parameter", method)));
                TypeSignature typeSignature = TypeSignatureTranslator.parseTypeSignature(type.value(), this.literalParameters);
                this.argumentTypes.add(typeSignature);
                if (typeSignature.getBase().equals("function")) {
                    Failures.checkCondition(parameterType.isAnnotationPresent(FunctionalInterface.class), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "argument %s is marked as lambda but the function interface class is not annotated: %s", parameterIndex, this.methodHandle);
                    this.argumentConventions.add(InvocationConvention.InvocationArgumentConvention.FUNCTION);
                    this.lambdaInterfaces.add(parameterType);
                    this.argumentNativeContainerTypes.add(Optional.empty());
                    ++parameterIndex;
                    continue;
                }
                if (Stream.of(annotations).anyMatch(SqlNullable.class::isInstance)) {
                    Failures.checkCondition(!parameterType.isPrimitive(), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Method [%s] has parameter with primitive type %s annotated with @SqlNullable", method, parameterType.getSimpleName());
                    argumentConvention = InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE;
                } else if (Stream.of(annotations).anyMatch(BlockPosition.class::isInstance)) {
                    Preconditions.checkState((method.getParameterCount() > parameterIndex + 1 ? 1 : 0) != 0);
                    Preconditions.checkState((parameterType == Block.class ? 1 : 0) != 0);
                    argumentConvention = InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION;
                    Annotation[] parameterAnnotations = method.getParameterAnnotations()[parameterIndex + 1];
                    Preconditions.checkState((boolean)Stream.of(parameterAnnotations).anyMatch(BlockIndex.class::isInstance));
                } else {
                    Failures.checkCondition(parameterType == Void.class || !Primitives.isWrapperType(parameterType), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "A parameter with USE_NULL_FLAG or RETURN_NULL_ON_NULL convention must not use wrapper type. Found in method [%s]", method);
                    boolean useNullFlag = false;
                    if (method.getParameterCount() > parameterIndex + 1) {
                        Annotation[] parameterAnnotations = method.getParameterAnnotations()[parameterIndex + 1];
                        if (Stream.of(parameterAnnotations).anyMatch(IsNull.class::isInstance)) {
                            Class<?> isNullType = method.getParameterTypes()[parameterIndex + 1];
                            Preconditions.checkArgument((boolean)Stream.of(parameterAnnotations).filter(FunctionsParserHelper::isTrinoAnnotation).allMatch(IsNull.class::isInstance), (String)"Method [%s] has @IsNull parameter that has other annotations", (Object)method);
                            Preconditions.checkArgument((isNullType == Boolean.TYPE ? 1 : 0) != 0, (String)"Method [%s] has non-boolean parameter with @IsNull", (Object)method);
                            Preconditions.checkArgument((parameterType == Void.class || !Primitives.isWrapperType(parameterType) ? 1 : 0) != 0, (String)"Method [%s] uses @IsNull following a parameter with boxed primitive type: %s", (Object)method, (Object)parameterType.getSimpleName());
                            useNullFlag = true;
                        }
                    }
                    argumentConvention = useNullFlag ? InvocationConvention.InvocationArgumentConvention.NULL_FLAG : InvocationConvention.InvocationArgumentConvention.NEVER_NULL;
                }
                if (argumentConvention == InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) {
                    this.argumentNativeContainerTypes.add(Optional.of(type.nativeContainerType()));
                } else {
                    this.inferSpecialization(method, parameterType, type.value());
                    Failures.checkCondition(type.nativeContainerType().equals(Object.class), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "@SqlType can only contain an explicitly specified nativeContainerType when using @BlockPosition", new Object[0]);
                    this.argumentNativeContainerTypes.add(Optional.of(Primitives.unwrap(parameterType)));
                }
                this.argumentConventions.add(argumentConvention);
                ++parameterIndex;
                if (argumentConvention != InvocationConvention.InvocationArgumentConvention.NULL_FLAG && argumentConvention != InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) continue;
                ++parameterIndex;
            }
        }

        private void inferSpecialization(Method method, Class<?> parameterType, String typeParameterName) {
            if (this.typeParameterNames.contains(typeParameterName) && parameterType != Object.class) {
                Class<?> specialization = this.specializedTypeParameters.get(typeParameterName);
                Class nativeParameterType = Primitives.unwrap(parameterType);
                Preconditions.checkArgument((specialization == null || specialization.equals(nativeParameterType) ? 1 : 0) != 0, (String)"Method [%s] type %s has conflicting specializations %s and %s", (Object)method, (Object)typeParameterName, specialization, (Object)nativeParameterType);
                this.specializedTypeParameters.put(typeParameterName, nativeParameterType);
            }
        }

        private Optional<MethodHandle> getConstructor(Method method, Optional<Constructor<?>> optionalConstructor) {
            if (Modifier.isStatic(method.getModifiers())) {
                return Optional.empty();
            }
            Preconditions.checkArgument((boolean)optionalConstructor.isPresent(), (String)"Method [%s] is an instance method. It must be in a class annotated with @ScalarFunction or @ScalarOperator, and the class is required to have a public constructor.", (Object)method);
            Constructor<?> constructor = optionalConstructor.get();
            Set constructorTypeParameters = (Set)Stream.of((TypeParameter[])constructor.getAnnotationsByType(TypeParameter.class)).collect(ImmutableSet.toImmutableSet());
            Preconditions.checkArgument((boolean)constructorTypeParameters.containsAll(this.typeParameters), (String)"Method [%s] is an instance method and requires a public constructor containing all type parameters: %s", (Object)method, this.typeParameters);
            for (int i = 0; i < constructor.getParameterCount(); ++i) {
                Annotation[] annotations = constructor.getParameterAnnotations()[i];
                Preconditions.checkArgument((boolean)FunctionsParserHelper.containsImplementationDependencyAnnotation(annotations), (String)"Constructors may only have meta parameters [%s]", constructor);
                Preconditions.checkArgument((annotations.length == 1 ? 1 : 0) != 0, (String)"Meta parameters may only have a single annotation [%s]", constructor);
                Annotation annotation = annotations[0];
                if (annotation instanceof TypeParameter) {
                    ImplementationDependency.checkTypeParameters(TypeSignatureTranslator.parseTypeSignature(((TypeParameter)annotation).value(), (Set<String>)ImmutableSet.of()), this.typeParameterNames, method);
                }
                this.constructorDependencies.add(ImplementationDependency.Factory.createDependency(annotation, this.literalParameters, constructor.getParameterTypes()[i]));
            }
            MethodHandle result = Reflection.constructorMethodHandle(StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, constructor);
            return Optional.of(result.asType(result.type().changeReturnType(Object.class)));
        }

        private MethodHandle getMethodHandle(Method method) {
            MethodHandle methodHandle = Reflection.methodHandle(StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, method);
            if (!Modifier.isStatic(method.getModifiers())) {
                int i;
                methodHandle = methodHandle.asType(methodHandle.type().changeParameterType(0, Object.class));
                int[] permutedIndices = new int[methodHandle.type().parameterCount()];
                permutedIndices[0] = this.dependencies.size();
                MethodType newType = methodHandle.type().changeParameterType(this.dependencies.size(), (Class<?>)methodHandle.type().parameterType(0));
                for (i = 0; i < this.dependencies.size(); ++i) {
                    permutedIndices[i + 1] = i;
                    newType = newType.changeParameterType(i, (Class<?>)methodHandle.type().parameterType(i + 1));
                }
                for (i = this.dependencies.size() + 1; i < permutedIndices.length; ++i) {
                    permutedIndices[i] = i;
                }
                methodHandle = MethodHandles.permuteArguments(methodHandle, newType, permutedIndices);
            }
            return methodHandle;
        }

        public List<Optional<Class<?>>> getArgumentNativeContainerTypes() {
            return this.argumentNativeContainerTypes;
        }

        public Map<String, Class<?>> getSpecializedTypeParameters() {
            return this.specializedTypeParameters;
        }

        public Class<?> getReturnNativeContainerType() {
            return this.returnNativeContainerType;
        }

        public ParametricScalarImplementationChoice getChoice() {
            return this.choice;
        }

        public SpecializedSignature getSpecializedSignature() {
            return new SpecializedSignature(this.getSignature(), this.argumentNativeContainerTypes, this.specializedTypeParameters, this.returnNativeContainerType);
        }

        public Signature getSignature() {
            return new Signature(this.functionName, FunctionsParserHelper.createTypeVariableConstraints(this.typeParameters, this.dependencies), this.longVariableConstraints, this.returnType, this.argumentTypes, false);
        }
    }

    public static final class SpecializedSignature {
        private final Signature signature;
        private final List<Optional<Class<?>>> argumentNativeContainerTypes;
        private final Map<String, Class<?>> specializedTypeParameters;
        private final Class<?> returnNativeContainerType;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpecializedSignature that = (SpecializedSignature)o;
            return Objects.equals(this.signature, that.signature) && Objects.equals(this.argumentNativeContainerTypes, that.argumentNativeContainerTypes) && Objects.equals(this.specializedTypeParameters, that.specializedTypeParameters) && Objects.equals(this.returnNativeContainerType, that.returnNativeContainerType);
        }

        public int hashCode() {
            return Objects.hash(this.signature, this.argumentNativeContainerTypes, this.specializedTypeParameters, this.returnNativeContainerType);
        }

        private SpecializedSignature(Signature signature, List<Optional<Class<?>>> argumentNativeContainerTypes, Map<String, Class<?>> specializedTypeParameters, Class<?> returnNativeContainerType) {
            this.signature = signature;
            this.argumentNativeContainerTypes = argumentNativeContainerTypes;
            this.specializedTypeParameters = specializedTypeParameters;
            this.returnNativeContainerType = returnNativeContainerType;
        }
    }

    public static final class ParametricScalarImplementationChoice
    implements Comparable<ParametricScalarImplementationChoice> {
        private final InvocationConvention.InvocationReturnConvention returnConvention;
        private final List<InvocationConvention.InvocationArgumentConvention> argumentConventions;
        private final List<Class<?>> lambdaInterfaces;
        private final MethodHandle methodHandle;
        private final Optional<MethodHandle> constructor;
        private final List<ImplementationDependency> dependencies;
        private final List<ImplementationDependency> constructorDependencies;
        private final int numberOfBlockPositionArguments;
        private final boolean hasConnectorSession;

        private ParametricScalarImplementationChoice(InvocationConvention.InvocationReturnConvention returnConvention, boolean hasConnectorSession, List<InvocationConvention.InvocationArgumentConvention> argumentConventions, List<Class<?>> lambdaInterfaces, MethodHandle methodHandle, Optional<MethodHandle> constructor, List<ImplementationDependency> dependencies, List<ImplementationDependency> constructorDependencies) {
            this.returnConvention = Objects.requireNonNull(returnConvention, "returnConvention is null");
            this.hasConnectorSession = hasConnectorSession;
            this.argumentConventions = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentConventions, "argumentConventions is null"));
            this.lambdaInterfaces = ImmutableList.copyOf((Collection)Objects.requireNonNull(lambdaInterfaces, "lambdaInterfaces is null"));
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            this.constructor = Objects.requireNonNull(constructor, "constructor is null");
            this.dependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(dependencies, "dependencies is null"));
            this.constructorDependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(constructorDependencies, "constructorDependencies is null"));
            this.numberOfBlockPositionArguments = (int)argumentConventions.stream().filter(arg_0 -> InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION.equals(arg_0)).count();
        }

        public InvocationConvention.InvocationReturnConvention getReturnConvention() {
            return this.returnConvention;
        }

        public boolean hasConnectorSession() {
            return this.hasConnectorSession;
        }

        public MethodHandle getMethodHandle() {
            return this.methodHandle;
        }

        @VisibleForTesting
        public List<ImplementationDependency> getDependencies() {
            return this.dependencies;
        }

        public List<InvocationConvention.InvocationArgumentConvention> getArgumentConventions() {
            return this.argumentConventions;
        }

        public List<Class<?>> getLambdaInterfaces() {
            return this.lambdaInterfaces;
        }

        public boolean checkDependencies() {
            for (int i = 1; i < this.getDependencies().size(); ++i) {
                if (this.getDependencies().get(i).equals(this.getDependencies().get(0))) continue;
                return false;
            }
            return true;
        }

        @VisibleForTesting
        public List<ImplementationDependency> getConstructorDependencies() {
            return this.constructorDependencies;
        }

        public Optional<MethodHandle> getConstructor() {
            return this.constructor;
        }

        @Override
        public int compareTo(ParametricScalarImplementationChoice choice) {
            if (choice.numberOfBlockPositionArguments < this.numberOfBlockPositionArguments) {
                return 1;
            }
            return -1;
        }
    }

    public static final class Builder {
        private final Signature signature;
        private final List<Optional<Class<?>>> argumentNativeContainerTypes;
        private final Map<String, Class<?>> specializedTypeParameters;
        private final Class<?> returnNativeContainerType;
        private final List<ParametricScalarImplementationChoice> choices;

        public Builder(Signature signature, List<Optional<Class<?>>> argumentNativeContainerTypes, Map<String, Class<?>> specializedTypeParameters, Class<?> returnNativeContainerType) {
            this.signature = Objects.requireNonNull(signature, "signature is null");
            this.argumentNativeContainerTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentNativeContainerTypes, "argumentNativeContainerTypes is null"));
            this.specializedTypeParameters = ImmutableMap.copyOf(Objects.requireNonNull(specializedTypeParameters, "specializedTypeParameters is null"));
            this.choices = new ArrayList<ParametricScalarImplementationChoice>();
            this.returnNativeContainerType = Objects.requireNonNull(returnNativeContainerType, "returnNativeContainerType is null");
        }

        void addChoice(ParametricScalarImplementationChoice choice) {
            this.choices.add(choice);
        }

        public ParametricScalarImplementation build() {
            this.choices.sort(ParametricScalarImplementationChoice::compareTo);
            return new ParametricScalarImplementation(this.signature, this.argumentNativeContainerTypes, this.specializedTypeParameters, this.choices, this.returnNativeContainerType);
        }
    }
}

