/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.base.Strings;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlFunction;
import io.trino.operator.window.WindowFunctionSupplier;
import java.util.Collections;
import java.util.Objects;

public class SqlWindowFunction
implements SqlFunction {
    private final WindowFunctionSupplier supplier;
    private final FunctionMetadata functionMetadata;

    public SqlWindowFunction(WindowFunctionSupplier supplier, boolean deprecated) {
        this.supplier = Objects.requireNonNull(supplier, "supplier is null");
        Signature signature = supplier.getSignature();
        this.functionMetadata = new FunctionMetadata(signature, signature.getName(), new FunctionNullability(true, Collections.nCopies(signature.getArgumentTypes().size(), true)), false, true, Strings.nullToEmpty((String)supplier.getDescription()), FunctionKind.WINDOW, deprecated);
    }

    @Override
    public FunctionMetadata getFunctionMetadata() {
        return this.functionMetadata;
    }

    public WindowFunctionSupplier specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        return this.specialize(boundSignature);
    }

    public WindowFunctionSupplier specialize(BoundSignature boundSignature) {
        return this.supplier;
    }
}

