/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.pattern;

import com.google.common.collect.ImmutableList;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.aggregation.Accumulator;
import io.trino.operator.aggregation.AccumulatorFactory;
import io.trino.operator.aggregation.InternalAggregationFunction;
import io.trino.operator.aggregation.LambdaProvider;
import io.trino.operator.window.matcher.ArrayView;
import io.trino.operator.window.pattern.ProjectingPagesWindowIndex;
import io.trino.operator.window.pattern.SetEvaluator;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MatchAggregation {
    private static final int ROWS_UNTIL_MEMORY_REPORT = 1000;
    private final String name;
    private final List<Integer> argumentChannels;
    private final AccumulatorFactory accumulatorFactory;
    private final SetEvaluator setEvaluator;
    private final AggregatedMemoryContext memoryContextSupplier;
    private final LocalMemoryContext memoryContext;
    private Accumulator accumulator;
    private int rowsFromMemoryReport;
    private Block resultOnEmpty;

    private MatchAggregation(String name, InternalAggregationFunction function, List<Integer> argumentChannels, List<LambdaProvider> lambdaProviders, SetEvaluator setEvaluator, AggregatedMemoryContext memoryContextSupplier) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.argumentChannels = ImmutableList.copyOf(argumentChannels);
        this.accumulatorFactory = function.bind(argumentChannels, Optional.empty(), (List<Type>)ImmutableList.of(), (List<Integer>)ImmutableList.of(), (List<SortOrder>)ImmutableList.of(), null, false, null, null, lambdaProviders, null);
        this.setEvaluator = setEvaluator;
        this.memoryContextSupplier = memoryContextSupplier;
        this.memoryContext = memoryContextSupplier.newLocalMemoryContext(MatchAggregation.class.getSimpleName());
        this.resetAccumulator();
    }

    private MatchAggregation(String name, List<Integer> argumentChannels, AccumulatorFactory accumulatorFactory, SetEvaluator setEvaluator, Accumulator accumulator, AggregatedMemoryContext memoryContextSupplier) {
        this.name = name;
        this.argumentChannels = argumentChannels;
        this.accumulatorFactory = accumulatorFactory;
        this.setEvaluator = setEvaluator;
        this.memoryContextSupplier = memoryContextSupplier;
        this.memoryContext = memoryContextSupplier.newLocalMemoryContext(MatchAggregation.class.getSimpleName());
        this.accumulator = accumulator;
    }

    public void reset() {
        this.resetAccumulator();
        this.setEvaluator.reset();
        this.rowsFromMemoryReport = 0;
    }

    private void resetAccumulator() {
        this.accumulator = this.accumulatorFactory.createAccumulator();
    }

    public Block aggregate(int currentRow, ArrayView matchedLabels, long matchNumber, ProjectingPagesWindowIndex windowIndex, int partitionStart, int patternStart) {
        ArrayView positions = this.setEvaluator.resolveNewPositions(currentRow, matchedLabels, partitionStart, patternStart);
        for (int i = 0; i < positions.length(); ++i) {
            int position = positions.get(i);
            windowIndex.setLabelAndMatchNumber(position, matchedLabels.get(position + partitionStart - patternStart), matchNumber);
            this.accumulator.addInput(windowIndex, this.argumentChannels, position, position);
        }
        this.rowsFromMemoryReport += positions.length();
        if (this.rowsFromMemoryReport >= 1000) {
            this.rowsFromMemoryReport = 0;
            this.memoryContext.setBytes(this.accumulator.getEstimatedSize() + this.setEvaluator.getAllPositionsSizeInBytes());
        }
        BlockBuilder blockBuilder = this.accumulator.getFinalType().createBlockBuilder(null, 1);
        this.accumulator.evaluateFinal(blockBuilder);
        return blockBuilder.build();
    }

    public Block aggregateEmpty() {
        if (this.resultOnEmpty != null) {
            return this.resultOnEmpty;
        }
        BlockBuilder blockBuilder = this.accumulator.getFinalType().createBlockBuilder(null, 1);
        this.accumulatorFactory.createAccumulator().evaluateFinal(blockBuilder);
        this.resultOnEmpty = blockBuilder.build();
        return this.resultOnEmpty;
    }

    public ArrayView getAllPositions(ArrayView labels) {
        return this.setEvaluator.getAllPositions(labels);
    }

    public MatchAggregation copy() {
        Accumulator accumulatorCopy;
        try {
            accumulatorCopy = this.accumulator.copy();
        }
        catch (UnsupportedOperationException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("aggregate function %s does not support copying", this.name), (Throwable)e);
        }
        return new MatchAggregation(this.name, this.argumentChannels, this.accumulatorFactory, this.setEvaluator.copy(), accumulatorCopy, this.memoryContextSupplier);
    }

    public static class MatchAggregationInstantiator {
        private final String name;
        private final InternalAggregationFunction function;
        private final List<Integer> argumentChannels;
        private final List<LambdaProvider> lambdaProviders;
        private final SetEvaluator.SetEvaluatorSupplier setEvaluatorSupplier;

        public MatchAggregationInstantiator(String name, InternalAggregationFunction function, List<Integer> argumentChannels, List<LambdaProvider> lambdaProviders, SetEvaluator.SetEvaluatorSupplier setEvaluatorSupplier) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.function = Objects.requireNonNull(function, "function is null");
            this.argumentChannels = Objects.requireNonNull(argumentChannels, "argumentChannels is null");
            this.lambdaProviders = Objects.requireNonNull(lambdaProviders, "lambdaProviders is null");
            this.setEvaluatorSupplier = Objects.requireNonNull(setEvaluatorSupplier, "setEvaluatorSupplier is null");
        }

        public MatchAggregation get(AggregatedMemoryContext memoryContextSupplier) {
            Objects.requireNonNull(memoryContextSupplier, "memoryContextSupplier is null");
            return new MatchAggregation(this.name, this.function, this.argumentChannels, this.lambdaProviders, this.setEvaluatorSupplier.get(), memoryContextSupplier);
        }
    }
}

