/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.pattern;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.PagesIndex;
import io.trino.operator.window.PagesWindowIndex;
import io.trino.operator.window.pattern.ArgumentComputation;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.WindowIndex;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ProjectingPagesWindowIndex
implements WindowIndex {
    private final PagesIndex pagesIndex;
    private final int start;
    private final int size;
    private final List<Type> projectedTypes;
    private final List<ArgumentComputation> projections;
    private final int firstProjectedChannel;
    private final List<String> labelNames;
    private int currentPosition;
    private Block label;
    private Block matchNumber;
    private final Block[] results;
    private final WindowIndex windowIndex;

    public ProjectingPagesWindowIndex(PagesIndex pagesIndex, int start, int end, List<ArgumentComputation> projections, List<String> labelNames) {
        Objects.requireNonNull(pagesIndex, "pagesIndex is null");
        Preconditions.checkPositionIndex((int)start, (int)pagesIndex.getPositionCount(), (String)"start");
        Preconditions.checkPositionIndex((int)end, (int)pagesIndex.getPositionCount(), (String)"end");
        Preconditions.checkArgument((start < end ? 1 : 0) != 0, (Object)"start must be before end");
        Objects.requireNonNull(projections, "projections is null");
        Objects.requireNonNull(labelNames, "labelNames is null");
        this.pagesIndex = pagesIndex;
        this.start = start;
        this.size = end - start;
        this.projections = ImmutableList.copyOf(projections);
        this.projectedTypes = (List)projections.stream().map(ArgumentComputation::getOutputType).collect(ImmutableList.toImmutableList());
        this.currentPosition = -1;
        this.firstProjectedChannel = pagesIndex.getTypes().size();
        this.labelNames = labelNames;
        this.results = new Block[this.projectedTypes.size()];
        this.windowIndex = new PagesWindowIndex(pagesIndex, start, end);
    }

    public void setLabelAndMatchNumber(int currentPosition, int label, long matchNumber) {
        this.currentPosition = currentPosition;
        this.label = Utils.nativeValueToBlock((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)this.labelNames.get(label)));
        this.matchNumber = Utils.nativeValueToBlock((Type)BigintType.BIGINT, (Object)matchNumber);
        Arrays.fill(this.results, null);
    }

    private Block compute(int position, int projectedChannel) {
        Block result;
        Preconditions.checkArgument((position == this.currentPosition ? 1 : 0) != 0, (String)"accessing position %s (current position: %s)", (int)position, (int)this.currentPosition);
        if (this.results[projectedChannel] != null) {
            return this.results[projectedChannel];
        }
        ArgumentComputation projection = this.projections.get(projectedChannel);
        List<Integer> layout = projection.getInputChannels();
        Block[] input = new Block[layout.size()];
        for (int i = 0; i < layout.size(); ++i) {
            int channel = layout.get(i);
            input[i] = channel == -2 ? this.matchNumber : (channel == -1 ? this.label : this.windowIndex.getSingleValueBlock(channel, position));
        }
        this.results[projectedChannel] = result = projection.compute(input);
        return result;
    }

    public int size() {
        return this.size;
    }

    public boolean isNull(int channel, int position) {
        if (channel < this.firstProjectedChannel) {
            return this.pagesIndex.isNull(channel, this.position(position));
        }
        return this.compute(position, channel - this.firstProjectedChannel).isNull(0);
    }

    public boolean getBoolean(int channel, int position) {
        if (channel < this.firstProjectedChannel) {
            return this.pagesIndex.getBoolean(channel, this.position(position));
        }
        int channelIndex = channel - this.firstProjectedChannel;
        return this.projectedTypes.get(channelIndex).getBoolean(this.compute(position, channelIndex), 0);
    }

    public long getLong(int channel, int position) {
        if (channel < this.firstProjectedChannel) {
            return this.pagesIndex.getLong(channel, this.position(position));
        }
        int channelIndex = channel - this.firstProjectedChannel;
        return this.projectedTypes.get(channelIndex).getLong(this.compute(position, channelIndex), 0);
    }

    public double getDouble(int channel, int position) {
        if (channel < this.firstProjectedChannel) {
            return this.pagesIndex.getDouble(channel, this.position(position));
        }
        int channelIndex = channel - this.firstProjectedChannel;
        return this.projectedTypes.get(channelIndex).getDouble(this.compute(position, channelIndex), 0);
    }

    public Slice getSlice(int channel, int position) {
        if (channel < this.firstProjectedChannel) {
            return this.pagesIndex.getSlice(channel, this.position(position));
        }
        int channelIndex = channel - this.firstProjectedChannel;
        return this.projectedTypes.get(channelIndex).getSlice(this.compute(position, channelIndex), 0);
    }

    public Block getSingleValueBlock(int channel, int position) {
        if (channel < this.firstProjectedChannel) {
            return this.pagesIndex.getSingleValueBlock(channel, this.position(position));
        }
        return this.compute(position, channel - this.firstProjectedChannel);
    }

    public Object getObject(int channel, int position) {
        if (channel < this.firstProjectedChannel) {
            return this.pagesIndex.getObject(channel, this.position(position));
        }
        int channelIndex = channel - this.firstProjectedChannel;
        return this.projectedTypes.get(channelIndex).getObject(this.compute(position, channelIndex), 0);
    }

    public void appendTo(int channel, int position, BlockBuilder output) {
        if (channel < this.firstProjectedChannel) {
            this.pagesIndex.appendTo(channel, this.position(position), output);
        }
        int channelIndex = channel - this.firstProjectedChannel;
        this.projectedTypes.get(channelIndex).appendTo(this.compute(position, channelIndex), 0, output);
    }

    private int position(int position) {
        Preconditions.checkElementIndex((int)position, (int)this.size, (String)"position");
        return position + this.start;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("size", this.size).add("input channels", this.firstProjectedChannel).add("projected channels", this.projectedTypes.size()).toString();
    }
}

