/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Streams;
import io.trino.metadata.NewTableLayout;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableExecuteHandle;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.QueryId;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.eventlistener.ColumnDetail;
import io.trino.spi.eventlistener.ColumnInfo;
import io.trino.spi.eventlistener.RoutineInfo;
import io.trino.spi.eventlistener.TableInfo;
import io.trino.spi.security.Identity;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.CanonicalizationAware;
import io.trino.sql.analyzer.ExpressionAnalysis;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.Field;
import io.trino.sql.analyzer.FieldId;
import io.trino.sql.analyzer.Output;
import io.trino.sql.analyzer.OutputColumn;
import io.trino.sql.analyzer.QueryType;
import io.trino.sql.analyzer.RelationType;
import io.trino.sql.analyzer.ResolvedField;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GroupingOperation;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.Join;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.MeasureDefinition;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Offset;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.QuerySpecification;
import io.trino.sql.tree.RangeQuantifier;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.SampledRelation;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.Table;
import io.trino.sql.tree.Unnest;
import io.trino.sql.tree.WindowFrame;
import io.trino.sql.tree.WindowOperation;
import io.trino.transaction.TransactionId;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class Analysis {
    @Nullable
    private final Statement root;
    private final Map<NodeRef<Parameter>, Expression> parameters;
    private String updateType;
    private Optional<UpdateTarget> target = Optional.empty();
    private boolean skipMaterializedViewRefresh;
    private final Map<NodeRef<Table>, Query> namedQueries = new LinkedHashMap<NodeRef<Table>, Query>();
    private final Map<NodeRef<Query>, Node> expandableNamedQueries = new LinkedHashMap<NodeRef<Query>, Node>();
    private final Map<NodeRef<Node>, Scope> expandableBaseScopes = new LinkedHashMap<NodeRef<Node>, Scope>();
    private final Map<NodeRef<QuerySpecification>, Scope> implicitFromScopes = new LinkedHashMap<NodeRef<QuerySpecification>, Scope>();
    private final Map<NodeRef<Node>, Scope> scopes = new LinkedHashMap<NodeRef<Node>, Scope>();
    private final Map<NodeRef<Expression>, ResolvedField> columnReferences = new LinkedHashMap<NodeRef<Expression>, ResolvedField>();
    private final Map<AccessControlInfo, Map<QualifiedObjectName, Set<String>>> tableColumnReferences = new LinkedHashMap<AccessControlInfo, Map<QualifiedObjectName, Set<String>>>();
    private final Map<NodeRef<DereferenceExpression>, ExpressionAnalyzer.LabelPrefixedReference> labelDereferences = new LinkedHashMap<NodeRef<DereferenceExpression>, ExpressionAnalyzer.LabelPrefixedReference>();
    private final Set<NodeRef<FunctionCall>> patternRecognitionFunctions = new LinkedHashSet<NodeRef<FunctionCall>>();
    private final Map<NodeRef<RangeQuantifier>, Range> ranges = new LinkedHashMap<NodeRef<RangeQuantifier>, Range>();
    private final Map<NodeRef<RowPattern>, Set<String>> undefinedLabels = new LinkedHashMap<NodeRef<RowPattern>, Set<String>>();
    private final Map<NodeRef<WindowOperation>, MeasureDefinition> measureDefinitions = new LinkedHashMap<NodeRef<WindowOperation>, MeasureDefinition>();
    private final Set<NodeRef<FunctionCall>> patternAggregations = new LinkedHashSet<NodeRef<FunctionCall>>();
    private final Map<NodeRef<QuerySpecification>, List<FunctionCall>> aggregates = new LinkedHashMap<NodeRef<QuerySpecification>, List<FunctionCall>>();
    private final Map<NodeRef<OrderBy>, List<Expression>> orderByAggregates = new LinkedHashMap<NodeRef<OrderBy>, List<Expression>>();
    private final Map<NodeRef<QuerySpecification>, GroupingSetAnalysis> groupingSets = new LinkedHashMap<NodeRef<QuerySpecification>, GroupingSetAnalysis>();
    private final Map<NodeRef<Node>, Expression> where = new LinkedHashMap<NodeRef<Node>, Expression>();
    private final Map<NodeRef<QuerySpecification>, Expression> having = new LinkedHashMap<NodeRef<QuerySpecification>, Expression>();
    private final Map<NodeRef<Node>, List<Expression>> orderByExpressions = new LinkedHashMap<NodeRef<Node>, List<Expression>>();
    private final Set<NodeRef<OrderBy>> redundantOrderBy = new HashSet<NodeRef<OrderBy>>();
    private final Map<NodeRef<Node>, List<SelectExpression>> selectExpressions = new LinkedHashMap<NodeRef<Node>, List<SelectExpression>>();
    private final Map<NodeRef<QuerySpecification>, Map<CanonicalizationAware<Identifier>, ResolvedWindow>> windowDefinitions = new LinkedHashMap<NodeRef<QuerySpecification>, Map<CanonicalizationAware<Identifier>, ResolvedWindow>>();
    private final Map<NodeRef<Node>, ResolvedWindow> windows = new LinkedHashMap<NodeRef<Node>, ResolvedWindow>();
    private final Map<NodeRef<QuerySpecification>, List<FunctionCall>> windowFunctions = new LinkedHashMap<NodeRef<QuerySpecification>, List<FunctionCall>>();
    private final Map<NodeRef<OrderBy>, List<FunctionCall>> orderByWindowFunctions = new LinkedHashMap<NodeRef<OrderBy>, List<FunctionCall>>();
    private final Map<NodeRef<QuerySpecification>, List<WindowOperation>> windowMeasures = new LinkedHashMap<NodeRef<QuerySpecification>, List<WindowOperation>>();
    private final Map<NodeRef<OrderBy>, List<WindowOperation>> orderByWindowMeasures = new LinkedHashMap<NodeRef<OrderBy>, List<WindowOperation>>();
    private final Map<NodeRef<Offset>, Long> offset = new LinkedHashMap<NodeRef<Offset>, Long>();
    private final Map<NodeRef<Node>, OptionalLong> limit = new LinkedHashMap<NodeRef<Node>, OptionalLong>();
    private final Map<NodeRef<AllColumns>, List<Field>> selectAllResultFields = new LinkedHashMap<NodeRef<AllColumns>, List<Field>>();
    private final Map<NodeRef<Join>, Expression> joins = new LinkedHashMap<NodeRef<Join>, Expression>();
    private final Map<NodeRef<Join>, JoinUsingAnalysis> joinUsing = new LinkedHashMap<NodeRef<Join>, JoinUsingAnalysis>();
    private final Map<NodeRef<Node>, SubqueryAnalysis> subqueries = new LinkedHashMap<NodeRef<Node>, SubqueryAnalysis>();
    private final Map<NodeRef<Expression>, PredicateCoercions> predicateCoercions = new LinkedHashMap<NodeRef<Expression>, PredicateCoercions>();
    private final Map<NodeRef<Table>, TableEntry> tables = new LinkedHashMap<NodeRef<Table>, TableEntry>();
    private final Map<NodeRef<Expression>, Type> types = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Map<NodeRef<Expression>, Type> coercions = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Set<NodeRef<Expression>> typeOnlyCoercions = new LinkedHashSet<NodeRef<Expression>>();
    private final Map<NodeRef<Expression>, Type> sortKeyCoercionsForFrameBoundCalculation = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Map<NodeRef<Expression>, Type> sortKeyCoercionsForFrameBoundComparison = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Map<NodeRef<Expression>, ResolvedFunction> frameBoundCalculations = new LinkedHashMap<NodeRef<Expression>, ResolvedFunction>();
    private final Map<NodeRef<Relation>, List<Type>> relationCoercions = new LinkedHashMap<NodeRef<Relation>, List<Type>>();
    private final Map<NodeRef<FunctionCall>, RoutineEntry> resolvedFunctions = new LinkedHashMap<NodeRef<FunctionCall>, RoutineEntry>();
    private final Map<NodeRef<Identifier>, LambdaArgumentDeclaration> lambdaArgumentReferences = new LinkedHashMap<NodeRef<Identifier>, LambdaArgumentDeclaration>();
    private final Map<Field, ColumnHandle> columns = new LinkedHashMap<Field, ColumnHandle>();
    private final Map<NodeRef<SampledRelation>, Double> sampleRatios = new LinkedHashMap<NodeRef<SampledRelation>, Double>();
    private final Map<NodeRef<QuerySpecification>, List<GroupingOperation>> groupingOperations = new LinkedHashMap<NodeRef<QuerySpecification>, List<GroupingOperation>>();
    private final Multiset<RowFilterScopeEntry> rowFilterScopes = HashMultiset.create();
    private final Map<NodeRef<Table>, List<Expression>> rowFilters = new LinkedHashMap<NodeRef<Table>, List<Expression>>();
    private final Multiset<ColumnMaskScopeEntry> columnMaskScopes = HashMultiset.create();
    private final Map<NodeRef<Table>, Map<String, List<Expression>>> columnMasks = new LinkedHashMap<NodeRef<Table>, Map<String, List<Expression>>>();
    private final Map<NodeRef<Unnest>, UnnestAnalysis> unnestAnalysis = new LinkedHashMap<NodeRef<Unnest>, UnnestAnalysis>();
    private Optional<Create> create = Optional.empty();
    private Optional<Insert> insert = Optional.empty();
    private Optional<RefreshMaterializedViewAnalysis> refreshMaterializedView = Optional.empty();
    private Optional<QualifiedObjectName> delegatedRefreshMaterializedView = Optional.empty();
    private Optional<TableHandle> analyzeTarget = Optional.empty();
    private Optional<List<ColumnSchema>> updatedColumns = Optional.empty();
    private final QueryType queryType;
    private final Deque<Table> tablesForView = new ArrayDeque<Table>();
    private final Map<NodeRef<Table>, FieldReference> rowIdField = new LinkedHashMap<NodeRef<Table>, FieldReference>();
    private final Multimap<Field, SourceColumn> originColumnDetails = ArrayListMultimap.create();
    private final Multimap<NodeRef<Expression>, Field> fieldLineage = ArrayListMultimap.create();
    private Optional<TableExecuteHandle> tableExecuteHandle = Optional.empty();

    public Analysis(@Nullable Statement root, Map<NodeRef<Parameter>, Expression> parameters, QueryType queryType) {
        this.root = root;
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
    }

    public Statement getStatement() {
        return this.root;
    }

    public String getUpdateType() {
        return this.updateType;
    }

    public Optional<Output> getTarget() {
        return this.target.map(target -> {
            QualifiedObjectName name = target.getName();
            return new Output(name.getCatalogName(), name.getSchemaName(), name.getObjectName(), target.getColumns());
        });
    }

    public void setUpdateType(String updateType) {
        if (this.queryType != QueryType.EXPLAIN) {
            this.updateType = updateType;
        }
    }

    public void setUpdateTarget(QualifiedObjectName targetName, Optional<Table> targetTable, Optional<List<OutputColumn>> targetColumns) {
        this.target = Optional.of(new UpdateTarget(targetName, targetTable, targetColumns));
    }

    public boolean isUpdateTarget(Table table) {
        Objects.requireNonNull(table, "table is null");
        return this.target.flatMap(UpdateTarget::getTable).map(tableReference -> tableReference == table).orElse(Boolean.FALSE);
    }

    public boolean isSkipMaterializedViewRefresh() {
        return this.skipMaterializedViewRefresh;
    }

    public void setSkipMaterializedViewRefresh(boolean skipMaterializedViewRefresh) {
        this.skipMaterializedViewRefresh = skipMaterializedViewRefresh;
    }

    public void setAggregates(QuerySpecification node, List<FunctionCall> aggregates) {
        this.aggregates.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), (List<FunctionCall>)ImmutableList.copyOf(aggregates));
    }

    public List<FunctionCall> getAggregates(QuerySpecification query) {
        return this.aggregates.get(NodeRef.of((Node)query));
    }

    public void setOrderByAggregates(OrderBy node, List<Expression> aggregates) {
        this.orderByAggregates.put((NodeRef<OrderBy>)NodeRef.of((Node)node), (List<Expression>)ImmutableList.copyOf(aggregates));
    }

    public List<Expression> getOrderByAggregates(OrderBy node) {
        return this.orderByAggregates.get(NodeRef.of((Node)node));
    }

    public Map<NodeRef<Expression>, Type> getTypes() {
        return Collections.unmodifiableMap(this.types);
    }

    public Type getType(Expression expression) {
        Type type = this.types.get(NodeRef.of((Node)expression));
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Expression not analyzed: %s", (Object)expression);
        return type;
    }

    public List<Type> getRelationCoercion(Relation relation) {
        return this.relationCoercions.get(NodeRef.of((Node)relation));
    }

    public void addRelationCoercion(Relation relation, Type[] types) {
        this.relationCoercions.put((NodeRef<Relation>)NodeRef.of((Node)relation), (List<Type>)ImmutableList.copyOf((Object[])types));
    }

    public Map<NodeRef<Expression>, Type> getCoercions() {
        return Collections.unmodifiableMap(this.coercions);
    }

    public Set<NodeRef<Expression>> getTypeOnlyCoercions() {
        return Collections.unmodifiableSet(this.typeOnlyCoercions);
    }

    public Type getCoercion(Expression expression) {
        return this.coercions.get(NodeRef.of((Node)expression));
    }

    public void addLambdaArgumentReferences(Map<NodeRef<Identifier>, LambdaArgumentDeclaration> lambdaArgumentReferences) {
        this.lambdaArgumentReferences.putAll(lambdaArgumentReferences);
    }

    public LambdaArgumentDeclaration getLambdaArgumentReference(Identifier identifier) {
        return this.lambdaArgumentReferences.get(NodeRef.of((Node)identifier));
    }

    public Map<NodeRef<Identifier>, LambdaArgumentDeclaration> getLambdaArgumentReferences() {
        return Collections.unmodifiableMap(this.lambdaArgumentReferences);
    }

    public void setGroupingSets(QuerySpecification node, GroupingSetAnalysis groupingSets) {
        this.groupingSets.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), groupingSets);
    }

    public boolean isAggregation(QuerySpecification node) {
        return this.groupingSets.containsKey(NodeRef.of((Node)node));
    }

    public boolean isTypeOnlyCoercion(Expression expression) {
        return this.typeOnlyCoercions.contains(NodeRef.of((Node)expression));
    }

    public GroupingSetAnalysis getGroupingSets(QuerySpecification node) {
        return this.groupingSets.get(NodeRef.of((Node)node));
    }

    public void setWhere(Node node, Expression expression) {
        this.where.put((NodeRef<Node>)NodeRef.of((Node)node), expression);
    }

    public Expression getWhere(QuerySpecification node) {
        return this.where.get(NodeRef.of((Node)node));
    }

    public void setOrderByExpressions(Node node, List<Expression> items) {
        this.orderByExpressions.put((NodeRef<Node>)NodeRef.of((Node)node), (List<Expression>)ImmutableList.copyOf(items));
    }

    public List<Expression> getOrderByExpressions(Node node) {
        return this.orderByExpressions.get(NodeRef.of((Node)node));
    }

    public void setOffset(Offset node, long rowCount) {
        this.offset.put((NodeRef<Offset>)NodeRef.of((Node)node), rowCount);
    }

    public long getOffset(Offset node) {
        Preconditions.checkState((boolean)this.offset.containsKey(NodeRef.of((Node)node)), (String)"missing OFFSET value for node %s", (Object)node);
        return this.offset.get(NodeRef.of((Node)node));
    }

    public void setLimit(Node node, OptionalLong rowCount) {
        this.limit.put((NodeRef<Node>)NodeRef.of((Node)node), rowCount);
    }

    public void setLimit(Node node, long rowCount) {
        this.limit.put((NodeRef<Node>)NodeRef.of((Node)node), OptionalLong.of(rowCount));
    }

    public OptionalLong getLimit(Node node) {
        Preconditions.checkState((boolean)this.limit.containsKey(NodeRef.of((Node)node)), (String)"missing LIMIT value for node %s", (Object)node);
        return this.limit.get(NodeRef.of((Node)node));
    }

    public void setSelectAllResultFields(AllColumns node, List<Field> expressions) {
        this.selectAllResultFields.put((NodeRef<AllColumns>)NodeRef.of((Node)node), (List<Field>)ImmutableList.copyOf(expressions));
    }

    public List<Field> getSelectAllResultFields(AllColumns node) {
        return this.selectAllResultFields.get(NodeRef.of((Node)node));
    }

    public void setSelectExpressions(Node node, List<SelectExpression> expressions) {
        this.selectExpressions.put((NodeRef<Node>)NodeRef.of((Node)node), (List<SelectExpression>)ImmutableList.copyOf(expressions));
    }

    public List<SelectExpression> getSelectExpressions(Node node) {
        return this.selectExpressions.get(NodeRef.of((Node)node));
    }

    public void setHaving(QuerySpecification node, Expression expression) {
        this.having.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), expression);
    }

    public void setJoinCriteria(Join node, Expression criteria) {
        this.joins.put((NodeRef<Join>)NodeRef.of((Node)node), criteria);
    }

    public Expression getJoinCriteria(Join join) {
        return this.joins.get(NodeRef.of((Node)join));
    }

    public void recordSubqueries(Node node, ExpressionAnalysis expressionAnalysis) {
        SubqueryAnalysis subqueries = this.subqueries.computeIfAbsent((NodeRef<Node>)NodeRef.of((Node)node), key -> new SubqueryAnalysis());
        subqueries.addInPredicates(this.dereference(expressionAnalysis.getSubqueryInPredicates()));
        subqueries.addSubqueries(this.dereference(expressionAnalysis.getSubqueries()));
        subqueries.addExistsSubqueries(this.dereference(expressionAnalysis.getExistsSubqueries()));
        subqueries.addQuantifiedComparisons(this.dereference(expressionAnalysis.getQuantifiedComparisons()));
    }

    private <T extends Node> List<T> dereference(Collection<NodeRef<T>> nodeRefs) {
        return (List)nodeRefs.stream().map(NodeRef::getNode).collect(ImmutableList.toImmutableList());
    }

    public SubqueryAnalysis getSubqueries(Node node) {
        return this.subqueries.computeIfAbsent((NodeRef<Node>)NodeRef.of((Node)node), key -> new SubqueryAnalysis());
    }

    public void addWindowDefinition(QuerySpecification query, CanonicalizationAware<Identifier> name, ResolvedWindow window) {
        this.windowDefinitions.computeIfAbsent((NodeRef<QuerySpecification>)NodeRef.of((Node)query), key -> new LinkedHashMap()).put(name, window);
    }

    public ResolvedWindow getWindowDefinition(QuerySpecification query, CanonicalizationAware<Identifier> name) {
        Map<CanonicalizationAware<Identifier>, ResolvedWindow> windows = this.windowDefinitions.get(NodeRef.of((Node)query));
        if (windows != null) {
            return windows.get(name);
        }
        return null;
    }

    public void setWindow(Node node, ResolvedWindow window) {
        this.windows.put((NodeRef<Node>)NodeRef.of((Node)node), window);
    }

    public ResolvedWindow getWindow(Node node) {
        return this.windows.get(NodeRef.of((Node)node));
    }

    public void setWindowFunctions(QuerySpecification node, List<FunctionCall> functions) {
        this.windowFunctions.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), (List<FunctionCall>)ImmutableList.copyOf(functions));
    }

    public List<FunctionCall> getWindowFunctions(QuerySpecification query) {
        return this.windowFunctions.get(NodeRef.of((Node)query));
    }

    public void setOrderByWindowFunctions(OrderBy node, List<FunctionCall> functions) {
        this.orderByWindowFunctions.put((NodeRef<OrderBy>)NodeRef.of((Node)node), (List<FunctionCall>)ImmutableList.copyOf(functions));
    }

    public List<FunctionCall> getOrderByWindowFunctions(OrderBy query) {
        return this.orderByWindowFunctions.get(NodeRef.of((Node)query));
    }

    public void setWindowMeasures(QuerySpecification node, List<WindowOperation> measures) {
        this.windowMeasures.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), (List<WindowOperation>)ImmutableList.copyOf(measures));
    }

    public List<WindowOperation> getWindowMeasures(QuerySpecification node) {
        return this.windowMeasures.get(NodeRef.of((Node)node));
    }

    public void setOrderByWindowMeasures(OrderBy node, List<WindowOperation> measures) {
        this.orderByWindowMeasures.put((NodeRef<OrderBy>)NodeRef.of((Node)node), (List<WindowOperation>)ImmutableList.copyOf(measures));
    }

    public List<WindowOperation> getOrderByWindowMeasures(OrderBy node) {
        return this.orderByWindowMeasures.get(NodeRef.of((Node)node));
    }

    public void addColumnReferences(Map<NodeRef<Expression>, ResolvedField> columnReferences) {
        this.columnReferences.putAll(columnReferences);
    }

    public Scope getScope(Node node) {
        return this.tryGetScope(node).orElseThrow(() -> new IllegalArgumentException(String.format("Analysis does not contain information for node: %s", node)));
    }

    public Optional<Scope> tryGetScope(Node node) {
        NodeRef key = NodeRef.of((Node)node);
        if (this.scopes.containsKey(key)) {
            return Optional.of(this.scopes.get(key));
        }
        return Optional.empty();
    }

    public Scope getRootScope() {
        return this.getScope((Node)this.root);
    }

    public void setScope(Node node, Scope scope) {
        this.scopes.put((NodeRef<Node>)NodeRef.of((Node)node), scope);
    }

    public RelationType getOutputDescriptor() {
        return this.getOutputDescriptor((Node)this.root);
    }

    public RelationType getOutputDescriptor(Node node) {
        return this.getScope(node).getRelationType();
    }

    public TableHandle getTableHandle(Table table) {
        return this.tables.get(NodeRef.of((Node)table)).getHandle().orElseThrow(() -> new IllegalArgumentException(String.format("%s is not a table reference", table)));
    }

    public Collection<TableHandle> getTables() {
        return (Collection)this.tables.values().stream().map(TableEntry::getHandle).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }

    public void registerTable(Table table, Optional<TableHandle> handle, QualifiedObjectName name, String authorization, Scope accessControlScope) {
        this.tables.put((NodeRef<Table>)NodeRef.of((Node)table), new TableEntry(handle, name, authorization, accessControlScope, this.tablesForView.isEmpty() && this.rowFilterScopes.isEmpty() && this.columnMaskScopes.isEmpty()));
    }

    public ResolvedFunction getResolvedFunction(FunctionCall function) {
        return this.resolvedFunctions.get(NodeRef.of((Node)function)).getFunction();
    }

    public void addResolvedFunction(FunctionCall node, ResolvedFunction function, String authorization) {
        this.resolvedFunctions.put((NodeRef<FunctionCall>)NodeRef.of((Node)node), new RoutineEntry(function, authorization));
    }

    public Set<NodeRef<Expression>> getColumnReferences() {
        return Collections.unmodifiableSet(this.columnReferences.keySet());
    }

    public Map<NodeRef<Expression>, ResolvedField> getColumnReferenceFields() {
        return Collections.unmodifiableMap(this.columnReferences);
    }

    public ResolvedField getResolvedField(Expression expression) {
        Preconditions.checkArgument((boolean)this.isColumnReference(expression), (String)"Expression is not a column reference: %s", (Object)expression);
        return this.columnReferences.get(NodeRef.of((Node)expression));
    }

    public boolean isColumnReference(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        return this.columnReferences.containsKey(NodeRef.of((Node)expression));
    }

    public void addTypes(Map<NodeRef<Expression>, Type> types) {
        this.types.putAll(types);
    }

    public void addCoercion(Expression expression, Type type, boolean isTypeOnlyCoercion) {
        this.coercions.put((NodeRef<Expression>)NodeRef.of((Node)expression), type);
        if (isTypeOnlyCoercion) {
            this.typeOnlyCoercions.add((NodeRef<Expression>)NodeRef.of((Node)expression));
        }
    }

    public void addCoercions(Map<NodeRef<Expression>, Type> coercions, Set<NodeRef<Expression>> typeOnlyCoercions, Map<NodeRef<Expression>, Type> sortKeyCoercionsForFrameBoundCalculation, Map<NodeRef<Expression>, Type> sortKeyCoercionsForFrameBoundComparison) {
        this.coercions.putAll(coercions);
        this.typeOnlyCoercions.addAll(typeOnlyCoercions);
        this.sortKeyCoercionsForFrameBoundCalculation.putAll(sortKeyCoercionsForFrameBoundCalculation);
        this.sortKeyCoercionsForFrameBoundComparison.putAll(sortKeyCoercionsForFrameBoundComparison);
    }

    public Type getSortKeyCoercionForFrameBoundCalculation(Expression frameOffset) {
        return this.sortKeyCoercionsForFrameBoundCalculation.get(NodeRef.of((Node)frameOffset));
    }

    public Type getSortKeyCoercionForFrameBoundComparison(Expression frameOffset) {
        return this.sortKeyCoercionsForFrameBoundComparison.get(NodeRef.of((Node)frameOffset));
    }

    public void addFrameBoundCalculations(Map<NodeRef<Expression>, ResolvedFunction> frameBoundCalculations) {
        this.frameBoundCalculations.putAll(frameBoundCalculations);
    }

    public ResolvedFunction getFrameBoundCalculation(Expression frameOffset) {
        return this.frameBoundCalculations.get(NodeRef.of((Node)frameOffset));
    }

    public Expression getHaving(QuerySpecification query) {
        return this.having.get(NodeRef.of((Node)query));
    }

    public void setColumn(Field field, ColumnHandle handle) {
        this.columns.put(field, handle);
    }

    public ColumnHandle getColumn(Field field) {
        return this.columns.get(field);
    }

    public Optional<TableHandle> getAnalyzeTarget() {
        return this.analyzeTarget;
    }

    public void setAnalyzeTarget(TableHandle analyzeTarget) {
        this.analyzeTarget = Optional.of(analyzeTarget);
    }

    public void setCreate(Create create) {
        this.create = Optional.of(create);
    }

    public Optional<Create> getCreate() {
        return this.create;
    }

    public void setInsert(Insert insert) {
        this.insert = Optional.of(insert);
    }

    public Optional<Insert> getInsert() {
        return this.insert;
    }

    public void setUpdatedColumns(List<ColumnSchema> updatedColumns) {
        this.updatedColumns = Optional.of(updatedColumns);
    }

    public Optional<List<ColumnSchema>> getUpdatedColumns() {
        return this.updatedColumns;
    }

    public void setRefreshMaterializedView(RefreshMaterializedViewAnalysis refreshMaterializedView) {
        this.refreshMaterializedView = Optional.of(refreshMaterializedView);
    }

    public Optional<RefreshMaterializedViewAnalysis> getRefreshMaterializedView() {
        return this.refreshMaterializedView;
    }

    public void setDelegatedRefreshMaterializedView(QualifiedObjectName viewName) {
        this.delegatedRefreshMaterializedView = Optional.of(viewName);
    }

    public Optional<QualifiedObjectName> getDelegatedRefreshMaterializedView() {
        return this.delegatedRefreshMaterializedView;
    }

    public Query getNamedQuery(Table table) {
        return this.namedQueries.get(NodeRef.of((Node)table));
    }

    public void registerNamedQuery(Table tableReference, Query query) {
        Objects.requireNonNull(tableReference, "tableReference is null");
        Objects.requireNonNull(query, "query is null");
        this.namedQueries.put((NodeRef<Table>)NodeRef.of((Node)tableReference), query);
    }

    public void registerExpandableQuery(Query query, Node recursiveReference) {
        Objects.requireNonNull(query, "query is null");
        Objects.requireNonNull(recursiveReference, "recursiveReference is null");
        this.expandableNamedQueries.put((NodeRef<Query>)NodeRef.of((Node)query), recursiveReference);
    }

    public boolean isExpandableQuery(Query query) {
        return this.expandableNamedQueries.containsKey(NodeRef.of((Node)query));
    }

    public Node getRecursiveReference(Query query) {
        Preconditions.checkArgument((boolean)this.isExpandableQuery(query), (Object)"query is not registered as expandable");
        return this.expandableNamedQueries.get(NodeRef.of((Node)query));
    }

    public void setExpandableBaseScope(Node node, Scope scope) {
        this.expandableBaseScopes.put((NodeRef<Node>)NodeRef.of((Node)node), scope);
    }

    public Optional<Scope> getExpandableBaseScope(Node node) {
        return Optional.ofNullable(this.expandableBaseScopes.get(NodeRef.of((Node)node)));
    }

    public void registerTableForView(Table tableReference) {
        this.tablesForView.push(Objects.requireNonNull(tableReference, "tableReference is null"));
    }

    public void unregisterTableForView() {
        this.tablesForView.pop();
    }

    public boolean hasTableInView(Table tableReference) {
        return this.tablesForView.contains(tableReference);
    }

    public void setSampleRatio(SampledRelation relation, double ratio) {
        this.sampleRatios.put((NodeRef<SampledRelation>)NodeRef.of((Node)relation), ratio);
    }

    public double getSampleRatio(SampledRelation relation) {
        NodeRef key = NodeRef.of((Node)relation);
        Preconditions.checkState((boolean)this.sampleRatios.containsKey(key), (String)"Sample ratio missing for %s. Broken analysis?", (Object)relation);
        return this.sampleRatios.get(key);
    }

    public void setGroupingOperations(QuerySpecification querySpecification, List<GroupingOperation> groupingOperations) {
        this.groupingOperations.put((NodeRef<QuerySpecification>)NodeRef.of((Node)querySpecification), (List<GroupingOperation>)ImmutableList.copyOf(groupingOperations));
    }

    public List<GroupingOperation> getGroupingOperations(QuerySpecification querySpecification) {
        return Optional.ofNullable(this.groupingOperations.get(NodeRef.of((Node)querySpecification))).orElse(Collections.emptyList());
    }

    public Map<NodeRef<Parameter>, Expression> getParameters() {
        return this.parameters;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public boolean isDescribe() {
        return this.queryType == QueryType.DESCRIBE;
    }

    public void setJoinUsing(Join node, JoinUsingAnalysis analysis) {
        this.joinUsing.put((NodeRef<Join>)NodeRef.of((Node)node), analysis);
    }

    public JoinUsingAnalysis getJoinUsing(Join node) {
        return this.joinUsing.get(NodeRef.of((Node)node));
    }

    public void setUnnest(Unnest node, UnnestAnalysis analysis) {
        this.unnestAnalysis.put((NodeRef<Unnest>)NodeRef.of((Node)node), analysis);
    }

    public UnnestAnalysis getUnnest(Unnest node) {
        return this.unnestAnalysis.get(NodeRef.of((Node)node));
    }

    public void addTableColumnReferences(AccessControl accessControl, Identity identity, Multimap<QualifiedObjectName, String> tableColumnMap) {
        AccessControlInfo accessControlInfo = new AccessControlInfo(accessControl, identity);
        Map references = this.tableColumnReferences.computeIfAbsent(accessControlInfo, k -> new LinkedHashMap());
        tableColumnMap.asMap().forEach((key, value) -> references.computeIfAbsent(key, k -> new HashSet()).addAll(value));
    }

    public void addEmptyColumnReferencesForTable(AccessControl accessControl, Identity identity, QualifiedObjectName table) {
        AccessControlInfo accessControlInfo = new AccessControlInfo(accessControl, identity);
        this.tableColumnReferences.computeIfAbsent(accessControlInfo, k -> new LinkedHashMap()).computeIfAbsent(table, k -> new HashSet());
    }

    public void addLabelDereferences(Map<NodeRef<DereferenceExpression>, ExpressionAnalyzer.LabelPrefixedReference> dereferences) {
        this.labelDereferences.putAll(dereferences);
    }

    public ExpressionAnalyzer.LabelPrefixedReference getLabelDereference(DereferenceExpression expression) {
        return this.labelDereferences.get(NodeRef.of((Node)expression));
    }

    public void addPatternRecognitionFunctions(Set<NodeRef<FunctionCall>> functions) {
        this.patternRecognitionFunctions.addAll(functions);
    }

    public boolean isPatternRecognitionFunction(FunctionCall functionCall) {
        return this.patternRecognitionFunctions.contains(NodeRef.of((Node)functionCall));
    }

    public void setRanges(Map<NodeRef<RangeQuantifier>, Range> quantifierRanges) {
        this.ranges.putAll(quantifierRanges);
    }

    public Range getRange(RangeQuantifier quantifier) {
        Range range = this.ranges.get(NodeRef.of((Node)quantifier));
        Preconditions.checkNotNull((Object)range, (String)"missing range for quantifier ", (Object)quantifier);
        return range;
    }

    public void setUndefinedLabels(RowPattern pattern, Set<String> labels) {
        this.undefinedLabels.put((NodeRef<RowPattern>)NodeRef.of((Node)pattern), labels);
    }

    public void setUndefinedLabels(Map<NodeRef<RowPattern>, Set<String>> labels) {
        this.undefinedLabels.putAll(labels);
    }

    public Set<String> getUndefinedLabels(RowPattern pattern) {
        Set<String> labels = this.undefinedLabels.get(NodeRef.of((Node)pattern));
        Preconditions.checkNotNull(labels, (String)"missing undefined labels for ", (Object)pattern);
        return labels;
    }

    public void setMeasureDefinitions(Map<NodeRef<WindowOperation>, MeasureDefinition> definitions) {
        this.measureDefinitions.putAll(definitions);
    }

    public MeasureDefinition getMeasureDefinition(WindowOperation measure) {
        return this.measureDefinitions.get(NodeRef.of((Node)measure));
    }

    public void setPatternAggregations(Set<NodeRef<FunctionCall>> aggregations) {
        this.patternAggregations.addAll(aggregations);
    }

    public boolean isPatternAggregation(FunctionCall function) {
        return this.patternAggregations.contains(NodeRef.of((Node)function));
    }

    public Map<AccessControlInfo, Map<QualifiedObjectName, Set<String>>> getTableColumnReferences() {
        return this.tableColumnReferences;
    }

    public void markRedundantOrderBy(OrderBy orderBy) {
        this.redundantOrderBy.add((NodeRef<OrderBy>)NodeRef.of((Node)orderBy));
    }

    public boolean isOrderByRedundant(OrderBy orderBy) {
        return this.redundantOrderBy.contains(NodeRef.of((Node)orderBy));
    }

    public boolean hasRowFilter(QualifiedObjectName table, String identity) {
        return this.rowFilterScopes.contains((Object)new RowFilterScopeEntry(table, identity));
    }

    public void registerTableForRowFiltering(QualifiedObjectName table, String identity) {
        this.rowFilterScopes.add((Object)new RowFilterScopeEntry(table, identity));
    }

    public void unregisterTableForRowFiltering(QualifiedObjectName table, String identity) {
        this.rowFilterScopes.remove((Object)new RowFilterScopeEntry(table, identity));
    }

    public void addRowFilter(Table table, Expression filter) {
        this.rowFilters.computeIfAbsent((NodeRef<Table>)NodeRef.of((Node)table), node -> new ArrayList()).add(filter);
    }

    public List<Expression> getRowFilters(Table node) {
        return this.rowFilters.getOrDefault(NodeRef.of((Node)node), (List<Expression>)ImmutableList.of());
    }

    public boolean hasColumnMask(QualifiedObjectName table, String column, String identity) {
        return this.columnMaskScopes.contains((Object)new ColumnMaskScopeEntry(table, column, identity));
    }

    public void registerTableForColumnMasking(QualifiedObjectName table, String column, String identity) {
        this.columnMaskScopes.add((Object)new ColumnMaskScopeEntry(table, column, identity));
    }

    public void unregisterTableForColumnMasking(QualifiedObjectName table, String column, String identity) {
        this.columnMaskScopes.remove((Object)new ColumnMaskScopeEntry(table, column, identity));
    }

    public void addColumnMask(Table table, String column, Expression mask) {
        Map masks = this.columnMasks.computeIfAbsent((NodeRef<Table>)NodeRef.of((Node)table), node -> new LinkedHashMap());
        masks.computeIfAbsent(column, name -> new ArrayList()).add(mask);
    }

    public Map<String, List<Expression>> getColumnMasks(Table table) {
        return this.columnMasks.getOrDefault(NodeRef.of((Node)table), (Map<String, List<Expression>>)ImmutableMap.of());
    }

    public List<TableInfo> getReferencedTables() {
        return (List)this.tables.entrySet().stream().filter(entry -> this.isInputTable((Table)((NodeRef)entry.getKey()).getNode())).map(entry -> {
            NodeRef table = (NodeRef)entry.getKey();
            QualifiedObjectName tableName = ((TableEntry)entry.getValue()).getName();
            List columns = (List)this.tableColumnReferences.values().stream().map(tablesToColumns -> (Set)tablesToColumns.get(tableName)).filter(Objects::nonNull).flatMap(Collection::stream).distinct().map(fieldName -> new ColumnInfo(fieldName, (List)this.columnMasks.getOrDefault(table, (Map<String, List<Expression>>)ImmutableMap.of()).getOrDefault(fieldName, (List<Expression>)ImmutableList.of()).stream().map(Expression::toString).collect(ImmutableList.toImmutableList()))).collect(ImmutableList.toImmutableList());
            TableEntry info = (TableEntry)entry.getValue();
            return new TableInfo(info.getName().getCatalogName(), info.getName().getSchemaName(), info.getName().getObjectName(), info.getAuthorization(), (List)this.rowFilters.getOrDefault(table, (List<Expression>)ImmutableList.of()).stream().map(Expression::toString).collect(ImmutableList.toImmutableList()), columns, info.isDirectlyReferenced());
        }).collect(ImmutableList.toImmutableList());
    }

    public List<RoutineInfo> getRoutines() {
        return (List)this.resolvedFunctions.entrySet().stream().map(entry -> new RoutineInfo(((RoutineEntry)entry.getValue()).function.getSignature().getName(), ((RoutineEntry)entry.getValue()).getAuthorization())).collect(ImmutableList.toImmutableList());
    }

    public void addSourceColumns(Field field, Set<SourceColumn> sourceColumn) {
        this.originColumnDetails.putAll((Object)field, sourceColumn);
    }

    public Set<SourceColumn> getSourceColumns(Field field) {
        return ImmutableSet.copyOf((Collection)this.originColumnDetails.get((Object)field));
    }

    public void addExpressionFields(Expression expression, Collection<Field> fields) {
        this.fieldLineage.putAll((Object)NodeRef.of((Node)expression), fields);
    }

    public Set<SourceColumn> getExpressionSourceColumns(Expression expression) {
        return (Set)this.fieldLineage.get((Object)NodeRef.of((Node)expression)).stream().flatMap(field -> this.getSourceColumns((Field)field).stream()).collect(ImmutableSet.toImmutableSet());
    }

    public void setRowIdField(Table table, FieldReference field) {
        this.rowIdField.put((NodeRef<Table>)NodeRef.of((Node)table), field);
    }

    public FieldReference getRowIdField(Table table) {
        return this.rowIdField.get(NodeRef.of((Node)table));
    }

    public Scope getAccessControlScope(Table node) {
        return this.tables.get(NodeRef.of((Node)node)).getAccessControlScope();
    }

    public void setImplicitFromScope(QuerySpecification node, Scope scope) {
        this.implicitFromScopes.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), scope);
    }

    public Scope getImplicitFromScope(QuerySpecification node) {
        return this.implicitFromScopes.get(NodeRef.of((Node)node));
    }

    public void addPredicateCoercions(Map<NodeRef<Expression>, PredicateCoercions> coercions) {
        this.predicateCoercions.putAll(coercions);
    }

    public PredicateCoercions getPredicateCoercions(Expression expression) {
        return this.predicateCoercions.get(NodeRef.of((Node)expression));
    }

    public void setTableExecuteHandle(TableExecuteHandle tableExecuteHandle) {
        Objects.requireNonNull(tableExecuteHandle, "tableExecuteHandle is null");
        Preconditions.checkState((boolean)this.tableExecuteHandle.isEmpty(), (Object)"tableExecuteHandle already set");
        this.tableExecuteHandle = Optional.of(tableExecuteHandle);
    }

    public Optional<TableExecuteHandle> getTableExecuteHandle() {
        return this.tableExecuteHandle;
    }

    private boolean isInputTable(Table table) {
        return !this.isUpdateTarget(table) && !this.isInsertTarget(table);
    }

    private boolean isInsertTarget(Table table) {
        Objects.requireNonNull(table, "table is null");
        return this.insert.map(Insert::getTable).map(tableReference -> tableReference == table).orElse(Boolean.FALSE);
    }

    public static class Range {
        private final Optional<Integer> atLeast;
        private final Optional<Integer> atMost;

        public Range(Optional<Integer> atLeast, Optional<Integer> atMost) {
            this.atLeast = Objects.requireNonNull(atLeast, "atLeast is null");
            this.atMost = Objects.requireNonNull(atMost, "atMost is null");
        }

        public Optional<Integer> getAtLeast() {
            return this.atLeast;
        }

        public Optional<Integer> getAtMost() {
            return this.atMost;
        }
    }

    private static class UpdateTarget {
        private final QualifiedObjectName name;
        private final Optional<Table> table;
        private final Optional<List<OutputColumn>> columns;

        public UpdateTarget(QualifiedObjectName name, Optional<Table> table, Optional<List<OutputColumn>> columns) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.columns = Objects.requireNonNull(columns, "columns is null").map(ImmutableList::copyOf);
        }

        public QualifiedObjectName getName() {
            return this.name;
        }

        public Optional<Table> getTable() {
            return this.table;
        }

        public Optional<List<OutputColumn>> getColumns() {
            return this.columns;
        }
    }

    private static class RoutineEntry {
        private final ResolvedFunction function;
        private final String authorization;

        public RoutineEntry(ResolvedFunction function, String authorization) {
            this.function = Objects.requireNonNull(function, "function is null");
            this.authorization = Objects.requireNonNull(authorization, "authorization is null");
        }

        public ResolvedFunction getFunction() {
            return this.function;
        }

        public String getAuthorization() {
            return this.authorization;
        }
    }

    public static class SourceColumn {
        private final QualifiedObjectName tableName;
        private final String columnName;

        @JsonCreator
        public SourceColumn(@JsonProperty(value="tableName") QualifiedObjectName tableName, @JsonProperty(value="columnName") String columnName) {
            this.tableName = Objects.requireNonNull(tableName, "tableName is null");
            this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        }

        @JsonProperty
        public QualifiedObjectName getTableName() {
            return this.tableName;
        }

        @JsonProperty
        public String getColumnName() {
            return this.columnName;
        }

        public ColumnDetail getColumnDetail() {
            return new ColumnDetail(this.tableName.getCatalogName(), this.tableName.getSchemaName(), this.tableName.getObjectName(), this.columnName);
        }

        public int hashCode() {
            return Objects.hash(this.tableName, this.columnName);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SourceColumn entry = (SourceColumn)obj;
            return Objects.equals(this.tableName, entry.tableName) && Objects.equals(this.columnName, entry.columnName);
        }
    }

    private static class TableEntry {
        private final Optional<TableHandle> handle;
        private final QualifiedObjectName name;
        private final String authorization;
        private final Scope accessControlScope;
        private final boolean directlyReferenced;

        public TableEntry(Optional<TableHandle> handle, QualifiedObjectName name, String authorization, Scope accessControlScope, boolean directlyReferenced) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.name = Objects.requireNonNull(name, "name is null");
            this.authorization = Objects.requireNonNull(authorization, "authorization is null");
            this.accessControlScope = Objects.requireNonNull(accessControlScope, "accessControlScope is null");
            this.directlyReferenced = directlyReferenced;
        }

        public Optional<TableHandle> getHandle() {
            return this.handle;
        }

        public QualifiedObjectName getName() {
            return this.name;
        }

        public boolean isDirectlyReferenced() {
            return this.directlyReferenced;
        }

        public String getAuthorization() {
            return this.authorization;
        }

        public Scope getAccessControlScope() {
            return this.accessControlScope;
        }
    }

    private static class ColumnMaskScopeEntry {
        private final QualifiedObjectName table;
        private final String column;
        private final String identity;

        public ColumnMaskScopeEntry(QualifiedObjectName table, String column, String identity) {
            this.table = Objects.requireNonNull(table, "table is null");
            this.column = Objects.requireNonNull(column, "column is null");
            this.identity = Objects.requireNonNull(identity, "identity is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnMaskScopeEntry that = (ColumnMaskScopeEntry)o;
            return this.table.equals(that.table) && this.column.equals(that.column) && this.identity.equals(that.identity);
        }

        public int hashCode() {
            return Objects.hash(this.table, this.column, this.identity);
        }
    }

    private static class RowFilterScopeEntry {
        private final QualifiedObjectName table;
        private final String identity;

        public RowFilterScopeEntry(QualifiedObjectName table, String identity) {
            this.table = Objects.requireNonNull(table, "table is null");
            this.identity = Objects.requireNonNull(identity, "identity is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowFilterScopeEntry that = (RowFilterScopeEntry)o;
            return this.table.equals(that.table) && this.identity.equals(that.identity);
        }

        public int hashCode() {
            return Objects.hash(this.table, this.identity);
        }
    }

    public static final class AccessControlInfo {
        private final AccessControl accessControl;
        private final Identity identity;

        public AccessControlInfo(AccessControl accessControl, Identity identity) {
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.identity = Objects.requireNonNull(identity, "identity is null");
        }

        public AccessControl getAccessControl() {
            return this.accessControl;
        }

        public SecurityContext getSecurityContext(TransactionId transactionId, QueryId queryId) {
            return new SecurityContext(transactionId, this.identity, queryId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AccessControlInfo that = (AccessControlInfo)o;
            return Objects.equals(this.accessControl, that.accessControl) && Objects.equals(this.identity, that.identity);
        }

        public int hashCode() {
            return Objects.hash(this.accessControl, this.identity);
        }

        public String toString() {
            return String.format("AccessControl: %s, Identity: %s", this.accessControl.getClass(), this.identity);
        }
    }

    public static class ResolvedWindow {
        private final List<Expression> partitionBy;
        private final Optional<OrderBy> orderBy;
        private final Optional<WindowFrame> frame;
        private final boolean partitionByInherited;
        private final boolean orderByInherited;
        private final boolean frameInherited;

        public ResolvedWindow(List<Expression> partitionBy, Optional<OrderBy> orderBy, Optional<WindowFrame> frame, boolean partitionByInherited, boolean orderByInherited, boolean frameInherited) {
            this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy is null");
            this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
            this.frame = Objects.requireNonNull(frame, "frame is null");
            this.partitionByInherited = partitionByInherited;
            this.orderByInherited = orderByInherited;
            this.frameInherited = frameInherited;
        }

        public List<Expression> getPartitionBy() {
            return this.partitionBy;
        }

        public Optional<OrderBy> getOrderBy() {
            return this.orderBy;
        }

        public Optional<WindowFrame> getFrame() {
            return this.frame;
        }

        public boolean isPartitionByInherited() {
            return this.partitionByInherited;
        }

        public boolean isOrderByInherited() {
            return this.orderByInherited;
        }

        public boolean isFrameInherited() {
            return this.frameInherited;
        }
    }

    public static class PredicateCoercions {
        private final Type valueType;
        private final Optional<Type> valueCoercion;
        private final Optional<Type> subqueryCoercion;

        public PredicateCoercions(Type valueType, Optional<Type> valueCoercion, Optional<Type> subqueryCoercion) {
            this.valueType = Objects.requireNonNull(valueType, "valueType is null");
            this.valueCoercion = Objects.requireNonNull(valueCoercion, "valueCoercion is null");
            this.subqueryCoercion = Objects.requireNonNull(subqueryCoercion, "subqueryCoercion is null");
        }

        public Type getValueType() {
            return this.valueType;
        }

        public Optional<Type> getValueCoercion() {
            return this.valueCoercion;
        }

        public Optional<Type> getSubqueryCoercion() {
            return this.subqueryCoercion;
        }
    }

    public static class SubqueryAnalysis {
        private final List<InPredicate> inPredicatesSubqueries = new ArrayList<InPredicate>();
        private final List<SubqueryExpression> subqueries = new ArrayList<SubqueryExpression>();
        private final List<ExistsPredicate> existsSubqueries = new ArrayList<ExistsPredicate>();
        private final List<QuantifiedComparisonExpression> quantifiedComparisonSubqueries = new ArrayList<QuantifiedComparisonExpression>();

        public void addInPredicates(List<InPredicate> expressions) {
            this.inPredicatesSubqueries.addAll(expressions);
        }

        public void addSubqueries(List<SubqueryExpression> expressions) {
            this.subqueries.addAll(expressions);
        }

        public void addExistsSubqueries(List<ExistsPredicate> expressions) {
            this.existsSubqueries.addAll(expressions);
        }

        public void addQuantifiedComparisons(List<QuantifiedComparisonExpression> expressions) {
            this.quantifiedComparisonSubqueries.addAll(expressions);
        }

        public List<InPredicate> getInPredicatesSubqueries() {
            return Collections.unmodifiableList(this.inPredicatesSubqueries);
        }

        public List<SubqueryExpression> getSubqueries() {
            return Collections.unmodifiableList(this.subqueries);
        }

        public List<ExistsPredicate> getExistsSubqueries() {
            return Collections.unmodifiableList(this.existsSubqueries);
        }

        public List<QuantifiedComparisonExpression> getQuantifiedComparisonSubqueries() {
            return Collections.unmodifiableList(this.quantifiedComparisonSubqueries);
        }
    }

    public static class UnnestAnalysis {
        private final Map<NodeRef<Expression>, List<Field>> mappings;
        private final Optional<Field> ordinalityField;

        public UnnestAnalysis(Map<NodeRef<Expression>, List<Field>> mappings, Optional<Field> ordinalityField) {
            Objects.requireNonNull(mappings, "mappings is null");
            this.mappings = (Map)mappings.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableList.copyOf((Collection)((Collection)entry.getValue()))));
            this.ordinalityField = Objects.requireNonNull(ordinalityField, "ordinalityField is null");
        }

        public Map<NodeRef<Expression>, List<Field>> getMappings() {
            return this.mappings;
        }

        public Optional<Field> getOrdinalityField() {
            return this.ordinalityField;
        }
    }

    public static class GroupingSetAnalysis {
        private final List<Expression> originalExpressions;
        private final List<Set<FieldId>> cubes;
        private final List<List<FieldId>> rollups;
        private final List<List<Set<FieldId>>> ordinarySets;
        private final List<Expression> complexExpressions;

        public GroupingSetAnalysis(List<Expression> originalExpressions, List<Set<FieldId>> cubes, List<List<FieldId>> rollups, List<List<Set<FieldId>>> ordinarySets, List<Expression> complexExpressions) {
            this.originalExpressions = ImmutableList.copyOf(originalExpressions);
            this.cubes = ImmutableList.copyOf(cubes);
            this.rollups = ImmutableList.copyOf(rollups);
            this.ordinarySets = ImmutableList.copyOf(ordinarySets);
            this.complexExpressions = ImmutableList.copyOf(complexExpressions);
        }

        public List<Expression> getOriginalExpressions() {
            return this.originalExpressions;
        }

        public List<Set<FieldId>> getCubes() {
            return this.cubes;
        }

        public List<List<FieldId>> getRollups() {
            return this.rollups;
        }

        public List<List<Set<FieldId>>> getOrdinarySets() {
            return this.ordinarySets;
        }

        public List<Expression> getComplexExpressions() {
            return this.complexExpressions;
        }

        public Set<FieldId> getAllFields() {
            return (Set)Streams.concat((Stream[])new Stream[]{this.cubes.stream().flatMap(Collection::stream), this.rollups.stream().flatMap(Collection::stream), this.ordinarySets.stream().flatMap(Collection::stream).flatMap(Collection::stream)}).collect(ImmutableSet.toImmutableSet());
        }
    }

    public static final class JoinUsingAnalysis {
        private final List<Integer> leftJoinFields;
        private final List<Integer> rightJoinFields;
        private final List<Integer> otherLeftFields;
        private final List<Integer> otherRightFields;

        JoinUsingAnalysis(List<Integer> leftJoinFields, List<Integer> rightJoinFields, List<Integer> otherLeftFields, List<Integer> otherRightFields) {
            this.leftJoinFields = ImmutableList.copyOf(leftJoinFields);
            this.rightJoinFields = ImmutableList.copyOf(rightJoinFields);
            this.otherLeftFields = ImmutableList.copyOf(otherLeftFields);
            this.otherRightFields = ImmutableList.copyOf(otherRightFields);
            Preconditions.checkArgument((leftJoinFields.size() == rightJoinFields.size() ? 1 : 0) != 0, (Object)"Expected join fields for left and right to have the same size");
        }

        public List<Integer> getLeftJoinFields() {
            return this.leftJoinFields;
        }

        public List<Integer> getRightJoinFields() {
            return this.rightJoinFields;
        }

        public List<Integer> getOtherLeftFields() {
            return this.otherLeftFields;
        }

        public List<Integer> getOtherRightFields() {
            return this.otherRightFields;
        }
    }

    @Immutable
    public static final class RefreshMaterializedViewAnalysis {
        private final Table table;
        private final TableHandle target;
        private final Query query;
        private final List<ColumnHandle> columns;

        public RefreshMaterializedViewAnalysis(Table table, TableHandle target, Query query, List<ColumnHandle> columns) {
            this.table = Objects.requireNonNull(table, "table is null");
            this.target = Objects.requireNonNull(target, "target is null");
            this.query = query;
            this.columns = Objects.requireNonNull(columns, "columns is null");
            Preconditions.checkArgument((columns.size() > 0 ? 1 : 0) != 0, (Object)"No columns given to refresh materialized view");
        }

        public Query getQuery() {
            return this.query;
        }

        public List<ColumnHandle> getColumns() {
            return this.columns;
        }

        public TableHandle getTarget() {
            return this.target;
        }

        public Table getTable() {
            return this.table;
        }
    }

    @Immutable
    public static final class Insert {
        private final Table table;
        private final TableHandle target;
        private final List<ColumnHandle> columns;
        private final Optional<NewTableLayout> newTableLayout;

        public Insert(Table table, TableHandle target, List<ColumnHandle> columns, Optional<NewTableLayout> newTableLayout) {
            this.table = Objects.requireNonNull(table, "table is null");
            this.target = Objects.requireNonNull(target, "target is null");
            this.columns = Objects.requireNonNull(columns, "columns is null");
            Preconditions.checkArgument((columns.size() > 0 ? 1 : 0) != 0, (Object)"No columns given to insert");
            this.newTableLayout = Objects.requireNonNull(newTableLayout, "newTableLayout is null");
        }

        public Table getTable() {
            return this.table;
        }

        public List<ColumnHandle> getColumns() {
            return this.columns;
        }

        public TableHandle getTarget() {
            return this.target;
        }

        public Optional<NewTableLayout> getNewTableLayout() {
            return this.newTableLayout;
        }
    }

    @Immutable
    public static final class Create {
        private final Optional<QualifiedObjectName> destination;
        private final Optional<ConnectorTableMetadata> metadata;
        private final Optional<NewTableLayout> layout;
        private final boolean createTableAsSelectWithData;
        private final boolean createTableAsSelectNoOp;

        public Create(Optional<QualifiedObjectName> destination, Optional<ConnectorTableMetadata> metadata, Optional<NewTableLayout> layout, boolean createTableAsSelectWithData, boolean createTableAsSelectNoOp) {
            this.destination = Objects.requireNonNull(destination, "destination is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.layout = Objects.requireNonNull(layout, "layout is null");
            this.createTableAsSelectWithData = createTableAsSelectWithData;
            this.createTableAsSelectNoOp = createTableAsSelectNoOp;
        }

        public Optional<QualifiedObjectName> getDestination() {
            return this.destination;
        }

        public Optional<ConnectorTableMetadata> getMetadata() {
            return this.metadata;
        }

        public Optional<NewTableLayout> getLayout() {
            return this.layout;
        }

        public boolean isCreateTableAsSelectWithData() {
            return this.createTableAsSelectWithData;
        }

        public boolean isCreateTableAsSelectNoOp() {
            return this.createTableAsSelectNoOp;
        }
    }

    @Immutable
    public static final class SelectExpression {
        private final Expression expression;
        private final Optional<List<Expression>> unfoldedExpressions;

        public SelectExpression(Expression expression, Optional<List<Expression>> unfoldedExpressions) {
            this.expression = Objects.requireNonNull(expression, "expression is null");
            this.unfoldedExpressions = Objects.requireNonNull(unfoldedExpressions);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public Optional<List<Expression>> getUnfoldedExpressions() {
            return this.unfoldedExpressions;
        }
    }
}

