/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.spi.security.GroupProvider;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class AnalyzerFactory {
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;
    private final GroupProvider groupProvider;
    private final StatementRewrite statementRewrite;

    @Inject
    public AnalyzerFactory(Metadata metadata, SqlParser sqlParser, AccessControl accessControl, GroupProvider groupProvider, StatementRewrite statementRewrite) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
        this.statementRewrite = Objects.requireNonNull(statementRewrite, "statementRewrite is null");
    }

    public Analyzer createAnalyzer(Session session, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector) {
        return new Analyzer(session, this.metadata, this.sqlParser, this, this.groupProvider, this.accessControl, parameters, parameterLookup, warningCollector, this.statementRewrite);
    }
}

