/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.tree.DefaultExpressionTraversalVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class FreeLambdaReferenceExtractor {
    private FreeLambdaReferenceExtractor() {
    }

    public static boolean hasFreeReferencesToLambdaArgument(Node node, Analysis analysis) {
        return !FreeLambdaReferenceExtractor.getFreeReferencesToLambdaArgument(node, analysis).isEmpty();
    }

    public static List<Expression> getFreeReferencesToLambdaArgument(Node node, Analysis analysis) {
        Visitor visitor = new Visitor(analysis);
        visitor.process(node, ImmutableSet.of());
        return visitor.getFreeReferencesToLambdaArgument();
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<Set<String>> {
        private final Analysis analysis;
        private final ImmutableList.Builder<Expression> freeReferencesToLambdaArgument = ImmutableList.builder();

        private Visitor(Analysis analysis) {
            this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        }

        List<Expression> getFreeReferencesToLambdaArgument() {
            return this.freeReferencesToLambdaArgument.build();
        }

        protected Void visitIdentifier(Identifier node, Set<String> lambdaArgumentNames) {
            if (this.analysis.getLambdaArgumentReferences().containsKey(NodeRef.of((Node)node)) && !lambdaArgumentNames.contains(node.getValue())) {
                this.freeReferencesToLambdaArgument.add((Object)node);
            }
            return null;
        }

        protected Void visitLambdaExpression(LambdaExpression node, Set<String> lambdaArgumentNames) {
            return (Void)this.process((Node)node.getBody(), ImmutableSet.builder().addAll(lambdaArgumentNames).addAll((Iterable)node.getArguments().stream().map(LambdaArgumentDeclaration::getName).map(Identifier::getValue).collect(ImmutableSet.toImmutableSet())).build());
        }
    }
}

