/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import io.trino.Session;
import io.trino.cost.CostCalculator;
import io.trino.cost.StatsCalculator;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.ParameterUtils;
import io.trino.sql.SqlFormatter;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.QueryType;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanFragmenter;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.PlanOptimizersFactory;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.planprinter.IoPlanPrinter;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.DropSchema;
import io.trino.sql.tree.ExplainType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Prepare;
import io.trino.sql.tree.Statement;
import io.trino.util.StatementUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueryExplainer {
    private final List<PlanOptimizer> planOptimizers;
    private final PlanFragmenter planFragmenter;
    private final Metadata metadata;
    private final TypeOperators typeOperators;
    private final SqlParser sqlParser;
    private final AnalyzerFactory analyzerFactory;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;

    QueryExplainer(PlanOptimizersFactory planOptimizersFactory, PlanFragmenter planFragmenter, Metadata metadata, TypeOperators typeOperators, SqlParser sqlParser, AnalyzerFactory analyzerFactory, StatsCalculator statsCalculator, CostCalculator costCalculator) {
        this.planOptimizers = Objects.requireNonNull(planOptimizersFactory.get(), "planOptimizers is null");
        this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.analyzerFactory = Objects.requireNonNull(analyzerFactory, "analyzerFactory is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
    }

    public void validate(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector) {
        this.analyze(session, statement, parameters, warningCollector);
    }

    public String getPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector) {
        Optional<String> explain = QueryExplainer.explainDataDefinition(statement, parameters);
        if (explain.isPresent()) {
            return explain.get();
        }
        switch (planType) {
            case LOGICAL: {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.textLogicalPlan(plan.getRoot(), plan.getTypes(), this.metadata, plan.getStatsAndCosts(), session, 0, false);
            }
            case DISTRIBUTED: {
                SubPlan subPlan = this.getDistributedPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.textDistributedPlan(subPlan, this.metadata, session, false);
            }
            case IO: {
                return IoPlanPrinter.textIoPlan(this.getLogicalPlan(session, statement, parameters, warningCollector), this.metadata, this.typeOperators, session);
            }
        }
        throw new IllegalArgumentException("Unhandled plan type: " + planType);
    }

    public String getGraphvizPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector) {
        Optional<String> explain = QueryExplainer.explainDataDefinition(statement, parameters);
        if (explain.isPresent()) {
            return explain.get();
        }
        switch (planType) {
            case LOGICAL: {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.graphvizLogicalPlan(plan.getRoot(), plan.getTypes());
            }
            case DISTRIBUTED: {
                SubPlan subPlan = this.getDistributedPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.graphvizDistributedPlan(subPlan);
            }
        }
        throw new IllegalArgumentException("Unhandled plan type: " + planType);
    }

    public String getJsonPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector) {
        Optional<String> explain = QueryExplainer.explainDataDefinition(statement, parameters);
        if (explain.isPresent()) {
            return explain.get();
        }
        switch (planType) {
            case IO: {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector);
                return IoPlanPrinter.textIoPlan(plan, this.metadata, this.typeOperators, session);
            }
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported explain plan type %s for JSON format", planType));
    }

    public Plan getLogicalPlan(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector) {
        Analysis analysis = this.analyze(session, statement, parameters, warningCollector);
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        LogicalPlanner logicalPlanner = new LogicalPlanner(session, this.planOptimizers, idAllocator, this.metadata, this.typeOperators, new TypeAnalyzer(this.sqlParser, this.metadata), this.statsCalculator, this.costCalculator, warningCollector);
        return logicalPlanner.plan(analysis, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, true);
    }

    private Analysis analyze(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector) {
        Analyzer analyzer = this.analyzerFactory.createAnalyzer(session, parameters, ParameterUtils.parameterExtractor(statement, parameters), warningCollector);
        return analyzer.analyze(statement, QueryType.EXPLAIN);
    }

    private SubPlan getDistributedPlan(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector) {
        Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector);
        return this.planFragmenter.createSubPlans(session, plan, false, warningCollector);
    }

    private static <T extends Statement> Optional<String> explainDataDefinition(T statement, List<Expression> parameters) {
        if (!StatementUtils.isDataDefinitionStatement(statement.getClass())) {
            return Optional.empty();
        }
        if (statement instanceof CreateSchema) {
            return Optional.of("CREATE SCHEMA " + ((CreateSchema)statement).getSchemaName());
        }
        if (statement instanceof DropSchema) {
            return Optional.of("DROP SCHEMA " + ((DropSchema)statement).getSchemaName());
        }
        if (statement instanceof CreateTable) {
            return Optional.of("CREATE TABLE " + ((CreateTable)statement).getName());
        }
        if (statement instanceof CreateView) {
            return Optional.of("CREATE VIEW " + ((CreateView)statement).getName());
        }
        if (statement instanceof CreateMaterializedView) {
            return Optional.of("CREATE MATERIALIZED VIEW " + ((CreateMaterializedView)statement).getName());
        }
        if (statement instanceof Prepare) {
            return Optional.of("PREPARE " + ((Prepare)statement).getName());
        }
        StringBuilder builder = new StringBuilder();
        builder.append(SqlFormatter.formatSql(statement));
        if (!parameters.isEmpty()) {
            builder.append("\n").append("Parameters: ").append(parameters);
        }
        return Optional.of(builder.toString());
    }
}

