/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import io.trino.cost.CostCalculator;
import io.trino.cost.StatsCalculator;
import io.trino.metadata.Metadata;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.PlanFragmenter;
import io.trino.sql.planner.PlanOptimizersFactory;
import java.util.Objects;
import javax.inject.Inject;

public class QueryExplainerFactory {
    private final PlanOptimizersFactory planOptimizersFactory;
    private final PlanFragmenter planFragmenter;
    private final Metadata metadata;
    private final TypeOperators typeOperators;
    private final SqlParser sqlParser;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;

    @Inject
    public QueryExplainerFactory(PlanOptimizersFactory planOptimizersFactory, PlanFragmenter planFragmenter, Metadata metadata, TypeOperators typeOperators, SqlParser sqlParser, StatsCalculator statsCalculator, CostCalculator costCalculator) {
        this.planOptimizersFactory = Objects.requireNonNull(planOptimizersFactory, "planOptimizersFactory is null");
        this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
    }

    public QueryExplainer createQueryExplainer(AnalyzerFactory analyzerFactory) {
        return new QueryExplainer(this.planOptimizersFactory, this.planFragmenter, this.metadata, this.typeOperators, this.sqlParser, analyzerFactory, this.statsCalculator, this.costCalculator);
    }
}

