/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.reflect.TypeToken;
import io.trino.matching.Pattern;
import io.trino.matching.pattern.TypeOfPattern;
import io.trino.sql.planner.iterative.Rule;
import java.util.Set;
import java.util.stream.Stream;

public class RuleIndex {
    private final ListMultimap<Class<?>, Rule<?>> rulesByRootType;

    private RuleIndex(ListMultimap<Class<?>, Rule<?>> rulesByRootType) {
        this.rulesByRootType = ImmutableListMultimap.copyOf(rulesByRootType);
    }

    public Stream<Rule<?>> getCandidates(Object object) {
        return RuleIndex.supertypes(object.getClass()).flatMap(clazz -> this.rulesByRootType.get(clazz).stream());
    }

    private static Stream<Class<?>> supertypes(Class<?> type) {
        return TypeToken.of(type).getTypes().stream().map(TypeToken::getRawType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableListMultimap.Builder<Class<?>, Rule<?>> rulesByRootType = ImmutableListMultimap.builder();

        public Builder register(Set<Rule<?>> rules) {
            rules.forEach(this::register);
            return this;
        }

        public Builder register(Rule<?> rule) {
            Pattern<?> pattern = this.getFirstPattern(rule.getPattern());
            if (!(pattern instanceof TypeOfPattern)) {
                throw new IllegalArgumentException("Unexpected Pattern: " + pattern);
            }
            this.rulesByRootType.put((Object)((TypeOfPattern)pattern).expectedClass(), rule);
            return this;
        }

        private Pattern<?> getFirstPattern(Pattern<?> pattern) {
            while (pattern.previous().isPresent()) {
                pattern = (Pattern)pattern.previous().get();
            }
            return pattern;
        }

        public RuleIndex build() {
            return new RuleIndex((ListMultimap<Class<?>, Rule<?>>)this.rulesByRootType.build());
        }
    }
}

