/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushPredicateIntoTableScan;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RemoveRedundantTableScanPredicate
implements Rule<FilterNode> {
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));
    private final Metadata metadata;
    private final TypeAnalyzer typeAnalyzer;
    private final TypeOperators typeOperators;

    public RemoveRedundantTableScanPredicate(Metadata metadata, TypeOperators typeOperators, TypeAnalyzer typeAnalyzer) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
        TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
        PlanNode rewritten = this.removeRedundantTableScanPredicate(tableScan, filterNode.getPredicate(), context.getSession(), context.getSymbolAllocator(), context.getIdAllocator(), this.typeOperators);
        if (rewritten instanceof FilterNode && Objects.equals(((FilterNode)rewritten).getPredicate(), filterNode.getPredicate())) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(rewritten);
    }

    private PlanNode removeRedundantTableScanPredicate(TableScanNode node, Expression predicate, Session session, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, TypeOperators typeOperators) {
        Expression deterministicPredicate = ExpressionUtils.filterDeterministicConjuncts(this.metadata, predicate);
        Expression nonDeterministicPredicate = ExpressionUtils.filterNonDeterministicConjuncts(this.metadata, predicate);
        DomainTranslator.ExtractionResult decomposedPredicate = DomainTranslator.fromPredicate(this.metadata, typeOperators, session, deterministicPredicate, symbolAllocator.getTypes());
        TupleDomain predicateDomain = decomposedPredicate.getTupleDomain().transformKeys(node.getAssignments()::get);
        if (predicateDomain.isNone()) {
            return new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of());
        }
        if (node.getEnforcedConstraint().isNone()) {
            return new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of());
        }
        Map enforcedColumnDomains = (Map)node.getEnforcedConstraint().getDomains().orElseThrow();
        TupleDomain unenforcedDomain = predicateDomain.transformDomains((columnHandle, predicateColumnDomain) -> {
            Type type = predicateColumnDomain.getType();
            Domain enforcedColumnDomain = Optional.ofNullable((Domain)enforcedColumnDomains.get(columnHandle)).orElseGet(() -> Domain.all((Type)type));
            if (predicateColumnDomain.contains(enforcedColumnDomain)) {
                return Domain.all((Type)type);
            }
            return predicateColumnDomain.intersect(enforcedColumnDomain);
        });
        ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
        Expression resultingPredicate = PushPredicateIntoTableScan.createResultingPredicate(this.metadata, session, symbolAllocator, this.typeAnalyzer, new DomainTranslator(session, this.metadata).toPredicate((TupleDomain<Symbol>)unenforcedDomain.transformKeys(((Map)assignments)::get)), nonDeterministicPredicate, decomposedPredicate.getRemainingExpression());
        if (!BooleanLiteral.TRUE_LITERAL.equals((Object)resultingPredicate)) {
            return new FilterNode(idAllocator.getNextId(), node, resultingPredicate);
        }
        return node;
    }
}

