/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.PolymorphicScalarFunctionBuilder;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.JsonOperators;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalConversions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.UnscaledDecimal128Arithmetic;
import io.trino.spi.type.VarcharType;
import io.trino.type.JsonType;
import io.trino.util.Failures;
import io.trino.util.JsonCastException;
import io.trino.util.JsonUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;

public final class DecimalCasts {
    public static final SqlScalarFunction DECIMAL_TO_BOOLEAN_CAST = DecimalCasts.castFunctionFromDecimalTo(BooleanType.BOOLEAN.getTypeSignature(), "shortDecimalToBoolean", "longDecimalToBoolean");
    public static final SqlScalarFunction BOOLEAN_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(BooleanType.BOOLEAN.getTypeSignature(), "booleanToShortDecimal", "booleanToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_BIGINT_CAST = DecimalCasts.castFunctionFromDecimalTo(BigintType.BIGINT.getTypeSignature(), "shortDecimalToBigint", "longDecimalToBigint");
    public static final SqlScalarFunction BIGINT_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(BigintType.BIGINT.getTypeSignature(), "bigintToShortDecimal", "bigintToLongDecimal");
    public static final SqlScalarFunction INTEGER_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(IntegerType.INTEGER.getTypeSignature(), "integerToShortDecimal", "integerToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_INTEGER_CAST = DecimalCasts.castFunctionFromDecimalTo(IntegerType.INTEGER.getTypeSignature(), "shortDecimalToInteger", "longDecimalToInteger");
    public static final SqlScalarFunction SMALLINT_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(SmallintType.SMALLINT.getTypeSignature(), "smallintToShortDecimal", "smallintToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_SMALLINT_CAST = DecimalCasts.castFunctionFromDecimalTo(SmallintType.SMALLINT.getTypeSignature(), "shortDecimalToSmallint", "longDecimalToSmallint");
    public static final SqlScalarFunction TINYINT_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(TinyintType.TINYINT.getTypeSignature(), "tinyintToShortDecimal", "tinyintToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_TINYINT_CAST = DecimalCasts.castFunctionFromDecimalTo(TinyintType.TINYINT.getTypeSignature(), "shortDecimalToTinyint", "longDecimalToTinyint");
    public static final SqlScalarFunction DECIMAL_TO_DOUBLE_CAST = DecimalCasts.castFunctionFromDecimalTo(DoubleType.DOUBLE.getTypeSignature(), "shortDecimalToDouble", "longDecimalToDouble");
    public static final SqlScalarFunction DOUBLE_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(DoubleType.DOUBLE.getTypeSignature(), "doubleToShortDecimal", "doubleToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_REAL_CAST = DecimalCasts.castFunctionFromDecimalTo(RealType.REAL.getTypeSignature(), "shortDecimalToReal", "longDecimalToReal");
    public static final SqlScalarFunction REAL_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(RealType.REAL.getTypeSignature(), "realToShortDecimal", "realToLongDecimal");
    public static final SqlScalarFunction VARCHAR_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")}), "varcharToShortDecimal", "varcharToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_JSON_CAST = DecimalCasts.castFunctionFromDecimalTo(JsonType.JSON.getTypeSignature(), "shortDecimalToJson", "longDecimalToJson");
    public static final SqlScalarFunction JSON_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFromBuilder(JsonType.JSON.getTypeSignature(), true, "jsonToShortDecimal", "jsonToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_VARCHAR_CAST = new PolymorphicScalarFunctionBuilder(DecimalCasts.class).signature(Signature.builder().operatorType(OperatorType.CAST).argumentTypes(new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"precision"), TypeSignatureParameter.typeVariable((String)"scale")})).returnType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).build()).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods("shortDecimalToVarchar", "longDecimalToVarchar").withExtraParameters(context -> {
        long scale = context.getLiteral("scale");
        VarcharType resultType = (VarcharType)context.getReturnType();
        long length = resultType.isUnbounded() ? Integer.MAX_VALUE : (long)resultType.getBoundedLength();
        return ImmutableList.of((Object)scale, (Object)length);
    }))).build();

    private static SqlScalarFunction castFunctionFromDecimalTo(TypeSignature to, String ... methodNames) {
        Signature signature = Signature.builder().operatorType(OperatorType.CAST).argumentTypes(new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"precision"), TypeSignatureParameter.typeVariable((String)"scale")})).returnType(to).build();
        return new PolymorphicScalarFunctionBuilder(DecimalCasts.class).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(methodNames).withExtraParameters(context -> {
            long precision = context.getLiteral("precision");
            long scale = context.getLiteral("scale");
            Number tenToScale = Decimals.isShortDecimal((Type)context.getParameterTypes().get(0)) ? Long.valueOf(Decimals.longTenToNth((int)DecimalConversions.intScale((long)scale))) : Decimals.bigIntegerTenToNth((int)DecimalConversions.intScale((long)scale));
            return ImmutableList.of((Object)precision, (Object)scale, (Object)tenToScale);
        }))).build();
    }

    private static SqlScalarFunction castFunctionToDecimalFrom(TypeSignature from, String ... methodNames) {
        return DecimalCasts.castFunctionToDecimalFromBuilder(from, false, methodNames);
    }

    private static SqlScalarFunction castFunctionToDecimalFromBuilder(TypeSignature from, boolean nullableResult, String ... methodNames) {
        Signature signature = Signature.builder().operatorType(OperatorType.CAST).argumentTypes(from).returnType(new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"precision"), TypeSignatureParameter.typeVariable((String)"scale")})).build();
        return new PolymorphicScalarFunctionBuilder(DecimalCasts.class).signature(signature).nullableResult(nullableResult).deterministic(true).choice(choice -> choice.returnConvention(nullableResult ? InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN : InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL).implementation(methodsGroup -> methodsGroup.methods(methodNames).withExtraParameters(context -> {
            DecimalType resultType = (DecimalType)context.getReturnType();
            Number tenToScale = Decimals.isShortDecimal((Type)resultType) ? Long.valueOf(Decimals.longTenToNth((int)resultType.getScale())) : Decimals.bigIntegerTenToNth((int)resultType.getScale());
            return ImmutableList.of((Object)resultType.getPrecision(), (Object)resultType.getScale(), (Object)tenToScale);
        }))).build();
    }

    private DecimalCasts() {
    }

    @UsedByGeneratedCode
    public static boolean shortDecimalToBoolean(long decimal, long precision, long scale, long tenToScale) {
        return decimal != 0L;
    }

    @UsedByGeneratedCode
    public static boolean longDecimalToBoolean(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        return !Decimals.decodeUnscaledValue((Slice)decimal).equals(BigInteger.ZERO);
    }

    @UsedByGeneratedCode
    public static long booleanToShortDecimal(boolean value, long precision, long scale, long tenToScale) {
        return value ? tenToScale : 0L;
    }

    @UsedByGeneratedCode
    public static Slice booleanToLongDecimal(boolean value, long precision, long scale, BigInteger tenToScale) {
        return UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)(value ? tenToScale : BigInteger.ZERO));
    }

    @UsedByGeneratedCode
    public static long shortDecimalToBigint(long decimal, long precision, long scale, long tenToScale) {
        if (decimal >= 0L) {
            return (decimal + tenToScale / 2L) / tenToScale;
        }
        return -((-decimal + tenToScale / 2L) / tenToScale);
    }

    @UsedByGeneratedCode
    public static long longDecimalToBigint(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        try {
            return UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLong((Slice)UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)DecimalConversions.intScale((long)(-scale))));
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to BIGINT", Decimals.toString((Slice)decimal, (int)DecimalConversions.intScale((long)scale))));
        }
    }

    @UsedByGeneratedCode
    public static long bigintToShortDecimal(long value, long precision, long scale, long tenToScale) {
        try {
            long decimal = Math.multiplyExact(value, tenToScale);
            if (Decimals.overflows((long)decimal, (int)DecimalConversions.intScale((long)precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast BIGINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast BIGINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Slice bigintToLongDecimal(long value, long precision, long scale, BigInteger tenToScale) {
        try {
            Slice decimal = UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)tenToScale), (long)value);
            if (UnscaledDecimal128Arithmetic.overflows((Slice)decimal, (int)DecimalConversions.intScale((long)precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast BIGINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast BIGINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static long shortDecimalToInteger(long decimal, long precision, long scale, long tenToScale) {
        long longResult = (decimal + tenToScale / 2L) / tenToScale;
        if (decimal < 0L) {
            longResult = -((-decimal + tenToScale / 2L) / tenToScale);
        }
        try {
            return Math.toIntExact(longResult);
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to INTEGER", longResult));
        }
    }

    @UsedByGeneratedCode
    public static long longDecimalToInteger(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        try {
            return Math.toIntExact(UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLong((Slice)UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)DecimalConversions.intScale((long)(-scale)))));
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to INTEGER", Decimals.toString((Slice)decimal, (int)DecimalConversions.intScale((long)scale))));
        }
    }

    @UsedByGeneratedCode
    public static long integerToShortDecimal(long value, long precision, long scale, long tenToScale) {
        try {
            long decimal = Math.multiplyExact(value, tenToScale);
            if (Decimals.overflows((long)decimal, (int)DecimalConversions.intScale((long)precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast INTEGER '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast INTEGER '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Slice integerToLongDecimal(long value, long precision, long scale, BigInteger tenToScale) {
        try {
            Slice decimal = UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)tenToScale), (long)value);
            if (UnscaledDecimal128Arithmetic.overflows((Slice)decimal, (int)DecimalConversions.intScale((long)precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast INTEGER '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast INTEGER '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static long shortDecimalToSmallint(long decimal, long precision, long scale, long tenToScale) {
        long longResult = (decimal + tenToScale / 2L) / tenToScale;
        if (decimal < 0L) {
            longResult = -((-decimal + tenToScale / 2L) / tenToScale);
        }
        try {
            return Shorts.checkedCast((long)longResult);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to SMALLINT", longResult));
        }
    }

    @UsedByGeneratedCode
    public static long longDecimalToSmallint(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        try {
            return Shorts.checkedCast((long)UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLong((Slice)UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)DecimalConversions.intScale((long)(-scale)))));
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to SMALLINT", Decimals.toString((Slice)decimal, (int)DecimalConversions.intScale((long)scale))));
        }
    }

    @UsedByGeneratedCode
    public static long smallintToShortDecimal(long value, long precision, long scale, long tenToScale) {
        try {
            long decimal = Math.multiplyExact(value, tenToScale);
            if (Decimals.overflows((long)decimal, (int)DecimalConversions.intScale((long)precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast SMALLINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast SMALLINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Slice smallintToLongDecimal(long value, long precision, long scale, BigInteger tenToScale) {
        try {
            Slice decimal = UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)tenToScale), (long)value);
            if (UnscaledDecimal128Arithmetic.overflows((Slice)decimal, (int)DecimalConversions.intScale((long)precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast SMALLINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast SMALLINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static long shortDecimalToTinyint(long decimal, long precision, long scale, long tenToScale) {
        long longResult = (decimal + tenToScale / 2L) / tenToScale;
        if (decimal < 0L) {
            longResult = -((-decimal + tenToScale / 2L) / tenToScale);
        }
        try {
            return SignedBytes.checkedCast((long)longResult);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to TINYINT", longResult));
        }
    }

    @UsedByGeneratedCode
    public static long longDecimalToTinyint(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        try {
            return SignedBytes.checkedCast((long)UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLong((Slice)UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)DecimalConversions.intScale((long)(-scale)))));
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to TINYINT", Decimals.toString((Slice)decimal, (int)DecimalConversions.intScale((long)scale))));
        }
    }

    @UsedByGeneratedCode
    public static long tinyintToShortDecimal(long value, long precision, long scale, long tenToScale) {
        try {
            long decimal = Math.multiplyExact(value, tenToScale);
            if (Decimals.overflows((long)decimal, (int)DecimalConversions.intScale((long)precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast TINYINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast TINYINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Slice tinyintToLongDecimal(long value, long precision, long scale, BigInteger tenToScale) {
        try {
            Slice decimal = UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)tenToScale), (long)value);
            if (UnscaledDecimal128Arithmetic.overflows((Slice)decimal, (int)DecimalConversions.intScale((long)precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast TINYINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast TINYINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static double shortDecimalToDouble(long decimal, long precision, long scale, long tenToScale) {
        return (double)decimal / (double)tenToScale;
    }

    @UsedByGeneratedCode
    public static double longDecimalToDouble(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        return DecimalConversions.longDecimalToDouble((Slice)decimal, (long)scale);
    }

    @UsedByGeneratedCode
    public static long shortDecimalToReal(long decimal, long precision, long scale, long tenToScale) {
        return DecimalConversions.shortDecimalToReal((long)decimal, (long)tenToScale);
    }

    @UsedByGeneratedCode
    public static long longDecimalToReal(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        return DecimalConversions.longDecimalToReal((Slice)decimal, (long)scale);
    }

    @UsedByGeneratedCode
    public static long doubleToShortDecimal(double value, long precision, long scale, long tenToScale) {
        return DecimalConversions.doubleToShortDecimal((double)value, (long)precision, (long)scale);
    }

    @UsedByGeneratedCode
    public static Slice doubleToLongDecimal(double value, long precision, long scale, BigInteger tenToScale) {
        return DecimalConversions.doubleToLongDecimal((double)value, (long)precision, (long)scale);
    }

    @UsedByGeneratedCode
    public static long realToShortDecimal(long value, long precision, long scale, long tenToScale) {
        return DecimalConversions.realToShortDecimal((long)value, (long)precision, (long)scale);
    }

    @UsedByGeneratedCode
    public static Slice realToLongDecimal(long value, long precision, long scale, BigInteger tenToScale) {
        return DecimalConversions.realToLongDecimal((long)value, (long)precision, (long)scale);
    }

    @UsedByGeneratedCode
    public static Slice shortDecimalToVarchar(long decimal, long scale, long varcharLength) {
        String stringValue = Decimals.toString((long)decimal, (int)DecimalConversions.intScale((long)scale));
        if ((long)stringValue.length() <= varcharLength) {
            return Slices.utf8Slice((String)stringValue);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Value %s cannot be represented as varchar(%s)", stringValue, varcharLength));
    }

    @UsedByGeneratedCode
    public static Slice longDecimalToVarchar(Slice decimal, long scale, long varcharLength) {
        String stringValue = Decimals.toString((Slice)decimal, (int)DecimalConversions.intScale((long)scale));
        if ((long)stringValue.length() <= varcharLength) {
            return Slices.utf8Slice((String)stringValue);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Value %s cannot be represented as varchar(%s)", stringValue, varcharLength));
    }

    @UsedByGeneratedCode
    public static long varcharToShortDecimal(Slice value, long precision, long scale, long tenToScale) {
        BigDecimal result;
        String stringValue = value.toString(StandardCharsets.UTF_8);
        try {
            result = new BigDecimal(stringValue).setScale(DecimalConversions.intScale((long)scale), RoundingMode.HALF_UP);
        }
        catch (NumberFormatException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast VARCHAR '%s' to DECIMAL(%s, %s). Value is not a number.", stringValue, precision, scale));
        }
        if (Decimals.overflows((BigDecimal)result, (long)precision)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast VARCHAR '%s' to DECIMAL(%s, %s). Value too large.", stringValue, precision, scale));
        }
        return result.unscaledValue().longValue();
    }

    @UsedByGeneratedCode
    public static Slice varcharToLongDecimal(Slice value, long precision, long scale, BigInteger tenToScale) {
        BigDecimal result;
        String stringValue = value.toString(StandardCharsets.UTF_8);
        try {
            result = new BigDecimal(stringValue).setScale(DecimalConversions.intScale((long)scale), RoundingMode.HALF_UP);
        }
        catch (NumberFormatException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast VARCHAR '%s' to DECIMAL(%s, %s). Value is not a number.", stringValue, precision, scale));
        }
        if (Decimals.overflows((BigDecimal)result, (long)precision)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast VARCHAR '%s' to DECIMAL(%s, %s). Value too large.", stringValue, precision, scale));
        }
        return Decimals.encodeUnscaledValue((BigInteger)result.unscaledValue());
    }

    @UsedByGeneratedCode
    public static Slice shortDecimalToJson(long decimal, long precision, long scale, long tenToScale) {
        return DecimalCasts.decimalToJson(BigDecimal.valueOf(decimal, DecimalConversions.intScale((long)scale)));
    }

    @UsedByGeneratedCode
    public static Slice longDecimalToJson(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        return DecimalCasts.decimalToJson(new BigDecimal(Decimals.decodeUnscaledValue((Slice)decimal), DecimalConversions.intScale((long)scale)));
    }

    private static Slice decimalToJson(BigDecimal bigDecimal) {
        try {
            DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(32);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JsonOperators.JSON_FACTORY, (SliceOutput)dynamicSliceOutput);){
                jsonGenerator.writeNumber(bigDecimal);
            }
            return dynamicSliceOutput.slice();
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%f' to %s", bigDecimal, "json"));
        }
    }

    @UsedByGeneratedCode
    public static Slice jsonToLongDecimal(Slice json, long precision, long scale, BigInteger tenToScale) {
        Slice slice;
        block8: {
            JsonParser parser = JsonUtil.createJsonParser(JsonOperators.JSON_FACTORY, json);
            try {
                parser.nextToken();
                Slice result = JsonUtil.currentTokenAsLongDecimal(parser, DecimalCasts.intPrecision(precision), DecimalConversions.intScale((long)scale));
                Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to DECIMAL(%s,%s)", precision, scale);
                slice = result;
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonCastException | IOException | NumberFormatException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to DECIMAL(%s,%s)", json.toStringUtf8(), precision, scale), (Throwable)e);
                }
            }
            parser.close();
        }
        return slice;
    }

    @UsedByGeneratedCode
    public static Long jsonToShortDecimal(Slice json, long precision, long scale, long tenToScale) {
        Long l;
        block8: {
            JsonParser parser = JsonUtil.createJsonParser(JsonOperators.JSON_FACTORY, json);
            try {
                parser.nextToken();
                Long result = JsonUtil.currentTokenAsShortDecimal(parser, DecimalCasts.intPrecision(precision), DecimalConversions.intScale((long)scale));
                Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to DECIMAL(%s,%s)", precision, scale);
                l = result;
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonCastException | IOException | NumberFormatException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to DECIMAL(%s,%s)", json.toStringUtf8(), precision, scale), (Throwable)e);
                }
            }
            parser.close();
        }
        return l;
    }

    private static int intPrecision(long precision) {
        return (int)precision;
    }
}

