/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.ColumnarTestUtils;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarMap;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.MapType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestColumnarMap {
    private static final int[] MAP_SIZES = new int[]{16, 0, 13, 1, 2, 11, 4, 7};

    @Test
    public void test() {
        Slice[][][] expectedValues = new Slice[MAP_SIZES.length][][];
        for (int mapIndex = 0; mapIndex < MAP_SIZES.length; ++mapIndex) {
            expectedValues[mapIndex] = new Slice[MAP_SIZES[mapIndex]][];
            for (int entryIndex = 0; entryIndex < MAP_SIZES[mapIndex]; ++entryIndex) {
                Slice[] entry = new Slice[2];
                entry[0] = Slices.utf8Slice((String)String.format("key.%d.%d", mapIndex, entryIndex));
                if (entryIndex % 3 != 1) {
                    entry[1] = Slices.utf8Slice((String)String.format("value.%d.%d", mapIndex, entryIndex));
                }
                expectedValues[mapIndex][entryIndex] = entry;
            }
        }
        BlockBuilder blockBuilder = TestColumnarMap.createBlockBuilderWithValues(expectedValues);
        TestColumnarMap.verifyBlock((Block)blockBuilder, expectedValues);
        TestColumnarMap.verifyBlock(blockBuilder.build(), expectedValues);
        Slice[][][] expectedValuesWithNull = (Slice[][][])ColumnarTestUtils.alternatingNullValues(expectedValues);
        BlockBuilder blockBuilderWithNull = TestColumnarMap.createBlockBuilderWithValues(expectedValuesWithNull);
        TestColumnarMap.verifyBlock((Block)blockBuilderWithNull, expectedValuesWithNull);
        TestColumnarMap.verifyBlock(blockBuilderWithNull.build(), expectedValuesWithNull);
    }

    private static void verifyBlock(Block block, Slice[][][] expectedValues) {
        ColumnarTestUtils.assertBlock(block, expectedValues);
        TestColumnarMap.assertColumnarMap(block, expectedValues);
        TestColumnarMap.assertDictionaryBlock(block, expectedValues);
        TestColumnarMap.assertRunLengthEncodedBlock(block, expectedValues);
        int offset = 1;
        int length = expectedValues.length - 2;
        Block blockRegion = block.getRegion(offset, length);
        Slice[][][] expectedValuesRegion = (Slice[][][])Arrays.copyOfRange(expectedValues, offset, offset + length);
        ColumnarTestUtils.assertBlock(blockRegion, expectedValuesRegion);
        TestColumnarMap.assertColumnarMap(blockRegion, expectedValuesRegion);
        TestColumnarMap.assertDictionaryBlock(blockRegion, expectedValuesRegion);
        TestColumnarMap.assertRunLengthEncodedBlock(blockRegion, expectedValuesRegion);
    }

    private static void assertDictionaryBlock(Block block, Slice[][][] expectedValues) {
        DictionaryBlock dictionaryBlock = ColumnarTestUtils.createTestDictionaryBlock(block);
        Slice[][][] expectedDictionaryValues = (Slice[][][])ColumnarTestUtils.createTestDictionaryExpectedValues(expectedValues);
        ColumnarTestUtils.assertBlock((Block)dictionaryBlock, expectedDictionaryValues);
        TestColumnarMap.assertColumnarMap((Block)dictionaryBlock, expectedDictionaryValues);
        TestColumnarMap.assertRunLengthEncodedBlock((Block)dictionaryBlock, expectedDictionaryValues);
    }

    private static void assertRunLengthEncodedBlock(Block block, Slice[][][] expectedValues) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            RunLengthEncodedBlock runLengthEncodedBlock = ColumnarTestUtils.createTestRleBlock(block, position);
            Slice[][][] expectedDictionaryValues = (Slice[][][])ColumnarTestUtils.createTestRleExpectedValues(expectedValues, position);
            ColumnarTestUtils.assertBlock((Block)runLengthEncodedBlock, expectedDictionaryValues);
            TestColumnarMap.assertColumnarMap((Block)runLengthEncodedBlock, expectedDictionaryValues);
        }
    }

    private static void assertColumnarMap(Block block, Slice[][][] expectedValues) {
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
        Assert.assertEquals((int)columnarMap.getPositionCount(), (int)expectedValues.length);
        Block keysBlock = columnarMap.getKeysBlock();
        Block valuesBlock = columnarMap.getValuesBlock();
        int elementsPosition = 0;
        for (int position = 0; position < expectedValues.length; ++position) {
            Slice[][] expectedMap = expectedValues[position];
            Assert.assertEquals((boolean)columnarMap.isNull(position), (expectedMap == null ? 1 : 0) != 0);
            if (expectedMap == null) {
                Assert.assertEquals((int)columnarMap.getEntryCount(position), (int)0);
                continue;
            }
            Assert.assertEquals((int)columnarMap.getEntryCount(position), (int)expectedMap.length);
            Assert.assertEquals((int)columnarMap.getOffset(position), (int)elementsPosition);
            for (int i = 0; i < columnarMap.getEntryCount(position); ++i) {
                Slice[] expectedEntry = expectedMap[i];
                Slice expectedKey = expectedEntry[0];
                ColumnarTestUtils.assertBlockPosition(keysBlock, elementsPosition, expectedKey);
                Slice expectedValue = expectedEntry[1];
                ColumnarTestUtils.assertBlockPosition(valuesBlock, elementsPosition, expectedValue);
                ++elementsPosition;
            }
        }
    }

    public static BlockBuilder createBlockBuilderWithValues(Slice[][][] expectedValues) {
        BlockBuilder blockBuilder = TestColumnarMap.createMapBuilder(100);
        for (Slice[][] expectedMap : expectedValues) {
            if (expectedMap == null) {
                blockBuilder.appendNull();
                continue;
            }
            BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
            VarcharType.VARCHAR.createBlockBuilder(null, expectedMap.length);
            for (Slice[] entry : expectedMap) {
                Slice key = entry[0];
                Assert.assertNotNull((Object)key);
                VarcharType.VARCHAR.writeSlice(entryBuilder, key);
                Slice value = entry[1];
                if (value == null) {
                    entryBuilder.appendNull();
                    continue;
                }
                VarcharType.VARCHAR.writeSlice(entryBuilder, value);
            }
            blockBuilder.closeEntry();
        }
        return blockBuilder;
    }

    private static BlockBuilder createMapBuilder(int expectedEntries) {
        MapType mapType = (MapType)InternalTypeManager.TESTING_TYPE_MANAGER.getType(new TypeSignature("map", new TypeSignatureParameter[]{TypeSignatureParameter.typeParameter((TypeSignature)VarcharType.VARCHAR.getTypeSignature()), TypeSignatureParameter.typeParameter((TypeSignature)VarcharType.VARCHAR.getTypeSignature())}));
        return new MapBlockBuilder(mapType, null, expectedEntries);
    }

    public static long blockVarcharHashCode(Block block, int position) {
        return block.hash(position, 0, block.getSliceLength(position));
    }
}

