/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import io.airlift.slice.Slice;
import io.trino.block.AbstractTestBlock;
import io.trino.block.BlockAssertions;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.DictionaryId;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDictionaryBlock
extends AbstractTestBlock {
    @Test
    public void testSizeInBytes() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        Assert.assertEquals((long)dictionaryBlock.getSizeInBytes(), (long)(dictionaryBlock.getDictionary().getSizeInBytes() + 400L));
    }

    @Test
    public void testLogicalSizeInBytes() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        Assert.assertEquals((long)dictionaryBlock.getDictionary().getLogicalSizeInBytes(), (long)95L);
        Assert.assertEquals((long)dictionaryBlock.getLogicalSizeInBytes(), (long)950L);
        dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(TestDictionaryBlock.alternatingNullValues(expectedValues), 210);
        Assert.assertEquals((int)dictionaryBlock.getDictionary().getPositionCount(), (int)21);
        Assert.assertEquals((long)dictionaryBlock.getDictionary().getLogicalSizeInBytes(), (long)150L);
        Assert.assertEquals((long)dictionaryBlock.getLogicalSizeInBytes(), (long)1500L);
    }

    @Test
    public void testCopyRegionCreatesCompactBlock() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        DictionaryBlock copyRegionDictionaryBlock = (DictionaryBlock)dictionaryBlock.copyRegion(1, 3);
        Assert.assertTrue((boolean)copyRegionDictionaryBlock.isCompact());
    }

    @Test
    public void testCopyRegionUnwrapping() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        io.airlift.testing.Assertions.assertInstanceOf((Object)dictionaryBlock.copyRegion(0, 0), VariableWidthBlock.class);
        io.airlift.testing.Assertions.assertInstanceOf((Object)dictionaryBlock.copyRegion(0, 1), VariableWidthBlock.class);
        DictionaryBlock compactSequentialDictionary = TestDictionaryBlock.createDictionaryBlock(expectedValues, expectedValues.length);
        Assert.assertTrue((boolean)compactSequentialDictionary.isCompact());
        io.airlift.testing.Assertions.assertInstanceOf((Object)compactSequentialDictionary.copyRegion(0, 5), VariableWidthBlock.class);
        DictionaryBlock outerDictionary = new DictionaryBlock((Block)compactSequentialDictionary, new int[]{1, 3, 5, 7});
        Assert.assertFalse((boolean)outerDictionary.isCompact());
        io.airlift.testing.Assertions.assertInstanceOf((Object)outerDictionary.copyRegion(1, 2), VariableWidthBlock.class);
        Block innermostRawBlock = BlockAssertions.createSlicesBlock(expectedValues);
        DictionaryBlock firstDictionary = new DictionaryBlock(innermostRawBlock, new int[]{0, 1, 1, 7, 7, 5, 3});
        DictionaryBlock secondDictionary = new DictionaryBlock((Block)firstDictionary, new int[]{3, 1, 1, 2});
        DictionaryBlock thirdDictionary = new DictionaryBlock((Block)secondDictionary, new int[]{0, 0, 0, 2});
        io.airlift.testing.Assertions.assertInstanceOf((Object)thirdDictionary.copyRegion(0, 2), DictionaryBlock.class);
        io.airlift.testing.Assertions.assertInstanceOf((Object)((DictionaryBlock)thirdDictionary.copyRegion(0, 2)).getDictionary(), VariableWidthBlock.class);
        Assert.assertFalse((boolean)firstDictionary.isCompact());
        Assert.assertFalse((boolean)secondDictionary.isCompact());
        Assert.assertFalse((boolean)thirdDictionary.isCompact());
        io.airlift.testing.Assertions.assertInstanceOf((Object)thirdDictionary.copyRegion(0, 2), DictionaryBlock.class);
        io.airlift.testing.Assertions.assertInstanceOf((Object)((DictionaryBlock)thirdDictionary.copyRegion(0, 2)).getDictionary(), VariableWidthBlock.class);
    }

    @Test
    public void testCopyPositionsWithCompaction() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        Slice firstExpectedValue = expectedValues[0];
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        int[] positionsToCopy = new int[]{0, 10, 20, 30, 40};
        DictionaryBlock copiedBlock = (DictionaryBlock)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length);
        Assert.assertEquals((int)copiedBlock.getDictionary().getPositionCount(), (int)1);
        Assert.assertEquals((int)copiedBlock.getPositionCount(), (int)positionsToCopy.length);
        this.assertBlock(copiedBlock.getDictionary(), TestDictionaryBlock::createBlockBuilder, new Slice[]{firstExpectedValue});
        this.assertBlock((Block)copiedBlock, TestDictionaryBlock::createBlockBuilder, new Slice[]{firstExpectedValue, firstExpectedValue, firstExpectedValue, firstExpectedValue, firstExpectedValue});
    }

    @Test
    public void testCopyPositionsWithCompactionsAndReorder() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        int[] positionsToCopy = new int[]{50, 55, 40, 45, 60};
        DictionaryBlock copiedBlock = (DictionaryBlock)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length);
        Assert.assertEquals((int)copiedBlock.getDictionary().getPositionCount(), (int)2);
        Assert.assertEquals((int)copiedBlock.getPositionCount(), (int)positionsToCopy.length);
        this.assertBlock(copiedBlock.getDictionary(), TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[0], expectedValues[5]});
        TestDictionaryBlock.assertDictionaryIds(copiedBlock, 0, 1, 0, 1, 0);
    }

    @Test
    public void testCopyPositionsSamePosition() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        int[] positionsToCopy = new int[]{52, 52, 52};
        DictionaryBlock copiedBlock = (DictionaryBlock)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length);
        Assert.assertEquals((int)copiedBlock.getDictionary().getPositionCount(), (int)1);
        Assert.assertEquals((int)copiedBlock.getPositionCount(), (int)positionsToCopy.length);
        this.assertBlock(copiedBlock.getDictionary(), TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[2]});
        TestDictionaryBlock.assertDictionaryIds(copiedBlock, 0, 0, 0);
    }

    @Test
    public void testCopyPositionsNoCompaction() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(1);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        int[] positionsToCopy = new int[]{0, 2, 4, 5};
        DictionaryBlock copiedBlock = (DictionaryBlock)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length);
        Assert.assertEquals((int)copiedBlock.getPositionCount(), (int)positionsToCopy.length);
        this.assertBlock(copiedBlock.getDictionary(), TestDictionaryBlock::createBlockBuilder, expectedValues);
    }

    @Test
    public void testCopyPositionsUnwrapping() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        Assert.assertTrue((boolean)dictionaryBlock.isCompact());
        io.airlift.testing.Assertions.assertInstanceOf((Object)dictionaryBlock.copyPositions(new int[0], 0, 0), VariableWidthBlock.class);
        io.airlift.testing.Assertions.assertInstanceOf((Object)dictionaryBlock.copyPositions(new int[1], 0, 1), VariableWidthBlock.class);
        int[] positionsToCopy = new int[]{9, 7, 5, 3, 2, 1, 0};
        io.airlift.testing.Assertions.assertInstanceOf((Object)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length), VariableWidthBlock.class);
        DictionaryBlock compactSequentialDictionary = TestDictionaryBlock.createDictionaryBlock(expectedValues, expectedValues.length);
        Assert.assertTrue((boolean)compactSequentialDictionary.isCompact());
        io.airlift.testing.Assertions.assertInstanceOf((Object)compactSequentialDictionary.copyPositions(positionsToCopy, 0, positionsToCopy.length), VariableWidthBlock.class);
        DictionaryBlock outerDictionary = new DictionaryBlock((Block)compactSequentialDictionary, new int[]{1, 3, 5, 7, 9});
        Assert.assertFalse((boolean)outerDictionary.isCompact());
        positionsToCopy = new int[]{0, 3, 2};
        io.airlift.testing.Assertions.assertInstanceOf((Object)outerDictionary.copyPositions(positionsToCopy, 0, positionsToCopy.length), VariableWidthBlock.class);
        Block innermostRawBlock = BlockAssertions.createSlicesBlock(expectedValues);
        DictionaryBlock firstDictionary = new DictionaryBlock(innermostRawBlock, new int[]{0, 1, 1, 7, 7, 5, 3});
        DictionaryBlock secondDictionary = new DictionaryBlock((Block)firstDictionary, new int[]{3, 1, 1, 2});
        DictionaryBlock thirdDictionary = new DictionaryBlock((Block)secondDictionary, new int[]{0, 0, 0, 2});
        positionsToCopy = new int[]{2, 1, 0};
        io.airlift.testing.Assertions.assertInstanceOf((Object)thirdDictionary.copyPositions(positionsToCopy, 0, 2), DictionaryBlock.class);
        io.airlift.testing.Assertions.assertInstanceOf((Object)((DictionaryBlock)thirdDictionary.copyPositions(positionsToCopy, 0, 2)).getDictionary(), VariableWidthBlock.class);
        Assert.assertFalse((boolean)firstDictionary.isCompact());
        Assert.assertFalse((boolean)secondDictionary.isCompact());
        Assert.assertFalse((boolean)thirdDictionary.isCompact());
        io.airlift.testing.Assertions.assertInstanceOf((Object)thirdDictionary.copyPositions(positionsToCopy, 0, 2), DictionaryBlock.class);
        io.airlift.testing.Assertions.assertInstanceOf((Object)((DictionaryBlock)thirdDictionary.copyPositions(positionsToCopy, 0, 2)).getDictionary(), VariableWidthBlock.class);
    }

    @Test
    public void testCompact() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(5);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlockWithUnreferencedKeys(expectedValues, 10);
        Assert.assertEquals((boolean)dictionaryBlock.isCompact(), (boolean)false);
        DictionaryBlock compactBlock = dictionaryBlock.compact();
        Assert.assertNotEquals((Object)dictionaryBlock.getDictionarySourceId(), (Object)compactBlock.getDictionarySourceId());
        Assert.assertEquals((int)compactBlock.getDictionary().getPositionCount(), (int)(expectedValues.length / 2 + 1));
        this.assertBlock(compactBlock.getDictionary(), TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[0], expectedValues[1], expectedValues[3]});
        TestDictionaryBlock.assertDictionaryIds(compactBlock, 0, 1, 1, 2, 2, 0, 1, 1, 2, 2);
        Assert.assertEquals((boolean)compactBlock.isCompact(), (boolean)true);
        DictionaryBlock reCompactedBlock = compactBlock.compact();
        Assert.assertEquals((Object)reCompactedBlock.getDictionarySourceId(), (Object)compactBlock.getDictionarySourceId());
    }

    @Test
    public void testNestedCompact() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        Block valuesBlock = BlockAssertions.createSlicesBlock(expectedValues);
        DictionaryBlock deeplyNestedDictionary = new DictionaryBlock(valuesBlock, new int[]{0, 1, 2, 2, 4, 5});
        DictionaryBlock nestedDictionary = new DictionaryBlock((Block)deeplyNestedDictionary, new int[]{0, 1, 2, 3, 4, 5});
        DictionaryBlock dictionary = new DictionaryBlock((Block)nestedDictionary, new int[]{2, 3, 2, 0});
        DictionaryBlock dictionaryWithAllPositionsUsed = new DictionaryBlock((Block)nestedDictionary, new int[]{0, 1, 2, 3, 4, 5});
        Assert.assertEquals((long)dictionary.getSizeInBytes(), (long)(valuesBlock.getPositionsSizeInBytes(new boolean[]{true, false, true, false, false, false}) + 16L));
        Assert.assertFalse((boolean)dictionary.isCompact());
        Assert.assertEquals((long)dictionaryWithAllPositionsUsed.getSizeInBytes(), (long)(valuesBlock.getPositionsSizeInBytes(new boolean[]{true, true, true, false, true, true}) + 24L));
        Assert.assertFalse((boolean)dictionaryWithAllPositionsUsed.isCompact());
        DictionaryBlock compactBlock = dictionary.compact();
        this.assertBlock(compactBlock.getDictionary(), TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[2], expectedValues[0]});
        TestDictionaryBlock.assertDictionaryIds(compactBlock, 0, 0, 0, 1);
        io.airlift.testing.Assertions.assertInstanceOf((Object)compactBlock.getDictionary(), VariableWidthBlock.class);
    }

    @Test
    public void testCompactAllKeysReferenced() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(5);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 10);
        DictionaryBlock compactBlock = dictionaryBlock.compact();
        Assert.assertEquals((Object)compactBlock.getDictionary(), (Object)dictionaryBlock.getDictionary());
        Assert.assertEquals((int)compactBlock.getPositionCount(), (int)dictionaryBlock.getPositionCount());
        for (int position = 0; position < compactBlock.getPositionCount(); ++position) {
            Assert.assertEquals((int)compactBlock.getId(position), (int)dictionaryBlock.getId(position));
        }
        Assert.assertEquals((boolean)compactBlock.isCompact(), (boolean)true);
    }

    @Test
    public void testBasicGetPositions() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = new DictionaryBlock(BlockAssertions.createSlicesBlock(expectedValues), new int[]{0, 1, 2, 3, 4, 5});
        this.assertBlock((Block)dictionaryBlock, TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[0], expectedValues[1], expectedValues[2], expectedValues[3], expectedValues[4], expectedValues[5]});
        DictionaryId dictionaryId = dictionaryBlock.getDictionarySourceId();
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{0, 8, 1, 2, 4, 5, 7, 9}, 2, 4);
        this.assertBlock((Block)dictionaryBlock, TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[1], expectedValues[2], expectedValues[4], expectedValues[5]});
        Assert.assertEquals((Object)dictionaryBlock.getDictionarySourceId(), (Object)dictionaryId);
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{0, 1, 3, 0, 0}, 0, 3);
        this.assertBlock((Block)dictionaryBlock, TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[1], expectedValues[2], expectedValues[5]});
        Assert.assertEquals((Object)dictionaryBlock.getDictionarySourceId(), (Object)dictionaryId);
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{-1, -1, 0, 1, 2}, 2, 3);
        this.assertBlock((Block)dictionaryBlock, TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[1], expectedValues[2], expectedValues[5]});
        Assert.assertEquals((Object)dictionaryBlock.getDictionarySourceId(), (Object)dictionaryId);
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{0, 2, 2}, 0, 3);
        this.assertBlock((Block)dictionaryBlock, TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[1], expectedValues[5], expectedValues[5]});
        Assert.assertEquals((Object)dictionaryBlock.getDictionarySourceId(), (Object)dictionaryId);
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{1, 1, 1, 1, 1}, 0, 5);
        this.assertBlock((Block)dictionaryBlock, TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[5], expectedValues[5], expectedValues[5], expectedValues[5], expectedValues[5]});
        Assert.assertEquals((Object)dictionaryBlock.getDictionarySourceId(), (Object)dictionaryId);
        DictionaryBlock finalDictionaryBlock = dictionaryBlock;
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)-1, (Object)6).iterator();
        while (unmodifiableIterator.hasNext()) {
            int position = (Integer)unmodifiableIterator.next();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDictionaryBlock.lambda$testBasicGetPositions$0((Block)finalDictionaryBlock, position)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position %d in block with %d positions", new Object[]{position, finalDictionaryBlock.getPositionCount()});
        }
        unmodifiableIterator = ImmutableList.of((Object)-1, (Object)6).iterator();
        while (unmodifiableIterator.hasNext()) {
            int offset = (Integer)unmodifiableIterator.next();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDictionaryBlock.lambda$testBasicGetPositions$1((Block)finalDictionaryBlock, offset)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessage("Invalid offset %d and length 1 in array with 1 elements", new Object[]{offset});
        }
        unmodifiableIterator = ImmutableList.of((Object)-1, (Object)6).iterator();
        while (unmodifiableIterator.hasNext()) {
            int length = (Integer)unmodifiableIterator.next();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDictionaryBlock.lambda$testBasicGetPositions$2((Block)finalDictionaryBlock, length)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessage("Invalid offset 0 and length %d in array with 1 elements", new Object[]{length});
        }
    }

    @Test
    public void testCompactGetPositions() {
        DictionaryBlock block = new DictionaryBlock(BlockAssertions.createSlicesBlock(TestDictionaryBlock.createExpectedValues(10)), new int[]{0, 1, 2, 3, 4, 5}).compact();
        block = (DictionaryBlock)block.getPositions(new int[]{3, 3, 4, 5, 2, 0, 1, 1}, 0, 7);
        Assert.assertTrue((boolean)block.isCompact());
        block = (DictionaryBlock)block.getPositions(new int[]{0, 1, 2, 3, 4, 5, 6, 6, 5, 4, 3, 2, 1}, 0, 12);
        Assert.assertTrue((boolean)block.isCompact());
        block = (DictionaryBlock)block.getPositions(new int[]{0, 2, 0, 2, 0}, 0, 5);
        Assert.assertFalse((boolean)block.isCompact());
        block = block.compact();
        block = (DictionaryBlock)block.getPositions(new int[]{0, 1, 1, 1}, 0, 4);
        Assert.assertTrue((boolean)block.isCompact());
        block = (DictionaryBlock)block.getPositions(new int[]{1, 1, 1, 1}, 0, 4);
        Assert.assertFalse((boolean)block.isCompact());
        block = block.compact();
        block = (DictionaryBlock)block.getPositions(new int[]{0}, 0, 1);
        Assert.assertTrue((boolean)block.isCompact());
        block = (DictionaryBlock)block.getPositions(new int[0], 0, 0);
        Assert.assertFalse((boolean)block.isCompact());
        block = block.compact();
        block = (DictionaryBlock)block.getPositions(new int[0], 0, 0);
        Assert.assertTrue((boolean)block.isCompact());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        int positionCount = 10;
        int dictionaryPositionCount = 100;
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(positionCount);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, dictionaryPositionCount);
        for (int position = 0; position < dictionaryPositionCount; ++position) {
            Assert.assertEquals((long)dictionaryBlock.getEstimatedDataSizeForStats(position), (long)expectedValues[position % positionCount].length());
        }
    }

    private static DictionaryBlock createDictionaryBlockWithUnreferencedKeys(Slice[] expectedValues, int positionCount) {
        int dictionarySize = expectedValues.length;
        int[] ids = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            int index = i % dictionarySize;
            if (index % 2 != 0 || index != 0) {
                // empty if block
            }
            ids[i] = --index;
        }
        return new DictionaryBlock(BlockAssertions.createSlicesBlock(expectedValues), ids);
    }

    private static DictionaryBlock createDictionaryBlock(Slice[] expectedValues, int positionCount) {
        int dictionarySize = expectedValues.length;
        int[] ids = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            ids[i] = i % dictionarySize;
        }
        return new DictionaryBlock(BlockAssertions.createSlicesBlock(expectedValues), ids);
    }

    private static BlockBuilder createBlockBuilder() {
        return new VariableWidthBlockBuilder(null, 100, 1);
    }

    private static void assertDictionaryIds(DictionaryBlock dictionaryBlock, int ... expected) {
        Assert.assertEquals((int)dictionaryBlock.getPositionCount(), (int)expected.length);
        for (int position = 0; position < dictionaryBlock.getPositionCount(); ++position) {
            Assert.assertEquals((int)dictionaryBlock.getId(position), (int)expected[position]);
        }
    }

    private static /* synthetic */ void lambda$testBasicGetPositions$2(Block finalDictionaryBlock, int length) throws Throwable {
        finalDictionaryBlock.getPositions(new int[]{0}, 0, length);
    }

    private static /* synthetic */ void lambda$testBasicGetPositions$1(Block finalDictionaryBlock, int offset) throws Throwable {
        finalDictionaryBlock.getPositions(new int[]{0}, offset, 1);
    }

    private static /* synthetic */ void lambda$testBasicGetPositions$0(Block finalDictionaryBlock, int position) throws Throwable {
        finalDictionaryBlock.getPositions(new int[]{position}, 0, 1);
    }
}

