/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.trino.connector.MockConnectorAccessControl;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorInsertTableHandle;
import io.trino.connector.MockConnectorOutputTableHandle;
import io.trino.connector.MockConnectorPageSource;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.connector.MockConnectorTransactionHandle;
import io.trino.spi.HostAddress;
import io.trino.spi.Page;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNewTableLayout;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.JoinApplicationResult;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RecordPageSource;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.connector.TopNApplicationResult;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class MockConnector
implements Connector {
    private static final String DELETE_ROW_ID = "delete_row_id";
    private static final String UPDATE_ROW_ID = "update_row_id";
    private final Function<ConnectorSession, List<String>> listSchemaNames;
    private final BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables;
    private final Optional<BiFunction<ConnectorSession, SchemaTablePrefix, Stream<TableColumnsMetadata>>> streamTableColumns;
    private final BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews;
    private final BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorMaterializedViewDefinition>> getMaterializedViews;
    private final BiFunction<ConnectorSession, SchemaTableName, Boolean> delegateMaterializedViewRefreshToConnector;
    private final BiFunction<ConnectorSession, SchemaTableName, CompletableFuture<?>> refreshMaterializedView;
    private final BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle;
    private final Function<SchemaTableName, List<ColumnMetadata>> getColumns;
    private final MockConnectorFactory.ApplyProjection applyProjection;
    private final MockConnectorFactory.ApplyAggregation applyAggregation;
    private final MockConnectorFactory.ApplyJoin applyJoin;
    private final MockConnectorFactory.ApplyTopN applyTopN;
    private final MockConnectorFactory.ApplyFilter applyFilter;
    private final MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect;
    private final BiFunction<ConnectorSession, SchemaTableName, Optional<CatalogSchemaTableName>> redirectTable;
    private final BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorNewTableLayout>> getInsertLayout;
    private final BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorNewTableLayout>> getNewTableLayout;
    private final BiFunction<ConnectorSession, ConnectorTableHandle, ConnectorTableProperties> getTableProperties;
    private final Supplier<Iterable<EventListener>> eventListeners;
    private final MockConnectorFactory.ListRoleGrants roleGrants;
    private final Optional<ConnectorAccessControl> accessControl;
    private final Function<SchemaTableName, List<List<?>>> data;
    private final Set<Procedure> procedures;

    MockConnector(Function<ConnectorSession, List<String>> listSchemaNames, BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables, Optional<BiFunction<ConnectorSession, SchemaTablePrefix, Stream<TableColumnsMetadata>>> streamTableColumns, BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews, BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorMaterializedViewDefinition>> getMaterializedViews, BiFunction<ConnectorSession, SchemaTableName, Boolean> delegateMaterializedViewRefreshToConnector, BiFunction<ConnectorSession, SchemaTableName, CompletableFuture<?>> refreshMaterializedView, BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle, Function<SchemaTableName, List<ColumnMetadata>> getColumns, MockConnectorFactory.ApplyProjection applyProjection, MockConnectorFactory.ApplyAggregation applyAggregation, MockConnectorFactory.ApplyJoin applyJoin, MockConnectorFactory.ApplyTopN applyTopN, MockConnectorFactory.ApplyFilter applyFilter, MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect, BiFunction<ConnectorSession, SchemaTableName, Optional<CatalogSchemaTableName>> redirectTable, BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorNewTableLayout>> getInsertLayout, BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorNewTableLayout>> getNewTableLayout, BiFunction<ConnectorSession, ConnectorTableHandle, ConnectorTableProperties> getTableProperties, Supplier<Iterable<EventListener>> eventListeners, MockConnectorFactory.ListRoleGrants roleGrants, Optional<ConnectorAccessControl> accessControl, Function<SchemaTableName, List<List<?>>> data, Set<Procedure> procedures) {
        this.listSchemaNames = Objects.requireNonNull(listSchemaNames, "listSchemaNames is null");
        this.listTables = Objects.requireNonNull(listTables, "listTables is null");
        this.streamTableColumns = Objects.requireNonNull(streamTableColumns, "streamTableColumns is null");
        this.getViews = Objects.requireNonNull(getViews, "getViews is null");
        this.getMaterializedViews = Objects.requireNonNull(getMaterializedViews, "getMaterializedViews is null");
        this.delegateMaterializedViewRefreshToConnector = Objects.requireNonNull(delegateMaterializedViewRefreshToConnector, "delegateMaterializedViewRefreshToConnector is null");
        this.refreshMaterializedView = Objects.requireNonNull(refreshMaterializedView, "refreshMaterializedView is null");
        this.getTableHandle = Objects.requireNonNull(getTableHandle, "getTableHandle is null");
        this.getColumns = Objects.requireNonNull(getColumns, "getColumns is null");
        this.applyProjection = Objects.requireNonNull(applyProjection, "applyProjection is null");
        this.applyAggregation = Objects.requireNonNull(applyAggregation, "applyAggregation is null");
        this.applyJoin = Objects.requireNonNull(applyJoin, "applyJoin is null");
        this.applyTopN = Objects.requireNonNull(applyTopN, "applyTopN is null");
        this.applyFilter = Objects.requireNonNull(applyFilter, "applyFilter is null");
        this.applyTableScanRedirect = Objects.requireNonNull(applyTableScanRedirect, "applyTableScanRedirection is null");
        this.redirectTable = Objects.requireNonNull(redirectTable, "redirectTable is null");
        this.getInsertLayout = Objects.requireNonNull(getInsertLayout, "getInsertLayout is null");
        this.getNewTableLayout = Objects.requireNonNull(getNewTableLayout, "getNewTableLayout is null");
        this.getTableProperties = Objects.requireNonNull(getTableProperties, "getTableProperties is null");
        this.eventListeners = Objects.requireNonNull(eventListeners, "eventListeners is null");
        this.roleGrants = Objects.requireNonNull(roleGrants, "roleGrants is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.data = Objects.requireNonNull(data, "data is null");
        this.procedures = Objects.requireNonNull(procedures, "procedures is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        return MockConnectorTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
        return new MockConnectorMetadata();
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return new MockConnectorPageSourceProvider();
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return new MockPageSinkProvider();
    }

    public ConnectorSplitManager getSplitManager() {
        return new ConnectorSplitManager(){

            public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, DynamicFilter dynamicFilter) {
                return new FixedSplitSource((Iterable)ImmutableList.of((Object)((Object)MockConnectorSplit.MOCK_CONNECTOR_SPLIT)));
            }
        };
    }

    public Iterable<EventListener> getEventListeners() {
        return this.eventListeners.get();
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl.orElseThrow(UnsupportedOperationException::new);
    }

    public Set<Procedure> getProcedures() {
        return this.procedures;
    }

    private class MockConnectorMetadata
    implements ConnectorMetadata {
        private MockConnectorMetadata() {
        }

        public boolean schemaExists(ConnectorSession session, String schemaName) {
            return MockConnector.this.listSchemaNames.apply(session).contains(schemaName);
        }

        public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle handle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
            return MockConnector.this.applyProjection.apply(session, handle, projections, assignments);
        }

        public Optional<AggregationApplicationResult<ConnectorTableHandle>> applyAggregation(ConnectorSession session, ConnectorTableHandle handle, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
            return MockConnector.this.applyAggregation.apply(session, handle, aggregates, assignments, groupingSets);
        }

        public Optional<JoinApplicationResult<ConnectorTableHandle>> applyJoin(ConnectorSession session, JoinType joinType, ConnectorTableHandle left, ConnectorTableHandle right, List<JoinCondition> joinConditions, Map<String, ColumnHandle> leftAssignments, Map<String, ColumnHandle> rightAssignments, JoinStatistics statistics) {
            return MockConnector.this.applyJoin.apply(session, joinType, left, right, joinConditions, leftAssignments, rightAssignments);
        }

        public Optional<TopNApplicationResult<ConnectorTableHandle>> applyTopN(ConnectorSession session, ConnectorTableHandle handle, long topNCount, List<SortItem> sortItems, Map<String, ColumnHandle> assignments) {
            return MockConnector.this.applyTopN.apply(session, handle, topNCount, sortItems, assignments);
        }

        public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
            return MockConnector.this.applyFilter.apply(session, handle, constraint);
        }

        public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(ConnectorSession session, ConnectorTableHandle tableHandle) {
            return MockConnector.this.applyTableScanRedirect.apply(session, tableHandle);
        }

        public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName schemaTableName) {
            return MockConnector.this.redirectTable.apply(session, schemaTableName);
        }

        public List<String> listSchemaNames(ConnectorSession session) {
            return MockConnector.this.listSchemaNames.apply(session);
        }

        public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        }

        public void renameSchema(ConnectorSession session, String source, String target) {
        }

        public void setSchemaAuthorization(ConnectorSession session, String source, TrinoPrincipal principal) {
        }

        public void dropSchema(ConnectorSession session, String schemaName) {
        }

        public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
            return MockConnector.this.getTableHandle.apply(session, tableName);
        }

        public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
            MockConnectorTableHandle table = (MockConnectorTableHandle)tableHandle;
            return new ConnectorTableMetadata(table.getTableName(), MockConnector.this.getColumns.apply(table.getTableName()));
        }

        public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
            if (schemaName.isPresent()) {
                return MockConnector.this.listTables.apply(session, schemaName.get());
            }
            ImmutableList.Builder tableNames = ImmutableList.builder();
            for (String schema : this.listSchemaNames(session)) {
                tableNames.addAll((Iterable)MockConnector.this.listTables.apply(session, schema));
            }
            return tableNames.build();
        }

        public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
            MockConnectorTableHandle table = (MockConnectorTableHandle)tableHandle;
            return (Map)MockConnector.this.getColumns.apply(table.getTableName()).stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, column -> new MockConnectorColumnHandle(column.getName(), column.getType())));
        }

        public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
            MockConnectorColumnHandle mockColumnHandle = (MockConnectorColumnHandle)columnHandle;
            return new ColumnMetadata(mockColumnHandle.getName(), mockColumnHandle.getType());
        }

        public Stream<TableColumnsMetadata> streamTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
            if (MockConnector.this.streamTableColumns.isPresent()) {
                return MockConnector.this.streamTableColumns.get().apply(session, prefix);
            }
            return this.listTables(session, prefix.getSchema()).stream().filter(arg_0 -> ((SchemaTablePrefix)prefix).matches(arg_0)).map(name -> TableColumnsMetadata.forTable((SchemaTableName)name, MockConnector.this.getColumns.apply((SchemaTableName)name)));
        }

        public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        }

        public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        }

        public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        }

        public void setTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Object> properties) {
        }

        public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        }

        public void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        }

        public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        }

        public void setTableAuthorization(ConnectorSession session, SchemaTableName tableName, TrinoPrincipal principal) {
        }

        public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        }

        public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        }

        public void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, boolean replace) {
        }

        public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        }

        public void setViewAuthorization(ConnectorSession session, SchemaTableName viewName, TrinoPrincipal principal) {
        }

        public void dropView(ConnectorSession session, SchemaTableName viewName) {
        }

        public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        }

        public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
            return Optional.ofNullable(MockConnector.this.getMaterializedViews.apply(session, viewName.toSchemaTablePrefix()).get(viewName));
        }

        public MaterializedViewFreshness getMaterializedViewFreshness(ConnectorSession session, SchemaTableName viewName) {
            ConnectorMaterializedViewDefinition view = MockConnector.this.getMaterializedViews.apply(session, viewName.toSchemaTablePrefix()).get(viewName);
            Preconditions.checkArgument((view != null ? 1 : 0) != 0, (String)"Materialized view %s does not exist", (Object)viewName);
            return new MaterializedViewFreshness(view.getStorageTable().isPresent());
        }

        public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        }

        public boolean delegateMaterializedViewRefreshToConnector(ConnectorSession session, SchemaTableName viewName) {
            return MockConnector.this.delegateMaterializedViewRefreshToConnector.apply(session, viewName);
        }

        public CompletableFuture<?> refreshMaterializedView(ConnectorSession session, SchemaTableName viewName) {
            return MockConnector.this.refreshMaterializedView.apply(session, viewName);
        }

        public ConnectorInsertTableHandle beginRefreshMaterializedView(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorTableHandle> sourceTableHandles) {
            return new MockConnectorInsertTableHandle(((MockConnectorTableHandle)tableHandle).getTableName());
        }

        public Optional<ConnectorOutputMetadata> finishRefreshMaterializedView(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, List<ConnectorTableHandle> sourceTableHandles) {
            return Optional.empty();
        }

        public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        }

        public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
            return MockConnector.this.getViews.apply(session, schemaName.map(SchemaTablePrefix::new).orElseGet(SchemaTablePrefix::new));
        }

        public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
            return Optional.ofNullable(MockConnector.this.getViews.apply(session, viewName.toSchemaTablePrefix()).get(viewName));
        }

        public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns) {
            return new MockConnectorInsertTableHandle(((MockConnectorTableHandle)tableHandle).getTableName());
        }

        public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
            return Optional.empty();
        }

        public Optional<ConnectorNewTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
            MockConnectorTableHandle table = (MockConnectorTableHandle)tableHandle;
            return MockConnector.this.getInsertLayout.apply(session, table.getTableName());
        }

        public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
            return new MockConnectorOutputTableHandle(tableMetadata.getTable());
        }

        public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
            return Optional.empty();
        }

        public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
            return MockConnector.this.getNewTableLayout.apply(session, tableMetadata);
        }

        public ConnectorTableHandle beginUpdate(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> updatedColumns) {
            return tableHandle;
        }

        public void finishUpdate(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        }

        public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> updatedColumns) {
            return new MockConnectorColumnHandle(MockConnector.UPDATE_ROW_ID, (Type)BigintType.BIGINT);
        }

        public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
            return tableHandle;
        }

        public ColumnHandle getDeleteRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
            return new MockConnectorColumnHandle(MockConnector.DELETE_ROW_ID, (Type)BigintType.BIGINT);
        }

        public void finishDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        }

        public boolean usesLegacyTableLayouts() {
            return false;
        }

        public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
            return MockConnector.this.getTableProperties.apply(session, table);
        }

        public Set<String> listRoles(ConnectorSession session) {
            return (Set)MockConnector.this.roleGrants.apply(session, Optional.empty(), Optional.empty(), OptionalLong.empty()).stream().map(RoleGrant::getRoleName).collect(ImmutableSet.toImmutableSet());
        }

        public Set<RoleGrant> listRoleGrants(ConnectorSession session, TrinoPrincipal principal) {
            return (Set)MockConnector.this.roleGrants.apply(session, Optional.empty(), Optional.empty(), OptionalLong.empty()).stream().filter(grant -> grant.getGrantee().equals((Object)principal)).collect(ImmutableSet.toImmutableSet());
        }

        public Set<RoleGrant> listAllRoleGrants(ConnectorSession session, Optional<Set<String>> roles, Optional<Set<String>> grantees, OptionalLong limit) {
            return MockConnector.this.roleGrants.apply(session, roles, grantees, limit);
        }

        public Set<RoleGrant> listApplicableRoles(ConnectorSession session, TrinoPrincipal principal) {
            return this.listRoleGrants(session, principal);
        }

        public Set<String> listEnabledRoles(ConnectorSession session) {
            return this.listRoles(session);
        }

        public void grantSchemaPrivileges(ConnectorSession session, String schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
            this.getMockAccessControl().grantSchemaPrivileges(schemaName, privileges, grantee, grantOption);
        }

        public void revokeSchemaPrivileges(ConnectorSession session, String schemaName, Set<Privilege> privileges, TrinoPrincipal revokee, boolean grantOption) {
            this.getMockAccessControl().revokeSchemaPrivileges(schemaName, privileges, revokee, grantOption);
        }

        public void grantTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
            this.getMockAccessControl().grantTablePrivileges(tableName, privileges, grantee, grantOption);
        }

        public void revokeTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, TrinoPrincipal revokee, boolean grantOption) {
            this.getMockAccessControl().revokeTablePrivileges(tableName, privileges, revokee, grantOption);
        }

        private MockConnectorAccessControl getMockAccessControl() {
            return (MockConnectorAccessControl)MockConnector.this.getAccessControl();
        }
    }

    private class MockConnectorPageSourceProvider
    implements ConnectorPageSourceProvider {
        private MockConnectorPageSourceProvider() {
        }

        public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
            MockConnectorTableHandle handle = (MockConnectorTableHandle)table;
            SchemaTableName tableName = handle.getTableName();
            List projection = (List)columns.stream().map(MockConnectorColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
            List types = (List)columns.stream().map(MockConnectorColumnHandle.class::cast).map(MockConnectorColumnHandle::getType).collect(ImmutableList.toImmutableList());
            Map<String, Integer> columnIndexes = this.getColumnIndexes(tableName);
            List records = (List)MockConnector.this.data.apply(tableName).stream().map(record -> {
                ImmutableList.Builder projectedRow = ImmutableList.builder();
                for (MockConnectorColumnHandle column : projection) {
                    String columnName = column.getName();
                    if (columnName.equals(MockConnector.DELETE_ROW_ID) || columnName.equals(MockConnector.UPDATE_ROW_ID)) {
                        projectedRow.add((Object)0);
                        continue;
                    }
                    Integer index = (Integer)columnIndexes.get(columnName);
                    Objects.requireNonNull(index, "index is null");
                    projectedRow.add(record.get(index));
                }
                return projectedRow.build();
            }).collect(ImmutableList.toImmutableList());
            return new MockConnectorPageSource((ConnectorPageSource)new RecordPageSource((RecordSet)new InMemoryRecordSet((Collection)types, (Iterable)records)));
        }

        private Map<String, Integer> getColumnIndexes(SchemaTableName tableName) {
            ImmutableMap.Builder columnIndexes = ImmutableMap.builder();
            List<ColumnMetadata> columnMetadata = MockConnector.this.getColumns.apply(tableName);
            for (int index = 0; index < columnMetadata.size(); ++index) {
                columnIndexes.put((Object)columnMetadata.get(index).getName(), (Object)index);
            }
            return columnIndexes.build();
        }
    }

    private static class MockPageSinkProvider
    implements ConnectorPageSinkProvider {
        private MockPageSinkProvider() {
        }

        public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle) {
            return new MockPageSink();
        }

        public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle) {
            return new MockPageSink();
        }
    }

    public static enum MockConnectorSplit implements ConnectorSplit
    {
        MOCK_CONNECTOR_SPLIT;


        public boolean isRemotelyAccessible() {
            return true;
        }

        public List<HostAddress> getAddresses() {
            return ImmutableList.of();
        }

        public Object getInfo() {
            return "mock connector split";
        }

        public long getRetainedSizeInBytes() {
            return 0L;
        }
    }

    private static class MockPageSink
    implements ConnectorPageSink {
        private MockPageSink() {
        }

        public CompletableFuture<?> appendPage(Page page) {
            return NOT_BLOCKED;
        }

        public CompletableFuture<Collection<Slice>> finish() {
            return CompletableFuture.completedFuture(ImmutableList.of());
        }

        public void abort() {
        }
    }
}

